/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.filters;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.filters.FilterTestDriver;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.InputDocument;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.resource.RawDocument;

public class RoundTripComparison {
    private static final Logger LOGGER = Logger.getLogger(RoundTripComparison.class.getName());
    private IFilter filter;
    private ArrayList<Event> extraction1Events = new ArrayList();
    private ArrayList<Event> extraction2Events = new ArrayList();
    private ArrayList<Event> subDocEvents = new ArrayList();
    private Event subDocEvent;
    private IFilterWriter writer;
    private ByteArrayOutputStream writerBuffer;
    private String defaultEncoding;
    private LocaleId srcLoc;
    private LocaleId trgLoc;
    private boolean includeSkeleton;

    public RoundTripComparison(boolean includeSkeleton) {
        this.includeSkeleton = includeSkeleton;
    }

    public RoundTripComparison() {
        this(true);
    }

    public boolean executeCompare(IFilter filter, List<InputDocument> inputDocs, String defaultEncoding, LocaleId srcLoc, LocaleId trgLoc) {
        this.filter = filter;
        this.defaultEncoding = defaultEncoding;
        this.srcLoc = srcLoc;
        this.trgLoc = trgLoc;
        this.writer = filter.createFilterWriter();
        for (InputDocument doc : inputDocs) {
            LOGGER.fine("Processing Document: " + doc.path);
            this.extraction1Events.clear();
            this.extraction2Events.clear();
            this.subDocEvents.clear();
            if (doc.paramFile != null && !doc.paramFile.equals("")) {
                String root = Util.getDirectoryName(doc.path);
                IParameters params = filter.getParameters();
                if (params != null) {
                    params.load(Util.toURI(root + File.separator + doc.paramFile), false);
                }
            }
            this.executeFirstExtraction(doc);
            this.executeSecondExtraction();
            if (FilterTestDriver.compareEvents(this.extraction1Events, this.extraction2Events, this.includeSkeleton)) continue;
            throw new RuntimeException("Events are different for " + doc.path);
        }
        return true;
    }

    public boolean executeCompare(IFilter filter, List<InputDocument> inputDocs, String defaultEncoding, LocaleId srcLoc, LocaleId trgLoc, String dirSuffix) {
        this.filter = filter;
        this.defaultEncoding = defaultEncoding;
        this.srcLoc = srcLoc;
        this.trgLoc = trgLoc;
        this.writer = filter.createFilterWriter();
        for (InputDocument doc : inputDocs) {
            LOGGER.fine("Processing Document: " + doc.path);
            this.extraction1Events.clear();
            this.extraction2Events.clear();
            this.subDocEvents.clear();
            if (doc.paramFile != null && !doc.paramFile.equals("")) {
                String root = Util.getDirectoryName(doc.path);
                IParameters params = filter.getParameters();
                if (params != null) {
                    params.load(Util.toURI(root + File.separator + doc.paramFile), false);
                }
            }
            String outPath = this.executeFirstExtractionToFile(doc, dirSuffix, null);
            this.executeSecondExtractionFromFile(outPath);
            if (FilterTestDriver.compareEvents(this.extraction1Events, this.extraction2Events, this.subDocEvents, this.includeSkeleton)) continue;
            throw new RuntimeException("Events are different for " + doc.path);
        }
        return true;
    }

    public boolean executeCompare(IFilter filter, List<InputDocument> inputDocs, String defaultEncoding, LocaleId srcLoc, LocaleId trgLoc, String dirSuffux, IPipelineStep ... steps) {
        this.filter = filter;
        this.defaultEncoding = defaultEncoding;
        this.srcLoc = srcLoc;
        this.trgLoc = trgLoc;
        this.writer = filter.createFilterWriter();
        for (InputDocument doc : inputDocs) {
            LOGGER.fine("Processing Document: " + doc.path);
            this.extraction1Events.clear();
            this.extraction2Events.clear();
            this.subDocEvents.clear();
            if (doc.paramFile == null) {
                IParameters params = filter.getParameters();
                if (params != null) {
                    params.reset();
                }
            } else {
                String root = Util.getDirectoryName(doc.path);
                IParameters params = filter.getParameters();
                if (params != null) {
                    params.load(Util.toURI(root + File.separator + doc.paramFile), false);
                }
            }
            String outPath = this.executeFirstExtractionToFile(doc, dirSuffux, steps);
            this.executeSecondExtractionFromFile(outPath);
            if (FilterTestDriver.compareEvents(this.extraction1Events, this.extraction2Events, this.includeSkeleton)) continue;
            throw new RuntimeException("Events are different for " + doc.path);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeFirstExtraction(InputDocument doc) {
        try {
            this.filter.open(new RawDocument(Util.toURI(doc.path), this.defaultEncoding, this.srcLoc, this.trgLoc));
            this.writer.setOptions(this.trgLoc, "UTF-16");
            this.writerBuffer = new ByteArrayOutputStream();
            this.writer.setOutput(this.writerBuffer);
            while (this.filter.hasNext()) {
                Event event = this.filter.next();
                switch (event.getEventType()) {
                    case START_DOCUMENT: 
                    case END_DOCUMENT: 
                    case END_SUBDOCUMENT: {
                        break;
                    }
                    case START_SUBDOCUMENT: {
                        this.subDocEvent = event;
                        break;
                    }
                    case START_GROUP: 
                    case END_GROUP: 
                    case TEXT_UNIT: {
                        this.extraction1Events.add(event);
                        this.subDocEvents.add(this.subDocEvent);
                    }
                }
                this.writer.handleEvent(event);
            }
        }
        finally {
            if (this.filter != null) {
                this.filter.close();
            }
            if (this.writer != null) {
                this.writer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSecondExtraction() {
        try {
            String input;
            try {
                input = new String(this.writerBuffer.toByteArray(), "UTF-16");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            this.filter.open(new RawDocument(input, this.srcLoc, this.trgLoc));
            while (this.filter.hasNext()) {
                Event event = this.filter.next();
                switch (event.getEventType()) {
                    case START_DOCUMENT: 
                    case END_DOCUMENT: 
                    case END_SUBDOCUMENT: 
                    case START_SUBDOCUMENT: {
                        break;
                    }
                    case START_GROUP: 
                    case END_GROUP: 
                    case TEXT_UNIT: {
                        this.extraction2Events.add(event);
                    }
                }
            }
        }
        finally {
            if (this.filter != null) {
                this.filter.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String executeFirstExtractionToFile(InputDocument doc, String outputDir, IPipelineStep ... steps) {
        String outPath = null;
        try {
            this.filter.open(new RawDocument(Util.toURI(doc.path), this.defaultEncoding, this.srcLoc, this.trgLoc));
            this.writer.setOptions(this.trgLoc, "UTF-8");
            outPath = Util.getDirectoryName(doc.path);
            outPath = Util.isEmpty(outputDir) ? outPath + File.separator + Util.getFilename(doc.path, true) : outPath + File.separator + outputDir + File.separator + Util.getFilename(doc.path, true);
            this.writer.setOutput(Util.fixPath(outPath));
            while (this.filter.hasNext()) {
                Event event = this.filter.next();
                switch (event.getEventType()) {
                    case START_DOCUMENT: 
                    case END_DOCUMENT: 
                    case END_SUBDOCUMENT: {
                        break;
                    }
                    case START_SUBDOCUMENT: {
                        this.subDocEvent = event;
                        break;
                    }
                    case START_GROUP: 
                    case END_GROUP: 
                    case TEXT_UNIT: {
                        this.extraction1Events.add(event);
                        this.subDocEvents.add(this.subDocEvent);
                    }
                }
                if (steps != null) {
                    for (IPipelineStep step : steps) {
                        event = step.handleEvent(event);
                        this.writer.handleEvent(event);
                    }
                    continue;
                }
                this.writer.handleEvent(event);
            }
        }
        finally {
            if (this.filter != null) {
                this.filter.close();
            }
            if (this.writer != null) {
                this.writer.close();
            }
        }
        return outPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSecondExtractionFromFile(String input) {
        try {
            this.filter.open(new RawDocument(Util.toURI(input), "UTF-8", this.srcLoc, this.trgLoc));
            while (this.filter.hasNext()) {
                Event event = this.filter.next();
                switch (event.getEventType()) {
                    case START_DOCUMENT: 
                    case END_DOCUMENT: 
                    case END_SUBDOCUMENT: 
                    case START_SUBDOCUMENT: {
                        break;
                    }
                    case START_GROUP: 
                    case END_GROUP: 
                    case TEXT_UNIT: {
                        this.extraction2Events.add(event);
                    }
                }
            }
        }
        finally {
            if (this.filter != null) {
                this.filter.close();
            }
        }
    }
}

