/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.filterwriter;

import net.sf.okapi.common.filterwriter.GenericContent;
import net.sf.okapi.common.resource.TextFragment;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GenericContentTest {
    private GenericContent fmt;

    @Before
    public void setUp() throws Exception {
        this.fmt = new GenericContent();
    }

    @Test
    public void testSimple_Default() {
        TextFragment tf = this.createTextFragment();
        Assert.assertEquals((long)tf.getCodes().size(), (long)5L);
        String gtext = this.fmt.setContent(tf).toString();
        Assert.assertEquals((Object)"t1<1><2><3/>t2</2></1>t3", (Object)gtext);
        TextFragment tf2 = tf.clone();
        this.fmt.updateFragment(gtext, tf2, false);
        Assert.assertEquals((Object)"t1<1><2><3/>t2</2></1>t3", (Object)this.fmt.setContent(tf2).toString());
    }

    @Test
    public void testSimple_WithOption() {
        TextFragment tf = this.createTextFragment();
        Assert.assertEquals((long)tf.getCodes().size(), (long)5L);
        this.fmt.setContent(tf);
        Assert.assertEquals((Object)"t1<b1><b2><x1/>t2</b2></b1>t3", (Object)this.fmt.toString(true));
        Assert.assertEquals((Object)"t1<1><2><3/>t2</2></1>t3", (Object)this.fmt.toString(false));
    }

    @Test
    public void testMisOrderedCodes() {
        TextFragment tf = new TextFragment();
        tf.append("t1");
        tf.append(TextFragment.TagType.OPENING, "b1", "<b1>");
        tf.append("t2");
        tf.append(TextFragment.TagType.OPENING, "b2", "<b2>");
        tf.append("t3");
        tf.append(TextFragment.TagType.CLOSING, "b1", "</b1>");
        tf.append("t4");
        tf.append(TextFragment.TagType.CLOSING, "b2", "</b2>");
        tf.append("t5");
        this.fmt.setContent(tf);
        Assert.assertEquals((Object)"t1<b1>t2<b2>t3</b1>t4</b2>t5", (Object)this.fmt.toString(true));
        String gtext = this.fmt.toString(false);
        Assert.assertEquals((Object)"t1<b1/>t2<b2/>t3<e1/>t4<e2/>t5", (Object)gtext);
        TextFragment tf2 = tf.clone();
        this.fmt.updateFragment(gtext, tf2, false);
        Assert.assertEquals((Object)"t1<b1>t2<b2>t3</b1>t4</b2>t5", (Object)this.fmt.setContent(tf2).toString(true));
        Assert.assertEquals((Object)"t1<b1/>t2<b2/>t3<e1/>t4<e2/>t5", (Object)this.fmt.setContent(tf2).toString());
    }

    @Test
    public void testReOrderingCodes() {
        TextFragment tf = new TextFragment();
        tf.append("t1");
        tf.append(TextFragment.TagType.OPENING, "b1", "<b1>");
        tf.append("t2");
        tf.append(TextFragment.TagType.OPENING, "b2", "<b2>");
        tf.append("t3");
        tf.append(TextFragment.TagType.CLOSING, "b1", "</b1>");
        tf.append("t4");
        tf.append(TextFragment.TagType.CLOSING, "b2", "</b2>");
        tf.append("t5");
        this.fmt.setContent(tf);
        Assert.assertEquals((Object)"t1<b1>t2<b2>t3</b1>t4</b2>t5", (Object)this.fmt.toString(true));
        Assert.assertEquals((Object)"t1<b1/>t2<b2/>t3<e1/>t4<e2/>t5", (Object)this.fmt.toString(false));
    }

    @Test
    public void testLetterCodedToFragment() {
        String ori = "t1<g1>t2</g1><g2><x3/>t3<g4>t4</g4>t5</g2>t6";
        TextFragment tf1 = this.fmt.fromLetterCodedToFragment(ori, null);
        Assert.assertNotNull((Object)tf1);
        Assert.assertEquals((long)7L, (long)tf1.getCodes().size());
        Assert.assertEquals((Object)"t1<1>t2</1><2><3/>t3<4>t4</4>t5</2>t6", (Object)this.fmt.setContent(tf1).toString());
        TextFragment tf = this.createTextFragment();
        tf1 = this.fmt.fromLetterCodedToFragment(ori, tf);
        Assert.assertEquals((Object)tf, (Object)tf1);
        Assert.assertEquals((Object)"t1<1>t2</1><2><3/>t3<4>t4</4>t5</2>t6", (Object)this.fmt.setContent(tf1).toString());
    }

    @Test
    public void testFragmentToLetterCoded() {
        TextFragment tf1 = this.createTextFragment();
        String res = this.fmt.fromFragmentToLetterCoded(tf1);
        Assert.assertEquals((Object)"t1<g1><g2><x3/>t2</g2></g1>t3", (Object)res);
        TextFragment tf2 = this.fmt.fromLetterCodedToFragment(res, null);
        Assert.assertEquals((Object)this.fmt.setContent(tf1).toString(), (Object)this.fmt.setContent(tf2).toString());
    }

    private TextFragment createTextFragment() {
        TextFragment tf = new TextFragment();
        tf.append("t1");
        tf.append(TextFragment.TagType.OPENING, "b1", "<b1>");
        tf.append(TextFragment.TagType.OPENING, "b2", "<b2>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "<x1/>");
        tf.append("t2");
        tf.append(TextFragment.TagType.CLOSING, "b2", "</b2>");
        tf.append(TextFragment.TagType.CLOSING, "b1", "</b1>");
        tf.append("t3");
        return tf;
    }
}

