/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.filterwriter;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiFileNotFoundException;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.MultiEvent;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartGroup;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.skeleton.ISkeletonWriter;

public class GenericFilterWriter
implements IFilterWriter {
    protected OutputStreamWriter writer;
    private LocaleId locale;
    private String encoding;
    private ISkeletonWriter skelWriter;
    private OutputStream output;
    private String outputPath;
    private EncoderManager encoderManager;
    private File tempFile;

    public GenericFilterWriter(ISkeletonWriter skelWriter, EncoderManager encoderManager) {
        this.skelWriter = skelWriter;
        this.encoderManager = encoderManager;
    }

    @Override
    public void cancel() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.writer == null) {
            return;
        }
        if (this.skelWriter != null) {
            this.skelWriter.close();
        }
        IOException err = null;
        InputStream orig = null;
        OutputStream dest = null;
        try {
            this.writer.close();
            this.writer = null;
            this.output = null;
            if (this.tempFile != null) {
                int len;
                dest = new FileOutputStream(this.outputPath);
                orig = new FileInputStream(this.tempFile);
                byte[] buffer = new byte[2048];
                while ((len = orig.read(buffer)) > 0) {
                    dest.write(buffer, 0, len);
                }
            }
        }
        catch (IOException e) {
            err = e;
        }
        finally {
            if (dest != null) {
                try {
                    dest.close();
                }
                catch (IOException e) {
                    err = e;
                }
                dest = null;
            }
            if (orig != null) {
                try {
                    orig.close();
                }
                catch (IOException e) {
                    err = e;
                }
                orig = null;
                if (err != null) {
                    throw new RuntimeException(err);
                }
                if (this.tempFile != null) {
                    this.tempFile.delete();
                    this.tempFile = null;
                }
            }
        }
    }

    @Override
    public String getName() {
        return "GenericFilterWriter";
    }

    @Override
    public EncoderManager getEncoderManager() {
        return this.encoderManager;
    }

    @Override
    public ISkeletonWriter getSkeletonWriter() {
        return this.skelWriter;
    }

    @Override
    public IParameters getParameters() {
        return null;
    }

    @Override
    public Event handleEvent(Event event) {
        try {
            switch (event.getEventType()) {
                case START_DOCUMENT: {
                    this.processStartDocument(this.locale, this.encoding, (StartDocument)event.getResource());
                    break;
                }
                case END_DOCUMENT: {
                    this.processEndDocument((Ending)event.getResource());
                    this.close();
                    break;
                }
                case START_SUBDOCUMENT: {
                    this.processStartSubDocument((StartSubDocument)event.getResource());
                    break;
                }
                case END_SUBDOCUMENT: {
                    this.processEndSubDocument((Ending)event.getResource());
                    break;
                }
                case START_GROUP: {
                    this.processStartGroup((StartGroup)event.getResource());
                    break;
                }
                case END_GROUP: {
                    this.processEndGroup((Ending)event.getResource());
                    break;
                }
                case TEXT_UNIT: {
                    this.processTextUnit((TextUnit)event.getResource());
                    break;
                }
                case DOCUMENT_PART: {
                    this.processDocumentPart((DocumentPart)event.getResource());
                    break;
                }
                case MULTI_EVENT: {
                    for (Event e : (MultiEvent)event.getResource()) {
                        this.handleEvent(e);
                    }
                    break;
                }
            }
        }
        catch (FileNotFoundException e) {
            throw new OkapiFileNotFoundException("File not found.", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return event;
    }

    private void processStartDocument(LocaleId outputLocale, String outputEncoding, StartDocument resource) throws IOException {
        this.createWriter(resource);
        if (outputEncoding == null) {
            outputEncoding = this.encoding;
        }
        this.writer.write(this.skelWriter.processStartDocument(outputLocale, outputEncoding, null, this.encoderManager, resource));
    }

    private void processEndDocument(Ending resource) throws IOException {
        this.writer.write(this.skelWriter.processEndDocument(resource));
    }

    private void processStartSubDocument(StartSubDocument resource) throws IOException {
        this.writer.write(this.skelWriter.processStartSubDocument(resource));
    }

    private void processEndSubDocument(Ending resource) throws IOException {
        this.writer.write(this.skelWriter.processEndSubDocument(resource));
    }

    private void processStartGroup(StartGroup resource) throws IOException {
        this.writer.write(this.skelWriter.processStartGroup(resource));
    }

    private void processEndGroup(Ending resource) throws IOException {
        this.writer.write(this.skelWriter.processEndGroup(resource));
    }

    private void processTextUnit(TextUnit resource) throws IOException {
        this.writer.write(this.skelWriter.processTextUnit(resource));
    }

    private void processDocumentPart(DocumentPart resource) throws IOException {
        this.writer.write(this.skelWriter.processDocumentPart(resource));
    }

    @Override
    public void setOptions(LocaleId locale, String defaultEncoding) {
        this.locale = locale;
        this.encoding = defaultEncoding;
    }

    @Override
    public void setOutput(String path) {
        this.close();
        this.outputPath = path;
    }

    @Override
    public void setOutput(OutputStream output) {
        this.close();
        this.output = output;
    }

    @Override
    public void setParameters(IParameters params) {
    }

    private void createWriter(StartDocument resource) {
        try {
            String originalEnc;
            this.tempFile = null;
            if (this.output == null) {
                boolean useTemp = false;
                File f = new File(this.outputPath);
                if (f.exists()) {
                    boolean bl = useTemp = !f.delete();
                }
                if (useTemp) {
                    this.tempFile = File.createTempFile("gfwTmp", null);
                    this.output = new BufferedOutputStream(new FileOutputStream(this.tempFile.getAbsolutePath()));
                } else {
                    Util.createDirectories(this.outputPath);
                    this.output = new BufferedOutputStream(new FileOutputStream(this.outputPath));
                }
            }
            if ((originalEnc = resource.getEncoding()) == null) {
                originalEnc = Charset.defaultCharset().name();
            }
            if (this.encoding == null) {
                this.encoding = originalEnc;
            }
            this.writer = new OutputStreamWriter(this.output, this.encoding);
            boolean useUTF8BOM = false;
            if ("utf-8".equalsIgnoreCase(this.encoding) && "utf-8".equalsIgnoreCase(originalEnc)) {
                useUTF8BOM = resource.hasUTF8BOM();
            }
            Util.writeBOMIfNeeded(this.writer, useUTF8BOM, this.encoding);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

