/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.filterwriter;

import java.util.List;
import java.util.Stack;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.TextFragment;

public class TMXContent {
    public static final int CODEMODE_ORIGINAL = 0;
    public static final int CODEMODE_EMPTY = 1;
    public static final int CODEMODE_GENERIC = 2;
    public static final int CODEMODE_LETTERCODED = 3;
    private String codedText;
    private List<Code> codes;
    private boolean withTradosWorkarounds = false;
    private int defaultQuoteMode = 1;
    private int codeMode = 0;

    public TMXContent() {
        this.codedText = "";
    }

    public TMXContent(TextFragment content) {
        this.setContent(content);
    }

    public void setTradosWorkarounds(boolean value) {
        this.withTradosWorkarounds = value;
    }

    public void setLetterCodedMode(boolean value) {
        this.codeMode = 3;
    }

    public boolean getLetterCodedMode() {
        return this.codeMode == 3;
    }

    public void setQuoteMode(int quoteMode) {
        this.defaultQuoteMode = quoteMode;
    }

    public void setCodeMode(int codeMode) {
        this.codeMode = codeMode;
    }

    public int getCodeMode() {
        return this.codeMode;
    }

    public TMXContent setContent(TextFragment content) {
        this.codedText = content.getCodedText();
        this.codes = content.getCodes();
        return this;
    }

    public String toString() {
        return this.toString(this.defaultQuoteMode, true);
    }

    public String toString(int quoteMode, boolean escapeGT) {
        StringBuilder tmp = new StringBuilder();
        Stack<Integer> otStack = new Stack<Integer>();
        int otId = 0;
        block45: for (int i = 0; i < this.codedText.length(); ++i) {
            switch (this.codedText.codePointAt(i)) {
                case 57601: {
                    int index = TextFragment.toIndex(this.codedText.charAt(++i));
                    Code code = this.codes.get(index);
                    if (code.hasAnnotation("protected")) {
                        tmp.append("<hi type=\"protected\">");
                        continue block45;
                    }
                    tmp.append(String.format("<bpt i=\"%d\">", code.getId()));
                    switch (this.codeMode) {
                        case 2: {
                            otStack.push(otId++);
                            tmp.append(Util.escapeToXML(String.format("<%d>", otStack.peek()), quoteMode, escapeGT, null));
                            break;
                        }
                        case 3: {
                            otStack.push(otId++);
                            tmp.append(Util.escapeToXML(String.format("<g%d>", otStack.peek()), quoteMode, escapeGT, null));
                            break;
                        }
                        case 1: {
                            break;
                        }
                        default: {
                            tmp.append(Util.escapeToXML(this.codes.get(index).toString(), quoteMode, escapeGT, null));
                        }
                    }
                    tmp.append("</bpt>");
                    continue block45;
                }
                case 57602: {
                    int index = TextFragment.toIndex(this.codedText.charAt(++i));
                    Code code = this.codes.get(index);
                    tmp.append(String.format("<ept i=\"%d\">", code.getId()));
                    switch (this.codeMode) {
                        case 2: {
                            tmp.append(Util.escapeToXML(String.format("</%d>", otStack.pop()), quoteMode, escapeGT, null));
                            break;
                        }
                        case 3: {
                            tmp.append(Util.escapeToXML(String.format("</g%d>", otStack.pop()), quoteMode, escapeGT, null));
                            break;
                        }
                        case 1: {
                            break;
                        }
                        default: {
                            tmp.append(Util.escapeToXML(this.codes.get(index).toString(), quoteMode, escapeGT, null));
                        }
                    }
                    tmp.append("</ept>");
                    if (!code.hasAnnotation("protected")) continue block45;
                    tmp.append("</hi>");
                    continue block45;
                }
                case 57603: {
                    int index = TextFragment.toIndex(this.codedText.charAt(++i));
                    Code code = this.codes.get(index);
                    int id = code.getId();
                    switch (code.getTagType()) {
                        case PLACEHOLDER: {
                            if (this.withTradosWorkarounds && (code.getData().indexOf(123) != -1 || code.getData().indexOf(125) != -1 || code.getData().indexOf(92) != -1)) {
                                tmp.append("<ut>{\\cs6\\f1\\cf6\\lang1024 </ut>");
                                tmp.append(Util.escapeToXML(code.toString(), quoteMode, escapeGT, null));
                                tmp.append("<ut>}</ut>");
                                break;
                            }
                            tmp.append(String.format("<ph x=\"%d\">", id));
                            switch (this.codeMode) {
                                case 2: {
                                    tmp.append(Util.escapeToXML(String.format("<%d/>", otId++), quoteMode, escapeGT, null));
                                    break;
                                }
                                case 3: {
                                    tmp.append(Util.escapeToXML(String.format("<x%d/>", otId++), quoteMode, escapeGT, null));
                                    break;
                                }
                                case 1: {
                                    break;
                                }
                                default: {
                                    tmp.append(Util.escapeToXML(code.toString(), quoteMode, escapeGT, null));
                                }
                            }
                            tmp.append("</ph>");
                            break;
                        }
                        case OPENING: {
                            tmp.append(String.format("<it x=\"%d\" pos=\"begin\">", id));
                            switch (this.codeMode) {
                                case 2: {
                                    tmp.append(Util.escapeToXML(String.format("<%d/>", otId++), quoteMode, escapeGT, null));
                                    break;
                                }
                                case 3: {
                                    tmp.append(Util.escapeToXML(String.format("<x%d/>", otId++), quoteMode, escapeGT, null));
                                    break;
                                }
                                case 1: {
                                    break;
                                }
                                default: {
                                    tmp.append(Util.escapeToXML(code.toString(), quoteMode, escapeGT, null));
                                }
                            }
                            tmp.append("</it>");
                            break;
                        }
                        case CLOSING: {
                            tmp.append(String.format("<it x=\"%d\" pos=\"end\">", id));
                            switch (this.codeMode) {
                                case 2: {
                                    tmp.append(Util.escapeToXML(String.format("<%d/>", otId++), quoteMode, escapeGT, null));
                                    break;
                                }
                                case 3: {
                                    tmp.append(Util.escapeToXML(String.format("<x%d/>", otId++), quoteMode, escapeGT, null));
                                    break;
                                }
                                case 1: {
                                    break;
                                }
                                default: {
                                    tmp.append(Util.escapeToXML(code.toString(), quoteMode, escapeGT, null));
                                }
                            }
                            tmp.append("</it>");
                        }
                    }
                    continue block45;
                }
                case 62: {
                    if (escapeGT) {
                        tmp.append("&gt;");
                        continue block45;
                    }
                    if (i > 0 && this.codedText.charAt(i - 1) == ']') {
                        tmp.append("&gt;");
                        continue block45;
                    }
                    tmp.append('>');
                    continue block45;
                }
                case 60: {
                    tmp.append("&lt;");
                    continue block45;
                }
                case 13: {
                    tmp.append("&#13;");
                    continue block45;
                }
                case 38: {
                    tmp.append("&amp;");
                    continue block45;
                }
                case 34: {
                    if (quoteMode > 0) {
                        tmp.append("&quot;");
                        continue block45;
                    }
                    tmp.append('\"');
                    continue block45;
                }
                case 39: {
                    switch (quoteMode) {
                        case 1: {
                            tmp.append("&apos;");
                            continue block45;
                        }
                        case 2: {
                            tmp.append("&#39;");
                            continue block45;
                        }
                    }
                    tmp.append(this.codedText.charAt(i));
                    continue block45;
                }
                default: {
                    tmp.append(this.codedText.charAt(i));
                }
            }
        }
        return tmp.toString();
    }
}

