/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.filterwriter;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.XMLWriter;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.filterwriter.TMXWriter;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.skeleton.ISkeletonWriter;

public class TMXFilterWriter
implements IFilterWriter {
    private TMXWriter writer;
    private OutputStream outputStream;
    private String outputPath;
    private LocaleId locale;
    private boolean canceled;
    private String segType;

    public void setSegType(String segType) {
        this.segType = segType;
    }

    @Override
    public void cancel() {
        this.close();
        this.canceled = true;
    }

    @Override
    public void close() {
        if (this.writer == null) {
            return;
        }
        this.writer.writeEndDocument();
        this.writer.close();
        this.writer = null;
    }

    @Override
    public String getName() {
        return "TMXFilterWriter";
    }

    @Override
    public EncoderManager getEncoderManager() {
        return null;
    }

    @Override
    public ISkeletonWriter getSkeletonWriter() {
        return null;
    }

    @Override
    public IParameters getParameters() {
        return null;
    }

    @Override
    public Event handleEvent(Event event) {
        if (this.canceled) {
            return new Event(EventType.CANCELED);
        }
        switch (event.getEventType()) {
            case START_DOCUMENT: {
                this.processStartDocument(event);
                break;
            }
            case END_DOCUMENT: {
                this.processEndDocument();
                break;
            }
            case TEXT_UNIT: {
                this.processTextUnit(event);
            }
        }
        return event;
    }

    @Override
    public void setOptions(LocaleId locale, String defaultEncoding) {
        this.locale = locale;
    }

    @Override
    public void setOutput(String path) {
        this.outputPath = path;
    }

    @Override
    public void setOutput(OutputStream output) {
        this.outputStream = output;
    }

    @Override
    public void setParameters(IParameters params) {
    }

    private void processStartDocument(Event event) {
        try {
            StartDocument sd = (StartDocument)event.getResource();
            if (this.outputStream == null) {
                this.writer = new TMXWriter(this.outputPath);
            } else if (this.outputStream != null) {
                this.writer = new TMXWriter(new XMLWriter(new OutputStreamWriter(this.outputStream, "UTF-8")));
            }
            this.writer.writeStartDocument(sd.getLocale(), this.locale, null, null, this.segType, "unknown", "text");
        }
        catch (IOException e) {
            throw new OkapiIOException("Error writing the header.", e);
        }
    }

    private void processEndDocument() {
        this.close();
    }

    private void processTextUnit(Event event) {
        this.writer.writeTUFull((TextUnit)event.getResource());
    }
}

