/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.filterwriter;

import net.sf.okapi.common.filterwriter.XLIFFContent;
import net.sf.okapi.common.resource.TextFragment;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class XLIFFContentTest {
    private XLIFFContent fmt;

    @Before
    public void setUp() throws Exception {
        this.fmt = new XLIFFContent();
    }

    @Test
    public void testSimpleDefault() {
        TextFragment tf = this.createTextUnit();
        Assert.assertEquals((long)tf.getCodes().size(), (long)5L);
        Assert.assertEquals((Object)"t1<bpt id=\"1\">&lt;b1&gt;</bpt><bpt id=\"2\">&lt;b2&gt;</bpt><ph id=\"3\">{\\x1\\}</ph>t2<ept id=\"2\">&lt;/b2&gt;</ept><ept id=\"1\">&lt;/b1&gt;</ept>t3", (Object)this.fmt.setContent(tf).toString());
    }

    @Test
    public void testSimpleGX() {
        TextFragment tf = this.createTextUnit();
        Assert.assertEquals((long)tf.getCodes().size(), (long)5L);
        Assert.assertEquals((Object)"t1<g id=\"1\"><g id=\"2\"><x id=\"3\"/>t2</g></g>t3", (Object)this.fmt.setContent(tf).toString(true));
    }

    @Test
    public void testMisOrderedGX1() {
        TextFragment tf = this.createMisOrderedTextUnit1();
        Assert.assertEquals((long)tf.getCodes().size(), (long)4L);
        Assert.assertEquals((Object)"t1<bx id=\"1\"/>t2<bx id=\"2\"/>t3<ex id=\"1\"/>t4<ex id=\"2\"/>t5", (Object)this.fmt.setContent(tf).toString(true));
    }

    @Test
    public void testMisOrderedGX2() {
        TextFragment tf = this.createMisOrderedTextUnit2();
        Assert.assertEquals((long)tf.getCodes().size(), (long)4L);
        Assert.assertEquals((Object)"<ex id=\"3\"/><g id=\"1\"></g><bx id=\"2\"/>", (Object)this.fmt.setContent(tf).toString(true));
    }

    @Test
    public void testMisOrderedComplexGX() {
        TextFragment tf = this.createMisOrderedComplexTextUnit();
        Assert.assertEquals((long)tf.getCodes().size(), (long)8L);
        Assert.assertEquals((Object)"<bx id=\"1\"/><bx id=\"2\"/><g id=\"3\"></g><ex id=\"1\"/><bx id=\"4\"/><ex id=\"2\"/><ex id=\"4\"/>", (Object)this.fmt.setContent(tf).toString(true));
    }

    @Test
    public void testMisOrderedComplexBPT() {
        TextFragment tf = this.createMisOrderedComplexTextUnit();
        Assert.assertEquals((long)tf.getCodes().size(), (long)8L);
        Assert.assertEquals((Object)"<it id=\"1\" pos=\"open\">&lt;b1&gt;</it><it id=\"2\" pos=\"open\">&lt;b2&gt;</it><bpt id=\"3\">&lt;b2&gt;</bpt><ept id=\"3\">&lt;/b2&gt;</ept><it id=\"1\" pos=\"close\">&lt;/b1&gt;</it><it id=\"4\" pos=\"open\">&lt;b3&gt;</it><it id=\"2\" pos=\"close\">&lt;/b2&gt;</it><it id=\"4\" pos=\"close\">&lt;/b3&gt;</it>", (Object)this.fmt.setContent(tf).toString(false));
    }

    private TextFragment createTextUnit() {
        TextFragment tf = new TextFragment();
        tf.append("t1");
        tf.append(TextFragment.TagType.OPENING, "b1", "<b1>");
        tf.append(TextFragment.TagType.OPENING, "b2", "<b2>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "x1", "{\\x1\\}");
        tf.append("t2");
        tf.append(TextFragment.TagType.CLOSING, "b2", "</b2>");
        tf.append(TextFragment.TagType.CLOSING, "b1", "</b1>");
        tf.append("t3");
        return tf;
    }

    private TextFragment createMisOrderedTextUnit1() {
        TextFragment tf = new TextFragment();
        tf.append("t1");
        tf.append(TextFragment.TagType.OPENING, "b1", "<b1>");
        tf.append("t2");
        tf.append(TextFragment.TagType.OPENING, "b2", "<b2>");
        tf.append("t3");
        tf.append(TextFragment.TagType.CLOSING, "b1", "</b1>");
        tf.append("t4");
        tf.append(TextFragment.TagType.CLOSING, "b2", "</b2>");
        tf.append("t5");
        return tf;
    }

    private TextFragment createMisOrderedTextUnit2() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.CLOSING, "b1", "</b1>");
        tf.append(TextFragment.TagType.OPENING, "b2", "<b2>");
        tf.append(TextFragment.TagType.CLOSING, "b2", "</b2>");
        tf.append(TextFragment.TagType.OPENING, "b3", "<b3>");
        return tf;
    }

    private TextFragment createMisOrderedComplexTextUnit() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "b1", "<b1>");
        tf.append(TextFragment.TagType.OPENING, "b2", "<b2>");
        tf.append(TextFragment.TagType.OPENING, "b2", "<b2>");
        tf.append(TextFragment.TagType.CLOSING, "b2", "</b2>");
        tf.append(TextFragment.TagType.CLOSING, "b1", "</b1>");
        tf.append(TextFragment.TagType.OPENING, "b3", "<b3>");
        tf.append(TextFragment.TagType.CLOSING, "b2", "</b2>");
        tf.append(TextFragment.TagType.CLOSING, "b3", "</b3>");
        return tf;
    }
}

