/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.pipeline;

import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.pipeline.IPipelineStep;

public abstract class BasePipelineStep
implements IPipelineStep {
    private boolean isLastOutputStep = false;

    @Override
    public IParameters getParameters() {
        return null;
    }

    @Override
    public void setParameters(IParameters params) {
    }

    @Override
    public boolean isDone() {
        return true;
    }

    @Override
    public String getHelpLocation() {
        return this.getName() + " Step";
    }

    @Override
    public Event handleEvent(Event event) {
        switch (event.getEventType()) {
            case START_BATCH: {
                event = this.handleStartBatch(event);
                break;
            }
            case END_BATCH: {
                event = this.handleEndBatch(event);
                break;
            }
            case START_BATCH_ITEM: {
                event = this.handleStartBatchItem(event);
                break;
            }
            case END_BATCH_ITEM: {
                event = this.handleEndBatchItem(event);
                break;
            }
            case RAW_DOCUMENT: {
                event = this.handleRawDocument(event);
                break;
            }
            case START_DOCUMENT: {
                event = this.handleStartDocument(event);
                break;
            }
            case END_DOCUMENT: {
                event = this.handleEndDocument(event);
                break;
            }
            case START_SUBDOCUMENT: {
                event = this.handleStartSubDocument(event);
                break;
            }
            case END_SUBDOCUMENT: {
                event = this.handleEndSubDocument(event);
                break;
            }
            case START_GROUP: {
                event = this.handleStartGroup(event);
                break;
            }
            case END_GROUP: {
                event = this.handleEndGroup(event);
                break;
            }
            case TEXT_UNIT: {
                event = this.handleTextUnit(event);
                break;
            }
            case DOCUMENT_PART: {
                event = this.handleDocumentPart(event);
                break;
            }
            case CUSTOM: {
                event = this.handleCustom(event);
                break;
            }
            case MULTI_EVENT: {
                event = this.handleMultiEvent(event);
            }
        }
        return event;
    }

    public void cancel() {
    }

    @Override
    public void destroy() {
    }

    @Override
    public boolean isLastOutputStep() {
        return this.isLastOutputStep;
    }

    @Override
    public void setLastOutputStep(boolean isLastStep) {
        this.isLastOutputStep = isLastStep;
    }

    protected Event handleStartBatch(Event event) {
        return event;
    }

    protected Event handleEndBatch(Event event) {
        return event;
    }

    protected Event handleStartBatchItem(Event event) {
        return event;
    }

    protected Event handleEndBatchItem(Event event) {
        return event;
    }

    protected Event handleRawDocument(Event event) {
        return event;
    }

    protected Event handleStartDocument(Event event) {
        return event;
    }

    protected Event handleEndDocument(Event event) {
        return event;
    }

    protected Event handleStartSubDocument(Event event) {
        return event;
    }

    protected Event handleEndSubDocument(Event event) {
        return event;
    }

    protected Event handleStartGroup(Event event) {
        return event;
    }

    protected Event handleEndGroup(Event event) {
        return event;
    }

    protected Event handleTextUnit(Event event) {
        return event;
    }

    protected Event handleDocumentPart(Event event) {
        return event;
    }

    protected Event handleCustom(Event event) {
        return event;
    }

    protected Event handleMultiEvent(Event event) {
        return event;
    }
}

