/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.plugins;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import net.sf.okapi.common.ClassInfo;
import net.sf.okapi.common.DefaultFilenameFilter;
import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.IEmbeddableParametersEditor;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IParametersEditor;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.plugins.PluginItem;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;

public class PluginsManager {
    private ArrayList<URL> urls;
    private List<PluginItem> plugins;
    private URLClassLoader loader;

    public void discover(File pluginsDir, boolean append) {
        try {
            File[] dirs;
            if (this.plugins == null) {
                this.plugins = new ArrayList<PluginItem>();
            }
            if (pluginsDir == null) {
                return;
            }
            if (!pluginsDir.isDirectory()) {
                return;
            }
            ArrayList<URL> existingUrls = new ArrayList<URL>();
            if (append && this.urls != null) {
                existingUrls.addAll(this.urls);
            }
            this.urls = new ArrayList();
            this.loader = null;
            for (File dir : dirs = pluginsDir.listFiles()) {
                File[] files;
                if (!dir.isDirectory()) continue;
                for (File file : files = dir.listFiles(new DefaultFilenameFilter(".jar"))) {
                    this.inspectFile(file);
                }
            }
            existingUrls.removeAll(this.urls);
            this.urls.addAll(existingUrls);
            if (this.urls.size() > 0) {
                URL[] tmp = new URL[this.urls.size()];
                for (int i = 0; i < this.urls.size(); ++i) {
                    tmp[i] = this.urls.get(i);
                }
                this.loader = new URLClassLoader(tmp);
            }
            block17: for (PluginItem item1 : this.plugins) {
                Class<?> cls1 = Class.forName(item1.className, false, this.loader);
                switch (item1.type) {
                    case 1: 
                    case 2: {
                        UsingParameters usingParams = cls1.getAnnotation(UsingParameters.class);
                        if (usingParams == null || usingParams.value().equals(IParameters.class)) continue block17;
                        for (PluginItem item2 : this.plugins) {
                            switch (item2.type) {
                                case 4: 
                                case 8: 
                                case 16: {
                                    Class<?> cls2 = Class.forName(item2.className, false, this.loader);
                                    EditorFor editorFor = cls2.getAnnotation(EditorFor.class);
                                    if (editorFor == null) break;
                                    if (editorFor.value().equals(usingParams.value())) {
                                        if (IParametersEditor.class.isAssignableFrom(cls2)) {
                                            item1.paramsEditor = new ClassInfo(item2.className, this.loader);
                                        }
                                        if (IEmbeddableParametersEditor.class.isAssignableFrom(cls2)) {
                                            item1.embeddableParamsEditor = new ClassInfo(item2.className, this.loader);
                                        }
                                        if (IEditorDescriptionProvider.class.isAssignableFrom(cls2)) {
                                            item1.editorDescriptionProvider = new ClassInfo(item2.className, this.loader);
                                        }
                                    }
                                    cls2 = null;
                                }
                            }
                        }
                        break;
                    }
                }
                cls1 = null;
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Class not found", e);
        }
        catch (SecurityException e) {
            throw new RuntimeException("Error when looking for getParameters() method.", e);
        }
        finally {
            System.gc();
        }
    }

    public List<String> getList(int type) {
        ArrayList<String> list = new ArrayList<String>();
        for (PluginItem item : this.plugins) {
            if (item.type != type) continue;
            list.add(item.className);
        }
        return list;
    }

    public List<PluginItem> getList() {
        return this.plugins;
    }

    public URLClassLoader getClassLoader() {
        return this.loader;
    }

    private void inspectFile(File file) {
        try {
            if (file == null || !file.exists()) {
                return;
            }
            URL url = file.toURI().toURL();
            URL[] tmpUrls = new URL[]{url};
            URLClassLoader loader = URLClassLoader.newInstance(tmpUrls);
            JarInputStream jarFile = new JarInputStream(new FileInputStream(file));
            Class<?> cls = null;
            while (true) {
                cls = null;
                JarEntry entry = jarFile.getNextJarEntry();
                if (entry == null) break;
                String name = entry.getName();
                if (!name.endsWith(".class")) continue;
                name = name.substring(0, name.length() - 6).replace('/', '.');
                try {
                    cls = Class.forName(name, false, loader);
                    if (cls.isInterface() || Modifier.isAbstract(cls.getModifiers())) continue;
                    if (IFilter.class.isAssignableFrom(cls)) {
                        if (cls.getAnnotation(UsingParameters.class) == null) continue;
                        if (!this.urls.contains(url)) {
                            this.urls.add(url);
                        }
                        this.plugins.add(new PluginItem(1, name));
                        continue;
                    }
                    if (IPipelineStep.class.isAssignableFrom(cls)) {
                        if (cls.getAnnotation(UsingParameters.class) == null) continue;
                        if (!this.urls.contains(url)) {
                            this.urls.add(url);
                        }
                        this.plugins.add(new PluginItem(2, name));
                        continue;
                    }
                    if (IParametersEditor.class.isAssignableFrom(cls)) {
                        if (cls.getAnnotation(EditorFor.class) == null) continue;
                        if (!this.urls.contains(url)) {
                            this.urls.add(url);
                        }
                        this.plugins.add(new PluginItem(4, name));
                        continue;
                    }
                    if (IEmbeddableParametersEditor.class.isAssignableFrom(cls)) {
                        if (cls.getAnnotation(EditorFor.class) == null) continue;
                        if (!this.urls.contains(url)) {
                            this.urls.add(url);
                        }
                        this.plugins.add(new PluginItem(8, name));
                        continue;
                    }
                    if (!IEditorDescriptionProvider.class.isAssignableFrom(cls) || cls.getAnnotation(EditorFor.class) == null) continue;
                    if (!this.urls.contains(url)) {
                        this.urls.add(url);
                    }
                    this.plugins.add(new PluginItem(16, name));
                }
                catch (Throwable e) {}
            }
            if (jarFile != null) {
                jarFile.close();
                jarFile = null;
            }
            loader = null;
        }
        catch (IOException e) {
            throw new RuntimeException("IO error when inspecting a file for plugins.", e);
        }
    }
}

