/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.resource;

import java.util.AbstractCollection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import net.sf.okapi.common.ISegmenter;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.exceptions.OkapiMisAlignmentException;
import net.sf.okapi.common.resource.AlignedPair;
import net.sf.okapi.common.resource.AlignmentStatus;
import net.sf.okapi.common.resource.IAlignedSegments;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;

public class AlignedSegments
implements IAlignedSegments {
    private ITextUnit myParent;

    public AlignedSegments(ITextUnit parent) {
        this.myParent = parent;
    }

    @Override
    public void append(Segment srcSeg, Segment trgSeg, LocaleId trgLoc, EnumSet<IAlignedSegments.VariantOptions> variantOptions, EnumSet<IAlignedSegments.CopyOptions> copyOptions) {
        if (srcSeg == null && trgSeg == null) {
            throw new IllegalArgumentException("srcSeg and trgSeg cannot both be null");
        }
        this.insertOrAppend(true, -1, srcSeg, trgSeg, trgLoc, variantOptions, copyOptions);
    }

    @Override
    public void insert(int index, Segment srcSeg, Segment trgSeg, LocaleId trgLoc, EnumSet<IAlignedSegments.VariantOptions> variantOptions, EnumSet<IAlignedSegments.CopyOptions> copyOptions) {
        if (srcSeg == null) {
            throw new IllegalArgumentException("srcSeg cannot be null");
        }
        this.insertOrAppend(false, index, srcSeg, trgSeg, trgLoc, variantOptions, copyOptions);
    }

    private void insertOrAppend(boolean append, int index, Segment srcSeg, Segment trgSeg, LocaleId trgLoc, EnumSet<IAlignedSegments.VariantOptions> variantOptions, EnumSet<IAlignedSegments.CopyOptions> copyOptions) {
        Segment sourceSeg = srcSeg != null ? srcSeg : trgSeg.clone();
        Segment targetSeg = trgSeg != null ? trgSeg : srcSeg.clone();
        Segment copySeg = sourceSeg.clone();
        String originalId = null;
        String insertedId = null;
        if (append) {
            targetSeg.id = sourceSeg.id;
        } else {
            originalId = this.getSource((LocaleId)trgLoc).getSegments().get((int)index).id;
        }
        if (!this.continueWithOperation(trgLoc, variantOptions)) {
            return;
        }
        if (variantOptions.contains((Object)IAlignedSegments.VariantOptions.MODIFY_SOURCE)) {
            if (!copyOptions.contains((Object)IAlignedSegments.CopyOptions.COPY_TO_SOURCE)) {
                sourceSeg.getContent().clear();
            }
            if (append) {
                this.getSource(trgLoc).append(sourceSeg);
            } else {
                insertedId = this.doInsert(this.getSource(trgLoc), index, null, null, sourceSeg);
            }
        }
        if (variantOptions.contains((Object)IAlignedSegments.VariantOptions.MODIFY_TARGET)) {
            if (!copyOptions.contains((Object)IAlignedSegments.CopyOptions.COPY_TO_TARGET)) {
                targetSeg.getContent().clear();
            }
            if (append) {
                this.myParent.getTarget_DIFF(trgLoc).getSegments().append(targetSeg);
            } else {
                insertedId = this.doInsert(this.myParent.getTarget_DIFF(trgLoc), index, originalId, insertedId, targetSeg);
            }
        }
        Segment tempSeg = copySeg.clone();
        if (variantOptions.contains((Object)IAlignedSegments.VariantOptions.MODIFY_TARGETS_WITH_SAME_SOURCE)) {
            if (!copyOptions.contains((Object)IAlignedSegments.CopyOptions.COPY_TO_TARGETS_WITH_SAME_SOURCE)) {
                tempSeg.getContent().clear();
            }
            for (TextContainer container : this.getSameSourceTargets(trgLoc)) {
                if (append) {
                    container.getSegments().append(tempSeg.clone());
                    continue;
                }
                insertedId = this.doInsert(container, index, originalId, insertedId, tempSeg.clone());
            }
        }
        tempSeg = copySeg.clone();
        if (variantOptions.contains((Object)IAlignedSegments.VariantOptions.MODIFY_VARIANT_SOURCES)) {
            if (!copyOptions.contains((Object)IAlignedSegments.CopyOptions.COPY_TO_VARIANT_SOURCES)) {
                tempSeg.getContent().clear();
            }
            for (TextContainer container : this.getOtherSources(trgLoc)) {
                if (append) {
                    container.getSegments().append(tempSeg.clone());
                    continue;
                }
                insertedId = this.doInsert(container, index, originalId, insertedId, tempSeg.clone());
            }
        }
        tempSeg = copySeg.clone();
        if (variantOptions.contains((Object)IAlignedSegments.VariantOptions.MODIFY_TARGETS_OF_VARIANT_SOURCES)) {
            if (!copyOptions.contains((Object)IAlignedSegments.CopyOptions.COPY_TO_TARGETS_OF_VARIANT_SOURCES)) {
                tempSeg.getContent().clear();
            }
            for (TextContainer container : this.getTargetsOfOtherSources(trgLoc)) {
                if (append) {
                    container.getSegments().append(tempSeg.clone());
                    continue;
                }
                insertedId = this.doInsert(container, index, originalId, insertedId, tempSeg.clone());
            }
        }
    }

    private boolean continueWithOperation(LocaleId trgLoc, EnumSet<IAlignedSegments.VariantOptions> variantOptions) {
        if (this.hasMultipleTargets(trgLoc)) {
            if (variantOptions.contains((Object)IAlignedSegments.VariantOptions.CANCEL_IF_MULTIPLE_TARGETS)) {
                return false;
            }
            if (variantOptions.contains((Object)IAlignedSegments.VariantOptions.CREATE_VARIANT_IF_MULTIPLE_TARGETS)) {
                this.myParent.getVariantSources().create(trgLoc, false, 7);
            }
        }
        return true;
    }

    private String doInsert(TextContainer container, int index, String originalId, String insertedId, Segment seg) {
        ISegments segs = container.getSegments();
        if (originalId == null) {
            segs.insert(index, seg);
            return seg.id;
        }
        Segment currentSeg = segs.get(originalId);
        if (currentSeg != null) {
            segs.insert(segs.getIndex(originalId), seg);
            if (insertedId != null) {
                seg.id = insertedId;
            }
            return seg.id;
        }
        segs.append(seg);
        return insertedId;
    }

    @Override
    public void setSegment(int index, Segment seg, LocaleId trgLoc, EnumSet<IAlignedSegments.VariantOptions> variantOptions, EnumSet<IAlignedSegments.VariantOptions> idUpdateOptions) {
        Segment tempSeg;
        if (!this.continueWithOperation(trgLoc, variantOptions)) {
            return;
        }
        ISegments segs = this.getSource(trgLoc).getSegments();
        String newId = seg.id;
        String oldId = segs.get((int)index).id;
        boolean idChanged = !newId.equals(oldId);
        int theIndex = index;
        if (variantOptions.contains((Object)IAlignedSegments.VariantOptions.MODIFY_SOURCE)) {
            segs.set(theIndex, seg.clone());
        }
        if (variantOptions.contains((Object)IAlignedSegments.VariantOptions.MODIFY_TARGET)) {
            segs = this.myParent.getTarget_DIFF(trgLoc).getSegments();
            tempSeg = seg.clone();
            segs.set(segs.getIndex(oldId), tempSeg);
        }
        if (variantOptions.contains((Object)IAlignedSegments.VariantOptions.MODIFY_TARGETS_WITH_SAME_SOURCE)) {
            for (TextContainer targ : this.getSameSourceTargets(trgLoc)) {
                segs = targ.getSegments();
                tempSeg = seg.clone();
                segs.set(segs.getIndex(oldId), tempSeg);
            }
        }
        if (variantOptions.contains((Object)IAlignedSegments.VariantOptions.MODIFY_VARIANT_SOURCES)) {
            for (TextContainer targ : this.getOtherSources(trgLoc)) {
                segs = targ.getSegments();
                tempSeg = seg.clone();
                segs.set(segs.getIndex(oldId), tempSeg);
            }
        }
        if (variantOptions.contains((Object)IAlignedSegments.VariantOptions.MODIFY_TARGETS_OF_VARIANT_SOURCES)) {
            for (TextContainer targ : this.getTargetsOfOtherSources(trgLoc)) {
                segs = targ.getSegments();
                tempSeg = seg.clone();
                segs.set(segs.getIndex(oldId), tempSeg);
            }
        }
        if (idChanged) {
            if (idUpdateOptions.contains((Object)IAlignedSegments.VariantOptions.MODIFY_SOURCE) && (tempSeg = this.getSource(trgLoc).getSegments().get(oldId)) != null) {
                tempSeg.id = newId;
            }
            if (idUpdateOptions.contains((Object)IAlignedSegments.VariantOptions.MODIFY_TARGET) && (tempSeg = this.myParent.getTarget_DIFF(trgLoc).getSegments().get(oldId)) != null) {
                tempSeg.id = newId;
            }
            if (idUpdateOptions.contains((Object)IAlignedSegments.VariantOptions.MODIFY_TARGETS_WITH_SAME_SOURCE)) {
                for (TextContainer targ : this.getSameSourceTargets(trgLoc)) {
                    tempSeg = targ.getSegments().get(oldId);
                    if (tempSeg == null) continue;
                    tempSeg.id = newId;
                }
            }
            if (idUpdateOptions.contains((Object)IAlignedSegments.VariantOptions.MODIFY_VARIANT_SOURCES)) {
                for (TextContainer targ : this.getOtherSources(trgLoc)) {
                    tempSeg = targ.getSegments().get(oldId);
                    if (tempSeg == null) continue;
                    tempSeg.id = newId;
                }
            }
            if (idUpdateOptions.contains((Object)IAlignedSegments.VariantOptions.MODIFY_TARGETS_OF_VARIANT_SOURCES)) {
                for (TextContainer targ : this.getTargetsOfOtherSources(trgLoc)) {
                    tempSeg = targ.getSegments().get(oldId);
                    if (tempSeg == null) continue;
                    tempSeg.id = newId;
                }
            }
        }
    }

    @Override
    public boolean remove(Segment seg, LocaleId trgLoc, EnumSet<IAlignedSegments.VariantOptions> variantOptions) {
        int count = 0;
        if (variantOptions.contains((Object)IAlignedSegments.VariantOptions.MODIFY_SOURCE)) {
            count += this.removeSegment(this.getSource(trgLoc), seg.id);
        }
        if (variantOptions.contains((Object)IAlignedSegments.VariantOptions.MODIFY_TARGET)) {
            count += this.removeSegment(this.myParent.getTarget_DIFF(trgLoc), seg.id);
        }
        if (variantOptions.contains((Object)IAlignedSegments.VariantOptions.MODIFY_TARGETS_WITH_SAME_SOURCE)) {
            for (TextContainer targ : this.getSameSourceTargets(trgLoc)) {
                count += this.removeSegment(targ, seg.id);
            }
        }
        if (variantOptions.contains((Object)IAlignedSegments.VariantOptions.MODIFY_VARIANT_SOURCES)) {
            for (TextContainer targ : this.getOtherSources(trgLoc)) {
                count += this.removeSegment(targ, seg.id);
            }
        }
        if (variantOptions.contains((Object)IAlignedSegments.VariantOptions.MODIFY_TARGETS_OF_VARIANT_SOURCES)) {
            for (TextContainer targ : this.getTargetsOfOtherSources(trgLoc)) {
                count += this.removeSegment(targ, seg.id);
            }
        }
        return count > 0;
    }

    private int removeSegment(TextContainer container, String segId) {
        ISegments segs = container.getSegments();
        int segIndex = segs.getIndex(segId);
        if (segIndex > -1) {
            container.remove(segs.getPartIndex(segIndex));
            return 1;
        }
        return 0;
    }

    @Override
    public Segment getSource(int index, LocaleId trgLoc) {
        return this.getSource(trgLoc).getSegments().get(index);
    }

    @Override
    public Segment getCorrespondingTarget(Segment srcSeg, LocaleId trgLoc, EnumSet<IAlignedSegments.VariantOptions> variantOptions, EnumSet<IAlignedSegments.CopyOptions> copyOptions) {
        variantOptions = ((EnumSet)variantOptions).clone();
        ISegments trgSegs = this.myParent.getTarget_DIFF(trgLoc).getSegments();
        Segment trgSeg = trgSegs.get(srcSeg.id);
        if (trgSeg == null) {
            ((AbstractCollection)variantOptions).remove((Object)IAlignedSegments.VariantOptions.MODIFY_SOURCE);
            ((AbstractCollection)variantOptions).add(IAlignedSegments.VariantOptions.MODIFY_TARGET);
            this.append(srcSeg, null, trgLoc, (EnumSet<IAlignedSegments.VariantOptions>)variantOptions, copyOptions);
        }
        return trgSegs.get(srcSeg.id);
    }

    @Override
    public Segment getCorrespondingSource(Segment trgSeg, LocaleId trgLoc, EnumSet<IAlignedSegments.VariantOptions> variantOptions, EnumSet<IAlignedSegments.CopyOptions> copyOptions) {
        variantOptions = ((EnumSet)variantOptions).clone();
        ISegments srcSegs = this.getSource(trgLoc).getSegments();
        Segment srcSeg = srcSegs.get(trgSeg.id);
        if (srcSeg == null) {
            ((AbstractCollection)variantOptions).add(IAlignedSegments.VariantOptions.MODIFY_SOURCE);
            ((AbstractCollection)variantOptions).remove((Object)IAlignedSegments.VariantOptions.MODIFY_TARGET);
            this.append(null, trgSeg, trgLoc, (EnumSet<IAlignedSegments.VariantOptions>)variantOptions, copyOptions);
        }
        return srcSegs.get(trgSeg.id);
    }

    @Override
    public void align(List<AlignedPair> alignedSegmentPairs, LocaleId trgLoc) {
        this.myParent.getTarget_DIFF(trgLoc).getSegments().setAlignmentStatus(AlignmentStatus.ALIGNED);
    }

    @Override
    public void align(LocaleId trgLoc) {
        Iterator<Segment> srcSegsIt = this.getSource(trgLoc).getSegments().iterator();
        Iterator<Segment> trgSegsIt = this.myParent.getTarget_DIFF(trgLoc).getSegments().iterator();
        while (srcSegsIt.hasNext()) {
            try {
                Segment srcSeg = srcSegsIt.next();
                Segment trgSeg = trgSegsIt.next();
                trgSeg.id = srcSeg.id;
            }
            catch (NoSuchElementException e) {
                throw new OkapiMisAlignmentException("Different number of source and target segments", e);
            }
        }
        this.myParent.getTarget_DIFF(trgLoc).getSegments().setAlignmentStatus(AlignmentStatus.ALIGNED);
    }

    @Override
    public void alignCollapseAll(LocaleId trgLoc, EnumSet<IAlignedSegments.VariantOptions> variantOptions) {
        this.myParent.getTarget_DIFF(trgLoc).getSegments().setAlignmentStatus(AlignmentStatus.ALIGNED);
    }

    @Override
    public Segment splitSource(LocaleId trgLoc, Segment srcSeg, int splitPos, EnumSet<IAlignedSegments.VariantOptions> variantOptions, EnumSet<IAlignedSegments.CopyOptions> copyOptions) {
        if (!this.continueWithOperation(trgLoc, variantOptions)) {
            return null;
        }
        TextContainer theSource = this.getSource(trgLoc);
        ISegments srcSegs = theSource.getSegments();
        int segIndex = srcSegs.getIndex(srcSeg.id);
        if (segIndex == -1) {
            return null;
        }
        int partIndex = srcSegs.getPartIndex(segIndex);
        theSource.split(partIndex, splitPos, splitPos, false);
        Segment newSeg = srcSegs.get(segIndex + 1);
        if (variantOptions.contains((Object)IAlignedSegments.VariantOptions.MODIFY_TARGET)) {
            ISegments currentSegs;
            Segment currentSeg;
            Segment tempSeg = newSeg.clone();
            if (!copyOptions.contains((Object)IAlignedSegments.CopyOptions.COPY_TO_TARGET)) {
                tempSeg.getContent().clear();
            }
            if ((currentSeg = (currentSegs = this.myParent.getTarget_DIFF(trgLoc).getSegments()).get(srcSeg.id)) != null) {
                currentSegs.insert(currentSegs.getIndex(srcSeg.id) + 1, tempSeg);
            }
        }
        this.propagateChangesForSplit(newSeg, srcSeg.id, trgLoc, variantOptions, copyOptions);
        return newSeg;
    }

    private void propagateChangesForSplit(Segment newSeg, String segId, LocaleId trgLoc, EnumSet<IAlignedSegments.VariantOptions> variantOptions, EnumSet<IAlignedSegments.CopyOptions> copyOptions) {
        Segment currentSeg;
        ISegments currentSegs;
        Segment tempSeg = newSeg.clone();
        if (variantOptions.contains((Object)IAlignedSegments.VariantOptions.MODIFY_TARGETS_WITH_SAME_SOURCE)) {
            if (!copyOptions.contains((Object)IAlignedSegments.CopyOptions.COPY_TO_TARGETS_WITH_SAME_SOURCE)) {
                tempSeg.getContent().clear();
            }
            for (TextContainer targ : this.getSameSourceTargets(trgLoc)) {
                currentSegs = targ.getSegments();
                currentSeg = currentSegs.get(segId);
                if (currentSeg == null) continue;
                currentSegs.insert(currentSegs.getIndex(segId) + 1, tempSeg.clone());
            }
        }
        tempSeg = newSeg.clone();
        if (variantOptions.contains((Object)IAlignedSegments.VariantOptions.MODIFY_VARIANT_SOURCES)) {
            if (!copyOptions.contains((Object)IAlignedSegments.CopyOptions.COPY_TO_VARIANT_SOURCES)) {
                tempSeg.getContent().clear();
            }
            for (TextContainer variant : this.getOtherSources(trgLoc)) {
                currentSegs = variant.getSegments();
                currentSeg = currentSegs.get(segId);
                if (currentSeg == null) continue;
                currentSegs.insert(currentSegs.getIndex(segId) + 1, tempSeg.clone());
            }
        }
        tempSeg = newSeg.clone();
        if (variantOptions.contains((Object)IAlignedSegments.VariantOptions.MODIFY_TARGETS_OF_VARIANT_SOURCES)) {
            if (!copyOptions.contains((Object)IAlignedSegments.CopyOptions.COPY_TO_TARGETS_OF_VARIANT_SOURCES)) {
                tempSeg.getContent().clear();
            }
            for (TextContainer variantTarg : this.getTargetsOfOtherSources(trgLoc)) {
                currentSegs = variantTarg.getSegments();
                currentSeg = currentSegs.get(segId);
                if (currentSeg == null) continue;
                currentSegs.insert(currentSegs.getIndex(segId) + 1, tempSeg.clone());
            }
        }
    }

    @Override
    public Segment splitTarget(LocaleId trgLoc, Segment trgSeg, int splitPos, EnumSet<IAlignedSegments.VariantOptions> variantOptions, EnumSet<IAlignedSegments.CopyOptions> copyOptions) {
        if (!this.continueWithOperation(trgLoc, variantOptions)) {
            return null;
        }
        TextContainer theTarget = this.myParent.getTarget_DIFF(trgLoc);
        ISegments trgSegs = theTarget.getSegments();
        int segIndex = trgSegs.getIndex(trgSeg.id);
        if (segIndex == -1) {
            return null;
        }
        int partIndex = trgSegs.getPartIndex(segIndex);
        theTarget.split(partIndex, splitPos, splitPos, false);
        Segment newSeg = trgSegs.get(segIndex + 1);
        if (variantOptions.contains((Object)IAlignedSegments.VariantOptions.MODIFY_TARGET)) {
            ISegments currentSegs;
            Segment currentSeg;
            Segment tempSeg = newSeg.clone();
            if (!copyOptions.contains((Object)IAlignedSegments.CopyOptions.COPY_TO_TARGET)) {
                tempSeg.getContent().clear();
            }
            if ((currentSeg = (currentSegs = this.getSource(trgLoc).getSegments()).get(trgSeg.id)) != null) {
                currentSegs.insert(currentSegs.getIndex(trgSeg.id) + 1, tempSeg);
            }
        }
        this.propagateChangesForSplit(newSeg, trgSeg.id, trgLoc, variantOptions, copyOptions);
        return newSeg;
    }

    @Override
    public void joinWithNext(Segment seg, LocaleId trgLoc, EnumSet<IAlignedSegments.VariantOptions> variantOptions) {
        if (!this.continueWithOperation(trgLoc, variantOptions)) {
            return;
        }
        if (variantOptions.contains((Object)IAlignedSegments.VariantOptions.MODIFY_SOURCE)) {
            this.doJoinWithNext(this.getSource(trgLoc), seg.id);
        }
        if (variantOptions.contains((Object)IAlignedSegments.VariantOptions.MODIFY_TARGET)) {
            this.doJoinWithNext(this.myParent.getTarget_DIFF(trgLoc), seg.id);
        }
        if (variantOptions.contains((Object)IAlignedSegments.VariantOptions.MODIFY_TARGETS_WITH_SAME_SOURCE)) {
            for (TextContainer targ : this.getSameSourceTargets(trgLoc)) {
                this.doJoinWithNext(targ, seg.id);
            }
        }
        if (variantOptions.contains((Object)IAlignedSegments.VariantOptions.MODIFY_VARIANT_SOURCES)) {
            for (TextContainer variant : this.getOtherSources(trgLoc)) {
                this.doJoinWithNext(variant, seg.id);
            }
        }
        if (variantOptions.contains((Object)IAlignedSegments.VariantOptions.MODIFY_TARGETS_OF_VARIANT_SOURCES)) {
            for (TextContainer variantTarg : this.getTargetsOfOtherSources(trgLoc)) {
                this.doJoinWithNext(variantTarg, seg.id);
            }
        }
    }

    private void doJoinWithNext(TextContainer targ, String segId) {
        ISegments segs = targ.getSegments();
        int segIndex = segs.getIndex(segId);
        if (segIndex != -1) {
            segs.joinWithNext(segIndex);
        }
    }

    @Override
    public void joinAll(LocaleId trgLoc, EnumSet<IAlignedSegments.VariantOptions> variantOptions) {
        if (!this.continueWithOperation(trgLoc, variantOptions)) {
            return;
        }
        if (variantOptions.contains((Object)IAlignedSegments.VariantOptions.MODIFY_SOURCE)) {
            this.getSource(trgLoc).joinAll();
        }
        if (variantOptions.contains((Object)IAlignedSegments.VariantOptions.MODIFY_TARGET)) {
            this.myParent.getTarget_DIFF(trgLoc).joinAll();
        }
        if (variantOptions.contains((Object)IAlignedSegments.VariantOptions.MODIFY_TARGETS_WITH_SAME_SOURCE)) {
            for (TextContainer targ : this.getSameSourceTargets(trgLoc)) {
                targ.joinAll();
            }
        }
        if (variantOptions.contains((Object)IAlignedSegments.VariantOptions.MODIFY_VARIANT_SOURCES)) {
            for (TextContainer variant : this.getOtherSources(trgLoc)) {
                variant.joinAll();
            }
        }
        if (variantOptions.contains((Object)IAlignedSegments.VariantOptions.MODIFY_TARGETS_OF_VARIANT_SOURCES)) {
            for (TextContainer variantTarg : this.getTargetsOfOtherSources(trgLoc)) {
                variantTarg.joinAll();
            }
        }
    }

    @Override
    public AlignmentStatus getAlignmentStatus() {
        for (LocaleId loc : this.myParent.getTargetLocales()) {
            ISegments trgSegs = this.myParent.getTarget_DIFF(loc).getSegments();
            if (trgSegs.getAlignmentStatus() != AlignmentStatus.NOT_ALIGNED) continue;
            return AlignmentStatus.NOT_ALIGNED;
        }
        return AlignmentStatus.ALIGNED;
    }

    @Override
    public AlignmentStatus getAlignmentStatus(LocaleId trgLoc) {
        return this.myParent.getTarget_DIFF(trgLoc).getSegments().getAlignmentStatus();
    }

    @Override
    public void segmentSource(ISegmenter segmenter, LocaleId targetLocale) {
        TextContainer theSource = this.getSource(targetLocale);
        segmenter.computeSegments(theSource);
        theSource.getSegments().create(segmenter.getRanges());
    }

    @Override
    public void segmentTarget(ISegmenter segmenter, LocaleId targetLocale) {
        TextContainer theTarget = this.myParent.getTarget_DIFF(targetLocale);
        segmenter.computeSegments(theTarget);
        theTarget.getSegments().create(segmenter.getRanges());
    }

    @Override
    public Iterator<Segment> iterator() {
        return this.myParent.getSource().getSegments().iterator();
    }

    @Override
    public Iterator<Segment> iterator(LocaleId trgLoc) {
        return this.getSource(trgLoc).getSegments().iterator();
    }

    private boolean hasMultipleTargets(LocaleId targetLocale) {
        if (this.hasVariant(targetLocale)) {
            return false;
        }
        int targetsOfDefault = 0;
        for (LocaleId loc : this.myParent.getTargetLocales()) {
            if (!this.myParent.getVariantSources().getLocales().contains(loc)) {
                ++targetsOfDefault;
            }
            if (targetsOfDefault <= 1) continue;
            return true;
        }
        return false;
    }

    private Set<TextContainer> getSameSourceTargets(LocaleId targetLocale) {
        HashSet<LocaleId> locales = new HashSet<LocaleId>();
        if (this.hasMultipleTargets(targetLocale)) {
            locales.addAll(this.myParent.getTargetLocales());
            locales.remove(targetLocale);
            if (this.myParent.hasVariantSources()) {
                locales.removeAll(this.myParent.getVariantSources().getLocales());
            }
        }
        HashSet<TextContainer> targets = new HashSet<TextContainer>();
        for (LocaleId loc : locales) {
            targets.add(this.myParent.getTarget_DIFF(loc));
        }
        return targets;
    }

    private Set<TextContainer> getOtherSources(LocaleId loc) {
        HashSet<TextContainer> sources = new HashSet<TextContainer>();
        if (!this.myParent.hasVariantSources()) {
            return sources;
        }
        for (LocaleId varLoc : this.myParent.getVariantSources().getLocales()) {
            sources.add(this.myParent.getVariantSources().get(varLoc));
        }
        sources.add(this.myParent.getSource());
        sources.remove(this.getSource(loc));
        return sources;
    }

    private Set<TextContainer> getTargetsOfOtherSources(LocaleId loc) {
        Set<Object> locales = new HashSet();
        if (this.hasVariant(loc)) {
            locales = this.myParent.getTargetLocales();
        } else if (this.myParent.hasVariantSources()) {
            locales = this.myParent.getVariantSources().getLocales();
        }
        locales.remove(loc);
        HashSet<TextContainer> targets = new HashSet<TextContainer>();
        for (LocaleId localeId : locales) {
            targets.add(this.myParent.getTarget_DIFF(localeId));
        }
        return targets;
    }

    private boolean hasVariant(LocaleId loc) {
        if (this.myParent.hasVariantSources()) {
            return this.myParent.getVariantSources().hasVariant(loc);
        }
        return false;
    }

    private TextContainer getSource(LocaleId loc) {
        if (this.hasVariant(loc)) {
            return this.myParent.getVariantSources().get(loc);
        }
        return this.myParent.getSource();
    }
}

