/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.resource;

import java.util.EnumSet;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.filterwriter.GenericContent;
import net.sf.okapi.common.resource.IAlignedSegments;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit4;
import org.junit.Assert;
import org.junit.Test;

public class AlignedSegmentsTest {
    private static final LocaleId locFR = LocaleId.FRENCH;
    private static final LocaleId locES = LocaleId.SPANISH;
    private static final String TU1 = "tu1";
    private GenericContent fmt = new GenericContent();

    @Test
    public void loopThroughSegments() {
        IAlignedSegments.VariantOptions v = IAlignedSegments.VariantOptions.MODIFY_SOURCE;
        ITextUnit tu = this.createSegmentedTUAndTarget();
        IAlignedSegments as = tu.getAlignedSegments();
        for (Segment srcSeg : as) {
            Segment trgSeg;
            if (srcSeg.id.equals("0")) {
                Assert.assertEquals((Object)"Part 1.", (Object)srcSeg.text.toString());
                trgSeg = as.getCorrespondingTarget(srcSeg, locFR, EnumSet.of(IAlignedSegments.VariantOptions.CANCEL_IF_MULTIPLE_TARGETS), IAlignedSegments.COPY_TO_NONE);
                Assert.assertEquals((Object)"Trg 1.", (Object)trgSeg.text.toString());
                continue;
            }
            Assert.assertEquals((Object)"Part 2.", (Object)srcSeg.text.toString());
            trgSeg = as.getCorrespondingTarget(srcSeg, locES, EnumSet.of(IAlignedSegments.VariantOptions.CANCEL_IF_MULTIPLE_TARGETS), IAlignedSegments.COPY_TO_NONE);
            Assert.assertEquals((Object)"Objetivo 2.", (Object)trgSeg.text.toString());
        }
    }

    @Test
    public void getSegmentsTest() {
        TextUnit4 tu = new TextUnit4(TU1);
        tu.setSourceContent(new TextFragment("text"));
        IAlignedSegments as = tu.getAlignedSegments();
        Assert.assertNotNull((Object)as);
    }

    @Test
    public void removeSegmentsTest() {
        ITextUnit tu = this.createSegmentedTU();
        IAlignedSegments as = tu.getAlignedSegments();
        Segment seg = as.getSource(0, locFR);
        Assert.assertEquals((Object)"0", (Object)seg.id);
        as.remove(seg, locFR, IAlignedSegments.MODIFY_ALL);
        seg = as.getSource(0, locFR);
        Assert.assertEquals((Object)"s2", (Object)seg.id);
    }

    @Test
    public void removeSegmentsWithTargetTest() {
        ITextUnit tu = this.createSegmentedTUAndTarget();
        IAlignedSegments as = tu.getAlignedSegments();
        Segment seg = as.getSource(0, locFR);
        Assert.assertEquals((Object)"0", (Object)seg.id);
        as.remove(seg, locFR, IAlignedSegments.MODIFY_ALL);
        ISegments segs = tu.getTargetSegments(locFR);
        seg = segs.get(0);
        Assert.assertEquals((Object)"s2", (Object)seg.id);
    }

    @Test
    public void insertSourceSegmentTest() {
        ITextUnit tu = this.createSegmentedTUAndTarget();
        IAlignedSegments as = tu.getAlignedSegments();
        Segment seg1 = new Segment("newId");
        as.insert(1, seg1, null, locFR, IAlignedSegments.MODIFY_ALL, EnumSet.of(IAlignedSegments.CopyOptions.COPY_TO_SOURCE));
        Segment seg2 = as.getSource(1, locFR);
        Assert.assertSame((Object)seg1, (Object)seg2);
        Segment seg3 = as.getSource(2, locFR);
        Assert.assertEquals((Object)"s2", (Object)seg3.id);
        Segment seg4 = as.getCorrespondingTarget(seg2, locFR, IAlignedSegments.MODIFY_ALL, IAlignedSegments.COPY_TO_NONE);
        Assert.assertEquals((Object)seg1.id, (Object)seg4.id);
    }

    @Test
    public void insertSourceSegmentChangeIdTest() {
        ITextUnit tu = this.createSegmentedTUAndTarget();
        IAlignedSegments as = tu.getAlignedSegments();
        Segment seg1 = new Segment("s2");
        as.insert(1, seg1, null, locFR, IAlignedSegments.MODIFY_ALL, EnumSet.of(IAlignedSegments.CopyOptions.COPY_TO_SOURCE));
        Segment seg2 = as.getSource(1, locFR);
        Assert.assertSame((Object)seg1, (Object)seg2);
        Assert.assertEquals((Object)"1", (Object)seg2.id);
        Segment seg4 = as.getCorrespondingTarget(seg2, locFR, IAlignedSegments.MODIFY_ALL, IAlignedSegments.COPY_TO_NONE);
        Assert.assertEquals((Object)seg1.id, (Object)seg4.id);
    }

    @Test
    public void insertSegmentsChangeIdTest() {
        ITextUnit tu = this.createSegmentedTUAndTarget();
        IAlignedSegments as = tu.getAlignedSegments();
        Segment insertSrcSeg = new Segment("s2");
        Segment insertTrgSeg = new Segment("zzId", new TextFragment("[text]"));
        as.insert(1, insertSrcSeg, insertTrgSeg, locFR, IAlignedSegments.MODIFY_ALL, IAlignedSegments.COPY_TO_SOURCE_AND_TARGET);
        Segment srcAtInsertedIndex = as.getSource(1, locFR);
        Assert.assertSame((String)"The given source should be inserted at the index (not a copy)", (Object)insertSrcSeg, (Object)srcAtInsertedIndex);
        Assert.assertEquals((Object)"1", (Object)srcAtInsertedIndex.id);
        Segment trgAtInsertedIndex = as.getCorrespondingTarget(srcAtInsertedIndex, locFR, IAlignedSegments.MODIFY_ALL, IAlignedSegments.COPY_TO_NONE);
        Assert.assertEquals((Object)"[text]", (Object)trgAtInsertedIndex.toString());
        Assert.assertEquals((Object)insertSrcSeg.id, (Object)trgAtInsertedIndex.id);
    }

    @Test
    public void splitSourceSegmentTest() {
        ITextUnit tu = this.createSegmentedTUAndTarget();
        IAlignedSegments as = tu.getAlignedSegments();
        Segment srcSeg = as.getSource(1, locFR);
        Segment newSrcSeg = as.splitSource(locFR, srcSeg, 5, IAlignedSegments.MODIFY_ALL, IAlignedSegments.COPY_TO_NONE);
        Assert.assertNotNull((Object)newSrcSeg);
        Assert.assertEquals((Object)"2.", (Object)newSrcSeg.text.toString());
        Assert.assertEquals((Object)"Part ", (Object)srcSeg.text.toString());
        Segment newTrgSeg = as.getCorrespondingTarget(newSrcSeg, locFR, IAlignedSegments.MODIFY_ALL, IAlignedSegments.COPY_TO_NONE);
        Assert.assertNotNull((Object)newTrgSeg);
        Assert.assertTrue((boolean)newTrgSeg.text.isEmpty());
        Assert.assertEquals((Object)"[Part 1.] a [Part ][2.]", (Object)this.fmt.printSegmentedContent(tu.getSource(), true));
        Assert.assertEquals((Object)"[Trg 1.] a [Trg 2.][]", (Object)this.fmt.printSegmentedContent(tu.getTarget_DIFF(locFR), true));
        Assert.assertEquals((Object)"[Objetivo 1.] a [Objetivo 2.][]", (Object)this.fmt.printSegmentedContent(tu.getTarget_DIFF(locES), true));
    }

    @Test
    public void splitTargetSegmentTest() {
        ITextUnit tu = this.createSegmentedTUAndTarget();
        IAlignedSegments as = tu.getAlignedSegments();
        Segment trgSeg = tu.getTargetSegments(locFR).get(1);
        Segment newTrgSeg = as.splitTarget(locFR, trgSeg, 4, IAlignedSegments.MODIFY_ALL, IAlignedSegments.COPY_TO_NONE);
        Assert.assertNotNull((Object)newTrgSeg);
        Assert.assertEquals((Object)"2.", (Object)newTrgSeg.text.toString());
        Assert.assertEquals((Object)"Trg ", (Object)trgSeg.text.toString());
        Segment newSrcSeg = as.getCorrespondingSource(newTrgSeg, locFR, IAlignedSegments.MODIFY_ALL, IAlignedSegments.COPY_TO_NONE);
        Assert.assertNotNull((Object)newSrcSeg);
        Assert.assertTrue((boolean)newSrcSeg.text.isEmpty());
        Assert.assertEquals((Object)"[Part 1.] a [Part 2.][]", (Object)this.fmt.printSegmentedContent(tu.getSource(), true));
        Assert.assertEquals((Object)"[Trg 1.] a [Trg ][2.]", (Object)this.fmt.printSegmentedContent(tu.getTarget_DIFF(locFR), true));
        Assert.assertEquals((Object)"[Objetivo 1.] a [Objetivo 2.][]", (Object)this.fmt.printSegmentedContent(tu.getTarget_DIFF(locES), true));
    }

    @Test
    public void setSourceTest() {
        ITextUnit tu = this.createSegmentedTUAndTarget();
        IAlignedSegments as = tu.getAlignedSegments();
        Segment newSeg = new Segment("newId", new TextFragment("newText"));
        as.setSegment(1, newSeg, locFR, EnumSet.of(IAlignedSegments.VariantOptions.MODIFY_SOURCE), IAlignedSegments.MODIFY_ALL);
        Segment seg = as.getSource(1, locFR);
        Assert.assertEquals((Object)"newText", (Object)seg.toString());
        Assert.assertEquals((Object)"newId", (Object)seg.id);
        seg = as.getCorrespondingTarget(newSeg, locES, IAlignedSegments.MODIFY_ALL, IAlignedSegments.COPY_TO_NONE);
        Assert.assertEquals((Object)"newId", (Object)seg.id);
        seg = as.getCorrespondingTarget(newSeg, locFR, IAlignedSegments.MODIFY_ALL, IAlignedSegments.COPY_TO_NONE);
        Assert.assertEquals((Object)"newId", (Object)seg.id);
    }

    @Test
    public void setTargetTest() {
        ITextUnit tu = this.createSegmentedTUAndTarget();
        IAlignedSegments as = tu.getAlignedSegments();
        Segment newSeg = new Segment("newId", new TextFragment("newText"));
        as.setSegment(1, newSeg, locFR, EnumSet.of(IAlignedSegments.VariantOptions.MODIFY_TARGET), IAlignedSegments.MODIFY_ALL);
        Segment seg = as.getSource(1, locFR);
        Assert.assertEquals((Object)"newId", (Object)seg.id);
        seg = as.getCorrespondingTarget(seg, locFR, IAlignedSegments.MODIFY_ALL, IAlignedSegments.COPY_TO_NONE);
        Assert.assertEquals((Object)"newText", (Object)seg.toString());
        seg = as.getCorrespondingTarget(newSeg, locES, IAlignedSegments.MODIFY_ALL, IAlignedSegments.COPY_TO_NONE);
        Assert.assertNotNull((Object)seg);
        Assert.assertEquals((Object)"newId", (Object)seg.id);
    }

    @Test
    public void getSourceTest() {
        ITextUnit tu = this.createSegmentedTUAndTarget();
        IAlignedSegments as = tu.getAlignedSegments();
        Assert.assertEquals((Object)"Part 2.", (Object)as.getSource((int)1, (LocaleId)AlignedSegmentsTest.locFR).text.toString());
    }

    @Test
    public void getCorrespondingTargetTest() {
        ITextUnit tu = this.createSegmentedTUAndTarget();
        IAlignedSegments as = tu.getAlignedSegments();
        Segment srcSeg = as.getSource(1, locFR);
        Segment trgSeg = as.getCorrespondingTarget(srcSeg, locFR, IAlignedSegments.MODIFY_ALL, IAlignedSegments.COPY_TO_NONE);
        Assert.assertEquals((Object)"Trg 2.", (Object)trgSeg.text.toString());
        trgSeg = as.getCorrespondingTarget(trgSeg, locES, IAlignedSegments.MODIFY_ALL, IAlignedSegments.COPY_TO_NONE);
        Assert.assertEquals((Object)"Objetivo 2.", (Object)trgSeg.text.toString());
    }

    @Test
    public void getCorrespondingSourceTest() {
        ITextUnit tu = this.createSegmentedTUAndTarget();
        IAlignedSegments as = tu.getAlignedSegments();
        Segment srcSeg1 = as.getSource(1, locFR);
        Segment trgSeg = as.getCorrespondingTarget(srcSeg1, locES, IAlignedSegments.MODIFY_ALL, IAlignedSegments.COPY_TO_NONE);
        Segment srcSeg2 = as.getCorrespondingSource(trgSeg, locFR, IAlignedSegments.MODIFY_ALL, IAlignedSegments.COPY_TO_NONE);
        Assert.assertSame((Object)srcSeg1, (Object)srcSeg2);
    }

    @Test
    public void joinWithNextTest() {
        ITextUnit tu = this.createSegmentedTUAndTarget();
        IAlignedSegments as = tu.getAlignedSegments();
        as.append(new Segment("nId", new TextFragment("newSrcText")), new Segment("nId", new TextFragment("newTrgText")), locFR, IAlignedSegments.MODIFY_ALL, IAlignedSegments.COPY_TO_SOURCE_AND_TARGET);
        Assert.assertEquals((Object)"[Part 1.] a [Part 2.][newSrcText]", (Object)this.fmt.printSegmentedContent(tu.getSource(), true));
        Assert.assertEquals((Object)"[Trg 1.] a [Trg 2.][newTrgText]", (Object)this.fmt.printSegmentedContent(tu.getTarget_DIFF(locFR), true));
        Assert.assertEquals((Object)"[Objetivo 1.] a [Objetivo 2.][]", (Object)this.fmt.printSegmentedContent(tu.getTarget_DIFF(locES), true));
        Segment srcSeg = as.getSource(1, locFR);
        as.joinWithNext(srcSeg, locFR, IAlignedSegments.MODIFY_ALL);
        Assert.assertEquals((Object)"[Part 1.] a [Part 2.newSrcText]", (Object)this.fmt.printSegmentedContent(tu.getSource(), true));
        Assert.assertEquals((Object)"[Trg 1.] a [Trg 2.newTrgText]", (Object)this.fmt.printSegmentedContent(tu.getTarget_DIFF(locFR), true));
        Assert.assertEquals((Object)"[Objetivo 1.] a [Objetivo 2.]", (Object)this.fmt.printSegmentedContent(tu.getTarget_DIFF(locES), true));
        srcSeg = as.getSource(0, locFR);
        as.joinWithNext(srcSeg, locFR, IAlignedSegments.MODIFY_ALL);
        Assert.assertEquals((Object)"[Part 1. a Part 2.newSrcText]", (Object)this.fmt.printSegmentedContent(tu.getSource(), true));
        Assert.assertEquals((Object)"[Trg 1. a Trg 2.newTrgText]", (Object)this.fmt.printSegmentedContent(tu.getTarget_DIFF(locFR), true));
        Assert.assertEquals((Object)"[Objetivo 1. a Objetivo 2.]", (Object)this.fmt.printSegmentedContent(tu.getTarget_DIFF(locES), true));
    }

    @Test
    public void joinAllTest() {
        ITextUnit tu = this.createSegmentedTUAndTarget();
        IAlignedSegments as = tu.getAlignedSegments();
        as.joinAll(locFR, IAlignedSegments.MODIFY_ALL);
        Assert.assertEquals((Object)"[Part 1. a Part 2.]", (Object)this.fmt.printSegmentedContent(tu.getSource(), true));
        Assert.assertEquals((Object)"[Trg 1. a Trg 2.]", (Object)this.fmt.printSegmentedContent(tu.getTarget_DIFF(locFR), true));
        Assert.assertEquals((Object)"[Objetivo 1. a Objetivo 2.]", (Object)this.fmt.printSegmentedContent(tu.getTarget_DIFF(locES), true));
    }

    @Test
    public void appendSegmentTest1() {
        ITextUnit tu = this.createSegmentedTUAndTarget();
        IAlignedSegments as = tu.getAlignedSegments();
        Segment seg = new Segment("nId", new TextFragment("newSrcText"));
        as.append(seg, null, locFR, IAlignedSegments.MODIFY_ALL, EnumSet.of(IAlignedSegments.CopyOptions.COPY_TO_SOURCE));
        Assert.assertEquals((Object)"newSrcText", (Object)as.getSource(2, locFR).toString());
        Assert.assertEquals((Object)"nId", (Object)as.getCorrespondingTarget((Segment)seg, (LocaleId)AlignedSegmentsTest.locFR, IAlignedSegments.MODIFY_ALL, IAlignedSegments.COPY_TO_NONE).id);
        Assert.assertEquals((Object)"[Part 1.] a [Part 2.][newSrcText]", (Object)this.fmt.printSegmentedContent(tu.getSource(), true));
        Assert.assertEquals((Object)"[Trg 1.] a [Trg 2.][]", (Object)this.fmt.printSegmentedContent(tu.getTarget_DIFF(locFR), true));
        Assert.assertEquals((Object)"[Objetivo 1.] a [Objetivo 2.][]", (Object)this.fmt.printSegmentedContent(tu.getTarget_DIFF(locES), true));
    }

    @Test
    public void appendSegmentTest2() {
        ITextUnit tu = this.createSegmentedTUAndTarget();
        IAlignedSegments as = tu.getAlignedSegments();
        Segment seg = new Segment("nId", new TextFragment("newSrcText"));
        as.append(seg, new Segment("nId", new TextFragment("newTrgText")), locFR, IAlignedSegments.MODIFY_ALL, IAlignedSegments.COPY_TO_SOURCE_AND_TARGET);
        Assert.assertEquals((Object)"newSrcText", (Object)as.getSource(2, locFR).toString());
        Assert.assertEquals((Object)"nId", (Object)as.getCorrespondingTarget((Segment)seg, (LocaleId)AlignedSegmentsTest.locFR, IAlignedSegments.MODIFY_ALL, IAlignedSegments.COPY_TO_NONE).id);
        Assert.assertEquals((Object)"newTrgText", (Object)as.getCorrespondingTarget(seg, locFR, IAlignedSegments.MODIFY_ALL, IAlignedSegments.COPY_TO_NONE).toString());
        Assert.assertEquals((Object)"[Part 1.] a [Part 2.][newSrcText]", (Object)this.fmt.printSegmentedContent(tu.getSource(), true));
        Assert.assertEquals((Object)"[Trg 1.] a [Trg 2.][newTrgText]", (Object)this.fmt.printSegmentedContent(tu.getTarget_DIFF(locFR), true));
        Assert.assertEquals((Object)"[Objetivo 1.] a [Objetivo 2.][]", (Object)this.fmt.printSegmentedContent(tu.getTarget_DIFF(locES), true));
    }

    private ITextUnit createSegmentedTU() {
        TextUnit4 tu = new TextUnit4("id", "Part 1.");
        tu.getSource().getSegments().append(new Segment("s2", new TextFragment("Part 2.")), " a ");
        return tu;
    }

    private ITextUnit createSegmentedTUAndTarget() {
        ITextUnit tu = this.createSegmentedTU();
        ISegments segs = tu.getTarget_DIFF(locFR).getSegments();
        segs.get((int)0).text.append("Trg 1.");
        segs.get((int)1).text.append("Trg 2.");
        segs = tu.getTarget_DIFF(locES).getSegments();
        segs.get((int)0).text.append("Objetivo 1.");
        segs.get((int)1).text.append("Objetivo 2.");
        return tu;
    }
}

