/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.resource;

import java.util.ArrayList;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.GenericSkeletonWriter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ResourcesTest {
    LocaleId locEN = LocaleId.fromString("en");
    LocaleId locSV = LocaleId.fromString("sv");

    @Before
    public void setUp() throws Exception {
    }

    @Test
    public void testMETATag1() {
        String test = "<meta http-equiv=\"keywords\" content=\"one,two,three\"/>";
        ArrayList<Event> list = new ArrayList<Event>();
        StartDocument sd = new StartDocument("sd");
        sd.setEncoding("UTF-16", false);
        sd.setMultilingual(true);
        sd.setLocale(this.locEN);
        sd.setLineBreak("\n");
        list.add(new Event(EventType.START_DOCUMENT, sd));
        GenericSkeleton skel = new GenericSkeleton();
        TextUnit tu = new TextUnit("t1", "one,two,three");
        skel.add("content=\"");
        skel.addContentPlaceholder(tu);
        skel.add("\"");
        tu.setIsReferent(true);
        tu.setName("content");
        tu.setSkeleton(skel);
        list.add(new Event(EventType.TEXT_UNIT, tu));
        skel = new GenericSkeleton();
        DocumentPart dp = new DocumentPart("dp1", false);
        skel.add("<meta http-equiv=\"keywords\" ");
        skel.addReference(tu);
        skel.add("/>");
        dp.setSkeleton(skel);
        list.add(new Event(EventType.DOCUMENT_PART, dp));
        Assert.assertEquals((Object)this.generateOutput(list, test, this.locEN), (Object)test);
    }

    @Test
    public void testPWithAttributes() {
        String test = "<p title='my title'>Text of p</p>";
        ArrayList<Event> list = new ArrayList<Event>();
        StartDocument sd = new StartDocument("sd");
        sd.setEncoding("UTF-16", false);
        sd.setMultilingual(true);
        sd.setLocale(this.locEN);
        sd.setLineBreak("\n");
        list.add(new Event(EventType.START_DOCUMENT, sd));
        GenericSkeleton skel = new GenericSkeleton();
        TextUnit tu1 = new TextUnit("t1", "my title");
        skel.add("title='");
        skel.addContentPlaceholder(tu1);
        skel.add("'");
        tu1.setIsReferent(true);
        tu1.setName("title");
        tu1.setSkeleton(skel);
        list.add(new Event(EventType.TEXT_UNIT, tu1));
        skel = new GenericSkeleton();
        TextUnit tu2 = new TextUnit("tu2", "Text of p");
        skel.add("<p ");
        skel.addReference(tu1);
        skel.add(">");
        skel.addContentPlaceholder(tu2);
        skel.append("</p>");
        tu2.setSkeleton(skel);
        list.add(new Event(EventType.TEXT_UNIT, tu2));
        Assert.assertEquals((Object)this.generateOutput(list, test, this.locEN), (Object)test);
    }

    @Test
    public void testComplexEmptyElement() {
        String test = "<elem wr-prop1='wr-value1' ro-prop1='ro-value1' wr-prop2='wr-value2' text='text'/>";
        ArrayList<Event> list = new ArrayList<Event>();
        StartDocument sd = new StartDocument("sd");
        sd.setEncoding("UTF-16", false);
        sd.setMultilingual(true);
        sd.setLocale(this.locEN);
        sd.setLineBreak("\n");
        list.add(new Event(EventType.START_DOCUMENT, sd));
        GenericSkeleton skel = new GenericSkeleton();
        TextUnit tu = new TextUnit("t1", "text");
        skel.add("text='");
        skel.addContentPlaceholder(tu);
        skel.add("'");
        tu.setIsReferent(true);
        tu.setName("text");
        tu.setSkeleton(skel);
        list.add(new Event(EventType.TEXT_UNIT, tu));
        skel = new GenericSkeleton();
        DocumentPart dp = new DocumentPart("dp1", false);
        skel.add("<elem wr-prop1='");
        dp.setSourceProperty(new Property("wr-prop1", "wr-value1", false));
        skel.addValuePlaceholder(dp, "wr-prop1", null);
        skel.add("' ro-prop1='ro-value1' wr-prop2='");
        dp.setSourceProperty(new Property("ro-prop1", "ro-value1"));
        dp.setSourceProperty(new Property("wr-prop2", "wr-value2", false));
        skel.addValuePlaceholder(dp, "wr-prop2", null);
        skel.append("' ");
        skel.addReference(tu);
        skel.append("/>");
        dp.setSkeleton(skel);
        list.add(new Event(EventType.DOCUMENT_PART, dp));
        Assert.assertEquals((Object)this.generateOutput(list, test, this.locEN), (Object)test);
    }

    @Test
    public void testPWithInlines() {
        String test = "<p>Before <b>bold</b> <a href=\"there\"/> after.</p>";
        ArrayList<Event> list = new ArrayList<Event>();
        StartDocument sd = new StartDocument("sd");
        sd.setEncoding("UTF-16", false);
        sd.setMultilingual(true);
        sd.setLocale(this.locEN);
        sd.setLineBreak("\n");
        list.add(new Event(EventType.START_DOCUMENT, sd));
        GenericSkeleton skel = new GenericSkeleton();
        DocumentPart dp1 = new DocumentPart("dp1", true);
        skel.add("<a href=\"");
        skel.addValuePlaceholder(dp1, "href", null);
        dp1.setSourceProperty(new Property("href", "there", false));
        skel.add("\"/>");
        dp1.setName("a");
        dp1.setSkeleton(skel);
        list.add(new Event(EventType.DOCUMENT_PART, dp1));
        skel = new GenericSkeleton();
        TextFragment tf = new TextFragment("Before ");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append("bold");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(" ");
        Code code = new Code(TextFragment.TagType.PLACEHOLDER, "a");
        code.appendReference("dp1");
        tf.append(code);
        tf.append(" after.");
        TextUnit tu1 = new TextUnit("tu1");
        tu1.setSourceContent(tf);
        skel.add("<p>");
        skel.addContentPlaceholder(tu1);
        skel.append("</p>");
        tu1.setSkeleton(skel);
        list.add(new Event(EventType.TEXT_UNIT, tu1));
        Assert.assertEquals((Object)this.generateOutput(list, test, this.locEN), (Object)test);
    }

    @Test
    public void testMETATag2() {
        String test = "<meta http-equiv=\"Content-Language\" content=\"en\"/>";
        ArrayList<Event> list = new ArrayList<Event>();
        StartDocument sd = new StartDocument("sd");
        sd.setEncoding("UTF-16", false);
        sd.setMultilingual(true);
        sd.setLocale(this.locEN);
        sd.setLineBreak("\n");
        list.add(new Event(EventType.START_DOCUMENT, sd));
        GenericSkeleton skel = new GenericSkeleton();
        DocumentPart dp = new DocumentPart("dp1", false);
        skel.add("<meta http-equiv=\"Content-Language\" content=\"");
        skel.addValuePlaceholder(dp, "language", null);
        skel.add("\"/>");
        dp.setSourceProperty(new Property("language", this.locEN.toString(), false));
        dp.setSkeleton(skel);
        list.add(new Event(EventType.DOCUMENT_PART, dp));
        Assert.assertEquals((Object)this.generateOutput(list, test, this.locEN), (Object)test);
    }

    @Test
    public void testTMXTU() {
        String test = "<tu><tuv xml:lang='EN'><seg>T1-en<sub>Sub-en</sub>T2-en</seg></tuv><tuv xml:lang='SV'><seg>T1-sv<sub>Sub-sv</sub>T2-sv</seg></tuv></tu>";
        ArrayList<Event> list = new ArrayList<Event>();
        StartDocument sd = new StartDocument("sd");
        sd.setEncoding("UTF-16", false);
        sd.setMultilingual(true);
        sd.setLocale(this.locEN);
        sd.setLineBreak("\n");
        list.add(new Event(EventType.START_DOCUMENT, sd));
        TextUnit tu = new TextUnit("tu");
        GenericSkeleton skel = new GenericSkeleton();
        skel.add("<tu><tuv xml:lang='EN'><seg>");
        TextFragment src = tu.getSource().getSegments().getFirstContent();
        src.append("T1-en");
        Code code = src.append(TextFragment.TagType.PLACEHOLDER, null, "<sub>");
        TextUnit tuSub = new TextUnit("tuSub", "Sub-en", true);
        GenericSkeleton skelSub = new GenericSkeleton();
        skelSub.addContentPlaceholder(tuSub);
        code.appendReference("tuSub");
        code.append("</sub>");
        src.append("T2-en");
        skel.addContentPlaceholder(tu);
        skel.add("</seg></tuv><tuv xml:lang='SV'><seg>");
        TextFragment trg = tu.setTargetContent(this.locSV, new TextFragment());
        trg.append("T1-sv");
        code = trg.append(TextFragment.TagType.PLACEHOLDER, null, "<sub>");
        tuSub.setTargetContent(this.locSV, new TextFragment("Sub-sv"));
        code.appendReference("tuSub");
        tuSub.setReferenceCount(tuSub.getReferenceCount() + 1);
        code.append("</sub>");
        trg.append("T2-sv");
        skel.addContentPlaceholder(tu, this.locSV);
        skel.add("</seg></tuv></tu>");
        tuSub.setSkeleton(skelSub);
        list.add(new Event(EventType.TEXT_UNIT, tuSub));
        tu.setSkeleton(skel);
        list.add(new Event(EventType.TEXT_UNIT, tu));
        this.generateOutput(list, test, this.locSV);
    }

    private String generateOutput(ArrayList<Event> list, String original, LocaleId outputLang) {
        GenericSkeletonWriter writer = new GenericSkeletonWriter();
        StringBuilder tmp = new StringBuilder();
        for (Event event : list) {
            switch (event.getEventType()) {
                case START_DOCUMENT: {
                    writer.processStartDocument(outputLang, "utf-8", null, new EncoderManager(), (StartDocument)event.getResource());
                    break;
                }
                case TEXT_UNIT: {
                    TextUnit tu = (TextUnit)event.getResource();
                    GenericSkeleton skl = (GenericSkeleton)tu.getSkeleton();
                    if (skl != null) {
                        // empty if block
                    }
                    tmp.append(writer.processTextUnit(tu));
                    break;
                }
                case DOCUMENT_PART: {
                    DocumentPart dp = (DocumentPart)event.getResource();
                    GenericSkeleton skl = (GenericSkeleton)dp.getSkeleton();
                    if (skl != null) {
                        // empty if block
                    }
                    tmp.append(writer.processDocumentPart(dp));
                }
            }
        }
        writer.close();
        return tmp.toString();
    }
}

