/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.resource;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import net.sf.okapi.common.Range;
import net.sf.okapi.common.annotation.Annotations;
import net.sf.okapi.common.annotation.IAnnotation;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.InvalidPositionException;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.Segments;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;

public class TextContainer
implements Iterable<TextPart> {
    private static final String PARTSEP1 = "\ue091";
    private static final String PARTSEP2 = "\ue092";
    private static final char PARTSEP1CHAR = '\ue091';
    private LinkedHashMap<String, Property> properties;
    private Annotations annotations;
    private List<TextPart> parts;
    private boolean segApplied;
    private Segments segments = new Segments(this);

    public ISegments getSegments() {
        return this.segments;
    }

    public static String contentToString(TextContainer tc) {
        StringBuilder tmp = new StringBuilder();
        tmp.append(tc.hasBeenSegmented() ? (char)'1' : '0');
        for (TextPart part : tc) {
            tmp.append(part.isSegment() ? (char)'1' : '0');
            tmp.append(part.text.getCodedText());
            tmp.append(PARTSEP1);
            tmp.append(Code.codesToString(part.text.getCodes()));
            tmp.append(PARTSEP1);
            if (part.isSegment()) {
                tmp.append(((Segment)part).id);
            }
            tmp.append(PARTSEP2);
        }
        return tmp.toString();
    }

    public static TextContainer stringToContent(String data) {
        TextContainer tc = new TextContainer();
        tc.setHasBeenSegmentedFlag(data.charAt(0) == '1');
        String[] chunks = data.substring(1).split(PARTSEP2, 0);
        tc.parts.clear();
        for (String chunk : chunks) {
            int n1 = chunk.indexOf(57489);
            int n2 = chunk.indexOf(57489, n1 + 1);
            TextFragment tf = new TextFragment(chunk.substring(1, n1), Code.stringToCodes(chunk.substring(n1 + 1, n2)));
            tc.parts.add(chunk.charAt(0) == '1' ? new Segment(chunk.substring(n2 + 1), tf) : new TextPart(tf));
        }
        return tc;
    }

    public static String[] contentToSplitStorage(TextContainer tc) {
        String[] res = new String[2];
        StringBuilder tmp1 = new StringBuilder();
        StringBuilder tmp2 = new StringBuilder();
        tmp1.append(tc.hasBeenSegmented() ? (char)'1' : '0');
        for (TextPart part : tc) {
            tmp1.append(part.isSegment() ? (char)'1' : '0');
            tmp1.append(part.text.getCodedText());
            tmp1.append(PARTSEP1);
            if (part.isSegment()) {
                tmp1.append(((Segment)part).id);
            }
            tmp1.append(PARTSEP2);
            tmp2.append(Code.codesToString(part.text.getCodes()));
            tmp2.append(PARTSEP2);
        }
        res[0] = tmp1.toString();
        res[1] = tmp2.toString();
        return res;
    }

    public static TextContainer splitStorageToContent(String ctext, String codes) {
        TextContainer tc = new TextContainer();
        tc.parts.clear();
        String[] codesParts = codes.split(PARTSEP2, -2);
        tc.setHasBeenSegmentedFlag(ctext.charAt(0) == '1');
        String[] chunks = ctext.substring(1).split(PARTSEP2, 0);
        int i = 0;
        for (String chunk : chunks) {
            int n = chunk.indexOf(57489);
            try {
                TextFragment tf = new TextFragment(chunk.substring(1, n), Code.stringToCodes(codesParts[i]));
                if (chunk.charAt(0) == '1') {
                    tc.parts.add(new Segment(chunk.substring(n + 1), tf));
                } else {
                    tc.parts.add(new TextPart(tf));
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            ++i;
        }
        return tc;
    }

    public TextContainer() {
        this.createSingleSegment(null);
    }

    public TextContainer(String text) {
        this.createSingleSegment(text);
    }

    public TextContainer(TextFragment fragment) {
        this.setContent(fragment);
    }

    public TextContainer(Segment segment) {
        if (segment.text == null) {
            segment.text = new TextFragment();
        }
        this.resetParts();
        this.parts.add(segment);
        this.segments.validateSegmentId(segment);
    }

    private void createSingleSegment(String text) {
        this.resetParts();
        Segment seg = new Segment("0", new TextFragment(text));
        this.parts.add(seg);
        this.segApplied = false;
    }

    private void resetParts() {
        this.parts = new ArrayList<TextPart>();
        this.segments.setParts(this.parts);
    }

    public String toString() {
        if (this.parts.size() == 1) {
            return this.parts.get(0).getContent().toText();
        }
        return this.createJoinedContent().toText();
    }

    @Override
    public Iterator<TextPart> iterator() {
        return new Iterator<TextPart>(){
            int current = 0;

            @Override
            public void remove() {
                throw new UnsupportedOperationException("The method remove() not supported.");
            }

            @Override
            public TextPart next() {
                if (this.current >= TextContainer.this.parts.size()) {
                    throw new NoSuchElementException("No more content parts.");
                }
                return (TextPart)TextContainer.this.parts.get(this.current++);
            }

            @Override
            public boolean hasNext() {
                return this.current < TextContainer.this.parts.size();
            }
        };
    }

    public int compareTo(TextContainer cont, boolean codeSensitive) {
        int res = 0;
        if (cont.contentIsOneSegment()) {
            if (this.contentIsOneSegment()) {
                return this.getFirstContent().compareTo(cont.getFirstContent(), codeSensitive);
            }
            res = this.getUnSegmentedContentCopy().compareTo(cont.getFirstContent(), codeSensitive);
        } else {
            res = this.contentIsOneSegment() ? this.getFirstContent().compareTo(cont.getUnSegmentedContentCopy(), codeSensitive) : this.getUnSegmentedContentCopy().compareTo(cont.getUnSegmentedContentCopy(), codeSensitive);
        }
        if (res != 0) {
            return res;
        }
        StringBuilder tmp1 = new StringBuilder();
        for (Range range : this.segments.getRanges()) {
            tmp1.append(range.toString());
        }
        StringBuilder tmp2 = new StringBuilder();
        for (Range range : cont.getSegments().getRanges()) {
            tmp2.append(range.toString());
        }
        return tmp1.toString().compareTo(tmp2.toString());
    }

    public boolean hasBeenSegmented() {
        return this.segApplied;
    }

    public void setHasBeenSegmentedFlag(boolean hasBeenSegmented) {
        this.segApplied = hasBeenSegmented;
    }

    public boolean contentIsOneSegment() {
        return this.parts.size() == 1 && this.parts.get(0).isSegment();
    }

    public void changePart(int partIndex) {
        if (this.parts.get(partIndex).isSegment()) {
            if (this.hasOnlyOneSegment()) {
                return;
            }
            this.parts.set(partIndex, new TextPart(this.parts.get((int)partIndex).text));
        } else {
            Segment seg = new Segment(null, this.parts.get((int)partIndex).text);
            this.segments.validateSegmentId(seg);
            this.parts.set(partIndex, seg);
            this.segApplied = true;
        }
    }

    public void insert(int partIndex, TextPart part) {
        this.parts.add(partIndex, part);
        if (part.isSegment()) {
            this.segments.validateSegmentId((Segment)part);
        }
        this.segApplied = true;
    }

    public void remove(int partIndex) {
        if (this.parts.get(partIndex).isSegment() && this.hasOnlyOneSegment()) {
            this.parts.get((int)partIndex).text.clear();
        } else {
            this.parts.remove(partIndex);
        }
    }

    public void append(TextFragment fragment, boolean collapseIfPreviousEmpty) {
        if (collapseIfPreviousEmpty) {
            if (this.parts.get(this.parts.size() - 1).getContent().isEmpty()) {
                this.parts.get((int)(this.parts.size() - 1)).text.append(fragment);
            } else {
                this.append(new TextPart(fragment), false);
            }
        } else {
            this.append(new TextPart(fragment), false);
        }
    }

    public void append(TextFragment fragment) {
        this.append(fragment, true);
    }

    public void append(String text, boolean collapseIfPreviousEmpty) {
        this.append(new TextPart(text), collapseIfPreviousEmpty);
    }

    public void append(String text) {
        this.append(text, true);
    }

    public void append(TextPart part, boolean collapseIfPreviousEmpty) {
        if (part.isSegment()) {
            this.getSegments().append((Segment)part, collapseIfPreviousEmpty);
            return;
        }
        if (collapseIfPreviousEmpty) {
            if (this.parts.get(this.parts.size() - 1).getContent().isEmpty()) {
                this.parts.set(this.parts.size() - 1, part);
            } else {
                this.parts.add(part);
            }
        } else {
            this.parts.add(part);
        }
        if (this.segments.count() == 0) {
            this.changePart(0);
        }
    }

    public void append(TextPart part) {
        this.append(part, true);
    }

    public String getCodedText() {
        if (this.parts.size() == 1) {
            return this.parts.get(0).getContent().getCodedText();
        }
        return this.createJoinedContent().getCodedText();
    }

    public void split(int partIndex, int start, int end, boolean spannedPartIsSegment) {
        TextPart part = this.parts.get(partIndex);
        if (end == -1) {
            end = part.text.text.length();
        }
        if (end < start) {
            throw new InvalidPositionException(String.format("Invalid segment boundaries: start=%d, end=%d.", start, end));
        }
        if (end - start == 0 && (start == 0 || end == part.text.text.length())) {
            return;
        }
        if (end - start >= part.text.text.length()) {
            return;
        }
        int newPartIndex = partIndex + 1;
        if (start == 0) {
            newPartIndex = partIndex;
        }
        boolean newPartIsSegment = spannedPartIsSegment;
        if (start == end) {
            newPartIsSegment = part.isSegment();
            end = part.text.text.length();
        }
        if (start == 0 || end == part.text.text.length()) {
            if (newPartIsSegment) {
                this.parts.add(newPartIndex, new Segment(null, part.text.subSequence(start, end)));
                this.segments.validateSegmentId((Segment)this.parts.get(newPartIndex));
            } else {
                this.parts.add(newPartIndex, new TextPart(part.text.subSequence(start, end)));
            }
            part.text.remove(start, end);
        } else {
            if (newPartIsSegment) {
                this.parts.add(newPartIndex, new Segment(null, part.text.subSequence(start, end)));
                this.segments.validateSegmentId((Segment)this.parts.get(newPartIndex));
            } else {
                this.parts.add(newPartIndex, new TextPart(part.text.subSequence(start, end)));
            }
            if (part.isSegment()) {
                this.parts.add(newPartIndex + 1, new Segment(null, part.text.subSequence(end, -1)));
                this.segments.validateSegmentId((Segment)this.parts.get(newPartIndex + 1));
            } else {
                this.parts.add(newPartIndex + 1, new TextPart(part.text.subSequence(end, -1)));
            }
            part.text.remove(start, -1);
        }
        this.segApplied = true;
    }

    public void unwrap(boolean trimEnds, boolean collapseMode) {
        int i;
        boolean wasWS = trimEnds;
        for (i = 0; i < this.parts.size(); ++i) {
            StringBuilder text = this.parts.get((int)i).text.text;
            block5: for (int j = 0; j < text.length(); ++j) {
                switch (text.charAt(j)) {
                    case '\ue101': 
                    case '\ue102': 
                    case '\ue103': {
                        ++j;
                        wasWS = false;
                        continue block5;
                    }
                    case '\t': 
                    case '\n': 
                    case ' ': {
                        if (wasWS) {
                            text.deleteCharAt(j);
                            --j;
                            continue block5;
                        }
                        text.setCharAt(j, ' ');
                        wasWS = true;
                        continue block5;
                    }
                    default: {
                        wasWS = false;
                    }
                }
            }
            if (this.parts.get(i).isSegment() && this.parts.size() > i + 1 && !this.parts.get(i + 1).isSegment() && text.toString().trim().length() == 0) {
                wasWS = collapseMode;
            }
            if (text.length() != 0 || this.parts.get(i).isSegment()) continue;
            this.parts.remove(i);
            --i;
        }
        if (trimEnds) {
            for (i = this.parts.size() - 1; i >= 0; --i) {
                TextPart part = this.parts.get(i);
                if (!part.text.getCodedText().endsWith(" ")) break;
                part.text.text.deleteCharAt(part.text.text.length() - 1);
                if (part.text.text.length() != 0) break;
                if (this.parts.get(i).isSegment()) continue;
                this.parts.remove(i);
            }
        }
    }

    public TextFragment getFirstContent() {
        return this.parts.get((int)0).text;
    }

    public Segment getFirstSegment() {
        for (TextPart part : this.parts) {
            if (!part.isSegment()) continue;
            return (Segment)part;
        }
        return null;
    }

    public TextFragment getLastContent() {
        return this.parts.get((int)(this.parts.size() - 1)).text;
    }

    public TextContainer clone() {
        return this.clone(true);
    }

    public TextContainer clone(boolean cloneProperties) {
        TextContainer newCont = new TextContainer();
        newCont.resetParts();
        for (TextPart part : this.parts) {
            newCont.parts.add(part.clone());
        }
        newCont.segApplied = this.segApplied;
        if (cloneProperties && this.properties != null) {
            newCont.properties = new LinkedHashMap();
            for (Property prop : this.properties.values()) {
                newCont.properties.put(prop.getName(), prop.clone());
            }
        }
        if (this.annotations != null) {
            newCont.annotations = this.annotations.clone();
        }
        return newCont;
    }

    public TextFragment getUnSegmentedContentCopy() {
        return this.createJoinedContent();
    }

    public void setContent(TextFragment content) {
        this.createSingleSegment(null);
        ((Segment)this.parts.get((int)0)).text = content;
    }

    public void clear() {
        this.createSingleSegment(null);
    }

    public boolean hasText(boolean lookInSegments, boolean whiteSpacesAreText) {
        for (TextPart part : this.parts) {
            if (!(part.isSegment() ? lookInSegments && part.getContent().hasText(whiteSpacesAreText) : part.getContent().hasText(whiteSpacesAreText))) continue;
            return true;
        }
        return false;
    }

    public boolean hasText(boolean whiteSpacesAreText) {
        for (TextPart part : this.parts) {
            if (!part.getContent().hasText(whiteSpacesAreText)) continue;
            return true;
        }
        return false;
    }

    public boolean hasText() {
        return this.hasText(false);
    }

    public boolean isEmpty() {
        for (TextPart part : this.parts) {
            if (part.getContent().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean hasProperty(String name) {
        return this.getProperty(name) != null;
    }

    public Property getProperty(String name) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(name);
    }

    public Property setProperty(Property property) {
        if (this.properties == null) {
            this.properties = new LinkedHashMap();
        }
        this.properties.put(property.getName(), property);
        return property;
    }

    public void removeProperty(String name) {
        if (this.properties != null) {
            this.properties.remove(name);
        }
    }

    public Set<String> getPropertyNames() {
        if (this.properties == null) {
            this.properties = new LinkedHashMap();
        }
        return this.properties.keySet();
    }

    public Annotations getAnnotations() {
        return this.annotations == null ? new Annotations() : this.annotations;
    }

    public <A extends IAnnotation> A getAnnotation(Class<A> type) {
        if (this.annotations == null) {
            return null;
        }
        return this.annotations.get(type);
    }

    public void setAnnotation(IAnnotation annotation) {
        if (this.annotations == null) {
            this.annotations = new Annotations();
        }
        this.annotations.set(annotation);
    }

    public TextPart get(int index) {
        return this.parts.get(index);
    }

    public int count() {
        return this.parts.size();
    }

    private boolean hasOnlyOneSegment() {
        return this.segments.count() == 1;
    }

    private TextFragment createJoinedContent() {
        TextFragment tf = new TextFragment();
        for (TextPart part : this.parts) {
            tf.append(part.getContent());
        }
        return tf;
    }

    public void joinAll() {
        this.segments.joinAll();
    }

    public int joinWithNext(int partIndex, int partCount) {
        int i;
        if (this.parts.size() == 1) {
            return 0;
        }
        TextFragment tf = this.parts.get(partIndex).getContent();
        int max = this.parts.size() - partIndex - 1;
        if (partCount == -1 || partCount > max) {
            partCount = max;
        }
        for (i = 0; i < partCount; ++i) {
            tf.append(this.parts.get(partIndex + 1).getContent());
            this.parts.remove(partIndex + 1);
        }
        if (this.parts.size() == 1 && !this.parts.get(0).isSegment()) {
            this.parts.set(0, new Segment(null, this.parts.get((int)0).text));
        }
        return i;
    }
}

