/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.resource;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.okapi.common.ISegmenter;
import net.sf.okapi.common.ISkeleton;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Range;
import net.sf.okapi.common.annotation.Annotations;
import net.sf.okapi.common.annotation.IAnnotation;
import net.sf.okapi.common.resource.INameable;
import net.sf.okapi.common.resource.IReferenceable;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;

public class TextUnit
implements INameable,
IReferenceable {
    public static final String TYPE_PARA = "paragraph";
    public static final String TYPE_LIST_ELEMENT = "list_element";
    public static final String TYPE_TITLE = "title";
    public static final String TYPE_HEADER = "header";
    public static final String TYPE_CDATA = "cdata";
    private static final int TARGETS_INITCAP = 2;
    private String id;
    private int refCount;
    private String name;
    private String type;
    private boolean isTranslatable = true;
    private boolean preserveWS;
    private ISkeleton skeleton;
    private LinkedHashMap<String, Property> properties;
    private Annotations annotations;
    private TextContainer source;
    private String mimeType;
    private ConcurrentHashMap<LocaleId, TextContainer> targets;
    private List<Range> srcSegRanges;
    private ConcurrentHashMap<LocaleId, List<Range>> trgSegRanges;
    private transient LocaleId syncLoc;

    public TextUnit(String id) {
        this.create(id, null, false, null);
    }

    public TextUnit(String id, String sourceText) {
        this.create(id, sourceText, false, null);
    }

    public TextUnit(String id, String sourceText, boolean isReferent) {
        this.create(id, sourceText, isReferent, null);
    }

    public TextUnit(String id, String sourceText, boolean isReferent, String mimeType) {
        this.create(id, sourceText, isReferent, mimeType);
    }

    private void create(String id, String sourceText, boolean isReferent, String mimeType) {
        this.targets = new ConcurrentHashMap(2);
        this.id = id;
        this.refCount = isReferent ? 1 : 0;
        this.mimeType = mimeType;
        this.source = new TextContainer(sourceText);
    }

    public String toString() {
        return this.source.toString();
    }

    public TextUnit clone() {
        TextUnit tu = new TextUnit(this.getId());
        if (this.annotations != null) {
            tu.setAnnotations(this.annotations.clone());
        }
        tu.setIsReferent(this.isReferent());
        tu.setIsTranslatable(this.isTranslatable);
        tu.setMimeType(this.getMimeType());
        tu.setName(this.getName());
        tu.setPreserveWhitespaces(this.preserveWS);
        tu.setReferenceCount(this.getReferenceCount());
        tu.setSkeleton(this.getSkeleton());
        tu.setSource(this.getSource().clone());
        tu.setType(this.getType());
        if (this.properties != null) {
            for (Property property : this.properties.values()) {
                tu.setProperty(property.clone());
            }
        }
        for (Map.Entry entry : this.targets.entrySet()) {
            tu.setTarget((LocaleId)entry.getKey(), ((TextContainer)entry.getValue()).clone());
        }
        return tu;
    }

    protected void setAnnotations(Annotations annotations) {
        this.annotations = annotations;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public ISkeleton getSkeleton() {
        return this.skeleton;
    }

    @Override
    public void setSkeleton(ISkeleton skeleton) {
        this.skeleton = skeleton;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String value) {
        this.type = value;
    }

    @Override
    public <A extends IAnnotation> A getAnnotation(Class<A> annotationType) {
        if (this.annotations == null) {
            return null;
        }
        return (A)((IAnnotation)annotationType.cast(this.annotations.get(annotationType)));
    }

    @Override
    public void setAnnotation(IAnnotation annotation) {
        if (this.annotations == null) {
            this.annotations = new Annotations();
        }
        this.annotations.set(annotation);
    }

    @Override
    public Property getProperty(String name) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(name);
    }

    @Override
    public Property setProperty(Property property) {
        if (this.properties == null) {
            this.properties = new LinkedHashMap();
        }
        this.properties.put(property.getName(), property);
        return property;
    }

    @Override
    public void removeProperty(String name) {
        if (this.properties != null) {
            this.properties.remove(name);
        }
    }

    @Override
    public Set<String> getPropertyNames() {
        if (this.properties == null) {
            this.properties = new LinkedHashMap();
        }
        return this.properties.keySet();
    }

    @Override
    public boolean hasProperty(String name) {
        if (this.properties == null) {
            return false;
        }
        return this.properties.containsKey(name);
    }

    @Override
    public Property getSourceProperty(String name) {
        return this.source.getProperty(name);
    }

    @Override
    public Property setSourceProperty(Property property) {
        return this.source.setProperty(property);
    }

    @Override
    public Set<String> getSourcePropertyNames() {
        return this.source.getPropertyNames();
    }

    @Override
    public void removeSourceProperty(String name) {
        this.source.removeProperty(name);
    }

    @Override
    public boolean hasSourceProperty(String name) {
        return this.source.hasProperty(name);
    }

    @Override
    public Property getTargetProperty(LocaleId locId, String name) {
        TextContainer tc = this.getTarget(locId);
        if (tc == null) {
            return null;
        }
        return tc.getProperty(name);
    }

    @Override
    public Property setTargetProperty(LocaleId locId, Property property) {
        return this.createTarget(locId, false, 0).setProperty(property);
    }

    @Override
    public void removeTargetProperty(LocaleId locId, String name) {
        TextContainer tc = this.getTarget(locId);
        if (tc != null) {
            tc.removeProperty(name);
        }
    }

    @Override
    public Set<String> getTargetPropertyNames(LocaleId locId) {
        TextContainer tc = this.createTarget(locId, false, 0);
        return tc.getPropertyNames();
    }

    @Override
    public boolean hasTargetProperty(LocaleId locId, String name) {
        TextContainer tc = this.getTarget(locId);
        if (tc == null) {
            return false;
        }
        return tc.getProperty(name) != null;
    }

    @Override
    public Set<LocaleId> getTargetLocales() {
        return this.targets.keySet();
    }

    @Override
    public Property createTargetProperty(LocaleId locId, String name, boolean overwriteExisting, int creationOptions) {
        TextContainer tc = this.createTarget(locId, false, 0);
        Property prop = tc.getProperty(name);
        if (prop == null || overwriteExisting) {
            prop = this.source.getProperty(name);
            if (prop == null) {
                return tc.setProperty(new Property(name, "", false));
            }
            if (creationOptions == 0) {
                return tc.setProperty(new Property(name, "", prop.isReadOnly()));
            }
            return tc.setProperty(prop.clone());
        }
        return prop;
    }

    @Override
    public boolean isTranslatable() {
        return this.isTranslatable;
    }

    @Override
    public void setIsTranslatable(boolean value) {
        this.isTranslatable = value;
    }

    @Override
    public boolean isReferent() {
        return this.refCount > 0;
    }

    @Override
    public void setIsReferent(boolean value) {
        this.refCount = value ? 1 : 0;
    }

    @Override
    public int getReferenceCount() {
        return this.refCount;
    }

    @Override
    public void setReferenceCount(int value) {
        this.refCount = value;
    }

    public TextContainer getSource() {
        return this.source;
    }

    public TextContainer setSource(TextContainer textContainer) {
        if (textContainer == null) {
            throw new NullPointerException("The source container of a TextUnit cannot be null.");
        }
        this.source = textContainer;
        return this.source;
    }

    public TextContainer getTarget(LocaleId locId) {
        return this.targets.get(locId);
    }

    public TextContainer setTarget(LocaleId locId, TextContainer text) {
        this.targets.put(locId, text);
        return text;
    }

    public void removeTarget(LocaleId locId) {
        if (this.hasTarget(locId)) {
            this.targets.remove(locId);
        }
        if (this.trgSegRanges != null) {
            this.trgSegRanges.remove(locId);
        }
        if (this.syncLoc != null && this.syncLoc.equals(locId)) {
            this.syncLoc = null;
        }
    }

    public boolean hasTarget(LocaleId locId) {
        return this.targets.get(locId) != null;
    }

    public TextContainer createTarget(LocaleId locId, boolean overwriteExisting, int creationOptions) {
        TextContainer trgCont = this.targets.get(locId);
        if (trgCont == null || overwriteExisting) {
            trgCont = this.getSource().clone((creationOptions & 2) == 2);
            if (creationOptions == 0 || creationOptions == 2) {
                trgCont.clear();
            }
            this.targets.put(locId, trgCont);
        }
        return trgCont;
    }

    public TextFragment setSourceContent(TextFragment content) {
        this.source.setContent(content);
        return this.source.getSegments().getFirstContent();
    }

    public TextFragment setTargetContent(LocaleId locId, TextFragment content) {
        TextContainer tc = this.createTarget(locId, false, 0);
        tc.setContent(content);
        return tc.getSegments().getFirstContent();
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    @Override
    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public boolean isEmpty() {
        return this.source.isEmpty();
    }

    @Override
    public boolean preserveWhitespaces() {
        return this.preserveWS;
    }

    @Override
    public void setPreserveWhitespaces(boolean value) {
        this.preserveWS = value;
    }

    public void createSourceSegmentation(ISegmenter segmenter) {
        segmenter.computeSegments(this.source);
        this.srcSegRanges = segmenter.getRanges();
        this.source.getSegments().create(this.srcSegRanges);
        this.syncLoc = null;
    }

    public void createTargetSegmentation(ISegmenter segmenter, LocaleId targetLocale) {
        TextContainer tc = this.getTarget(targetLocale);
        if (tc == null) {
            throw new RuntimeException(String.format("There is no target content for '%s'", targetLocale.toString()));
        }
        segmenter.computeSegments(tc);
        tc.getSegments().create(segmenter.getRanges());
    }

    public List<Range> saveCurrentSourceSegmentation() {
        this.srcSegRanges = this.source.getSegments().getRanges();
        return this.srcSegRanges;
    }

    public void setSourceSegmentationForTarget(LocaleId locId, List<Range> ranges) {
        if (this.trgSegRanges == null) {
            this.trgSegRanges = new ConcurrentHashMap();
        }
        this.trgSegRanges.put(locId, ranges);
        if (this.syncLoc != null && this.syncLoc.equals(locId)) {
            this.syncLoc = null;
        }
    }

    public void synchronizeSourceSegmentation(LocaleId locId) {
        if (this.syncLoc != null && this.syncLoc.equals(locId)) {
            return;
        }
        List<Range> ranges = null;
        if (this.trgSegRanges != null) {
            ranges = this.trgSegRanges.get(locId);
        }
        if (ranges == null) {
            ranges = this.srcSegRanges;
        }
        this.source.getSegments().create(ranges);
        this.syncLoc = locId;
    }

    public void removeAllSegmentations() {
        if (this.getSource().hasBeenSegmented()) {
            this.getSource().joinAll();
        }
        this.srcSegRanges = null;
        for (Map.Entry<LocaleId, TextContainer> entry : this.targets.entrySet()) {
            if (!entry.getValue().hasBeenSegmented()) continue;
            entry.getValue().joinAll();
        }
        if (this.trgSegRanges != null) {
            this.trgSegRanges.clear();
        }
        this.syncLoc = null;
    }

    @Override
    public Iterable<IAnnotation> getAnnotations() {
        if (this.annotations == null) {
            return Collections.emptyList();
        }
        return this.annotations;
    }
}

