/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.resource;

import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.filterwriter.GenericContent;
import net.sf.okapi.common.resource.IAlignedSegments;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit4;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TextUnit4Test {
    private static final LocaleId locFR = LocaleId.FRENCH;
    private static final LocaleId locES = LocaleId.SPANISH;
    private static final String TU1 = "tu1";
    private TextContainer tc1;
    private ITextUnit tu1;
    private GenericContent fmt = new GenericContent();

    @Before
    public void setUp() {
        this.tu1 = new TextUnit4(TU1);
        this.tc1 = new TextContainer("fr text");
    }

    @Test
    public void isEmptyTrue() {
        Assert.assertTrue((String)"The TextUnit should be empty", (boolean)this.tu1.isEmpty());
    }

    @Test
    public void isEmptyFalse() {
        this.tu1.setSource(this.tc1);
        Assert.assertFalse((String)"The TextUnit should not be empty", (boolean)this.tu1.isEmpty());
    }

    @Test
    public void getSetSource() {
        this.tu1.setSource(this.tc1);
        Assert.assertSame((Object)this.tu1.getSource(), (Object)this.tc1);
    }

    @Test
    public void hasVariantSourceFalse() {
        Assert.assertFalse((String)"hasVariantSource() should return false before any variant sources have been added", (boolean)this.tu1.hasVariantSources());
    }

    @Test
    public void hasVariantSourceFalseAfterRemoving() {
        this.tu1.getVariantSources().create(locFR, true, 0);
        this.tu1.getVariantSources().remove(locFR);
        Assert.assertFalse((String)"hasVariantSource() should return false after the last variant source has been removed", (boolean)this.tu1.hasVariantSources());
    }

    @Test
    public void hasVaraintSourceTrue() {
        this.tu1.getVariantSources().create(locFR, true, 0);
        Assert.assertTrue((String)"hasVariantSource() should return true if this text unit has one or more varaint sources", (boolean)this.tu1.hasVariantSources());
    }

    @Test
    public void getTargetReturnsNewEmptyOnNoMatch() {
        Assert.assertNotNull((String)"When there is no match a empty should be returned", (Object)this.tu1.getTarget_DIFF(locFR));
        Assert.assertEquals((Object)"", (Object)this.tu1.getTarget_DIFF(locFR).toString());
    }

    @Test
    public void getSetTarget() {
        this.tu1.setTarget(locFR, this.tc1);
        Assert.assertSame((String)"The target should be TextContainer we just set", (Object)this.tc1, (Object)this.tu1.getTarget_DIFF(locFR));
    }

    @Test
    public void removeTarget() {
        this.tu1.setTarget(locFR, this.tc1);
        this.tu1.removeTarget(locFR);
        Assert.assertFalse((String)"TextUnit should no longer have a target", (boolean)this.tu1.hasTarget(locFR));
    }

    @Test
    public void hasTargetNo() {
        Assert.assertFalse((String)"No target should exist", (boolean)this.tu1.hasTarget(locFR));
    }

    @Test
    public void hasTargetYes() {
        this.tu1.setTarget(locFR, this.tc1);
        Assert.assertTrue((String)"TextUnit should now have a target", (boolean)this.tu1.hasTarget(locFR));
    }

    @Test
    public void hasTargetCaseSensitive() {
        this.tu1.setTarget(locFR, this.tc1);
        Assert.assertTrue((boolean)this.tu1.hasTarget(LocaleId.fromString("FR")));
        Assert.assertTrue((!this.tu1.hasTarget(LocaleId.fromString("fr-fr")) ? 1 : 0) != 0);
    }

    @Test
    public void createTargetCase1() {
        this.tu1 = this.createSegmentedTU();
        this.tu1.createTarget(locFR, false, 7);
        Assert.assertEquals((Object)this.tu1.getSource().toString(), (Object)this.tu1.getTarget_DIFF(locFR).toString());
        Assert.assertEquals((long)this.tu1.getSource().getSegments().count(), (long)this.tu1.getTarget_DIFF(locFR).getSegments().count());
    }

    @Test
    public void createTargetCase2() {
        this.tu1 = this.createSegmentedTU();
        this.tu1.createTarget(locFR, false, 4);
        Assert.assertEquals((long)this.tu1.getSource().getSegments().count(), (long)this.tu1.getTarget_DIFF(locFR).getSegments().count());
        Assert.assertEquals((Object)"[] a []", (Object)this.fmt.printSegmentedContent(this.tu1.getTarget_DIFF(locFR), true));
        Assert.assertEquals((Object)" a ", (Object)this.tu1.getTarget_DIFF(locFR).toString());
    }

    @Test
    public void createTargetCase3() {
        this.tu1 = this.createSegmentedTU();
        this.tu1.createTarget(locFR, false, 1);
        Assert.assertEquals((long)1L, (long)this.tu1.getTarget_DIFF(locFR).getSegments().count());
        Assert.assertEquals((Object)"Part 1. a Part 2.", (Object)this.tu1.getTarget_DIFF(locFR).toString());
    }

    @Test
    public void createTargetSourceContentAndTargetContentSame() {
        this.tu1.setSource(this.tc1);
        this.tu1.createTarget(locFR, false, 7);
        Assert.assertEquals((String)"Target text vs Source Text", (Object)this.tu1.getSource().toString(), (Object)this.tu1.getTarget_DIFF(locFR).toString());
    }

    @Test
    public void createTargetDoesntAlreadyExist() {
        this.tu1.setSource(this.tc1);
        TextContainer tc2 = this.tu1.createTarget(locFR, false, 7);
        Assert.assertSame((String)"Target should be the same as returned from createTarget", (Object)tc2, (Object)this.tu1.getTarget_DIFF(locFR));
        Assert.assertNotSame((String)"Target should have been cloned", (Object)this.tu1.getTarget_DIFF(locFR), (Object)this.tu1.getSource());
    }

    @Test
    public void createTargetAlreadyExistsDontOverwriteExisting() {
        this.tu1.setSource(this.tc1);
        TextContainer tc2 = new TextContainer("unique fr text");
        this.tu1.setTarget(locFR, tc2);
        this.tu1.createTarget(locFR, false, 7);
        Assert.assertSame((String)"Target should not have been modified", (Object)tc2, (Object)this.tu1.getTarget_DIFF(locFR));
    }

    @Test
    public void createTargetAlreadyExistsOverwriteExisting() {
        this.tu1.setSource(this.tc1);
        TextContainer tc2 = new TextContainer("unique fr text");
        this.tu1.setTarget(locFR, tc2);
        this.tu1.createTarget(locFR, true, 7);
        Assert.assertNotSame((String)"Target should not have been modified", (Object)tc2, (Object)this.tu1.getTarget_DIFF(locFR));
    }

    @Test
    public void createTargetEmptyOption() {
        this.tu1.setSource(this.tc1);
        this.tu1.createTarget(locFR, false, 0);
        Assert.assertTrue((boolean)this.tu1.hasTarget(locFR));
        Assert.assertEquals((String)"Empty target created", (Object)"", (Object)this.tu1.getTarget_DIFF(locFR).toString());
    }

    @Test
    public void createTargetEmptyOptionOverwriteExisting() {
        this.tu1.setSource(this.tc1);
        TextContainer tc2 = new TextContainer("unique fr text");
        this.tu1.setTarget(locFR, tc2);
        this.tu1.createTarget(locFR, true, 0);
        Assert.assertTrue((boolean)this.tu1.hasTarget(locFR));
        Assert.assertEquals((String)"Empty target created", (Object)"", (Object)this.tu1.getTarget_DIFF(locFR).toString());
    }

    @Test
    public void createTargetPropertiesOption() {
        this.tu1.setSource(this.tc1);
        this.tu1.getSource().setProperty(new Property("test", "value"));
        this.tu1.createTarget(locFR, false, 2);
        Assert.assertTrue((boolean)this.tu1.hasTarget(locFR));
        Assert.assertEquals((String)"Empty target created", (Object)"", (Object)this.tu1.getTarget_DIFF(locFR).toString());
        Assert.assertTrue((this.tu1.getTarget_DIFF(locFR).getProperty("test") != null ? 1 : 0) != 0);
    }

    @Test
    public void createTargetPropertiesOptionOverwriteExisting() {
        this.tu1.setSource(this.tc1);
        this.tu1.getSource().setProperty(new Property("test", "value"));
        TextContainer tc2 = new TextContainer("unique fr text");
        this.tu1.setTarget(locFR, tc2);
        this.tu1.createTarget(locFR, true, 2);
        Assert.assertTrue((boolean)this.tu1.hasTarget(locFR));
        Assert.assertEquals((String)"Empty target created", (Object)"", (Object)this.tu1.getTarget_DIFF(locFR).toString());
        Assert.assertTrue((this.tu1.getTarget_DIFF(locFR).getProperty("test") != null ? 1 : 0) != 0);
    }

    @Test
    public void createTargetPropertiesOptionNotOverwriteExisting() {
        this.tu1.setSource(this.tc1);
        this.tu1.getSource().setProperty(new Property("test", "value"));
        TextContainer tc2 = new TextContainer("unique fr text");
        this.tu1.setTarget(locFR, tc2);
        this.tu1.createTarget(locFR, false, 2);
        Assert.assertTrue((boolean)this.tu1.hasTarget(locFR));
        Assert.assertEquals((Object)"unique fr text", (Object)this.tu1.getTarget_DIFF(locFR).toString());
        Assert.assertTrue((this.tu1.getTarget_DIFF(locFR).getProperty("test") == null ? 1 : 0) != 0);
    }

    @Test
    public void getSegments() {
        ITextUnit tu = this.createSegmentedTUAndTarget();
        IAlignedSegments as = tu.getAlignedSegments();
        Assert.assertNotNull((String)"getSegments() should return a non-null IAlignedSegments instance", (Object)as);
    }

    @Test
    public void loopThroughSegments() {
        this.tu1 = this.createSegmentedTUAndTarget();
        for (Segment srcSeg : this.tu1.getSourceSegments()) {
            Segment trgSeg;
            if (srcSeg.id.equals("0")) {
                Assert.assertEquals((Object)"Part 1.", (Object)srcSeg.text.toString());
                trgSeg = this.tu1.getTargetSegment(locFR, srcSeg.id, false);
                Assert.assertEquals((Object)"Trg 1.", (Object)trgSeg.text.toString());
                continue;
            }
            Assert.assertEquals((Object)"Part 2.", (Object)srcSeg.text.toString());
            trgSeg = this.tu1.getTargetSegment(locFR, srcSeg.id, false);
            Assert.assertEquals((Object)"Trg 2.", (Object)trgSeg.text.toString());
        }
    }

    @Test
    public void loopThroughSegmentsWithoutTargets() {
        ITextUnit tu = this.createSegmentedTU();
        tu.createTarget(locES, true, 0);
        for (Segment srcSeg : tu.getSourceSegments()) {
            Segment trgSeg;
            if (srcSeg.id.equals("0")) {
                Assert.assertEquals((Object)"Part 1.", (Object)srcSeg.text.toString());
                trgSeg = tu.getTargetSegment(locFR, srcSeg.id, true);
                Assert.assertEquals((Object)"", (Object)trgSeg.text.toString());
                continue;
            }
            Assert.assertEquals((Object)"Part 2.", (Object)srcSeg.text.toString());
            trgSeg = tu.getTargetSegment(locES, srcSeg.id, false);
            Assert.assertNull((Object)trgSeg);
        }
        Assert.assertEquals((Object)"[Part 1.] a [Part 2.]", (Object)this.fmt.printSegmentedContent(tu.getSource(), true));
        Assert.assertTrue((boolean)tu.hasTarget(locFR));
        Assert.assertEquals((Object)"[] a []", (Object)this.fmt.printSegmentedContent(tu.getTarget_DIFF(locFR), true));
        Assert.assertTrue((boolean)tu.hasTarget(locES));
        Assert.assertEquals((Object)"[]", (Object)this.fmt.printSegmentedContent(tu.getTarget_DIFF(locES), true));
    }

    @Test
    public void getSourceSegments() {
        ITextUnit tu = this.createSegmentedTU();
        ISegments segs = tu.getSourceSegments();
        Assert.assertNotNull((Object)segs);
        Assert.assertEquals((long)2L, (long)segs.count());
    }

    @Test
    public void getExistingTargetSegments() {
        ITextUnit tu = this.createSegmentedTUAndTarget();
        ISegments segs = tu.getTargetSegments(locFR);
        Assert.assertNotNull((Object)segs);
        Assert.assertEquals((long)2L, (long)segs.count());
        Assert.assertEquals((Object)"Trg 1.", (Object)segs.get(0).toString());
    }

    @Test
    public void getNonExistingTargetSegments() {
        ITextUnit tu = this.createSegmentedTU();
        ISegments segs = tu.getTargetSegments(locES);
        Assert.assertNotNull((Object)segs);
        Assert.assertEquals((long)2L, (long)segs.count());
        Assert.assertEquals((Object)"", (Object)segs.get(0).toString());
    }

    @Test
    public void toStringFromSource() {
        this.tu1.setSource(this.tc1);
        Assert.assertEquals((String)"TextUnit.toString()", (Object)"fr text", (Object)this.tu1.toString());
    }

    @Test
    public void getSetId() {
        Assert.assertEquals((Object)this.tu1.getId(), (Object)TU1);
        this.tu1.setId("id2");
        Assert.assertEquals((Object)this.tu1.getId(), (Object)"id2");
    }

    @Test
    public void getSetMimeType() {
        Assert.assertNull((Object)this.tu1.getMimeType());
        this.tu1.setMimeType("test");
        Assert.assertEquals((Object)this.tu1.getMimeType(), (Object)"test");
    }

    @Test
    public void propertiesInitialization() {
        Assert.assertEquals((String)"Should be empty", (long)0L, (long)this.tu1.getPropertyNames().size());
    }

    @Test
    public void getPropertyReturnsDoesntExist() {
        Assert.assertNull((String)"returns null when no property exists", (Object)this.tu1.getProperty("NAME"));
    }

    @Test
    public void getSetProperty() {
        Property p1 = new Property("name", "value", true);
        this.tu1.setProperty(p1);
        Assert.assertSame((String)"should return the same property", (Object)p1, (Object)this.tu1.getProperty("name"));
    }

    @Test
    public void sourcePropertiesInitialization() {
        Assert.assertEquals((String)"Should be empty", (long)0L, (long)this.tu1.getSourcePropertyNames().size());
    }

    @Test
    public void getSourcePropertyDoesntExist() {
        Assert.assertNull((String)"returns null when no property exists", (Object)this.tu1.getSourceProperty("NAME"));
    }

    @Test
    public void getSetSourcePropertyFound() {
        Property p1 = new Property("name", "value", true);
        this.tu1.setSourceProperty(p1);
        Assert.assertSame((String)"Should be the same object", (Object)p1, (Object)this.tu1.getSourceProperty("name"));
    }

    @Test
    public void targetPropertiesInitialization() {
        Assert.assertEquals((long)this.tu1.getTargetPropertyNames(locFR).size(), (long)0L);
    }

    @Test
    public void getTargetPropertyNotFound() {
        this.tu1.setTarget(locFR, this.tc1);
        Assert.assertNull((String)"Target shoudln't be found", (Object)this.tu1.getTargetProperty(locFR, "NAME"));
    }

    @Test
    public void getSetTargetProperty() {
        this.tu1.setTarget(locFR, this.tc1);
        Property p1 = new Property("name", "value", true);
        this.tu1.setTargetProperty(locFR, p1);
        Assert.assertSame((String)"Properties should be the same", (Object)p1, (Object)this.tu1.getTargetProperty(locFR, "name"));
    }

    private ITextUnit createSegmentedTU() {
        TextUnit4 tu = new TextUnit4("id", "Part 1.");
        tu.getSource().getSegments().append(new Segment("s2", new TextFragment("Part 2.")), " a ");
        return tu;
    }

    private ITextUnit createSegmentedTUAndTarget() {
        ITextUnit tu = this.createSegmentedTU();
        ISegments segs = tu.getTarget_DIFF(locFR).getSegments();
        segs.get((int)0).text.append("Trg 1.");
        segs.get((int)1).text.append("Trg 2.");
        segs = tu.getTarget_DIFF(locES).getSegments();
        segs.get((int)0).text.append("Objetivo 1.");
        segs.get((int)1).text.append("Objetivo 2.");
        return tu;
    }
}

