/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.resource;

import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TextUnitTest {
    private static final LocaleId locFR = LocaleId.fromString("fr");
    private static final String TU1 = "tu1";
    private TextContainer tc1;
    TextUnit tu1;

    @Before
    public void setUp() {
        this.tu1 = new TextUnit(TU1);
        this.tc1 = new TextContainer("fr text");
    }

    @Test
    public void isEmptyTrue() {
        Assert.assertTrue((String)"The TextUnit should be empty", (boolean)this.tu1.isEmpty());
    }

    @Test
    public void isEmptyFalse() {
        this.tu1.setSource(this.tc1);
        Assert.assertFalse((String)"The TextUnit should not be empty", (boolean)this.tu1.isEmpty());
    }

    @Test
    public void toStringFromSource() {
        this.tu1.setSource(this.tc1);
        Assert.assertEquals((String)"TextUnit.toString()", (Object)"fr text", (Object)this.tu1.toString());
    }

    @Test
    public void getSetSource() {
        this.tu1.setSource(this.tc1);
        Assert.assertSame((Object)this.tu1.getSource(), (Object)this.tc1);
    }

    @Test
    public void getTargetReturnsNullOnNoMatch() {
        Assert.assertNull((String)"When there is no match a null should be returned", (Object)this.tu1.getTarget(locFR));
    }

    @Test
    public void getSetTarget() {
        this.tu1.setTarget(locFR, this.tc1);
        Assert.assertSame((String)"The target should be TextContainer we just set", (Object)this.tc1, (Object)this.tu1.getTarget(locFR));
    }

    @Test
    public void hasTargetNo() {
        Assert.assertFalse((String)"No target should exist", (boolean)this.tu1.hasTarget(locFR));
    }

    @Test
    public void hasTargetYes() {
        this.tu1.setTarget(locFR, this.tc1);
        Assert.assertTrue((String)"TextUnit should now have a target", (boolean)this.tu1.hasTarget(locFR));
    }

    @Test
    public void hasTargetCaseSensitive() {
        this.tu1.setTarget(locFR, this.tc1);
        Assert.assertTrue((boolean)this.tu1.hasTarget(LocaleId.fromString("FR")));
        Assert.assertTrue((!this.tu1.hasTarget(LocaleId.fromString("fr-fr")) ? 1 : 0) != 0);
    }

    @Test
    public void removeTarget() {
        this.tu1.setTarget(locFR, this.tc1);
        this.tu1.removeTarget(locFR);
        Assert.assertFalse((String)"TextUnit should no longer have a target", (boolean)this.tu1.hasTarget(locFR));
    }

    @Test
    public void createTargetSourceContentAndTargetContentSame() {
        this.tu1.setSource(this.tc1);
        this.tu1.createTarget(locFR, false, 7);
        Assert.assertEquals((String)"Target text vs Source Text", (Object)this.tu1.getSource().toString(), (Object)this.tu1.getTarget(locFR).toString());
    }

    @Test
    public void createTargetDoesntAlreadyExist() {
        this.tu1.setSource(this.tc1);
        TextContainer tc2 = this.tu1.createTarget(locFR, false, 7);
        Assert.assertSame((String)"Target should be the same as returned from createTarget", (Object)tc2, (Object)this.tu1.getTarget(locFR));
        Assert.assertNotSame((String)"Target should have been cloned", (Object)this.tu1.getTarget(locFR), (Object)this.tu1.getSource());
    }

    @Test
    public void createTargetAlreadyExistsDontOverwriteExisting() {
        this.tu1.setSource(this.tc1);
        TextContainer tc2 = new TextContainer("unique fr text");
        this.tu1.setTarget(locFR, tc2);
        this.tu1.createTarget(locFR, false, 7);
        Assert.assertSame((String)"Target should not have been modified", (Object)tc2, (Object)this.tu1.getTarget(locFR));
    }

    @Test
    public void createTargetAlreadyExistsOverwriteExisting() {
        this.tu1.setSource(this.tc1);
        TextContainer tc2 = new TextContainer("unique fr text");
        this.tu1.setTarget(locFR, tc2);
        this.tu1.createTarget(locFR, true, 7);
        Assert.assertNotSame((String)"Target should not have been modified", (Object)tc2, (Object)this.tu1.getTarget(locFR));
    }

    @Test
    public void createTargetEmptyOption() {
        this.tu1.setSource(this.tc1);
        this.tu1.createTarget(locFR, false, 0);
        Assert.assertTrue((boolean)this.tu1.hasTarget(locFR));
        Assert.assertEquals((String)"Empty target created", (Object)"", (Object)this.tu1.getTarget(locFR).toString());
    }

    @Test
    public void createTargetEmptyOptionOverwriteExisting() {
        this.tu1.setSource(this.tc1);
        TextContainer tc2 = new TextContainer("unique fr text");
        this.tu1.setTarget(locFR, tc2);
        this.tu1.createTarget(locFR, true, 0);
        Assert.assertTrue((boolean)this.tu1.hasTarget(locFR));
        Assert.assertEquals((String)"Empty target created", (Object)"", (Object)this.tu1.getTarget(locFR).toString());
    }

    @Test
    public void createTargetPropertiesOption() {
        this.tu1.setSource(this.tc1);
        this.tu1.getSource().setProperty(new Property("test", "value"));
        this.tu1.createTarget(locFR, false, 2);
        Assert.assertTrue((boolean)this.tu1.hasTarget(locFR));
        Assert.assertEquals((String)"Empty target created", (Object)"", (Object)this.tu1.getTarget(locFR).toString());
        Assert.assertTrue((this.tu1.getTarget(locFR).getProperty("test") != null ? 1 : 0) != 0);
    }

    @Test
    public void createTargetPropertiesOptionOverwriteExisting() {
        this.tu1.setSource(this.tc1);
        this.tu1.getSource().setProperty(new Property("test", "value"));
        TextContainer tc2 = new TextContainer("unique fr text");
        this.tu1.setTarget(locFR, tc2);
        this.tu1.createTarget(locFR, true, 2);
        Assert.assertTrue((boolean)this.tu1.hasTarget(locFR));
        Assert.assertEquals((String)"Empty target created", (Object)"", (Object)this.tu1.getTarget(locFR).toString());
        Assert.assertTrue((this.tu1.getTarget(locFR).getProperty("test") != null ? 1 : 0) != 0);
    }

    @Test
    public void createTargetPropertiesOptionNotOverwriteExisting() {
        this.tu1.setSource(this.tc1);
        this.tu1.getSource().setProperty(new Property("test", "value"));
        TextContainer tc2 = new TextContainer("unique fr text");
        this.tu1.setTarget(locFR, tc2);
        this.tu1.createTarget(locFR, false, 2);
        Assert.assertTrue((boolean)this.tu1.hasTarget(locFR));
        Assert.assertEquals((Object)"unique fr text", (Object)this.tu1.getTarget(locFR).toString());
        Assert.assertTrue((this.tu1.getTarget(locFR).getProperty("test") == null ? 1 : 0) != 0);
    }

    @Test
    public void getSetId() {
        Assert.assertEquals((Object)this.tu1.getId(), (Object)TU1);
        this.tu1.setId("id2");
        Assert.assertEquals((Object)this.tu1.getId(), (Object)"id2");
    }

    @Test
    public void getSetMimeType() {
        Assert.assertNull((Object)this.tu1.getMimeType());
        this.tu1.setMimeType("test");
        Assert.assertEquals((Object)this.tu1.getMimeType(), (Object)"test");
    }

    @Test
    public void propertiesInitialization() {
        Assert.assertEquals((String)"Should be empty", (long)0L, (long)this.tu1.getPropertyNames().size());
    }

    @Test
    public void getPropertyReturnsDoesntExist() {
        Assert.assertNull((String)"returns null when no property exists", (Object)this.tu1.getProperty("NAME"));
    }

    @Test
    public void getSetProperty() {
        Property p1 = new Property("name", "value", true);
        this.tu1.setProperty(p1);
        Assert.assertSame((String)"should return the same property", (Object)p1, (Object)this.tu1.getProperty("name"));
    }

    @Test
    public void sourcePropertiesInitialization() {
        Assert.assertEquals((String)"Should be empty", (long)0L, (long)this.tu1.getSourcePropertyNames().size());
    }

    @Test
    public void getSourcePropertyDoesntExist() {
        Assert.assertNull((String)"returns null when no property exists", (Object)this.tu1.getSourceProperty("NAME"));
    }

    @Test
    public void getSetSourcePropertyFound() {
        Property p1 = new Property("name", "value", true);
        this.tu1.setSourceProperty(p1);
        Assert.assertSame((String)"Should be the same object", (Object)p1, (Object)this.tu1.getSourceProperty("name"));
    }

    @Test
    public void targetPropertiesInitialization() {
        Assert.assertEquals((long)this.tu1.getTargetPropertyNames(locFR).size(), (long)0L);
    }

    @Test
    public void getTargetPropertyNotFound() {
        this.tu1.setTarget(locFR, this.tc1);
        Assert.assertNull((String)"Target shoudln't be found", (Object)this.tu1.getTargetProperty(locFR, "NAME"));
    }

    @Test
    public void getSetTargetProperty() {
        this.tu1.setTarget(locFR, this.tc1);
        Property p1 = new Property("name", "value", true);
        this.tu1.setTargetProperty(locFR, p1);
        Assert.assertSame((String)"Properties should be the same", (Object)p1, (Object)this.tu1.getTargetProperty(locFR, "name"));
    }
}

