/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.resource;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.ReversedIterator;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.AltTranslation;
import net.sf.okapi.common.annotation.AltTranslationsAnnotation;
import net.sf.okapi.common.annotation.IAnnotation;
import net.sf.okapi.common.resource.AlignedPair;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.GenericSkeletonPart;
import net.sf.okapi.common.skeleton.SkeletonUtil;

public class TextUnitUtil {
    private static final Logger LOGGER = Logger.getLogger(TextUnitUtil.class.getName());

    public static void trimLeading(TextFragment textFragment) {
        TextUnitUtil.trimLeading(textFragment, null);
    }

    public static TextFragment adjustTargetCodes(TextFragment oriSrc, TextFragment newTrg, boolean alwaysCopyCodes, boolean addMissingCodes, TextFragment newSrc, TextUnit parent) {
        int i;
        List<Code> newCodes = newTrg.getCodes();
        List<Code> oriCodes = oriSrc.getCodes();
        boolean needAdjustment = false;
        if (!alwaysCopyCodes) {
            for (Code code : newCodes) {
                if (code.hasData()) continue;
                needAdjustment = true;
                break;
            }
            if (!needAdjustment) {
                for (Code code : oriCodes) {
                    if (!code.hasReference()) continue;
                    needAdjustment = true;
                    break;
                }
            }
            if (!needAdjustment) {
                return newTrg;
            }
        }
        if (!newTrg.hasCode() && !oriSrc.hasCode()) {
            return newTrg;
        }
        if (newSrc != null && !needAdjustment && oriCodes.toString().equals(newSrc.getCodes().toString())) {
            return newTrg;
        }
        int[] oriIndices = new int[oriCodes.size()];
        for (int i2 = 0; i2 < oriIndices.length; ++i2) {
            oriIndices[i2] = i2;
        }
        int done = 0;
        for (i = 0; i < newCodes.size(); ++i) {
            Code newCode = newCodes.get(i);
            newCode.setOuterData(null);
            Code oriCode = null;
            for (int j = 0; j < oriIndices.length; ++j) {
                if (oriCodes.get(j).getId() != newCode.getId() || oriCodes.get(j).getTagType() != newCode.getTagType()) continue;
                if (oriIndices[j] == -1 && !oriCodes.get(j).isCloneable()) {
                    String place = null;
                    if (parent != null) {
                        place = String.format(" (item id='%s', name='%s')", parent.getId(), parent.getName() == null ? "" : parent.getName());
                    }
                    LOGGER.warning(String.format("The extra code id='%d' cannot be cloned.", newCode.getId()) + (place == null ? "" : place));
                }
                oriCode = oriCodes.get(j);
                oriIndices[j] = -1;
                ++done;
                break;
            }
            if (oriCode == null) {
                if (newCode.getData() != null && newCode.getData().length() != 0) continue;
                String place = null;
                if (parent != null) {
                    place = String.format(" (item id='%s', name='%s')", parent.getId(), parent.getName() == null ? "" : parent.getName());
                }
                LOGGER.warning(String.format("The extra target code id='%d' does not have corresponding data.", newCode.getId()) + (place == null ? "" : place));
                continue;
            }
            newCode.setData(oriCode.getData());
            newCode.setOuterData(oriCode.getOuterData());
            newCode.setReferenceFlag(oriCode.hasReference());
        }
        if (oriCodes.size() > done) {
            for (i = 0; i < oriIndices.length; ++i) {
                if (oriIndices[i] == -1) continue;
                Code code = oriCodes.get(oriIndices[i]);
                if (!addMissingCodes) continue;
                newTrg.append(code.clone());
            }
        }
        return newTrg;
    }

    public static void trimLeading(TextFragment textFragment, GenericSkeleton skel) {
        TextFragment skelTF;
        if (textFragment == null) {
            return;
        }
        String st = textFragment.getCodedText();
        int pos = TextFragment.indexOfFirstNonWhitespace(st, 0, -1, false, false, false, true);
        if (pos == -1) {
            skelTF = new TextFragment(st);
            textFragment.setCodedText("");
        } else {
            skelTF = textFragment.subSequence(0, pos);
            textFragment.setCodedText(st.substring(pos));
        }
        if (skel == null) {
            return;
        }
        if (skelTF == null) {
            return;
        }
        st = skelTF.toText();
        if (!Util.isEmpty(st)) {
            skel.append(st);
        }
    }

    public static void trimTrailing(TextFragment textFragment) {
        TextUnitUtil.trimTrailing(textFragment, null);
    }

    public static void trimTrailing(TextFragment textFragment, GenericSkeleton skel) {
        TextFragment skelTF;
        if (textFragment == null) {
            return;
        }
        String st = textFragment.getCodedText();
        int pos = TextFragment.indexOfLastNonWhitespace(st, -1, 0, false, false, false, true);
        if (pos == -1) {
            skelTF = new TextFragment(st);
            textFragment.setCodedText("");
        } else {
            skelTF = textFragment.subSequence(pos + 1, st.length());
            textFragment.setCodedText(st.substring(0, pos + 1));
        }
        if (skel == null) {
            return;
        }
        if (skelTF == null) {
            return;
        }
        st = skelTF.toText();
        if (!Util.isEmpty(st)) {
            skel.append(st);
        }
    }

    public static boolean endsWith(TextFragment textFragment, String substr) {
        if (textFragment == null) {
            return false;
        }
        if (Util.isEmpty(substr)) {
            return false;
        }
        String st = textFragment.getCodedText();
        int pos = TextFragment.indexOfLastNonWhitespace(st, -1, 0, true, true, true, true);
        if (pos == -1) {
            return false;
        }
        return st.lastIndexOf(substr) == pos - substr.length() + 1;
    }

    public static boolean isEmpty(TextUnit textUnit) {
        return textUnit == null || textUnit.getSource().isEmpty();
    }

    public static boolean hasSource(TextUnit textUnit) {
        return !TextUnitUtil.isEmpty(textUnit, true);
    }

    public static boolean isEmpty(TextUnit textUnit, boolean ignoreWS) {
        return textUnit == null || Util.isEmpty(TextUnitUtil.getSourceText(textUnit), ignoreWS);
    }

    public static String getSourceText(TextUnit textUnit) {
        return textUnit.getSource().getFirstContent().getCodedText();
    }

    public static String getSourceText(TextUnit textUnit, boolean removeCodes) {
        if (textUnit == null) {
            return "";
        }
        if (removeCodes) {
            return TextUnitUtil.getText(textUnit.getSource().getFirstContent());
        }
        return textUnit.getSource().getFirstContent().getCodedText();
    }

    public static String getTargetText(TextUnit textUnit, LocaleId locId) {
        if (textUnit == null) {
            return "";
        }
        if (Util.isNullOrEmpty(locId)) {
            return "";
        }
        return TextUnitUtil.getCodedText(textUnit.getTarget(locId).getFirstContent());
    }

    public static String getCodedText(TextFragment textFragment) {
        if (textFragment == null) {
            return "";
        }
        return textFragment.getCodedText();
    }

    public static String getText(TextFragment textFragment, List<Integer> markerPositions) {
        if (textFragment == null) {
            return "";
        }
        String res = textFragment.getCodedText();
        if (markerPositions != null) {
            markerPositions.clear();
        }
        if (!textFragment.hasCode()) {
            return res;
        }
        StringBuilder sb = new StringBuilder();
        int startPos = -1;
        block3: for (int i = 0; i < res.length(); ++i) {
            switch (res.charAt(i)) {
                case '\ue101': 
                case '\ue102': 
                case '\ue103': {
                    if (markerPositions != null) {
                        markerPositions.add(i);
                    }
                    if (i > startPos && startPos >= 0) {
                        sb.append(res.substring(startPos, i));
                    }
                    ++i;
                    startPos = -1;
                    continue block3;
                }
                default: {
                    if (startPos >= 0) continue block3;
                    startPos = i;
                }
            }
        }
        if (startPos < 0 && sb.length() == 0) {
            startPos = 0;
        } else if (startPos > -1 && startPos < res.length()) {
            sb.append(res.substring(startPos));
        }
        return sb.toString();
    }

    public static String getText(TextFragment textFragment) {
        return TextUnitUtil.getText(textFragment, null);
    }

    public static char getLastChar(TextFragment textFragment) {
        if (textFragment == null) {
            return '\u0000';
        }
        String st = textFragment.getCodedText();
        int pos = TextFragment.indexOfLastNonWhitespace(st, -1, 0, true, true, true, true);
        if (pos == -1) {
            return '\u0000';
        }
        return st.charAt(pos);
    }

    public static void deleteLastChar(TextFragment textFragment) {
        if (textFragment == null) {
            return;
        }
        String st = textFragment.getCodedText();
        int pos = TextFragment.indexOfLastNonWhitespace(st, -1, 0, true, true, true, true);
        if (pos == -1) {
            return;
        }
        textFragment.remove(pos, pos + 1);
    }

    public static int lastIndexOf(TextFragment textFragment, String findWhat) {
        if (textFragment == null) {
            return -1;
        }
        if (Util.isEmpty(findWhat)) {
            return -1;
        }
        if (Util.isEmpty(textFragment.getCodedText())) {
            return -1;
        }
        return textFragment.getCodedText().lastIndexOf(findWhat);
    }

    public static boolean isEmpty(TextFragment textFragment) {
        return textFragment == null || textFragment != null && textFragment.isEmpty();
    }

    public static TextUnit buildTU(TextContainer source) {
        return TextUnitUtil.buildTU(null, "", source, null, LocaleId.EMPTY, "");
    }

    public static TextUnit buildTU(String source) {
        return TextUnitUtil.buildTU(new TextContainer(source));
    }

    public static TextUnit buildTU(String srcPart, String skelPart) {
        TextUnit res = TextUnitUtil.buildTU(srcPart);
        if (res == null) {
            return null;
        }
        GenericSkeleton skel = (GenericSkeleton)res.getSkeleton();
        if (skel == null) {
            return null;
        }
        skel.addContentPlaceholder(res);
        skel.append(skelPart);
        return res;
    }

    public static TextUnit buildTU(TextUnit textUnit, String name, TextContainer source, TextContainer target, LocaleId locId, String comment) {
        if (textUnit == null) {
            textUnit = new TextUnit("");
        }
        if (textUnit.getSkeleton() == null) {
            GenericSkeleton skel = new GenericSkeleton();
            textUnit.setSkeleton(skel);
        }
        if (!Util.isEmpty(name)) {
            textUnit.setName(name);
        }
        if (source != null) {
            textUnit.setSource(source);
        }
        if (target != null && !Util.isNullOrEmpty(locId)) {
            textUnit.setTarget(locId, target);
        }
        if (!Util.isEmpty(comment)) {
            textUnit.setProperty(new Property("note", comment));
        }
        return textUnit;
    }

    public static GenericSkeleton forceSkeleton(TextUnit tu) {
        if (tu == null) {
            return null;
        }
        GenericSkeleton skel = (GenericSkeleton)tu.getSkeleton();
        if (skel == null) {
            skel = new GenericSkeleton();
            tu.setSkeleton(skel);
        }
        if (!SkeletonUtil.hasTuRef(skel)) {
            skel.addContentPlaceholder(tu);
        }
        return skel;
    }

    public static GenericSkeleton convertToSkeleton(TextUnit textUnit) {
        if (textUnit == null) {
            return null;
        }
        GenericSkeleton skel = (GenericSkeleton)textUnit.getSkeleton();
        if (skel == null) {
            return new GenericSkeleton(textUnit.toString());
        }
        List<GenericSkeletonPart> list = skel.getParts();
        if (list.size() == 0) {
            return new GenericSkeleton(textUnit.toString());
        }
        String tuRef = TextFragment.makeRefMarker("$self$");
        GenericSkeleton res = new GenericSkeleton();
        List<GenericSkeletonPart> list2 = res.getParts();
        for (GenericSkeletonPart part : list) {
            String st = part.toString();
            if (Util.isEmpty(st)) continue;
            if (st.equalsIgnoreCase(tuRef)) {
                LocaleId locId = part.getLocale();
                if (Util.isNullOrEmpty(locId)) {
                    res.add(TextUnitUtil.getSourceText(textUnit));
                    continue;
                }
                res.add(TextUnitUtil.getTargetText(textUnit, locId));
                continue;
            }
            list2.add(part);
        }
        return res;
    }

    public static <A extends IAnnotation> A getSourceAnnotation(TextUnit textUnit, Class<A> type) {
        if (textUnit == null) {
            return null;
        }
        if (textUnit.getSource() == null) {
            return null;
        }
        return textUnit.getSource().getAnnotation(type);
    }

    public static void setSourceAnnotation(TextUnit textUnit, IAnnotation annotation) {
        if (textUnit == null) {
            return;
        }
        if (textUnit.getSource() == null) {
            return;
        }
        textUnit.getSource().setAnnotation(annotation);
    }

    public static <A extends IAnnotation> A getTargetAnnotation(TextUnit textUnit, LocaleId locId, Class<A> type) {
        if (textUnit == null) {
            return null;
        }
        if (Util.isNullOrEmpty(locId)) {
            return null;
        }
        if (textUnit.getTarget(locId) == null) {
            return null;
        }
        return textUnit.getTarget(locId).getAnnotation(type);
    }

    public static void setTargetAnnotation(TextUnit textUnit, LocaleId locId, IAnnotation annotation) {
        if (textUnit == null) {
            return;
        }
        if (Util.isNullOrEmpty(locId)) {
            return;
        }
        if (textUnit.getTarget(locId) == null) {
            return;
        }
        textUnit.getTarget(locId).setAnnotation(annotation);
    }

    public static void setSourceText(TextUnit textUnit, String text) {
        TextFragment source = textUnit.getSource().getFirstContent();
        source.setCodedText(text);
    }

    public static void setTargetText(TextUnit textUnit, LocaleId locId, String text) {
        TextFragment target = textUnit.getTarget(locId).getFirstContent();
        target.setCodedText(text);
    }

    public static void trimTU(TextUnit textUnit, boolean trimLeading, boolean trimTrailing) {
        int index;
        if (textUnit == null) {
            return;
        }
        if (!trimLeading && !trimTrailing) {
            return;
        }
        TextContainer source = textUnit.getSource();
        GenericSkeleton tuSkel = TextUnitUtil.forceSkeleton(textUnit);
        GenericSkeleton skel = new GenericSkeleton();
        if (trimLeading) {
            TextUnitUtil.trimLeading(source.getFirstContent(), skel);
        }
        skel.addContentPlaceholder(textUnit);
        if (trimTrailing) {
            TextUnitUtil.trimTrailing(source.getFirstContent(), skel);
        }
        if ((index = SkeletonUtil.findTuRefInSkeleton(tuSkel)) != -1) {
            SkeletonUtil.replaceSkeletonPart(tuSkel, index, skel);
        } else {
            tuSkel.add(skel);
        }
    }

    public static void removeQualifiers(TextUnit textUnit, String startQualifier, String endQualifier) {
        if (textUnit == null) {
            return;
        }
        if (Util.isEmpty(startQualifier)) {
            return;
        }
        if (Util.isEmpty(endQualifier)) {
            return;
        }
        String st = TextUnitUtil.getSourceText(textUnit);
        if (st == null) {
            return;
        }
        int startQualifierLen = startQualifier.length();
        int endQualifierLen = endQualifier.length();
        if (st.startsWith(startQualifier) && st.endsWith(endQualifier)) {
            GenericSkeleton tuSkel = TextUnitUtil.forceSkeleton(textUnit);
            GenericSkeleton skel = new GenericSkeleton();
            skel.add(startQualifier);
            skel.addContentPlaceholder(textUnit);
            skel.add(endQualifier);
            TextUnitUtil.setSourceText(textUnit, st.substring(startQualifierLen, Util.getLength(st) - endQualifierLen));
            int index = SkeletonUtil.findTuRefInSkeleton(tuSkel);
            if (index != -1) {
                SkeletonUtil.replaceSkeletonPart(tuSkel, index, skel);
            } else {
                tuSkel.add(skel);
            }
        }
    }

    public static void removeQualifiers(TextUnit textUnit, String qualifier) {
        TextUnitUtil.removeQualifiers(textUnit, qualifier, qualifier);
    }

    public static TextUnit createMultilingualTextUnit(TextUnit textUnit, List<AlignedPair> alignedSegmentPairs, LocaleId trgLocaleId) {
        TextUnit tu = textUnit.clone();
        tu.getSource().clear();
        for (LocaleId locId : tu.getTargetLocales()) {
            tu.removeTarget(locId);
        }
        tu.createTarget(trgLocaleId, true, 7);
        for (AlignedPair alignedPair : alignedSegmentPairs) {
            TextPart part4;
            TextPart part2;
            LinkedList<TextPart> sourceParts = new LinkedList<TextPart>(alignedPair.getSourceParts());
            LinkedList<TextPart> targetParts = new LinkedList<TextPart>(alignedPair.getTargetParts());
            int beforeIndex = 0;
            int afterIndex = sourceParts.size();
            Iterator i$ = sourceParts.iterator();
            while (i$.hasNext() && !(part2 = (TextPart)i$.next()).isSegment()) {
                ++beforeIndex;
            }
            ReversedIterator<TextPart> ri = new ReversedIterator<TextPart>(sourceParts);
            for (TextPart part3 : ri) {
                if (part3.isSegment()) break;
                --afterIndex;
            }
            for (TextPart part3 : sourceParts.subList(0, beforeIndex)) {
                tu.getSource().append(part3);
            }
            TextFragment src = new TextFragment();
            for (TextPart part4 : sourceParts.subList(beforeIndex, afterIndex)) {
                src.append(part4.getContent());
            }
            tu.getSource().getSegments().append(new Segment(null, src));
            for (TextPart part4 : sourceParts.subList(afterIndex, sourceParts.size())) {
                tu.getSource().append(part4);
            }
            beforeIndex = 0;
            afterIndex = targetParts.size();
            Iterator<Object> i$2 = targetParts.iterator();
            while (i$2.hasNext() && !(part4 = (TextPart)i$2.next()).isSegment()) {
                ++beforeIndex;
            }
            ri = new ReversedIterator<TextPart>(targetParts);
            i$2 = ri.iterator();
            while (i$2.hasNext() && !(part4 = (TextPart)i$2.next()).isSegment()) {
                --afterIndex;
            }
            for (TextPart part4 : targetParts.subList(0, beforeIndex)) {
                tu.getTarget(trgLocaleId).append(part4);
            }
            TextFragment trg = new TextFragment();
            for (TextPart part5 : targetParts.subList(beforeIndex, afterIndex)) {
                trg.append(part5.getContent());
            }
            tu.getTarget(trgLocaleId).getSegments().append(new Segment(tu.getSource().getSegments().getLast().getId(), trg));
            for (TextPart part5 : targetParts.subList(afterIndex, targetParts.size())) {
                tu.getTarget(trgLocaleId).append(part5);
            }
        }
        tu.getSource().setHasBeenSegmentedFlag(true);
        tu.getTarget(trgLocaleId).setHasBeenSegmentedFlag(true);
        return tu;
    }

    public static AltTranslationsAnnotation addAltTranslation(TextContainer targetContainer, AltTranslation alt) {
        AltTranslationsAnnotation altTrans = targetContainer.getAnnotation(AltTranslationsAnnotation.class);
        if (altTrans == null) {
            altTrans = new AltTranslationsAnnotation();
            targetContainer.setAnnotation(altTrans);
        }
        altTrans.add(alt);
        return altTrans;
    }

    public static AltTranslationsAnnotation addAltTranslation(Segment seg, AltTranslation alt) {
        AltTranslationsAnnotation altTrans = seg.getAnnotation(AltTranslationsAnnotation.class);
        if (altTrans == null) {
            altTrans = new AltTranslationsAnnotation();
            seg.setAnnotation(altTrans);
        }
        altTrans.add(alt);
        return altTrans;
    }
}

