/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.resource;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.filterwriter.GenericContent;
import net.sf.okapi.common.resource.AlignedPair;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.resource.TextUnitUtil;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.GenericSkeletonPart;
import org.junit.Assert;
import org.junit.Test;

public class TextUnitUtilTest {
    private GenericContent fmt = new GenericContent();
    private LocaleId locTrg = LocaleId.fromString("trg");

    @Test
    public void testAdjustTargetFragment() {
        TextFragment toTransSrc = this.makeFragment1();
        TextFragment proposalTrg = this.makeFragment1Bis("trg");
        Assert.assertEquals((Object)"{B}A{/B}B{BR/}C trg", (Object)proposalTrg.toText());
        TextUnitUtil.adjustTargetCodes(toTransSrc, proposalTrg, true, true, null, null);
        Assert.assertEquals((Object)"[b]A[/b]B[br/]C trg", (Object)proposalTrg.toText());
    }

    @Test
    public void testAdjustIncompleteTargetFragmentAutoAdded() {
        TextFragment toTransSrc = this.makeFragment1();
        TextFragment proposalTrg = this.makeFragment1Bis("trg");
        proposalTrg.remove(6, 8);
        Assert.assertEquals((Object)"{B}A{/B}BC trg", (Object)proposalTrg.toText());
        TextUnitUtil.adjustTargetCodes(toTransSrc, proposalTrg, true, true, null, null);
        Assert.assertEquals((Object)"[b]A[/b]BC trg[br/]", (Object)proposalTrg.toText());
    }

    @Test
    public void testAdjustIncompleteTargetFragmentNoAddition() {
        TextFragment toTransSrc = this.makeFragment1();
        TextFragment proposalTrg = this.makeFragment1Bis("with warning");
        proposalTrg.remove(6, 8);
        Assert.assertEquals((Object)"{B}A{/B}BC with warning", (Object)proposalTrg.toText());
        TextUnitUtil.adjustTargetCodes(toTransSrc, proposalTrg, true, false, null, null);
        Assert.assertEquals((Object)"[b]A[/b]BC with warning", (Object)proposalTrg.toText());
    }

    @Test
    public void testAdjustNoCodes() {
        TextUnit tu = new TextUnit("1", "src");
        TextFragment newSrc = new TextFragment("src");
        TextFragment newTrg = new TextFragment("trg");
        TextUnitUtil.adjustTargetCodes(tu.getSource().getSegments().getFirstContent(), newTrg, true, false, newSrc, tu);
        Assert.assertEquals((Object)this.locTrg, (Object)newTrg.toText());
    }

    @Test
    public void testAdjustSameMarkers() {
        TextUnit tu = this.createTextUnit1();
        TextFragment tf = new TextFragment("T ");
        tf.append(TextFragment.TagType.OPENING, "b", "<T>");
        tf.append("BOLD");
        tf.append(TextFragment.TagType.CLOSING, "b", "</T>");
        tf.append(" T ");
        tf.append(TextFragment.TagType.PLACEHOLDER, "br", "<PH/>");
        TextUnitUtil.adjustTargetCodes(tu.getSource().getSegments().getFirstContent(), tf, true, false, null, tu);
        Assert.assertEquals((Object)"T <b>BOLD</b> T <br/>", (Object)tf.toText());
        this.fmt.setContent(tf);
        Assert.assertEquals((Object)"T <1>BOLD</1> T <2/>", (Object)this.fmt.toString());
    }

    @Test
    public void testAdjustExtraMarkers() {
        TextUnit tu = this.createTextUnit1();
        TextFragment tf = new TextFragment("T ");
        tf.append(TextFragment.TagType.OPENING, "b", "<T>");
        tf.append("BOLD");
        tf.append(TextFragment.TagType.CLOSING, "b", "</T>");
        tf.append(" T ");
        tf.append(TextFragment.TagType.PLACEHOLDER, "br", "<PH/>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "extra", "<EXTRA/>");
        TextUnitUtil.adjustTargetCodes(tu.getSource().getSegments().getFirstContent(), tf, true, false, null, tu);
        Assert.assertEquals((Object)"T <b>BOLD</b> T <br/><EXTRA/>", (Object)tf.toText());
        this.fmt.setContent(tf);
        Assert.assertEquals((Object)"T <1>BOLD</1> T <2/><3/>", (Object)this.fmt.toString());
    }

    @Test
    public void testAdjustMissingMarker() {
        TextUnit tu = this.createTextUnit1();
        TextFragment tf = new TextFragment("T ");
        tf.append(TextFragment.TagType.OPENING, "b", "<T>");
        tf.append("BOLD");
        tf.append(" T ");
        tf.append(TextFragment.TagType.PLACEHOLDER, "br", "<PH/>");
        tf.append(TextFragment.TagType.PLACEHOLDER, "extra", "<EXTRA/>");
        TextUnitUtil.adjustTargetCodes(tu.getSource().getSegments().getFirstContent(), tf, true, false, null, tu);
        Assert.assertEquals((Object)"T <b>BOLD T <br/><EXTRA/>", (Object)tf.toText());
        this.fmt.setContent(tf);
        Assert.assertEquals((Object)"T <b1/>BOLD T <2/><3/>", (Object)this.fmt.toString());
    }

    @Test
    public void testAdjustDifferentTextSameMarkers() {
        TextUnit tu = this.createTextUnit1();
        TextFragment tf = new TextFragment("U ");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append("BOLD");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(" U ");
        tf.append(TextFragment.TagType.PLACEHOLDER, "br", "<br/>");
        TextUnitUtil.adjustTargetCodes(tu.getSource().getFirstContent(), tf, true, false, null, tu);
        Assert.assertEquals((Object)"U <b>BOLD</b> U <br/>", (Object)tf.toText());
        Assert.assertEquals((Object)"U <1>BOLD</1> U <2/>", (Object)this.fmt.setContent(tf).toString());
    }

    @Test
    public void testMovedCodes() {
        TextFragment oriFrag = new TextFragment("s1 ");
        oriFrag.append(TextFragment.TagType.PLACEHOLDER, "c1", "[c1]");
        oriFrag.append(" s2 ");
        oriFrag.append(TextFragment.TagType.OPENING, "c2", "[c2>]");
        oriFrag.append(" s3 ");
        oriFrag.append(TextFragment.TagType.CLOSING, "c2", "[<c2]");
        TextFragment trgFrag = this.fmt.fromLetterCodedToFragment("<g2>t3</g2> t1 <x1/> t2", null);
        TextUnitUtil.adjustTargetCodes(oriFrag, trgFrag, true, false, null, null);
        Assert.assertEquals((Object)"[c2>]t3[<c2] t1 [c1] t2", (Object)this.fmt.setContent(trgFrag).toString(true));
    }

    @Test
    public void testUtils() {
        String st = "12345678";
        Assert.assertEquals((Object)"45678", (Object)Util.trimStart(st, "123"));
        Assert.assertEquals((Object)"12345", (Object)Util.trimEnd(st, "678"));
        Assert.assertEquals((Object)"12345678", (Object)Util.trimEnd(st, "9"));
        st = "     ";
        Assert.assertEquals((Object)"", (Object)Util.trimStart(st, " "));
        Assert.assertEquals((Object)"", (Object)Util.trimEnd(st, " "));
        st = "  1234   ";
        TextFragment tf = new TextFragment(st);
        TextUnitUtil.trimLeading(tf, null);
        Assert.assertEquals((Object)"1234   ", (Object)tf.toText());
        TextUnitUtil.trimTrailing(tf, null);
        Assert.assertEquals((Object)"1234", (Object)tf.toText());
        st = "     ";
        tf = new TextFragment(st);
        TextUnitUtil.trimLeading(tf, null);
        Assert.assertEquals((Object)"", (Object)tf.toText());
        TextUnitUtil.trimTrailing(tf, null);
        Assert.assertEquals((Object)"", (Object)tf.toText());
        st = "     ";
        tf = new TextFragment(st);
        TextUnitUtil.trimTrailing(tf, null);
        Assert.assertEquals((Object)"", (Object)tf.toText());
        TextFragment tc = new TextFragment("test");
        Code c = new Code(TextFragment.TagType.PLACEHOLDER, "code");
        tc.append(c);
        tc.append(" string");
        TextFragment tcc = new TextFragment();
        Code c2 = new Code(TextFragment.TagType.PLACEHOLDER, "code");
        tcc.append("   ");
        tcc.append(c2);
        tcc.append("    123456  ");
        GenericSkeleton skel = new GenericSkeleton();
        TextUnitUtil.trimLeading(tcc, skel);
        TextUnit tu1 = new TextUnit("tu1");
        tu1.setSourceContent(tcc);
        Assert.assertEquals((Object)"    123456  ", (Object)tu1.toString());
        Assert.assertEquals((Object)"   ", (Object)skel.toString());
        TextFragment tcc2 = new TextFragment("    123456  ");
        Code c3 = new Code(TextFragment.TagType.PLACEHOLDER, "code");
        tcc2.append(c3);
        GenericSkeleton skel2 = new GenericSkeleton();
        TextUnitUtil.trimTrailing(tcc2, skel2);
        tu1.setSourceContent(tcc2);
        Assert.assertEquals((Object)"    123456  ", (Object)tu1.toString());
        Assert.assertEquals((Object)"", (Object)skel2.toString());
        TextFragment tcc4 = new TextFragment("    123456  ");
        Code c4 = new Code(TextFragment.TagType.PLACEHOLDER, "code");
        tcc4.append(c4);
        char ch = TextUnitUtil.getLastChar(tcc4);
        Assert.assertEquals((long)54L, (long)ch);
        TextFragment tcc5 = new TextFragment("    123456  ");
        TextUnitUtil.deleteLastChar(tcc5);
        Assert.assertEquals((Object)"    12345  ", (Object)tcc5.getCodedText());
        TextFragment tcc6 = new TextFragment("123456_    ");
        Assert.assertTrue((boolean)TextUnitUtil.endsWith(tcc6, "_"));
        Assert.assertTrue((boolean)TextUnitUtil.endsWith(tcc6, "6_"));
        Assert.assertFalse((boolean)TextUnitUtil.endsWith(tcc6, "  "));
        TextFragment tcc7 = new TextFragment("123456<splicer>    ");
        Assert.assertTrue((boolean)TextUnitUtil.endsWith(tcc7, "<splicer>"));
        Assert.assertTrue((boolean)TextUnitUtil.endsWith(tcc7, "6<splicer>"));
        Assert.assertFalse((boolean)TextUnitUtil.endsWith(tcc7, "  "));
    }

    @Test
    public void testGetText() {
        TextFragment tf = new TextFragment("ab");
        tf.append(TextFragment.TagType.OPENING, "type1", "z");
        tf.append("cde");
        tf.append(TextFragment.TagType.PLACEHOLDER, "type2", "z");
        tf.append("fgh");
        tf.append(TextFragment.TagType.PLACEHOLDER, "type3", "z");
        tf.append("ijklm");
        tf.append(TextFragment.TagType.CLOSING, "type1", "z");
        Assert.assertEquals((Object)"abcdefghijklm", (Object)TextUnitUtil.getText(tf));
        ArrayList<Integer> positions = new ArrayList<Integer>();
        Assert.assertEquals((Object)"abcdefghijklm", (Object)TextUnitUtil.getText(tf, positions));
        Assert.assertEquals((long)4L, (long)positions.size());
        Assert.assertEquals((long)2L, (long)positions.get(0).intValue());
        Assert.assertEquals((long)7L, (long)positions.get(1).intValue());
        Assert.assertEquals((long)12L, (long)positions.get(2).intValue());
        Assert.assertEquals((long)19L, (long)positions.get(3).intValue());
        tf = new TextFragment("ab");
        tf.append(TextFragment.TagType.OPENING, "type1", "z");
        tf.append("cde");
        tf.append(TextFragment.TagType.PLACEHOLDER, "type2", "z");
        tf.append("fgh");
        tf.append(TextFragment.TagType.PLACEHOLDER, "type3", "z");
        tf.append("ijklm");
        tf.append(TextFragment.TagType.CLOSING, "type1", "z");
        tf.append("n");
        Assert.assertEquals((Object)"abcdefghijklmn", (Object)TextUnitUtil.getText(tf));
        positions = new ArrayList();
        Assert.assertEquals((Object)"abcdefghijklmn", (Object)TextUnitUtil.getText(tf, positions));
        Assert.assertEquals((long)4L, (long)positions.size());
        Assert.assertEquals((long)2L, (long)positions.get(0).intValue());
        Assert.assertEquals((long)7L, (long)positions.get(1).intValue());
        Assert.assertEquals((long)12L, (long)positions.get(2).intValue());
        Assert.assertEquals((long)19L, (long)positions.get(3).intValue());
        String st = "abcdefghijklmn";
        Assert.assertEquals((Object)st, (Object)TextUnitUtil.getText(new TextFragment(st)));
        tf = new TextFragment("abcde");
        tf.append(TextFragment.TagType.PLACEHOLDER, "iso", "z");
        tf.append(TextFragment.TagType.PLACEHOLDER, "iso", "z");
        tf.append("fghijklm");
        tf.append(TextFragment.TagType.PLACEHOLDER, "iso", "z");
        tf.append(TextFragment.TagType.PLACEHOLDER, "iso", "z");
        tf.append("n");
        Assert.assertEquals((Object)"abcdefghijklmn", (Object)TextUnitUtil.getText(tf));
        positions = new ArrayList();
        Assert.assertEquals((Object)"abcdefghijklmn", (Object)TextUnitUtil.getText(tf, positions));
        Assert.assertEquals((long)4L, (long)positions.size());
        Assert.assertEquals((long)5L, (long)positions.get(0).intValue());
        Assert.assertEquals((long)7L, (long)positions.get(1).intValue());
        Assert.assertEquals((long)17L, (long)positions.get(2).intValue());
        Assert.assertEquals((long)19L, (long)positions.get(3).intValue());
        st = "abcdefghijklmn";
        Assert.assertEquals((Object)st, (Object)TextUnitUtil.getText(new TextFragment(st)));
    }

    @Test
    public void testRemoveQualifiers() {
        TextUnit tu = TextUnitUtil.buildTU("\"qualified text\"");
        TextUnitUtil.removeQualifiers(tu, "\"");
        Assert.assertEquals((Object)"qualified text", (Object)tu.getSource().toString());
        tu.setSourceContent(new TextFragment("((({[qualified text]})))"));
        Assert.assertEquals((Object)"((({[qualified text]})))", (Object)tu.getSource().toString());
        TextUnitUtil.removeQualifiers(tu, "((({", "})))");
        Assert.assertEquals((Object)"[qualified text]", (Object)tu.getSource().toString());
        GenericSkeleton tuSkel = (GenericSkeleton)tu.getSkeleton();
        Assert.assertNotNull((Object)tuSkel);
        List<GenericSkeletonPart> parts = tuSkel.getParts();
        Assert.assertEquals((long)5L, (long)parts.size());
        String tuRef = TextFragment.makeRefMarker("$self$");
        Assert.assertEquals((Object)"\"", (Object)parts.get(0).toString());
        Assert.assertEquals((Object)"((({", (Object)parts.get(1).toString());
        Assert.assertEquals((Object)tuRef, (Object)parts.get(2).toString());
        Assert.assertEquals((Object)"})))", (Object)parts.get(3).toString());
        Assert.assertEquals((Object)"\"", (Object)parts.get(4).toString());
    }

    @Test
    public void createMultilingualTextUnit() {
        TextUnit otu = new TextUnit("id1");
        LinkedList<TextPart> sourceParts = new LinkedList<TextPart>();
        LinkedList<TextPart> targetParts = new LinkedList<TextPart>();
        sourceParts.add(new Segment("id", new TextFragment("sSentence one.")));
        sourceParts.add(new TextPart(" "));
        sourceParts.add(new Segment("id", new TextFragment("sSentence two.")));
        sourceParts.add(new TextPart(" "));
        targetParts.add(new Segment("id", new TextFragment("tSentence one.")));
        targetParts.add(new TextPart(" "));
        targetParts.add(new Segment("id", new TextFragment("tSentence two.")));
        targetParts.add(new TextPart(" "));
        LinkedList<AlignedPair> alignedPairs = new LinkedList<AlignedPair>();
        alignedPairs.add(new AlignedPair(sourceParts, targetParts, LocaleId.SPANISH));
        TextUnit mtu = TextUnitUtil.createMultilingualTextUnit(otu, alignedPairs, LocaleId.SPANISH);
        Assert.assertEquals((Object)otu.getId(), (Object)mtu.getId());
        Assert.assertEquals((Object)"[sSentence one. sSentence two.] ", (Object)this.fmt.printSegmentedContent(mtu.getSource(), true));
        Assert.assertEquals((Object)"[tSentence one. tSentence two.] ", (Object)this.fmt.printSegmentedContent(mtu.getTarget(LocaleId.SPANISH), true));
        Assert.assertEquals((long)1L, (long)mtu.getSource().getSegments().count());
        Assert.assertEquals((Object)"sSentence one. sSentence two.", (Object)mtu.getSource().getSegments().get(0).toString());
        Assert.assertEquals((long)1L, (long)mtu.getTarget(LocaleId.SPANISH).getSegments().count());
        Segment tseg = mtu.getTarget(LocaleId.SPANISH).getSegments().get(0);
        Segment sseg = mtu.getSource().getSegments().get(0);
        Assert.assertEquals((Object)"tSentence one. tSentence two.", (Object)tseg.toString());
        Assert.assertEquals((Object)sseg.id, (Object)tseg.id);
    }

    private TextFragment makeFragment1() {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "b", "[b]");
        tf.append("A");
        tf.append(TextFragment.TagType.PLACEHOLDER, "br", "[br/]");
        tf.append("B");
        tf.append(TextFragment.TagType.CLOSING, "b", "[/b]");
        tf.append("C");
        return tf;
    }

    private TextFragment makeFragment1Bis(String extra) {
        TextFragment tf = new TextFragment();
        tf.append(TextFragment.TagType.OPENING, "b", "{B}");
        tf.append("A");
        tf.append(TextFragment.TagType.CLOSING, "b", "{/B}");
        tf.append("B");
        tf.append(TextFragment.TagType.PLACEHOLDER, "br", "{BR/}");
        tf.append("C " + extra);
        return tf;
    }

    private TextUnit createTextUnit1() {
        TextUnit tu = new TextUnit("1", "t ");
        TextFragment tf = tu.getSource().getSegments().getFirstContent();
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append("bold");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(" t ");
        tf.append(TextFragment.TagType.PLACEHOLDER, "br", "<br/>");
        return tu;
    }
}

