/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.skeleton;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.MultiEvent;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.GenericSkeletonWriter;
import net.sf.okapi.common.skeleton.ResourceSimplifier;
import net.sf.okapi.common.skeleton.ZipSkeleton;
import org.junit.Assert;
import org.junit.Test;

public class ResourceSimplifierTest {
    private static final LocaleId ENUS = new LocaleId("en", "us");
    private static final LocaleId ESES = new LocaleId("es", "es");
    private static final LocaleId FRFR = new LocaleId("fr", "fr");

    @Test
    public void testMonolingual() {
        ResourceSimplifier conv = new ResourceSimplifier(ESES);
        TextUnit tu1 = new TextUnit("tu1");
        tu1.setSource(new TextContainer("text1"));
        GenericSkeleton skel1 = new GenericSkeleton();
        tu1.setSkeleton(skel1);
        skel1.add("title='");
        skel1.addContentPlaceholder(tu1);
        skel1.add("'");
        TextUnit tu2 = new TextUnit("tu2");
        tu2.setSource(new TextContainer("text2"));
        GenericSkeleton skel2 = new GenericSkeleton();
        tu2.setSkeleton(skel2);
        skel2.add("<p ");
        skel2.addReference(tu1);
        tu1.setIsReferent(true);
        skel2.add(">");
        skel2.addContentPlaceholder(tu2);
        skel2.add("</p>");
        Event e = conv.convert(new Event(EventType.TEXT_UNIT, tu1));
        Assert.assertEquals((Object)((Object)EventType.TEXT_UNIT), (Object)((Object)e.getEventType()));
        Assert.assertTrue((boolean)tu1.isReferent());
        e = conv.convert(new Event(EventType.TEXT_UNIT, tu2));
        Assert.assertEquals((Object)((Object)EventType.MULTI_EVENT), (Object)((Object)e.getEventType()));
        MultiEvent packedME = (MultiEvent)e.getResource();
        Iterator<Event> itr = packedME.iterator();
        Assert.assertTrue((boolean)itr.hasNext());
        Event event = itr.next();
        Assert.assertEquals((Object)((Object)EventType.DOCUMENT_PART), (Object)((Object)event.getEventType()));
        IResource res = event.getResource();
        Assert.assertEquals((Object)"<p title='", (Object)((Object)res.getSkeleton()).toString());
        Assert.assertTrue((boolean)itr.hasNext());
        event = itr.next();
        Assert.assertEquals((Object)((Object)EventType.TEXT_UNIT), (Object)((Object)event.getEventType()));
        res = event.getResource();
        Assert.assertEquals((Object)"text1", (Object)res.toString());
        Assert.assertTrue((boolean)itr.hasNext());
        event = itr.next();
        Assert.assertEquals((Object)((Object)EventType.DOCUMENT_PART), (Object)((Object)event.getEventType()));
        res = event.getResource();
        Assert.assertEquals((Object)"'>", (Object)((Object)res.getSkeleton()).toString());
        Assert.assertTrue((boolean)itr.hasNext());
        event = itr.next();
        Assert.assertEquals((Object)((Object)EventType.TEXT_UNIT), (Object)((Object)event.getEventType()));
        res = event.getResource();
        Assert.assertEquals((Object)"text2", (Object)res.toString());
        Assert.assertTrue((boolean)itr.hasNext());
        event = itr.next();
        Assert.assertEquals((Object)((Object)EventType.DOCUMENT_PART), (Object)((Object)event.getEventType()));
        res = event.getResource();
        Assert.assertEquals((Object)"</p>", (Object)((Object)res.getSkeleton()).toString());
        Assert.assertFalse((boolean)itr.hasNext());
    }

    @Test
    public void testPackMultiEvent() {
        MultiEvent me = new MultiEvent();
        GenericSkeleton skel1 = new GenericSkeleton("dp1");
        GenericSkeleton skel2 = new GenericSkeleton("dp2");
        GenericSkeleton skel3 = new GenericSkeleton("dp3");
        GenericSkeleton skel4 = new GenericSkeleton("tu1");
        me.addEvent(new Event(EventType.DOCUMENT_PART, new DocumentPart("dp1", false, skel1)));
        me.addEvent(new Event(EventType.DOCUMENT_PART, new DocumentPart("dp2", false, skel2)));
        me.addEvent(new Event(EventType.DOCUMENT_PART, new DocumentPart("dp3", false, skel3)));
        MultiEvent packedME = ResourceSimplifier.packMultiEvent(me);
        Iterator<Event> itr = packedME.iterator();
        Assert.assertTrue((boolean)itr.hasNext());
        Event event = itr.next();
        Assert.assertTrue((event.getEventType() == EventType.DOCUMENT_PART ? 1 : 0) != 0);
        IResource res = event.getResource();
        Assert.assertEquals((Object)"dp1dp2dp3", (Object)((Object)res.getSkeleton()).toString());
        Assert.assertFalse((boolean)itr.hasNext());
        me = new MultiEvent();
        skel1 = new GenericSkeleton("dp1");
        skel2 = new GenericSkeleton("dp2");
        skel3 = new GenericSkeleton("dp3");
        skel4 = new GenericSkeleton("tu1");
        me.addEvent(new Event(EventType.DOCUMENT_PART, new DocumentPart("dp1", false, skel1)));
        me.addEvent(new Event(EventType.DOCUMENT_PART, new DocumentPart("dp2", false, skel2)));
        TextUnit tu1 = new TextUnit("tu1");
        tu1.setSkeleton(skel4);
        me.addEvent(new Event(EventType.TEXT_UNIT, tu1));
        me.addEvent(new Event(EventType.DOCUMENT_PART, new DocumentPart("dp3", false, skel3)));
        packedME = ResourceSimplifier.packMultiEvent(me);
        itr = packedME.iterator();
        Assert.assertTrue((boolean)itr.hasNext());
        event = itr.next();
        res = event.getResource();
        Assert.assertEquals((Object)"dp1dp2", (Object)((Object)res.getSkeleton()).toString());
        Assert.assertTrue((boolean)itr.hasNext());
        event = itr.next();
        res = event.getResource();
        Assert.assertEquals((Object)"tu1", (Object)((Object)res.getSkeleton()).toString());
        Assert.assertTrue((boolean)itr.hasNext());
        event = itr.next();
        res = event.getResource();
        Assert.assertEquals((Object)"dp3", (Object)((Object)res.getSkeleton()).toString());
        Assert.assertFalse((boolean)itr.hasNext());
        me = new MultiEvent();
        skel1 = new GenericSkeleton("dp1");
        skel2 = new GenericSkeleton("dp2");
        skel3 = new GenericSkeleton("dp3");
        skel4 = new GenericSkeleton("tu1");
        tu1 = new TextUnit("tu1");
        tu1.setSkeleton(skel4);
        me.addEvent(new Event(EventType.TEXT_UNIT, tu1));
        me.addEvent(new Event(EventType.DOCUMENT_PART, new DocumentPart("dp1", false, skel1)));
        me.addEvent(new Event(EventType.DOCUMENT_PART, new DocumentPart("dp2", false, skel2)));
        me.addEvent(new Event(EventType.DOCUMENT_PART, new DocumentPart("dp3", false, skel3)));
        packedME = ResourceSimplifier.packMultiEvent(me);
        itr = packedME.iterator();
        Assert.assertTrue((boolean)itr.hasNext());
        event = itr.next();
        res = event.getResource();
        Assert.assertEquals((Object)"tu1", (Object)((Object)res.getSkeleton()).toString());
        Assert.assertTrue((boolean)itr.hasNext());
        event = itr.next();
        res = event.getResource();
        Assert.assertEquals((Object)"dp1dp2dp3", (Object)((Object)res.getSkeleton()).toString());
        Assert.assertFalse((boolean)itr.hasNext());
        me = new MultiEvent();
        skel1 = new GenericSkeleton("dp1");
        skel2 = new GenericSkeleton("dp2");
        skel3 = new GenericSkeleton("dp3");
        skel4 = new GenericSkeleton("tu1");
        tu1 = new TextUnit("tu1");
        tu1.setSkeleton(skel4);
        me.addEvent(new Event(EventType.DOCUMENT_PART, new DocumentPart("dp1", false, skel1)));
        me.addEvent(new Event(EventType.DOCUMENT_PART, new DocumentPart("dp2", false, skel2)));
        me.addEvent(new Event(EventType.DOCUMENT_PART, new DocumentPart("dp3", false, skel3)));
        me.addEvent(new Event(EventType.TEXT_UNIT, tu1));
        packedME = ResourceSimplifier.packMultiEvent(me);
        itr = packedME.iterator();
        Assert.assertTrue((boolean)itr.hasNext());
        event = itr.next();
        res = event.getResource();
        Assert.assertEquals((Object)"dp1dp2dp3", (Object)((Object)res.getSkeleton()).toString());
        Assert.assertTrue((boolean)itr.hasNext());
        event = itr.next();
        res = event.getResource();
        Assert.assertEquals((Object)"tu1", (Object)((Object)res.getSkeleton()).toString());
        Assert.assertFalse((boolean)itr.hasNext());
        me = new MultiEvent();
        skel1 = new GenericSkeleton("dp1");
        skel2 = new GenericSkeleton("dp2");
        skel3 = new GenericSkeleton("dp3");
        skel4 = new GenericSkeleton("tu1");
        tu1 = new TextUnit("tu1");
        tu1.setSkeleton(skel4);
        me.addEvent(new Event(EventType.TEXT_UNIT, tu1));
        packedME = ResourceSimplifier.packMultiEvent(me);
        itr = packedME.iterator();
        Assert.assertTrue((boolean)itr.hasNext());
        event = itr.next();
        res = event.getResource();
        Assert.assertEquals((Object)"tu1", (Object)((Object)res.getSkeleton()).toString());
        Assert.assertFalse((boolean)itr.hasNext());
        me = new MultiEvent();
        packedME = ResourceSimplifier.packMultiEvent(me);
        itr = packedME.iterator();
        Assert.assertFalse((boolean)itr.hasNext());
    }

    @Test
    public void testConversion() {
        GenericSkeleton skel = new GenericSkeleton();
        TextUnit tu1 = new TextUnit("tu1");
        tu1.setSource(new TextContainer("English text"));
        tu1.setTarget(FRFR, new TextContainer("Texte en langue Francaise"));
        tu1.setSkeleton(skel);
        TextUnit tu2 = new TextUnit("tu2");
        tu2.setSource(new TextContainer("English text"));
        tu2.setTarget(ESES, new TextContainer("Texto en Espanol"));
        tu2.setIsReferent(true);
        skel.add("part1");
        skel.addContentPlaceholder(tu1);
        skel.add("part2");
        skel.addContentPlaceholder(tu1, FRFR);
        skel.add("part3");
        skel.addContentPlaceholder(tu2, ESES);
        skel.add("part4");
        ResourceSimplifier rs = new ResourceSimplifier(ENUS);
        Event event = rs.convert(new Event(EventType.TEXT_UNIT, tu1));
        Assert.assertNotNull((Object)event);
        Assert.assertTrue((boolean)(event.getResource() instanceof MultiEvent));
        MultiEvent me = (MultiEvent)event.getResource();
        Iterator<Event> itr = me.iterator();
        Assert.assertTrue((boolean)itr.hasNext());
        event = itr.next();
        IResource res = event.getResource();
        Assert.assertEquals((Object)"dp_tu1", (Object)res.getId());
        Assert.assertTrue((boolean)(res instanceof DocumentPart));
        Assert.assertEquals((Object)"part1", (Object)((Object)res.getSkeleton()).toString());
        Assert.assertTrue((boolean)itr.hasNext());
        event = itr.next();
        res = event.getResource();
        Assert.assertEquals((Object)"tu1", (Object)res.getId());
        Assert.assertTrue((boolean)(res instanceof TextUnit));
        Assert.assertNull((Object)res.getSkeleton());
        Assert.assertTrue((boolean)itr.hasNext());
        event = itr.next();
        res = event.getResource();
        Assert.assertEquals((Object)"dp_tu1_2", (Object)res.getId());
        Assert.assertTrue((boolean)(res instanceof DocumentPart));
        Assert.assertEquals((Object)"part2Texte en langue Francaisepart3English textpart4", (Object)((Object)res.getSkeleton()).toString());
        Assert.assertFalse((boolean)itr.hasNext());
    }

    @Test
    public void testConversion2() {
        GenericSkeleton skel = new GenericSkeleton();
        TextUnit tu1 = new TextUnit("tu1");
        tu1.setSource(new TextContainer("English text"));
        tu1.setTarget(FRFR, new TextContainer("Texte en langue Francaise"));
        tu1.setSkeleton(skel);
        TextUnit tu2 = new TextUnit("tu2");
        tu2.setSource(new TextContainer("English text"));
        tu2.setTarget(ESES, new TextContainer("Texto en Espanol"));
        tu2.setIsReferent(true);
        skel.add("part1");
        skel.addContentPlaceholder(tu1);
        skel.add("part2");
        skel.addContentPlaceholder(tu1, FRFR);
        skel.add("part3");
        skel.addReference(tu2);
        skel.add("part4");
        ResourceSimplifier rs = new ResourceSimplifier(ENUS);
        Event complexEvent = new Event(EventType.TEXT_UNIT, tu1);
        rs.convert(new Event(EventType.TEXT_UNIT, tu2));
        Event simpleEvent = rs.convert(complexEvent);
        Assert.assertNotNull((Object)simpleEvent);
        Assert.assertTrue((boolean)(simpleEvent.getResource() instanceof MultiEvent));
        MultiEvent me = (MultiEvent)simpleEvent.getResource();
        Iterator<Event> itr = me.iterator();
        Assert.assertTrue((boolean)itr.hasNext());
        Event event = itr.next();
        IResource res = event.getResource();
        Assert.assertEquals((Object)"dp_tu1", (Object)res.getId());
        Assert.assertTrue((boolean)(res instanceof DocumentPart));
        Assert.assertEquals((Object)"part1", (Object)((Object)res.getSkeleton()).toString());
        Assert.assertTrue((boolean)itr.hasNext());
        event = itr.next();
        res = event.getResource();
        Assert.assertEquals((Object)"tu1", (Object)res.getId());
        Assert.assertTrue((boolean)(res instanceof TextUnit));
        Assert.assertNull((Object)res.getSkeleton());
        Assert.assertTrue((boolean)itr.hasNext());
        event = itr.next();
        res = event.getResource();
        Assert.assertEquals((Object)"dp_tu1_2", (Object)res.getId());
        Assert.assertTrue((boolean)(res instanceof DocumentPart));
        Assert.assertEquals((Object)"part2Texte en langue Francaisepart3English textpart4", (Object)((Object)res.getSkeleton()).toString());
        Assert.assertFalse((boolean)itr.hasNext());
        GenericSkeletonWriter gsw = new GenericSkeletonWriter();
        StartDocument sd = new StartDocument("sd");
        gsw.processStartDocument(ENUS, "UTF-8", null, null, sd);
        gsw.processTextUnit(tu2);
        this.checkTUConversion(tu1, simpleEvent, gsw);
    }

    private void checkTUConversion(TextUnit tu, Event simpleEvent, GenericSkeletonWriter gsw) {
        Assert.assertNotNull((Object)simpleEvent);
        Assert.assertTrue((boolean)(simpleEvent.getResource() instanceof MultiEvent));
        MultiEvent me = (MultiEvent)simpleEvent.getResource();
        String st1 = gsw.processTextUnit(tu);
        StringBuilder sb = new StringBuilder();
        for (Event event : me) {
            switch (event.getEventType()) {
                case DOCUMENT_PART: {
                    sb.append(gsw.processDocumentPart((DocumentPart)event.getResource()));
                    break;
                }
                case TEXT_UNIT: {
                    sb.append(gsw.processTextUnit((TextUnit)event.getResource()));
                }
            }
        }
        Assert.assertEquals((Object)st1, (Object)sb.toString());
    }

    private ZipSkeleton createZipSkeleton() throws IOException {
        File tempZip = File.createTempFile("~temp.zip", null);
        tempZip.deleteOnExit();
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(tempZip));
        zos.putNextEntry(new ZipEntry("test"));
        zos.close();
        return new ZipSkeleton(new ZipFile(tempZip), new ZipEntry("test"));
    }

    @Test
    public void testDp_GenericSkeleton() {
        DocumentPart dp1 = new DocumentPart("P1C1D3-dp1", true);
        GenericSkeleton skel = new GenericSkeleton();
        dp1.setSkeleton(skel);
        ResourceSimplifier rs = new ResourceSimplifier(ENUS);
        Event event = rs.convert(new Event(EventType.DOCUMENT_PART, dp1));
        Assert.assertNotNull((Object)event);
        Assert.assertTrue((boolean)(event.getResource() instanceof DocumentPart));
    }

    @Test
    public void testDp_NonGenericSkeleton() throws IOException {
        DocumentPart dp1 = new DocumentPart("P1C1D3-dp1", true);
        dp1.setSkeleton(this.createZipSkeleton());
        ResourceSimplifier rs = new ResourceSimplifier(ENUS);
        Event event = rs.convert(new Event(EventType.DOCUMENT_PART, dp1));
        Assert.assertNotNull((Object)event);
        Assert.assertTrue((boolean)(event.getResource() instanceof DocumentPart));
    }

    @Test
    public void testTu_NoSkeleton() {
        TextUnit tu1 = new TextUnit("P1C1D3-tu1");
        tu1.setSource(new TextContainer("Source"));
        ResourceSimplifier rs = new ResourceSimplifier(ENUS);
        Event event = rs.convert(new Event(EventType.TEXT_UNIT, tu1));
        Assert.assertNotNull((Object)event);
        Assert.assertTrue((boolean)(event.getResource() instanceof TextUnit));
    }

    @Test
    public void testTu_GenericSkeleton() {
        TextUnit tu1 = new TextUnit("P1C1D3-tu1");
        tu1.setSource(new TextContainer("Source"));
        GenericSkeleton skel2 = new GenericSkeleton();
        tu1.setSkeleton(skel2);
        skel2.add("Prefix");
        skel2.addContentPlaceholder(tu1);
        skel2.add("Suffix");
        ResourceSimplifier rs = new ResourceSimplifier(ENUS);
        Event event = rs.convert(new Event(EventType.TEXT_UNIT, tu1));
        Assert.assertNotNull((Object)event);
        Assert.assertTrue((boolean)(event.getResource() instanceof MultiEvent));
        MultiEvent me = (MultiEvent)event.getResource();
        Assert.assertEquals((long)3L, (long)me.size());
        Iterator<Event> itr = me.iterator();
        Event ev = itr.next();
        Assert.assertTrue((boolean)(ev.getResource() instanceof DocumentPart));
        Assert.assertEquals((Object)"Prefix", (Object)ev.getResource().toString());
        ev = itr.next();
        Assert.assertTrue((boolean)(ev.getResource() instanceof TextUnit));
        Assert.assertEquals((Object)"Source", (Object)ev.getResource().toString());
        ev = itr.next();
        Assert.assertTrue((boolean)(ev.getResource() instanceof DocumentPart));
        Assert.assertEquals((Object)"Suffix", (Object)ev.getResource().toString());
    }

    @Test
    public void testTu_NonGenericSkeleton() throws IOException {
        TextUnit tu1 = new TextUnit("P1C1D3-tu1");
        tu1.setSource(new TextContainer("Source"));
        tu1.setSkeleton(this.createZipSkeleton());
        ResourceSimplifier rs = new ResourceSimplifier(ENUS);
        Event event = rs.convert(new Event(EventType.TEXT_UNIT, tu1));
        Assert.assertNotNull((Object)event);
        Assert.assertTrue((boolean)(event.getResource() instanceof TextUnit));
    }

    @Test
    public void testReferencesInTuCodes_NoSkeleton() {
        DocumentPart dp1 = new DocumentPart("P1C1D3-dp1", true);
        GenericSkeleton skel = new GenericSkeleton();
        dp1.setSkeleton(skel);
        skel.add("<a id=\"jsHelplink\" ");
        skel.add("href=\"");
        skel.addValuePlaceholder(dp1, "href", null);
        skel.add("\"");
        skel.add(">");
        dp1.setSourceProperty(new Property("href", "{0}"));
        TextUnit tu1 = new TextUnit("P1C1D3-tu1");
        TextContainer tc = new TextContainer();
        tu1.setSource(tc);
        TextFragment tf = new TextFragment();
        tc.setContent(tf);
        tf.append(TextFragment.TagType.OPENING, "bold", "<b>", 1);
        tf.append("Javascript is not enabled on your internet browser.");
        tf.append(TextFragment.TagType.CLOSING, "bold", "</b>", 1);
        tf.append(TextFragment.TagType.PLACEHOLDER, "br", "<br/>", 2);
        tf.append(TextFragment.TagType.PLACEHOLDER, "br", "<br/>", 3);
        tf.append("FamilySearch Indexing requires Javascript to operate properly.  Please click");
        tf.append(TextFragment.TagType.OPENING, "link", "", 4).appendReference(dp1.getId());
        tf.append("here ");
        tf.append(TextFragment.TagType.CLOSING, "link", "</a>", 4);
        tf.append(" for instructions on enabling this browser feature.");
        ResourceSimplifier rs = new ResourceSimplifier(ENUS);
        rs.convert(new Event(EventType.DOCUMENT_PART, dp1));
        Event event = rs.convert(new Event(EventType.TEXT_UNIT, tu1));
        Assert.assertNotNull((Object)event);
        Assert.assertTrue((boolean)(event.getResource() instanceof TextUnit));
        TextUnit tu = (TextUnit)event.getResource();
        Assert.assertEquals((Object)"<b>Javascript is not enabled on your internet browser.</b><br/><br/>FamilySearch Indexing requires Javascript to operate properly.  Please click<a id=\"jsHelplink\" href=\"{0}\">here </a> for instructions on enabling this browser feature.", (Object)tu.toString());
        Assert.assertEquals((long)6L, (long)tu.getSource().getUnSegmentedContentCopy().getCodes().size());
        Code code = tu.getSource().getUnSegmentedContentCopy().getCode(4);
        Assert.assertEquals((Object)((Object)TextFragment.TagType.OPENING), (Object)((Object)code.getTagType()));
    }

    @Test
    public void testReferencesInTuCodes_WithSkeleton() {
        DocumentPart dp1 = new DocumentPart("P1C1D3-dp1", true);
        GenericSkeleton skel1 = new GenericSkeleton();
        dp1.setSkeleton(skel1);
        skel1.add("<a id=\"jsHelplink\" ");
        skel1.add("href=\"");
        skel1.addValuePlaceholder(dp1, "href", null);
        skel1.add("\"");
        skel1.add(">");
        dp1.setSourceProperty(new Property("href", "{0}"));
        TextUnit tu1 = new TextUnit("P1C1D3-tu1");
        GenericSkeleton skel2 = new GenericSkeleton();
        tu1.setSkeleton(skel2);
        skel2.add("Prefix");
        skel2.addContentPlaceholder(tu1);
        skel2.add("Suffix");
        TextContainer tc = new TextContainer();
        tu1.setSource(tc);
        TextFragment tf = new TextFragment();
        tc.setContent(tf);
        tf.append(TextFragment.TagType.OPENING, "bold", "<b>", 1);
        tf.append("Javascript is not enabled on your internet browser.");
        tf.append(TextFragment.TagType.CLOSING, "bold", "</b>", 1);
        tf.append(TextFragment.TagType.PLACEHOLDER, "br", "<br/>", 2);
        tf.append(TextFragment.TagType.PLACEHOLDER, "br", "<br/>", 3);
        tf.append("FamilySearch Indexing requires Javascript to operate properly.  Please click");
        tf.append(TextFragment.TagType.OPENING, "link", "", 4).appendReference(dp1.getId());
        tf.append("here ");
        tf.append(TextFragment.TagType.CLOSING, "link", "</a>", 4);
        tf.append(" for instructions on enabling this browser feature.");
        ResourceSimplifier rs = new ResourceSimplifier(ENUS);
        rs.convert(new Event(EventType.DOCUMENT_PART, dp1));
        Event event = rs.convert(new Event(EventType.TEXT_UNIT, tu1));
        Assert.assertNotNull((Object)event);
        Assert.assertTrue((boolean)(event.getResource() instanceof MultiEvent));
        MultiEvent me = (MultiEvent)event.getResource();
        Assert.assertEquals((long)3L, (long)me.size());
        Iterator<Event> itr = me.iterator();
        Event ev = itr.next();
        Assert.assertTrue((boolean)(ev.getResource() instanceof DocumentPart));
        Assert.assertEquals((Object)"Prefix", (Object)ev.getResource().toString());
        ev = itr.next();
        Assert.assertTrue((boolean)(ev.getResource() instanceof TextUnit));
        Assert.assertEquals((Object)"<b>Javascript is not enabled on your internet browser.</b><br/><br/>FamilySearch Indexing requires Javascript to operate properly.  Please click<a id=\"jsHelplink\" href=\"{0}\">here </a> for instructions on enabling this browser feature.", (Object)ev.getResource().toString());
        ev = itr.next();
        Assert.assertTrue((boolean)(ev.getResource() instanceof DocumentPart));
        Assert.assertEquals((Object)"Suffix", (Object)ev.getResource().toString());
    }
}

