/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.apertium;

import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Map;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.query.MatchType;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.connectors.apertium.Parameters;
import net.sf.okapi.lib.translation.BaseConnector;
import net.sf.okapi.lib.translation.QueryResult;
import net.sf.okapi.lib.translation.QueryUtil;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class ApertiumMTConnector
extends BaseConnector {
    private Parameters params = new Parameters();
    private JSONParser parser;
    private QueryUtil util = new QueryUtil();

    public ApertiumMTConnector() {
        this.parser = new JSONParser();
    }

    @Override
    public String getName() {
        return "Apertium MT";
    }

    @Override
    public String getSettingsDisplay() {
        return String.format("Server: %s\n%s", this.params.getServer(), Util.isEmpty(this.params.getApiKey()) ? "Without API key" : "With API key");
    }

    @Override
    public void close() {
    }

    @Override
    public void open() {
    }

    @Override
    public int query(String plainText) {
        return this.query(new TextFragment(plainText));
    }

    @Override
    public int query(TextFragment fragment) {
        this.result = null;
        this.current = -1;
        try {
            JSONObject object;
            if (!fragment.hasText(false)) {
                return 0;
            }
            String qtext = this.util.toCodedHTML(fragment);
            URL url = Util.isEmpty(this.params.getApiKey()) ? new URL(this.params.getServer() + String.format("?format=html&markUnknown=no&q=%s&langpair=%s|%s", URLEncoder.encode(qtext, "UTF-8"), this.srcCode, this.trgCode)) : new URL(this.params.getServer() + String.format("?key=%s&format=html&markUnknown=no&q=%s&langpair=%s|%s", URLEncoder.encode(this.params.getApiKey(), "UTF-8"), URLEncoder.encode(qtext, "UTF-8"), this.srcCode, this.trgCode));
            URLConnection conn = url.openConnection();
            conn.setConnectTimeout(this.params.getTimeout() * 1000);
            JSONObject map = object = (JSONObject)this.parser.parse(new InputStreamReader(conn.getInputStream(), "UTF-8"));
            Map data = (Map)map.get("responseData");
            String res = (String)data.get("translatedText");
            if (res == null) {
                return 0;
            }
            if (res.endsWith("\n") && !qtext.endsWith("\n")) {
                res = res.substring(0, res.length() - 1);
            }
            this.result = new QueryResult();
            this.result.weight = this.getWeight();
            this.result.source = fragment;
            this.result.target = fragment.hasCode() ? new TextFragment(this.util.fromCodedHTML(res, fragment), fragment.getCodes()) : new TextFragment(this.util.fromCodedHTML(res, fragment));
            this.result.score = 95;
            this.result.origin = this.getName();
            this.result.matchType = MatchType.MT;
            this.current = 0;
        }
        catch (Throwable e) {
            throw new RuntimeException("Error querying the server." + e.getMessage(), e);
        }
        return this.current == 0 ? 1 : 0;
    }

    @Override
    protected String toInternalCode(LocaleId standardCode) {
        String lang = standardCode.getLanguage();
        String reg = standardCode.getRegion();
        if (reg != null) {
            if (reg.equals("aran")) {
                lang = lang + "_aran";
            }
            if (reg.equals("br")) {
                lang = lang + "_BR";
            }
        }
        return lang;
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }
}

