/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.crosslanguage;

import com.crosslang.clgateway.ws.gateway.impl.ClGatewayPortBindingStub;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import net.sf.okapi.common.Base64;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.query.MatchType;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.connectors.crosslanguage.Parameters;
import net.sf.okapi.lib.translation.BaseConnector;
import net.sf.okapi.lib.translation.QueryResult;
import net.sf.okapi.lib.translation.QueryUtil;

public class CrossLanguageMTConnector
extends BaseConnector {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss z");
    private Parameters params = new Parameters();
    private QueryUtil util = new QueryUtil();
    private ClGatewayPortBindingStub clGateway;
    private String requestTime;
    private String secret;

    @Override
    public void close() {
        this.clGateway = null;
    }

    @Override
    public String getName() {
        return "CrossLanguage Gateway";
    }

    @Override
    public String getSettingsDisplay() {
        return "Server: " + this.params.getServerURL();
    }

    @Override
    public void open() {
        try {
            URL url = new URL(this.params.getServerURL());
            this.clGateway = new ClGatewayPortBindingStub(url, null);
            this.requestTime = this.generateTimeStamp();
            this.secret = this.generateSecret(this.params.getUser(), this.requestTime, this.params.getPassword());
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("Invalid key.", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Encryption error.", e);
        }
        catch (Throwable e) {
            throw new RuntimeException("Error when initializing the MT engine.", e);
        }
    }

    @Override
    public int query(String plainText) {
        return this.queryString(plainText);
    }

    @Override
    public int query(TextFragment text) {
        return this.queryFile(text);
    }

    private int queryString(String text) {
        this.current = -1;
        try {
            String res = this.clGateway.translateSentence(this.params.getApiKey(), this.params.getUser(), this.requestTime, this.secret, text);
            if (res == null) {
                return 0;
            }
            this.result = new QueryResult();
            this.result.weight = this.getWeight();
            this.result.source = new TextFragment(text);
            this.result.target = new TextFragment(res);
            this.result.score = 95;
            this.result.origin = this.getName();
            this.result.matchType = MatchType.MT;
            this.current = 0;
        }
        catch (Throwable e) {
            throw new RuntimeException("Error querying the server: " + e.getMessage(), e);
        }
        return this.current == 0 ? 1 : 0;
    }

    private int queryFile(TextFragment text) {
        this.current = -1;
        try {
            if (!text.hasText(false)) {
                return 0;
            }
            String qtext = "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"><p>" + this.util.toCodedHTML(text) + "</p>";
            String res = this.clGateway.translateFile(this.params.getApiKey(), this.params.getUser(), this.requestTime, this.secret, Base64.encodeString(qtext), "html");
            if (res == null) {
                return 0;
            }
            if (res.startsWith("TransError")) {
                throw new RuntimeException("Error querying the server: " + res);
            }
            this.result = new QueryResult();
            this.result.source = text;
            String data = Base64.decodeString(res);
            int pos = data.indexOf("<p>");
            if (pos > -1) {
                data = data.substring(pos + 3, data.length() - 4);
            }
            this.result.target = text.hasCode() ? new TextFragment(this.util.fromCodedHTML(data, text), text.getCodes()) : new TextFragment(this.util.fromCodedHTML(data, text));
            this.result.score = 95;
            this.result.origin = this.getName();
            this.result.matchType = MatchType.MT;
            this.current = 0;
        }
        catch (Throwable e) {
            throw new RuntimeException("Error querying the server: " + e.getMessage(), e);
        }
        return this.current == 0 ? 1 : 0;
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        params = (Parameters)params;
    }

    private String generateTimeStamp() {
        return DATE_FORMAT.format(new Date());
    }

    private String generateSecret(String username, String timestamp, String password) throws NoSuchAlgorithmException, InvalidKeyException, IllegalStateException, UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder(username).append("#").append(timestamp);
        SecretKeySpec signingKey = new SecretKeySpec(password.getBytes(), "HmacSHA1");
        Mac mac = Mac.getInstance("HmacSHA1");
        mac.init(signingKey);
        byte[] rawHmac = mac.doFinal(sb.toString().getBytes("UTF-8"));
        return new String(Base64.encode(rawHmac)).trim();
    }
}

