/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.globalsight;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.TextInputPart;

public class Parameters
extends BaseParameters
implements IEditorDescriptionProvider {
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final String SERVERURL = "serverURL";
    private static final String TMPROFILE = "tmProfile";
    private String username;
    private String password;
    private String serverURL;
    private String tmProfile;

    public Parameters() {
        this.reset();
        this.toString();
    }

    public Parameters(String initialData) {
        this.fromString(initialData);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getServerURL() {
        return this.serverURL;
    }

    public void setServerURL(String serverURL) {
        this.serverURL = serverURL;
    }

    public String getTmProfile() {
        return this.tmProfile;
    }

    public void setTmProfile(String tmProfile) {
        this.tmProfile = tmProfile;
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.username = this.buffer.getString(USERNAME, this.username);
        this.password = this.buffer.getString(PASSWORD, this.password);
        this.serverURL = this.buffer.getString(SERVERURL, this.serverURL);
        this.tmProfile = this.buffer.getString(TMPROFILE, this.tmProfile);
    }

    @Override
    public void reset() {
        this.username = "";
        this.password = "";
        this.serverURL = "http://HOST:PORT/globalsight/services/AmbassadorWebService?wsdl";
        this.tmProfile = "default";
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setString(USERNAME, this.username);
        this.buffer.setString(PASSWORD, this.password);
        this.buffer.setString(SERVERURL, this.serverURL);
        this.buffer.setString(TMPROFILE, this.tmProfile);
        return this.buffer.toString();
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(SERVERURL, "Server URL", "The full URL of the TM server (e.g. http://xyz:8080/globalsight/services/AmbassadorWebService?wsdl");
        desc.add(USERNAME, "User name", "The login name to use");
        desc.add(PASSWORD, "Password", "The password for the given user name");
        desc.add(TMPROFILE, "TM profile", "The name of the TM profile to use");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("GlobalSight TM Connector Settings");
        desc.addTextInputPart(paramsDesc.get(SERVERURL));
        desc.addTextInputPart(paramsDesc.get(USERNAME));
        TextInputPart tip = desc.addTextInputPart(paramsDesc.get(PASSWORD));
        tip.setPassword(true);
        desc.addTextInputPart(paramsDesc.get(TMPROFILE));
        return desc;
    }
}

