/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.microsoft;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.query.MatchType;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.connectors.microsoft.Parameters;
import net.sf.okapi.lib.translation.BaseConnector;
import net.sf.okapi.lib.translation.QueryResult;
import net.sf.okapi.lib.translation.QueryUtil;

@UsingParameters(value=Parameters.class)
public class MicrosoftMTConnector
extends BaseConnector {
    private QueryUtil util = new QueryUtil();
    Parameters params = new Parameters();

    @Override
    public void close() {
    }

    @Override
    public String getName() {
        return "Micosoft-MT";
    }

    @Override
    public String getSettingsDisplay() {
        return "Service: http://api.microsofttranslator.com/V2/Http.svc";
    }

    @Override
    public void open() {
    }

    @Override
    public int query(String plainText) {
        return this.query(new TextFragment(plainText));
    }

    private static String fromInputStreamToString(InputStream stream, String encoding) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(stream, encoding));
        StringBuilder sb = new StringBuilder();
        String line = null;
        while ((line = br.readLine()) != null) {
            sb.append(line + "\n");
        }
        br.close();
        return sb.toString();
    }

    @Override
    public int query(TextFragment frag) {
        this.current = -1;
        this.result = null;
        if (!frag.hasText(false)) {
            return 0;
        }
        try {
            String qtext = this.util.separateCodesFromText(frag);
            URL url = new URL(String.format("http://api.microsofttranslator.com/v2/Http.svc/Translate?appId=%s&text=%s&from=%s&to=%s", this.params.getAppId(), URLEncoder.encode(qtext, "UTF-8"), this.srcCode, this.trgCode));
            URLConnection conn = url.openConnection();
            String resp = MicrosoftMTConnector.fromInputStreamToString(conn.getInputStream(), "UTF-8");
            int n1 = resp.indexOf("<string");
            if (n1 == -1) {
                return 0;
            }
            if ((n1 = resp.indexOf(62, n1)) == -1) {
                return 0;
            }
            int n2 = resp.indexOf("</string>", n1 + 1);
            if (n2 == -1) {
                return 0;
            }
            String res = resp.substring(n1 + 1, n2);
            this.result = new QueryResult();
            this.result.weight = this.getWeight();
            this.result.source = frag;
            this.result.target = this.util.createNewFragmentWithCodes(this.util.fromPlainTextHTML(res));
            this.result.score = 95;
            this.result.origin = this.getName();
            this.result.matchType = MatchType.MT;
            this.current = 0;
        }
        catch (Throwable e) {
            throw new RuntimeException("Error querying the MT server." + e.getMessage(), e);
        }
        return this.current == 0 ? 1 : 0;
    }

    @Override
    protected String toInternalCode(LocaleId locale) {
        String code = locale.toBCP47();
        code = code.equals("zh-tw") || code.equals("zh-hant") || code.equals("zh-cht") ? "zh-CHT" : (code.startsWith("zh") ? "zh-CHS" : locale.getLanguage());
        return code;
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }
}

