/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.translatetoolkit;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;

public class Parameters
extends BaseParameters
implements IEditorDescriptionProvider {
    private String host;
    private int port;

    public Parameters() {
        this.reset();
        this.toString();
    }

    public Parameters(String initialData) {
        this.fromString(initialData);
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.host = this.buffer.getString("host", this.host);
        this.port = this.buffer.getInteger("port", this.port);
    }

    @Override
    public void reset() {
        this.host = "localhost";
        this.port = 8080;
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setString("host", this.host);
        this.buffer.setInteger("port", this.port);
        return this.buffer.toString();
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add("host", "Host", "The host name of the TM server (e.g. localhost)");
        desc.add("port", "Port", "The port number of the TM server (e.g. 8080)");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("Translation Toolkit TM Connector Settings");
        desc.addTextInputPart(paramsDesc.get("host"));
        desc.addTextInputPart(paramsDesc.get("port"));
        return desc;
    }
}

