/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.util.List;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.filters.idml.IDMLFilter;
import net.sf.okapi.filters.idml.IDMLSkeleton;
import net.sf.okapi.filters.idml.NodeReference;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class IDMLContext {
    private boolean inScope;
    private Node topNode;
    private Node scopeNode;
    private TextFragment tf;
    private int status;
    private boolean isReferent;
    private IDMLSkeleton skel;
    private String tuId;
    private static final boolean phOnly = true;

    public IDMLContext(boolean isReferent, Node topNode) {
        this.isReferent = isReferent;
        this.topNode = topNode;
    }

    public void enterScope(Node scopeNode, String tuId) {
        this.scopeNode = scopeNode;
        this.tuId = tuId;
        this.tf = new TextFragment();
        this.status = 0;
        this.inScope = true;
    }

    public Node getTopNode() {
        return this.topNode;
    }

    public Node getScopeNode() {
        return this.scopeNode;
    }

    public void leaveScope() {
        this.inScope = false;
        this.skel = null;
    }

    public boolean inScope() {
        return this.inScope;
    }

    public boolean addToQueue(List<Event> queue) {
        if (this.tf.isEmpty()) {
            return false;
        }
        TextUnit tu = new TextUnit(this.tuId, null, this.isReferent);
        tu.setSourceContent(this.tf);
        if (this.skel == null) {
            this.skel = new IDMLSkeleton(this.topNode, this.scopeNode);
        }
        tu.setSkeleton(this.skel);
        queue.add(new Event(EventType.TEXT_UNIT, tu));
        return true;
    }

    public void addContent(Element elem) {
        this.tf.append(TextFragment.TagType.PLACEHOLDER, "code", this.buildStartTag(elem));
        IDMLFilter.processContent(elem, this.tf);
        this.tf.append(TextFragment.TagType.PLACEHOLDER, "code", this.buildEndTag(elem));
        ++this.status;
    }

    public void addCode(Code code) {
        this.tf.append(code);
    }

    public void addCode(Node node) {
        if (node.getNodeType() == 3) {
            String text = node.getNodeValue();
            for (int i = 0; i < text.length(); ++i) {
                if (Character.isWhitespace(text.charAt(i))) continue;
                this.tf.append(TextFragment.TagType.PLACEHOLDER, "text", text);
                return;
            }
        } else if (node.getNodeType() == 4) {
            this.tf.append(TextFragment.TagType.PLACEHOLDER, "cdata", "<![CDATA[" + node.getNodeValue() + "]]>");
        }
    }

    public void addReference(String key, NodeReference ref) {
        if (this.skel == null) {
            this.skel = new IDMLSkeleton(this.topNode, this.scopeNode);
        }
        this.skel.addReferenceNode(key, ref);
    }

    public void addStartTag(Element elem) {
        this.tf.append(TextFragment.TagType.PLACEHOLDER, elem.getNodeName(), this.buildStartTag(elem));
    }

    public void addEndTag(Element elem) {
        if (elem.hasChildNodes()) {
            this.tf.append(TextFragment.TagType.PLACEHOLDER, elem.getNodeName(), this.buildEndTag(elem));
        }
    }

    public String buildStartTag(Element elem) {
        StringBuilder sb = new StringBuilder("<" + elem.getNodeName());
        NamedNodeMap attrNames = elem.getAttributes();
        for (int i = 0; i < attrNames.getLength(); ++i) {
            Attr attr = (Attr)attrNames.item(i);
            sb.append(" " + attr.getName() + "=\"");
            sb.append(Util.escapeToXML(attr.getValue(), 3, false, null));
            sb.append("\"");
        }
        if (elem.hasChildNodes()) {
            sb.append(">");
        } else {
            sb.append("/>");
        }
        return sb.toString();
    }

    public String buildEndTag(Element elem) {
        return "</" + elem.getNodeName() + ">";
    }
}

