/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.TextFragment;

public class Simplifier {
    protected static final int MAX = 10;
    private LinkedList<CodeNode> codeNodesList;
    private String codedText;

    private void prepare(String pCodedText, List<Code> pCodes) {
        this.codeNodesList = new LinkedList();
        this.codedText = pCodedText;
        Stack<StartCodeNode> codeNodesStack = new Stack<StartCodeNode>();
        for (int i = 0; i < this.codedText.length(); ++i) {
            CodeNode cn;
            char c = this.codedText.charAt(i);
            if (c == '\ue101') {
                cn = new StartCodeNode(i, TextFragment.toIndex(this.codedText.charAt(i + 1)), this.codedText.charAt(i + 1), pCodes.get(TextFragment.toIndex(this.codedText.charAt(i + 1))));
                this.codeNodesList.add(cn);
                codeNodesStack.push((StartCodeNode)cn);
                continue;
            }
            if (c == '\ue102') {
                cn = new EndCodeNode(i, TextFragment.toIndex(this.codedText.charAt(i + 1)), this.codedText.charAt(i + 1), pCodes.get(TextFragment.toIndex(this.codedText.charAt(i + 1))));
                this.codeNodesList.add(cn);
                ((StartCodeNode)codeNodesStack.pop()).endNode = cn;
                continue;
            }
            if (c != '\ue103') continue;
            cn = new PhCodeNode(i, TextFragment.toIndex(this.codedText.charAt(i + 1)), this.codedText.charAt(i + 1), pCodes.get(TextFragment.toIndex(this.codedText.charAt(i + 1))));
            this.codeNodesList.add(cn);
        }
        this.updateAdjacentFlags();
    }

    private void updateAdjacentFlags() {
        for (int i = 0; i < this.codeNodesList.size(); ++i) {
            CodeNode peekCn;
            CodeNode cn = this.codeNodesList.get(i);
            if (i + 1 >= this.codeNodesList.size() || !this.adjacentMarkers(cn, peekCn = this.codeNodesList.get(i + 1))) continue;
            cn.adjacentNext = true;
            peekCn.adjacentPrev = true;
        }
    }

    public String[] simplifyAll(TextFragment tf, int maxIterations, boolean removeLeadingTrailingCodes) {
        int isolatedMerges = 0;
        int openCloseMerges = 0;
        int emptyOpenCloseMerges = 0;
        int iteration = 0;
        do {
            ++iteration;
            this.prepare(tf.getCodedText(), tf.getCodes());
            isolatedMerges = this.simplifyIsolated();
            tf.setCodedText(this.getCodedText(), this.getCodes());
            this.prepare(tf.getCodedText(), tf.getCodes());
            openCloseMerges = this.simplifyOpeningClosing();
            tf.setCodedText(this.getCodedText(), this.getCodes());
            this.prepare(tf.getCodedText(), tf.getCodes());
            emptyOpenCloseMerges = this.simplifyEmptyOpeningClosing();
            tf.setCodedText(this.getCodedText(), this.getCodes());
        } while (iteration < maxIterations && isolatedMerges + openCloseMerges + emptyOpenCloseMerges > 0);
        if (removeLeadingTrailingCodes) {
            return this.removeLeadingTrailingCodes(tf);
        }
        return null;
    }

    private String[] removeLeadingTrailingCodes(TextFragment tf) {
        Code code;
        if (tf.isEmpty()) {
            return null;
        }
        String ctext = tf.getCodedText();
        String[] res = new String[2];
        switch (ctext.charAt(0)) {
            case '\ue103': {
                code = tf.getCode(TextFragment.toIndex(ctext.charAt(1)));
                res[0] = code.getOuterData();
                tf.remove(0, 2);
            }
        }
        ctext = tf.getCodedText();
        int last = ctext.length() - 2;
        if (last > 0) {
            switch (ctext.charAt(last)) {
                case '\ue103': {
                    code = tf.getCode(TextFragment.toIndex(ctext.charAt(last + 1)));
                    res[1] = code.getOuterData();
                    tf.remove(last, last + 2);
                }
            }
        }
        return res;
    }

    public String[] simplifyAll(TextFragment tf, boolean removeLeadingTrailingCodes) {
        return this.simplifyAll(tf, 10, removeLeadingTrailingCodes);
    }

    public void simplifyIsolated(TextFragment tf) {
        this.prepare(tf.getCodedText(), tf.getCodes());
        this.simplifyIsolated();
        tf.setCodedText(this.getCodedText(), this.getCodes());
    }

    private int simplifyIsolated() {
        int merges = 0;
        for (int i = 0; i < this.codeNodesList.size(); ++i) {
            CodeNode cn = this.codeNodesList.get(i);
            if (i + 1 >= this.codeNodesList.size()) continue;
            CodeNode peekCn = this.codeNodesList.get(i + 1);
            if (!cn.adjacentNext || !peekCn.adjacentPrev || cn.code.getTagType() != TextFragment.TagType.PLACEHOLDER && peekCn.code.getTagType() != TextFragment.TagType.PLACEHOLDER) continue;
            this.mergeNodes(cn, peekCn);
            ++merges;
            --i;
        }
        this.renumberMarkerIndexes();
        this.updateCodeIds();
        return merges++;
    }

    public void simplifyOpeningClosing(TextFragment tf) {
        this.prepare(tf.getCodedText(), tf.getCodes());
        this.simplifyOpeningClosing();
        tf.setCodedText(this.getCodedText(), this.getCodes());
    }

    private int simplifyOpeningClosing() {
        int merges = 0;
        for (int i = 0; i < this.codeNodesList.size(); ++i) {
            CodeNode cn = this.codeNodesList.get(i);
            if (i + 1 >= this.codeNodesList.size()) continue;
            CodeNode peekCn = this.codeNodesList.get(i + 1);
            if (!cn.adjacentNext || !peekCn.adjacentPrev || cn.code.getTagType() != TextFragment.TagType.OPENING || peekCn.code.getTagType() != TextFragment.TagType.OPENING) continue;
            StartCodeNode scn1 = (StartCodeNode)cn;
            StartCodeNode scn2 = (StartCodeNode)peekCn;
            EndCodeNode ecn2 = scn2.endNode;
            EndCodeNode ecn1 = scn1.endNode;
            if (!this.adjacentMarkers(ecn2, ecn1)) continue;
            this.mergeEndNodes(ecn2, ecn1);
            this.mergeNodes(scn1, scn2);
            ++merges;
            --i;
        }
        this.renumberMarkerIndexes();
        this.updateCodeIds();
        return merges;
    }

    public void simplifyEmptyOpeningClosing(TextFragment tf) {
        this.prepare(tf.getCodedText(), tf.getCodes());
        this.simplifyEmptyOpeningClosing();
        tf.setCodedText(this.getCodedText(), this.getCodes());
    }

    private int simplifyEmptyOpeningClosing() {
        int merges = 0;
        for (int i = 0; i < this.codeNodesList.size(); ++i) {
            CodeNode cn = this.codeNodesList.get(i);
            if (i + 1 >= this.codeNodesList.size()) continue;
            CodeNode peekCn = this.codeNodesList.get(i + 1);
            if (!cn.adjacentNext || !peekCn.adjacentPrev || cn.code.getTagType() != TextFragment.TagType.OPENING || peekCn.code.getTagType() != TextFragment.TagType.CLOSING || cn.intIndex != peekCn.intIndex - 1) continue;
            StartCodeNode scn = (StartCodeNode)cn;
            EndCodeNode ecn = (EndCodeNode)peekCn;
            this.mergeEmptyNodes(scn, ecn);
            ++merges;
            --i;
        }
        this.renumberMarkerIndexes();
        this.updateCodeIds();
        return merges++;
    }

    private void renumberMarkerIndexes() {
        int i = 0;
        while (i < this.codeNodesList.size()) {
            CodeNode cn = this.codeNodesList.get(i);
            char newCharIndex = TextFragment.toChar(i);
            String newMarker = new String(cn.markerFlag + newCharIndex);
            this.codedText = this.codedText.replace(cn.marker, newMarker);
            cn.intIndex = i++;
            cn.charIndex = newCharIndex;
            cn.marker = newMarker;
        }
    }

    private List<Code> getCodes() {
        ArrayList<Code> codes = new ArrayList<Code>();
        for (CodeNode cn : this.codeNodesList) {
            codes.add(cn.code);
        }
        return codes;
    }

    private String getCodedText() {
        return this.codedText;
    }

    private void updateCodeIds() {
        for (int i = 0; i < this.codeNodesList.size(); ++i) {
            CodeNode cn = this.codeNodesList.get(i);
            if (cn.code.getTagType() == TextFragment.TagType.OPENING) {
                StartCodeNode scn = (StartCodeNode)cn;
                scn.code.setId(i + 1);
                scn.endNode.code.setId(i + 1);
                continue;
            }
            if (cn.code.getTagType() != TextFragment.TagType.PLACEHOLDER) continue;
            cn.code.setId(i + 1);
        }
    }

    private boolean adjacentMarkers(CodeNode node1, CodeNode node2) {
        return node1.offset + 2 == node2.offset;
    }

    private void mergeNodes(CodeNode node1, CodeNode node2) {
        this.codedText = this.codedText.replace(node1.marker + node2.marker, node1.marker);
        node1.code.setData(node1.code.getData() + node2.code.getData());
        this.codeNodesList.remove(node2);
    }

    private void mergeEndNodes(CodeNode node1, CodeNode node2) {
        this.codedText = this.codedText.replace(node1.marker + node2.marker, node2.marker);
        node2.code.setData(node1.code.getData() + node2.code.getData());
        this.codeNodesList.remove(node1);
    }

    private void mergeEmptyNodes(CodeNode node1, CodeNode node2) {
        this.codedText = this.codedText.replace(node1.marker + node2.marker, "\ue103" + node1.charIndex);
        node1.code.setData(node1.code.getData() + node2.code.getData());
        node1.code.setTagType(TextFragment.TagType.PLACEHOLDER);
        PhCodeNode pcn = new PhCodeNode(node1.offset, node1.intIndex, node1.charIndex, node1.code);
        int i = this.codeNodesList.indexOf(node2);
        this.codeNodesList.add(i, pcn);
        this.codeNodesList.remove(node1);
        this.codeNodesList.remove(node2);
    }

    class PhCodeNode
    extends CodeNode {
        PhCodeNode(int offset, int intIndex, char charIndex, Code code) {
            super(offset, intIndex, charIndex, code);
            this.marker = new String("\ue103" + charIndex);
            this.markerFlag = new String("\ue102");
        }
    }

    class EndCodeNode
    extends CodeNode {
        StartCodeNode beginNode;

        EndCodeNode(int offset, int intIndex, char charIndex, Code code) {
            super(offset, intIndex, charIndex, code);
            this.marker = new String("\ue102" + charIndex);
            this.markerFlag = new String("\ue102");
        }
    }

    class StartCodeNode
    extends CodeNode {
        EndCodeNode endNode;

        StartCodeNode(int offset, int intIndex, char charIndex, Code code) {
            super(offset, intIndex, charIndex, code);
            this.marker = new String("\ue101" + charIndex);
            this.markerFlag = new String("\ue101");
        }
    }

    class CodeNode {
        int offset;
        int intIndex;
        char charIndex;
        Code code;
        String marker;
        String markerFlag;
        boolean adjacentPrev = false;
        boolean adjacentNext = false;

        public CodeNode(int offset, int intIndex, char charIndex, Code code) {
            this.offset = offset;
            this.intIndex = intIndex;
            this.charIndex = charIndex;
            this.code = code;
        }
    }
}

