/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.LinkedList;
import net.sf.okapi.common.resource.InvalidContentException;
import net.sf.okapi.filters.openxml.TagRange;

public class FixXML {
    private BufferedReader in;
    private BufferedWriter out;
    private InputStream inn;
    private LinkedList<TagRange> llTigger;
    private static final int STARTTAG = 1;
    private static final int STANDALONETAG = 2;
    private static final int ENDTAG = 3;
    private static final int CONFUSEDTAG = 4;
    private String sBadFileIn;
    private String sGoodFileOut;
    private String sCurrentBuffer = "";

    public FixXML(String sBadFileIn, String sGoodFileOut) {
        this.sBadFileIn = sBadFileIn;
        this.sGoodFileOut = sGoodFileOut;
        this.inn = null;
    }

    public FixXML(InputStream inn, String sGoodFileOut) {
        this.sBadFileIn = "Unknown Filename";
        this.sGoodFileOut = sGoodFileOut;
        this.inn = inn;
    }

    public boolean DoFix() {
        if (this.inn == null) {
            this.in = this.openAlmostXML(this.sBadFileIn);
        } else {
            try {
                this.in = new BufferedReader(new InputStreamReader(this.inn));
            }
            catch (Exception e) {
                throw new InvalidContentException("Input file cannot be Buffered");
            }
        }
        this.out = this.openOutputXML(this.sGoodFileOut);
        if (this.in != null && this.out != null) {
            this.fixit();
            int iBuffSize = this.sizit();
            this.writit(iBuffSize);
            try {
                this.in.close();
                this.out.close();
            }
            catch (IOException e) {
                throw new InvalidContentException("Can't read/write temporary file with error " + e.getMessage());
            }
        }
        return true;
    }

    private BufferedReader openAlmostXML(String filename) {
        BufferedReader in = null;
        File theFile = new File(filename);
        boolean rslt = true;
        if (!theFile.exists()) {
            throw new InvalidContentException(filename + " could not be Found");
        }
        if (!theFile.canRead()) {
            throw new InvalidContentException(filename + " cannot be Read");
        }
        try {
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(theFile), "UTF-8"));
        }
        catch (IOException e) {
            throw new InvalidContentException(filename + " cannot be Buffered");
        }
        return rslt ? in : null;
    }

    private BufferedWriter openOutputXML(String filename) {
        BufferedWriter out;
        File outFile;
        try {
            outFile = new File(filename);
        }
        catch (Throwable e) {
            throw new InvalidContentException("Report File " + filename + " has error " + e.getMessage());
        }
        if (outFile.exists() && !outFile.canWrite()) {
            throw new InvalidContentException("Report File " + filename + " cannot be Written");
        }
        try {
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), "UTF-8"));
        }
        catch (IOException e) {
            throw new InvalidContentException(filename + " cannot be written because it is open");
        }
        catch (Throwable e) {
            throw new InvalidContentException(filename + " has error " + e.getMessage());
        }
        return out;
    }

    private void fixit() {
        boolean bChangeToStandalone;
        int iNdex2;
        TagRange trBeg;
        long lEnd = 0L;
        int iLastStartTag = -1;
        this.llTigger = new LinkedList();
        LinkedList<Integer> llTagStack = new LinkedList<Integer>();
        while ((trBeg = this.gitTag(lEnd)) != null) {
            lEnd = trBeg.getLEnd();
            this.llTigger.addLast(trBeg);
        }
        int iTot = this.llTigger.size();
        block5: for (int iNdex = 0; iNdex < iTot; ++iNdex) {
            TagRange trEnd = this.llTigger.get(iNdex);
            int iTagType = trEnd.getITagType();
            switch (iTagType) {
                case 1: 
                case 2: 
                case 4: {
                    llTagStack.add(new Integer(iNdex));
                    if (iTagType != 1) continue block5;
                    iLastStartTag = iNdex;
                    continue block5;
                }
                case 3: {
                    if (iLastStartTag > 0) {
                        for (iNdex2 = iNdex - 1; iNdex2 >= iLastStartTag; --iNdex2) {
                            llTagStack.remove(iNdex2);
                        }
                        --iLastStartTag;
                        while (iLastStartTag >= 0) {
                            iNdex2 = (Integer)llTagStack.get(iLastStartTag);
                            trBeg = this.llTigger.get(iNdex2);
                            iTagType = trBeg.getITagType();
                            bChangeToStandalone = trBeg.getBChangeToStandalone();
                            if (iTagType == 1 && !bChangeToStandalone) continue block5;
                            --iLastStartTag;
                        }
                        continue block5;
                    }
                    this.llTigger.get(iNdex).setBChangeToStandalone(true);
                    llTagStack.add(new Integer(iNdex));
                }
            }
        }
        while (iLastStartTag > -1) {
            iNdex2 = (Integer)llTagStack.get(iLastStartTag);
            trBeg = this.llTigger.get(iNdex2);
            bChangeToStandalone = trBeg.getBChangeToStandalone();
            --iLastStartTag;
        }
    }

    public int sizit() {
        int iSiz;
        long lMax = 0L;
        int iTot = this.llTigger.size();
        for (int iNdex = 0; iNdex < iTot; ++iNdex) {
            TagRange tr = this.llTigger.get(iNdex);
            long lCur = tr.getLBegin() - tr.getLEnd();
            if (lCur <= lMax) continue;
            lMax = lCur;
        }
        try {
            iSiz = (int)lMax;
        }
        catch (Exception e) {
            throw new InvalidContentException("Input File is too long");
        }
        return iSiz;
    }

    public void writit(int sbSiz) {
        char[] cbBuff = new char[sbSiz + 1];
        int iTot = this.llTigger.size();
        for (int iNdex = 0; iNdex < iTot; ++iNdex) {
            long lEnd;
            TagRange tr = this.llTigger.get(iNdex);
            long lBeg = tr.getLBegin();
            int iLen = (int)(lBeg - (lEnd = tr.getLEnd()));
            if (iLen <= 0) continue;
            try {
                this.in.read(cbBuff, (int)lBeg, iLen);
                boolean bAddFakeTagName = tr.getBAddFakeTagName();
                boolean bChangeToStandalone = tr.getBChangeToStandalone();
                boolean bAddBeginningBracket = tr.getBAddBeginningBracket();
                boolean bAddEndBracket = tr.getBAddEndBracket();
                boolean bGotEndBracket = false;
                int iCnt = 0;
                this.out.append('<');
                if (cbBuff[0] == '<') {
                    ++iCnt;
                }
                if (bAddFakeTagName) {
                    this.out.append("FAKE ");
                }
                if (cbBuff[1] == '/' && bChangeToStandalone) {
                    ++iCnt;
                }
                while (iCnt < iLen) {
                    char cOal = cbBuff[iCnt];
                    if (cOal == '/' && iCnt < iLen - 1 && cbBuff[iCnt + 1] == '>') {
                        this.out.append("/>");
                        ++iCnt;
                        bGotEndBracket = true;
                    } else if (cOal == '>' && bChangeToStandalone) {
                        this.out.append("/>");
                        ++iCnt;
                        bGotEndBracket = true;
                    } else if (bAddEndBracket && !bGotEndBracket && iCnt == iLen - 1 && cOal != '>') {
                        this.out.append(cOal);
                        this.out.append('>');
                    } else if (cOal == '>') {
                        this.out.append(cOal);
                        bGotEndBracket = true;
                    } else {
                        this.out.append(cOal);
                    }
                    ++iCnt;
                }
                continue;
            }
            catch (IOException e) {
                throw new InvalidContentException("Error tidying input file " + this.sBadFileIn);
            }
        }
    }

    public TagRange gitTag(long lOffset) {
        String s;
        String tag = "";
        long lRealOffset = lOffset;
        TagRange tr = null;
        boolean bGotEndBracket = false;
        boolean bGotTag = false;
        boolean bFirstChar = true;
        boolean bInQuote = false;
        boolean bAddBeginningBracket = true;
        boolean bAddFakeTagName = false;
        boolean bAddEndBracket = false;
        String ss = "<";
        int iTagType = 1;
        while ((s = this.gitNextChar()) != null) {
            char c = s.charAt(0);
            char c2 = s.length() > 1 ? s.charAt(1) : (char)'\u0000';
            if (bFirstChar) {
                bFirstChar = false;
                if (c == '/') {
                    iTagType = 3;
                    ss = ss + c;
                    continue;
                }
            }
            if (c == '\"') {
                bInQuote = !bInQuote;
                ss = ss + c;
                continue;
            }
            if (bGotEndBracket) {
                if (c == '<') break;
                if (c == '>') {
                    tr = new TagRange(tag, lRealOffset, lRealOffset + (long)ss.length(), iTagType, bAddBeginningBracket, bAddFakeTagName, bAddEndBracket);
                    this.llTigger.addLast(tr);
                    lRealOffset += (long)ss.length();
                    ss = "";
                    iTagType = 2;
                    tag = "FAKE";
                    bAddFakeTagName = true;
                    bAddBeginningBracket = true;
                } else {
                    ss = ss + c;
                    continue;
                }
            }
            if (bGotTag) {
                if (c == '>' && !bInQuote) {
                    bGotEndBracket = true;
                } else if (c == '<' && !bInQuote) {
                    bAddEndBracket = true;
                    break;
                }
                ss = ss + c;
                continue;
            }
            if (c == '/' && c2 == '>' && !bInQuote) {
                if (tag.length() == 0) {
                    bAddFakeTagName = true;
                    tag = "FAKE";
                }
                iTagType = iTagType == 1 ? 2 : 4;
                ss = ss + "/>";
                continue;
            }
            if (c == '>' && !bInQuote) {
                if (tag.length() == 0) {
                    tag = "FAKE";
                    bAddFakeTagName = true;
                } else {
                    bGotEndBracket = true;
                    bGotTag = true;
                    continue;
                }
            }
            if (c == ' ' || c == '\n' || c == '\f' || c == '\r') {
                if (tag.length() == 0) {
                    tag = "FAKE";
                    bAddFakeTagName = true;
                }
                bGotTag = true;
                ss = ss + c;
                continue;
            }
            tag = tag + c;
        }
        tr = new TagRange(tag, lRealOffset, lRealOffset + (long)ss.length(), iTagType, bAddBeginningBracket, bAddFakeTagName, bAddEndBracket);
        return tr;
    }

    public String gitNextChar() {
        String ss = null;
        while (this.sCurrentBuffer.length() == 0) {
            try {
                String s = this.in.readLine();
                if (s == null) {
                    return null;
                }
                this.sCurrentBuffer = s;
            }
            catch (EOFException e) {
                return null;
            }
            catch (IOException e) {
                throw new InvalidContentException("Can't read stop word file " + this.sBadFileIn);
            }
        }
        ss = this.sCurrentBuffer.substring(0, 1);
        this.sCurrentBuffer = this.sCurrentBuffer.substring(1);
        return ss;
    }
}

