/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.properties;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.filters.InlineCodeFinder;
import net.sf.okapi.common.filters.LocalizationDirectives;

public class Parameters
extends BaseParameters {
    public boolean useCodeFinder;
    public InlineCodeFinder codeFinder;
    public boolean escapeExtendedChars;
    public boolean useKeyCondition;
    public boolean extractOnlyMatchingKey;
    public String keyCondition;
    public boolean extraComments;
    public boolean commentsAreNotes;
    public LocalizationDirectives locDir = new LocalizationDirectives();
    public boolean convertLFandTab;

    public Parameters() {
        this.codeFinder = new InlineCodeFinder();
        this.reset();
        this.toString();
    }

    @Override
    public void reset() {
        this.locDir.reset();
        this.escapeExtendedChars = true;
        this.convertLFandTab = true;
        this.useCodeFinder = true;
        this.codeFinder.reset();
        this.codeFinder.setSample("%s, %d, {1}, \\n, \\r, \\t, etc.");
        this.codeFinder.setUseAllRulesWhenTesting(true);
        this.codeFinder.addRule("%(([-0+#]?)[-0+#]?)((\\d\\$)?)(([\\d\\*]*)(\\.[\\d\\*]*)?)[dioxXucsfeEgGpn]");
        this.codeFinder.addRule("(\\\\r\\\\n)|\\\\a|\\\\b|\\\\f|\\\\n|\\\\r|\\\\t|\\\\v");
        this.codeFinder.addRule("\\{\\d.*?\\}");
        this.useKeyCondition = false;
        this.extractOnlyMatchingKey = true;
        this.keyCondition = ".*text.*";
        this.extraComments = false;
        this.commentsAreNotes = true;
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setBoolean("convertLFandTab", this.convertLFandTab);
        this.buffer.setBoolean("useLD", this.locDir.useLD());
        this.buffer.setBoolean("localizeOutside", this.locDir.localizeOutside());
        this.buffer.setBoolean("useKeyCondition", this.useKeyCondition);
        this.buffer.setBoolean("extractOnlyMatchingKey", this.extractOnlyMatchingKey);
        this.buffer.setString("keyCondition", this.keyCondition);
        this.buffer.setBoolean("extraComments", this.extraComments);
        this.buffer.setBoolean("commentsAreNotes", this.commentsAreNotes);
        this.buffer.setBoolean("escapeExtendedChars", this.escapeExtendedChars);
        this.buffer.setBoolean("useCodeFinder", this.useCodeFinder);
        this.buffer.setGroup("codeFinderRules", this.codeFinder.toString());
        return this.buffer.toString();
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.convertLFandTab = this.buffer.getBoolean("convertLFandTab", this.convertLFandTab);
        boolean tmpBool1 = this.buffer.getBoolean("useLD", this.locDir.useLD());
        boolean tmpBool2 = this.buffer.getBoolean("localizeOutside", this.locDir.localizeOutside());
        this.locDir.setOptions(tmpBool1, tmpBool2);
        this.useKeyCondition = this.buffer.getBoolean("useKeyCondition", this.useKeyCondition);
        this.extractOnlyMatchingKey = this.buffer.getBoolean("extractOnlyMatchingKey", this.extractOnlyMatchingKey);
        this.keyCondition = this.buffer.getString("keyCondition", this.keyCondition);
        this.extraComments = this.buffer.getBoolean("extraComments", this.extraComments);
        this.commentsAreNotes = this.buffer.getBoolean("commentsAreNotes", this.commentsAreNotes);
        this.escapeExtendedChars = this.buffer.getBoolean("escapeExtendedChars", this.escapeExtendedChars);
        this.useCodeFinder = this.buffer.getBoolean("useCodeFinder", this.useCodeFinder);
        this.codeFinder.fromString(this.buffer.getGroup("codeFinderRules", ""));
    }
}

