/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.regex;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import net.sf.okapi.common.BOMNewlineEncodingDetector;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.exceptions.OkapiIllegalFilterOperationException;
import net.sf.okapi.common.exceptions.OkapiUnsupportedEncodingException;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filterwriter.GenericFilterWriter;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartGroup;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.GenericSkeletonWriter;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.filters.regex.Parameters;
import net.sf.okapi.filters.regex.Rule;

@UsingParameters(value=Parameters.class)
public class RegexFilter
implements IFilter {
    private static String MIMETYPE = "text/x-regex";
    private boolean canceled;
    private Parameters params = new Parameters();
    private String encoding;
    private String inputText;
    private Stack<StartGroup> groupStack;
    private int tuId;
    private IdGenerator otherId;
    private String docName;
    private TextUnit tuRes;
    private LinkedList<Event> queue;
    private int startSearch;
    private int startSkl;
    private int parseState = 0;
    private LocaleId trgLang;
    private String lineBreak;
    private boolean hasUTF8BOM;
    private EncoderManager encoderManager;

    @Override
    public void cancel() {
        this.canceled = true;
    }

    @Override
    public void close() {
        this.inputText = null;
        this.parseState = 0;
    }

    @Override
    public String getName() {
        return "okf_regex";
    }

    @Override
    public String getDisplayName() {
        return "Regex Filter";
    }

    @Override
    public String getMimeType() {
        return MIMETYPE;
    }

    @Override
    public List<FilterConfiguration> getConfigurations() {
        ArrayList<FilterConfiguration> list = new ArrayList<FilterConfiguration>();
        list.add(new FilterConfiguration(this.getName(), MIMETYPE, this.getClass().getName(), "Regex Default", "Default Regex configuration."));
        list.add(new FilterConfiguration(this.getName() + "-srt", MIMETYPE, this.getClass().getName(), "SRT Sub-Titles", "Configuration for SRT (Sub-Rip Text) sub-titles files.", "srt.fprm"));
        list.add(new FilterConfiguration(this.getName() + "-textLine", MIMETYPE, this.getClass().getName(), "Text (Line=Paragraph)", "Configuration for text files where each line is a text unit", "textLine.fprm"));
        list.add(new FilterConfiguration(this.getName() + "-textBlock", MIMETYPE, this.getClass().getName(), "Text (Block=Paragraph)", "Configuration for text files where text units are separated by 2 or more line-breaks.", "textBlock.fprm"));
        return list;
    }

    @Override
    public EncoderManager getEncoderManager() {
        if (this.encoderManager == null) {
            this.encoderManager = new EncoderManager();
            this.encoderManager.setAllKnownMappings();
        }
        return this.encoderManager;
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public boolean hasNext() {
        return this.parseState > 0;
    }

    @Override
    public Event next() {
        block7: {
            Rule bestRule;
            MatchResult result;
            block8: {
                int maxPos;
                if (this.canceled) {
                    this.parseState = 0;
                    this.queue.clear();
                    this.queue.add(new Event(EventType.CANCELED));
                }
                if (this.queue.size() > 0) {
                    return this.nextEvent();
                }
                int bestPosition = maxPos = this.inputText.length() + 99;
                result = null;
                do {
                    bestRule = null;
                    for (Rule rule : this.params.getRules()) {
                        Matcher m = rule.pattern.matcher(this.inputText);
                        if (!m.find(this.startSearch) || m.start() >= bestPosition) continue;
                        bestPosition = m.start();
                        bestRule = rule;
                    }
                    if (bestRule == null) break block7;
                    Matcher m = bestRule.pattern.matcher(this.inputText);
                    if (m.find(bestPosition)) {
                        result = m.toMatchResult();
                    }
                    if (result.start() != result.end()) break block8;
                    this.startSearch = result.end() + 1;
                    bestPosition = maxPos;
                } while (this.startSearch < this.inputText.length());
                --this.startSearch;
                break block7;
            }
            if (result.start() != this.inputText.length()) {
                return this.processMatch(bestRule, result);
            }
        }
        if (this.startSearch < this.inputText.length()) {
            this.addSkeletonToQueue(this.inputText.substring(this.startSkl, this.inputText.length()), true);
        }
        this.closeGroups();
        Ending ending = new Ending(this.otherId.createId());
        this.queue.add(new Event(EventType.END_DOCUMENT, ending));
        return this.nextEvent();
    }

    private void closeGroups() {
        if (this.groupStack.size() > 0) {
            Ending ending = new Ending(this.otherId.createId());
            this.queue.add(new Event(EventType.END_GROUP, ending));
            this.groupStack.pop();
        }
    }

    @Override
    public void open(RawDocument input) {
        this.open(input, true);
    }

    @Override
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    public ISkeletonWriter createSkeletonWriter() {
        return new GenericSkeletonWriter();
    }

    @Override
    public IFilterWriter createFilterWriter() {
        return new GenericFilterWriter(this.createSkeletonWriter(), this.getEncoderManager());
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        this.close();
        BOMNewlineEncodingDetector detector = new BOMNewlineEncodingDetector(input.getStream(), input.getEncoding());
        detector.detectAndRemoveBom();
        input.setEncoding(detector.getEncoding());
        this.encoding = input.getEncoding();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(detector.getInputStream(), this.encoding));
        }
        catch (UnsupportedEncodingException e) {
            throw new OkapiUnsupportedEncodingException(String.format("The encoding '%s' is not supported.", this.encoding), e);
        }
        this.trgLang = input.getTargetLocale();
        this.hasUTF8BOM = detector.hasUtf8Bom();
        this.lineBreak = detector.getNewlineType().toString();
        if (input.getInputURI() != null) {
            this.docName = input.getInputURI().getPath();
        }
        StringBuilder tmp = new StringBuilder();
        char[] buf = new char[2048];
        int count = 0;
        try {
            while ((count = reader.read(buf)) != -1) {
                tmp.append(buf, 0, count);
            }
        }
        catch (IOException e) {
            throw new OkapiIOException("Error reading the input.", e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    throw new OkapiIOException("Error closing the input.", e);
                }
            }
        }
        this.inputText = tmp.toString().replace(this.lineBreak, "\n");
        this.parseState = 1;
        this.canceled = false;
        this.groupStack = new Stack();
        this.startSearch = 0;
        this.startSkl = 0;
        this.tuId = 0;
        this.otherId = new IdGenerator(null, "o");
        this.params.compileRules();
        this.queue = new LinkedList();
        StartDocument startDoc = new StartDocument(this.otherId.createId());
        startDoc.setName(this.docName);
        startDoc.setEncoding(this.encoding, this.hasUTF8BOM);
        startDoc.setLocale(input.getSourceLocale());
        startDoc.setLineBreak(this.lineBreak);
        startDoc.setFilterParameters(this.getParameters());
        startDoc.setFilterWriter(this.createFilterWriter());
        startDoc.setType(this.params.getMimeType());
        startDoc.setMimeType(this.params.getMimeType());
        startDoc.setMultilingual(this.hasRulesWithTarget());
        this.queue.add(new Event(EventType.START_DOCUMENT, startDoc));
    }

    private Event processMatch(Rule rule, MatchResult result) {
        switch (rule.ruleType) {
            case 2: 
            case 3: {
                GenericSkeleton skel = new GenericSkeleton(this.inputText.substring(this.startSkl, result.end()).replace("\n", this.lineBreak));
                this.startSearch = result.end();
                this.startSkl = result.end();
                if (rule.ruleType == 2) {
                    this.params.getLocalizationDirectives().process(result.group(rule.sourceGroup));
                }
                return new Event(EventType.DOCUMENT_PART, new DocumentPart(this.otherId.createId(), false, skel));
            }
            case 4: 
            case 5: {
                GenericSkeleton skel = new GenericSkeleton(this.inputText.substring(this.startSkl, result.end()).replace("\n", this.lineBreak));
                this.startSearch = result.end();
                this.startSkl = result.end();
                if (rule.ruleType == 4) {
                    String name;
                    if (this.params.getOneLevelGroups() && this.groupStack.size() > 0) {
                        this.closeGroups();
                    }
                    StartGroup startGroup = new StartGroup(null);
                    startGroup.setId(this.otherId.createId());
                    startGroup.setSkeleton(skel);
                    if (rule.nameGroup != -1 && (name = result.group(rule.nameGroup)).length() > 0) {
                        startGroup.setName(name);
                    }
                    this.groupStack.push(startGroup);
                    this.queue.add(new Event(EventType.START_GROUP, startGroup));
                    return this.queue.poll();
                }
                if (this.groupStack.size() == 0) {
                    throw new OkapiIllegalFilterOperationException("Rule for closing a group detected, but no group is open.");
                }
                this.groupStack.pop();
                Ending ending = new Ending(this.otherId.createId());
                ending.setSkeleton(skel);
                return new Event(EventType.END_GROUP, ending);
            }
        }
        if (result.start() > this.startSkl) {
            this.addSkeletonToQueue(this.inputText.substring(this.startSkl, result.start()), false);
        }
        this.startSkl = result.start();
        this.startSearch = result.end();
        if (!this.params.getLocalizationDirectives().isLocalizable(true)) {
            this.addSkeletonToQueue(this.inputText.substring(this.startSkl, result.end()), false);
            this.startSkl = result.end();
            return this.nextEvent();
        }
        if (rule.ruleType == 1) {
            this.processContent(rule, result);
        } else if (rule.ruleType == 0) {
            if (result.start(rule.sourceGroup) > result.start()) {
                this.addSkeletonToQueue(this.inputText.substring(this.startSkl, result.start(rule.sourceGroup)), false);
            }
            this.processStrings(rule, result);
            if (result.end(rule.sourceGroup) < result.end()) {
                this.addSkeletonToQueue(this.inputText.substring(result.end(rule.sourceGroup), result.end()), false);
            }
            this.startSkl = result.end();
        }
        return this.nextEvent();
    }

    private void processContent(Rule rule, MatchResult result) {
        String note;
        String name;
        boolean hasTarget;
        this.tuRes = new TextUnit(String.valueOf(++this.tuId), result.group(rule.sourceGroup));
        GenericSkeleton skel = new GenericSkeleton();
        this.tuRes.setSkeleton(skel);
        boolean bl = hasTarget = rule.targetGroup != -1;
        if (hasTarget) {
            this.tuRes.setTargetContent(this.trgLang, new TextFragment(result.group(rule.targetGroup)));
            if (result.start(rule.targetGroup) > result.start(rule.sourceGroup)) {
                if (result.start(rule.sourceGroup) > this.startSkl) {
                    skel.append(this.inputText.substring(this.startSkl, result.start(rule.sourceGroup)).replace("\n", this.lineBreak));
                }
                skel.addContentPlaceholder(this.tuRes);
                skel.append(this.inputText.substring(result.end(rule.sourceGroup), result.start(rule.targetGroup)).replace("\n", this.lineBreak));
                skel.addContentPlaceholder(this.tuRes, this.trgLang);
                if (result.end(rule.targetGroup) < result.end()) {
                    skel.append(this.inputText.substring(result.end(rule.targetGroup), result.end()).replace("\n", this.lineBreak));
                }
            } else {
                if (result.start(rule.targetGroup) > this.startSkl) {
                    skel.append(this.inputText.substring(this.startSkl, result.start(rule.targetGroup)).replace("\n", this.lineBreak));
                }
                skel.addContentPlaceholder(this.tuRes, this.trgLang);
                skel.append(this.inputText.substring(result.end(rule.targetGroup), result.start(rule.sourceGroup)).replace("\n", this.lineBreak));
                skel.addContentPlaceholder(this.tuRes);
                if (result.end(rule.sourceGroup) < result.end()) {
                    skel.append(this.inputText.substring(result.end(rule.sourceGroup), result.end()).replace("\n", this.lineBreak));
                }
            }
        } else {
            if (result.start(rule.sourceGroup) > this.startSkl) {
                skel.append(this.inputText.substring(this.startSkl, result.start(rule.sourceGroup)).replace("\n", this.lineBreak));
            }
            skel.addContentPlaceholder(this.tuRes);
            if (result.end(rule.sourceGroup) < result.end()) {
                skel.append(this.inputText.substring(result.end(rule.sourceGroup), result.end()).replace("\n", this.lineBreak));
            }
        }
        this.startSkl = result.end();
        this.tuRes.setMimeType(MIMETYPE);
        if (rule.preserveWS) {
            this.tuRes.setPreserveWhitespaces(true);
        } else {
            this.tuRes.getSource().unwrap(true, true);
            if (hasTarget) {
                this.tuRes.getTarget(this.trgLang).unwrap(true, true);
            }
        }
        if (rule.useCodeFinder) {
            rule.codeFinder.process(this.tuRes.getSource().getFirstContent());
            if (hasTarget) {
                rule.codeFinder.process(this.tuRes.getTarget(this.trgLang).getFirstContent());
            }
        }
        if (rule.nameGroup != -1 && (name = result.group(rule.nameGroup)).length() > 0) {
            this.tuRes.setName(name);
        }
        if (rule.noteGroup != -1 && (note = result.group(rule.noteGroup)).length() > 0) {
            this.tuRes.setProperty(new Property("note", note, true));
        }
        this.queue.add(new Event(EventType.TEXT_UNIT, this.tuRes));
    }

    private void processStrings(Rule rule, MatchResult result) {
        int i = -1;
        int startSearch = 0;
        int count = 0;
        String data = result.group(rule.sourceGroup);
        int endChar = 0;
        do {
            String note;
            String name;
            int start = startSearch;
            int end = -1;
            int state = 0;
            while (end == -1 && ++i < data.length()) {
                if (state > 0 && this.params.getUseBSlashEscape()) {
                    while (data.codePointAt(i) == 92) {
                        if (i + 2 < data.length()) {
                            i += 2;
                            continue;
                        }
                        throw new OkapiIllegalFilterOperationException("Escape syntax error in [" + data + "]");
                    }
                }
                switch (state) {
                    case 0: {
                        int n = this.params.getStartString().indexOf(data.codePointAt(i));
                        if (n <= -1) break;
                        start = i + 1;
                        state = 1;
                        endChar = this.params.getEndString().charAt(n);
                        break;
                    }
                    case 1: {
                        if (data.codePointAt(i) != endChar || (end = i) != start) break;
                        end = -1;
                        state = 0;
                    }
                }
            }
            if (end == -1) continue;
            ++count;
            if (start > startSearch) {
                this.addSkeletonToQueue(data.substring(startSearch, start), false);
            }
            this.tuRes = new TextUnit(String.valueOf(++this.tuId), data.substring(start, end));
            this.tuRes.setMimeType(MIMETYPE);
            if (rule.preserveWS) {
                this.tuRes.setPreserveWhitespaces(true);
            } else {
                this.tuRes.getSource().unwrap(true, true);
            }
            if (rule.useCodeFinder) {
                rule.codeFinder.process(this.tuRes.getSource().getFirstContent());
            }
            if (rule.nameGroup != -1 && (name = result.group(rule.nameGroup)).length() > 0) {
                if (count > 1) {
                    this.tuRes.setName(String.format("%s%d", name, count));
                } else {
                    this.tuRes.setName(name);
                }
            }
            if (rule.noteGroup != -1 && (note = result.group(rule.noteGroup)).length() > 0) {
                this.tuRes.setProperty(new Property("note", note, true));
            }
            this.queue.add(new Event(EventType.TEXT_UNIT, this.tuRes));
            startSearch = end;
        } while (i < data.length());
        if (startSearch < data.length()) {
            this.addSkeletonToQueue(data.substring(startSearch), false);
        }
    }

    private void addSkeletonToQueue(String data, boolean forceNewEntry) {
        if (!forceNewEntry && this.queue.size() > 0 && this.queue.getLast().getResource() instanceof DocumentPart) {
            GenericSkeleton skel = (GenericSkeleton)this.queue.getLast().getResource().getSkeleton();
            skel.append(data.replace("\n", this.lineBreak));
            return;
        }
        GenericSkeleton skel = new GenericSkeleton(data.replace("\n", this.lineBreak));
        this.queue.add(new Event(EventType.DOCUMENT_PART, new DocumentPart(this.otherId.createId(), false, skel)));
    }

    private Event nextEvent() {
        if (this.queue.size() == 0) {
            return null;
        }
        if (this.queue.peek().getEventType() == EventType.END_DOCUMENT) {
            this.parseState = 0;
        }
        return this.queue.poll();
    }

    private boolean hasRulesWithTarget() {
        for (Rule rule : this.params.getRules()) {
            if (rule.targetGroup == -1) continue;
            return true;
        }
        return false;
    }
}

