/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.rtf;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.logging.Logger;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.exceptions.OkapiIllegalFilterOperationException;
import net.sf.okapi.common.exceptions.OkapiUnsupportedEncodingException;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filterwriter.GenericFilterWriter;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.skeleton.GenericSkeletonWriter;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.filters.rtf.RTFContext;
import net.sf.okapi.filters.rtf.RTFFont;

public class RTFFilter
implements IFilter {
    public static final String PROP_HASHIDDENTEXT = "hashiddentext";
    public static final int TOKEN_CHAR = 0;
    public static final int TOKEN_STARTGROUP = 1;
    public static final int TOKEN_ENDGROUP = 2;
    public static final int TOKEN_ENDINPUT = 3;
    public static final int TOKEN_CTRLWORD = 4;
    public static final int CW_ANSI = 1;
    public static final int CW_F = 2;
    public static final int CW_U = 3;
    public static final int CW_ANSICPG = 4;
    public static final int CW_LQUOTE = 5;
    public static final int CW_RQUOTE = 6;
    public static final int CW_LDBLQUOTE = 7;
    public static final int CW_RDBLQUOTE = 8;
    public static final int CW_BULLET = 9;
    public static final int CW_ENDASH = 10;
    public static final int CW_EMDASH = 11;
    public static final int CW_ZWJ = 12;
    public static final int CW_ZWNJ = 13;
    public static final int CW_LTRMARK = 14;
    public static final int CW_RTLMARK = 15;
    public static final int CW_UC = 16;
    public static final int CW_CPG = 17;
    public static final int CW_FONTTBL = 18;
    public static final int CW_FCHARSET = 19;
    public static final int CW_PAR = 20;
    public static final int CW_PAGE = 21;
    public static final int CW_STYLESHEET = 22;
    public static final int CW_COLORTBL = 23;
    public static final int CW_SPECIAL = 24;
    public static final int CW_FOOTNOTE = 25;
    public static final int CW_TAB = 26;
    public static final int CW_V = 27;
    public static final int CW_XE = 28;
    public static final int CW_CCHS = 29;
    public static final int CW_PICT = 30;
    public static final int CW_SHPTXT = 31;
    public static final int CW_LINE = 32;
    public static final int CW_INDEXSEP = 33;
    public static final int CW_ULDB = 34;
    public static final int CW_TITLE = 35;
    public static final int CW_TROWD = 36;
    public static final int CW_CELL = 37;
    public static final int CW_BKMKSTART = 38;
    public static final int CW_ROW = 39;
    public static final int CW_UL = 40;
    public static final int CW_PARD = 41;
    public static final int CW_NONSHPPICT = 42;
    public static final int CW_INFO = 43;
    public static final int CW_CS = 44;
    public static final int CW_DELETED = 45;
    public static final int CW_PLAIN = 46;
    public static final int CW_BKMKEND = 47;
    public static final int CW_ANNOTATION = 48;
    public static final int CW_MAC = 49;
    public static final int CW_PC = 50;
    public static final int CW_PCA = 51;
    public static final int CW_FTNSEP = 52;
    public static final int CW_FTNSEPC = 53;
    public static final int CW_AFTNSEP = 54;
    public static final int CW_AFTNSEPC = 55;
    public static final int CW_RTF = 56;
    public static final int CW_FLDINST = 57;
    public static final int CW_XMLOPEN = 58;
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private static final String PAIREDTAGS = ":fc:cs:b:i:s:bi:c:c1:c2:cns:el:elf:ti:";
    private BufferedReader reader;
    private boolean canceled;
    private LocaleId trgLang;
    private String passedEncoding;
    private Hashtable<Integer, String> winCharsets = new Hashtable();
    private Hashtable<Integer, String> winCodepages;
    private Hashtable<String, Integer> controlWords;
    private Hashtable<Integer, RTFFont> fonts;
    private char chCurrent;
    private char chPrevTextChar;
    private int value;
    private Stack<RTFContext> ctxStack;
    private int inFontTable;
    private String defaultEncoding;
    private boolean setCharset0ToDefault;
    private StringBuilder word;
    private boolean reParse;
    private char chReParseChar;
    private int skip;
    private int code;
    private int group;
    private int noReset;
    private byte byteData;
    private char uChar;
    private int internalStyle;
    private boolean rtfDetected;
    private int doNotTranslateStyle;
    private CharsetDecoder currentCSDec;
    private int currentDBCSCodepage;
    private String currentCSName;
    private ByteBuffer byteBuffer;
    private LinkedList<Event> queue;
    private boolean hasNext;
    private String docName;
    private int tuId;
    private EncoderManager encoderManager;

    public RTFFilter() {
        this.winCharsets.put(0, "windows-1252");
        this.winCharsets.put(1, Charset.defaultCharset().name());
        this.winCharsets.put(2, "symbol");
        this.winCharsets.put(3, "invalid-fcharset");
        this.winCharsets.put(77, "MacRoman");
        this.winCharsets.put(128, "Shift_JIS");
        this.winCharsets.put(129, "windows949");
        this.winCharsets.put(130, "johab");
        this.winCharsets.put(134, "windows-936");
        this.winCharsets.put(136, "Big5");
        this.winCharsets.put(161, "windows-1253");
        this.winCharsets.put(162, "windows-1254");
        this.winCharsets.put(163, "windows-1258");
        this.winCharsets.put(177, "windows-1255");
        this.winCharsets.put(178, "windows-1256");
        this.winCharsets.put(179, "windows-1256");
        this.winCharsets.put(180, "arabic-user");
        this.winCharsets.put(181, "hebrew-user");
        this.winCharsets.put(186, "windows-1257");
        this.winCharsets.put(204, "windows-1251");
        this.winCharsets.put(222, "windows-874");
        this.winCharsets.put(238, "windows-1250");
        this.winCharsets.put(254, "ibm437");
        this.winCharsets.put(255, "oem");
        this.winCodepages = new Hashtable();
        this.winCodepages.put(437, "IBM437");
        this.winCodepages.put(850, "IBM850");
        this.winCodepages.put(852, "IBM852");
        this.winCodepages.put(932, "Shift_JIS");
        this.winCodepages.put(936, "windows-936");
        this.winCodepages.put(949, "windows949");
        this.winCodepages.put(950, "Big5");
        this.winCodepages.put(1250, "windows-1250");
        this.winCodepages.put(1251, "windows-1251");
        this.winCodepages.put(1252, "windows-1252");
        this.winCodepages.put(1253, "windows-1253");
        this.winCodepages.put(1254, "windows-1254");
        this.winCodepages.put(1255, "windows-1255");
        this.winCodepages.put(1256, "windows-1256");
        this.winCodepages.put(1257, "windows-1257");
        this.winCodepages.put(1258, "windows-1258");
        this.controlWords = new Hashtable();
        this.controlWords.put("par", 20);
        this.controlWords.put("pard", 41);
        this.controlWords.put("f", 2);
        this.controlWords.put("u", 3);
        this.controlWords.put("plain", 46);
        this.controlWords.put("page", 21);
        this.controlWords.put("lquote", 5);
        this.controlWords.put("rquote", 6);
        this.controlWords.put("cell", 37);
        this.controlWords.put("trowd", 36);
        this.controlWords.put("tab", 26);
        this.controlWords.put("endash", 10);
        this.controlWords.put("emdash", 11);
        this.controlWords.put("ldblquote", 7);
        this.controlWords.put("rdblquote", 8);
        this.controlWords.put("v", 27);
        this.controlWords.put("xe", 28);
        this.controlWords.put("cchs", 29);
        this.controlWords.put("bkmkstart", 38);
        this.controlWords.put("row", 39);
        this.controlWords.put("uc", 16);
        this.controlWords.put("*", 24);
        this.controlWords.put("pict", 30);
        this.controlWords.put(":", 33);
        this.controlWords.put("shptxt", 31);
        this.controlWords.put("fcharset", 19);
        this.controlWords.put("footnote", 25);
        this.controlWords.put("uldb", 34);
        this.controlWords.put("ul", 40);
        this.controlWords.put("bullet", 9);
        this.controlWords.put("ltrmark", 14);
        this.controlWords.put("rtlmark", 15);
        this.controlWords.put("line", 32);
        this.controlWords.put("zwj", 12);
        this.controlWords.put("zwnj", 13);
        this.controlWords.put("cpg", 17);
        this.controlWords.put("ansi", 1);
        this.controlWords.put("fonttbl", 18);
        this.controlWords.put("stylesheet", 22);
        this.controlWords.put("colortbl", 23);
        this.controlWords.put("info", 43);
        this.controlWords.put("title", 35);
        this.controlWords.put("nonshppict", 42);
        this.controlWords.put("ansicpg", 4);
        this.controlWords.put("cs", 44);
        this.controlWords.put("deleted", 45);
        this.controlWords.put("bkmkend", 47);
        this.controlWords.put("annotation", 48);
        this.controlWords.put("mac", 49);
        this.controlWords.put("pc", 50);
        this.controlWords.put("pca", 51);
        this.controlWords.put("ftnsep", 52);
        this.controlWords.put("ftnsepc", 53);
        this.controlWords.put("aftnsep", 54);
        this.controlWords.put("aftnsepc", 55);
        this.controlWords.put("rtf", 56);
        this.controlWords.put("fldinst", 57);
        this.controlWords.put("xmlopen", 58);
    }

    @Override
    public void cancel() {
        this.canceled = true;
    }

    @Override
    public void close() {
        try {
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
            this.hasNext = false;
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
    }

    @Override
    public String getName() {
        return "okf_tradosrtf";
    }

    @Override
    public String getDisplayName() {
        return "Trados-Tagged RTF Filter - READING ONLY";
    }

    @Override
    public String getMimeType() {
        return "application/rtf";
    }

    @Override
    public List<FilterConfiguration> getConfigurations() {
        ArrayList<FilterConfiguration> list = new ArrayList<FilterConfiguration>();
        list.add(new FilterConfiguration(this.getName(), "application/rtf", this.getClass().getName(), "Trados-Tagged RTF", "Configuration for Trados-tagged RTF files - READING ONLY.", null, ".rtf;"));
        return list;
    }

    @Override
    public EncoderManager getEncoderManager() {
        if (this.encoderManager == null) {
            this.encoderManager = new EncoderManager();
        }
        return this.encoderManager;
    }

    @Override
    public IParameters getParameters() {
        return null;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public Event next() {
        if (this.canceled) {
            this.queue.clear();
            this.queue.add(new Event(EventType.CANCELED));
            this.hasNext = false;
        }
        if (this.queue.size() == 0) {
            this.parseNext();
        }
        if (this.queue.peek().getEventType() == EventType.END_DOCUMENT) {
            this.hasNext = false;
        }
        return this.queue.poll();
    }

    public void parseNext() {
        TextUnit textUnit;
        if (!this.getSegment(textUnit = new TextUnit(String.valueOf(++this.tuId)))) {
            this.queue.add(new Event(EventType.END_DOCUMENT, new Ending(String.valueOf("ed"))));
        } else {
            this.queue.add(new Event(EventType.TEXT_UNIT, textUnit));
        }
    }

    @Override
    public void open(RawDocument input) {
        this.open(input, true);
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        try {
            this.passedEncoding = input.getEncoding();
            this.trgLang = input.getTargetLocale();
            if (input.getInputURI() != null) {
                this.docName = input.getInputURI().getPath();
            }
            this.reset(this.passedEncoding);
            this.reader = new BufferedReader(new InputStreamReader(input.getStream(), this.passedEncoding));
            StartDocument startDoc = new StartDocument("sd");
            startDoc.setName(this.docName);
            startDoc.setEncoding(this.passedEncoding, false);
            startDoc.setLocale(input.getSourceLocale());
            startDoc.setFilterParameters(this.getParameters());
            startDoc.setFilterWriter(this.createFilterWriter());
            startDoc.setType("application/rtf");
            startDoc.setMimeType("application/rtf");
            startDoc.setMultilingual(true);
            startDoc.setLineBreak("\r\n");
            this.queue.add(new Event(EventType.START_DOCUMENT, startDoc));
        }
        catch (UnsupportedEncodingException e) {
            throw new OkapiUnsupportedEncodingException(e);
        }
    }

    @Override
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
    }

    @Override
    public void setParameters(IParameters params) {
    }

    @Override
    public ISkeletonWriter createSkeletonWriter() {
        return new GenericSkeletonWriter();
    }

    @Override
    public IFilterWriter createFilterWriter() {
        return new GenericFilterWriter(this.createSkeletonWriter(), this.getEncoderManager());
    }

    private void reset(String defaultEncoding) {
        this.close();
        this.canceled = false;
        this.rtfDetected = false;
        this.chCurrent = '\u0000';
        this.reParse = false;
        this.chReParseChar = '\u0000';
        this.group = 0;
        this.skip = 0;
        this.byteData = 0;
        this.code = 0;
        this.word = new StringBuilder();
        this.value = 0;
        this.chPrevTextChar = '\u0000';
        this.uChar = '\u0000';
        this.byteBuffer = ByteBuffer.allocate(10);
        this.fonts = new Hashtable();
        this.inFontTable = 0;
        this.noReset = 0;
        this.internalStyle = 6;
        this.doNotTranslateStyle = 8;
        RTFContext ctx = new RTFContext();
        ctx.uniCount = 1;
        ctx.inText = true;
        ctx.font = 0;
        this.defaultEncoding = defaultEncoding;
        ctx.encoding = defaultEncoding;
        this.ctxStack = new Stack();
        this.ctxStack.push(ctx);
        this.loadEncoding(ctx.encoding);
        this.hasNext = true;
        this.tuId = 0;
        this.queue = new LinkedList();
    }

    public boolean getSegment(TextUnit tu) {
        int nState = 0;
        String sTmp = "";
        String sCode = "";
        int nGrp = 0;
        int nStyle = 0;
        int nCode = 0;
        int startHidden = -1;
        int endHidden = -1;
        int fldinst = 0;
        int xmlopen = 0;
        TextFragment srcFrag = tu.setSourceContent(new TextFragment());
        TextFragment trgFrag = new TextFragment();
        TextFragment currentFrag = null;
        block26: while (true) {
            switch (this.getNextToken()) {
                case 3: {
                    if (!this.rtfDetected) {
                        this.logger.warning("The input does not seem to be an RTF document.");
                    }
                    return false;
                }
                case 0: {
                    if (this.ctxStack.peek().inText) {
                        if (startHidden > -1 && endHidden == -1) {
                            endHidden = trgFrag.length();
                        }
                    } else {
                        if (nStyle > 0) {
                            sTmp = sTmp + this.chCurrent;
                        }
                        if (nState == 7 && startHidden < 0) {
                            startHidden = trgFrag.length();
                        }
                    }
                    switch (nState) {
                        case 0: {
                            if (this.chCurrent != '{') break;
                            nState = 1;
                            break;
                        }
                        case 1: {
                            if (this.chCurrent == '0') {
                                nState = 2;
                                break;
                            }
                            if (this.chCurrent == '{') break;
                            nState = 0;
                            break;
                        }
                        case 2: {
                            if (this.chCurrent == '>') {
                                nState = 3;
                                currentFrag = srcFrag;
                                break;
                            }
                            if (this.chCurrent == '{') {
                                nState = 1;
                                break;
                            }
                            nState = 0;
                            break;
                        }
                        case 3: {
                            if (fldinst > 0 || xmlopen > 0) break;
                            if (this.chCurrent == '<') {
                                sTmp = "";
                                nState = 4;
                                break;
                            }
                            if (nGrp > 0) {
                                sCode = sCode + this.chCurrent;
                                break;
                            }
                            srcFrag.append(this.chCurrent);
                            break;
                        }
                        case 4: {
                            if (this.chCurrent == '}') {
                                nState = 5;
                                break;
                            }
                            if (this.chCurrent == '<') {
                                if (nGrp > 0) {
                                    sCode = sCode + this.chCurrent;
                                    break;
                                }
                                srcFrag.append(this.chCurrent);
                                break;
                            }
                            if (nGrp > 0) {
                                sCode = sCode + '<';
                                sCode = sCode + this.chCurrent;
                            } else {
                                srcFrag.append('<');
                                srcFrag.append(this.chCurrent);
                            }
                            nState = 3;
                            break;
                        }
                        case 5: {
                            if (this.chCurrent == '{') {
                                nState = 6;
                                break;
                            }
                            if (!Character.isDigit(this.chCurrent)) {
                                if (nGrp > 0) {
                                    sCode = sCode + "<}";
                                    sCode = sCode + sTmp;
                                    sCode = sCode + this.chCurrent;
                                } else {
                                    srcFrag.append("<}");
                                    srcFrag.append(sTmp);
                                    srcFrag.append(this.chCurrent);
                                }
                                nState = 3;
                                break;
                            }
                            sTmp = sTmp + this.chCurrent;
                            break;
                        }
                        case 6: {
                            if (this.chCurrent == '>') {
                                currentFrag = trgFrag;
                                nState = 7;
                                break;
                            }
                            throw new OkapiIllegalFilterOperationException("Expecting: '>' while parsing Trados markup.");
                        }
                        case 7: {
                            if (this.chCurrent == '<') {
                                nState = 8;
                                break;
                            }
                            if (nGrp > 0) {
                                sCode = sCode + this.chCurrent;
                                break;
                            }
                            if (fldinst != 0 || xmlopen != 0) break;
                            trgFrag.append(this.chCurrent);
                            break;
                        }
                        case 8: {
                            if (this.chCurrent == '0') {
                                nState = 9;
                                break;
                            }
                            if (this.chCurrent == '<') {
                                if (nGrp > 0) {
                                    sCode = sCode + this.chCurrent;
                                    break;
                                }
                                trgFrag.append(this.chCurrent);
                                break;
                            }
                            if (nGrp > 0) {
                                sCode = sCode + '<';
                                sCode = sCode + this.chCurrent;
                            } else {
                                trgFrag.append('<');
                                trgFrag.append(this.chCurrent);
                            }
                            nState = 7;
                            break;
                        }
                        case 9: {
                            if (this.chCurrent == '}') {
                                if (!trgFrag.isEmpty()) {
                                    tu.setTargetContent(this.trgLang, trgFrag);
                                    if (startHidden > -1) {
                                        if (endHidden == -1) {
                                            endHidden = trgFrag.length();
                                        }
                                        if (endHidden - startHidden > 0) {
                                            this.logger.warning(String.format("Hidden text detected in target content of text unit '%s'\nTarget=\"%s\"", tu.getId(), trgFrag.toText()));
                                            tu.setTargetProperty(this.trgLang, new Property(PROP_HASHIDDENTEXT, String.format("%d;%d", startHidden, endHidden)));
                                        }
                                    }
                                }
                                return true;
                            }
                            if (this.chCurrent == '<') {
                                if (nGrp > 0) {
                                    sCode = sCode + "<0";
                                } else {
                                    trgFrag.append("<0");
                                }
                                nState = 8;
                                break;
                            }
                            if (nGrp > 0) {
                                sCode = sCode + '<';
                                sCode = sCode + this.chCurrent;
                            } else {
                                trgFrag.append('<');
                                trgFrag.append(this.chCurrent);
                            }
                            nState = 8;
                        }
                    }
                    continue block26;
                }
                case 1: {
                    continue block26;
                }
                case 2: {
                    if (nStyle > 0) {
                        if (nStyle < this.ctxStack.size() + 1) {
                            if ("tw4winInternal;".compareTo(sTmp) == 0) {
                                this.internalStyle = nCode;
                                continue block26;
                            }
                            if ("DO_NOT_TRANSLATE;".compareTo(sTmp) != 0) continue block26;
                            this.doNotTranslateStyle = nCode;
                            continue block26;
                        }
                        nStyle = 0;
                        continue block26;
                    }
                    if (nGrp > 0) {
                        if (nGrp != this.ctxStack.size() + 1) continue block26;
                        if (currentFrag != null) {
                            this.addInlineCode(currentFrag, sCode);
                        }
                        nGrp = 0;
                        continue block26;
                    }
                    if (fldinst > 0 && fldinst == this.ctxStack.size() + 1) {
                        fldinst = 0;
                    }
                    if (xmlopen <= 0 || xmlopen != this.ctxStack.size() + 1) continue block26;
                    xmlopen = 0;
                    continue block26;
                }
                case 4: {
                    switch (this.code) {
                        case 27: {
                            this.ctxStack.peek().inText = this.value == 0;
                            break;
                        }
                        case 44: {
                            if (nStyle > 0) {
                                nCode = this.value;
                                sTmp = "";
                                break;
                            }
                            if (this.value != this.internalStyle) break;
                            sCode = "";
                            nGrp = this.ctxStack.size();
                            break;
                        }
                        case 22: {
                            nStyle = this.ctxStack.size();
                            break;
                        }
                        case 57: {
                            fldinst = this.ctxStack.size();
                            break;
                        }
                        case 58: {
                            xmlopen = this.ctxStack.size();
                        }
                    }
                    continue block26;
                }
            }
        }
    }

    private void addInlineCode(TextFragment frag, String oriData) {
        Code code;
        ArrayList<String> list = new ArrayList<String>();
        int pos = oriData.indexOf("><");
        if (pos > -1) {
            int start = 0;
            while (pos > -1) {
                list.add(oriData.substring(start, pos + 1));
                start = pos + 1;
                pos = oriData.indexOf("><", start);
            }
            list.add(oriData.substring(start));
        } else {
            list.add(oriData);
        }
        String ct = frag.getCodedText();
        if (ct.length() >= 2 && TextFragment.isMarker(ct.charAt(ct.length() - 2)) && (code = frag.getCode(TextFragment.toIndex(ct.charAt(ct.length() - 1)))).getData().startsWith("<") && !code.getData().endsWith(">")) {
            code.setData(code.getData() + (String)list.get(0));
            list.remove(0);
        }
        for (String data : list) {
            int n;
            String type = null;
            TextFragment.TagType tagType = TextFragment.TagType.PLACEHOLDER;
            int last = data.length() - 1;
            int extra = 0;
            boolean detected = false;
            if (last > 1) {
                if (last > 3 && data.startsWith("<:")) {
                    if (data.charAt(2) == '/') {
                        extra = 1;
                    }
                    if ((n = data.indexOf(32)) == -1) {
                        n = data.indexOf(62);
                    }
                    if (n > -1) {
                        String tag = ":" + data.substring(2 + extra, n) + ":";
                        if (PAIREDTAGS.contains(tag)) {
                            if (extra == 0) {
                                tagType = TextFragment.TagType.OPENING;
                                extra = 1;
                            } else {
                                tagType = TextFragment.TagType.CLOSING;
                                extra = 2;
                            }
                        }
                        detected = true;
                    }
                }
                if (!detected && data.charAt(0) == '<' && data.charAt(last) == '>' && data.indexOf(60, 1) == -1) {
                    if (data.charAt(1) == '/' && last > 2) {
                        tagType = TextFragment.TagType.CLOSING;
                        extra = 1;
                    } else if (data.charAt(last - 1) != '/') {
                        tagType = TextFragment.TagType.OPENING;
                    }
                }
            }
            if (tagType != TextFragment.TagType.PLACEHOLDER) {
                n = data.indexOf(32);
                type = n > -1 ? data.substring(1 + extra, n) : data.substring(1 + extra, last);
            }
            frag.append(tagType, type, data);
        }
    }

    public int getTextUntil(StringBuilder text, int cwCode, int errorCwCode) {
        text.setLength(0);
        while (true) {
            switch (this.getNextToken()) {
                case 3: {
                    if (text.length() > 0) {
                        return 0;
                    }
                    return 2;
                }
                case 0: {
                    if (!this.ctxStack.peek().inText) break;
                    text.append(this.chCurrent);
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 4: {
                    if (cwCode == -1) {
                        if ((this.code == 20 || this.code == 32) && this.ctxStack.peek().inText) {
                            return 0;
                        }
                    } else if (this.code == cwCode) {
                        if (this.code == 20 || this.code == 32) {
                            // empty if block
                        }
                        return 0;
                    }
                    if (this.code != errorCwCode) break;
                    return 1;
                }
            }
        }
    }

    private int readChar() {
        try {
            int nRes = this.reader.read();
            if (nRes == -1) {
                this.chCurrent = '\u0000';
                return 3;
            }
            this.chCurrent = (char)nRes;
            return 0;
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
    }

    /*
     * Unable to fully structure code
     */
    private int getNextToken() {
        waitingSecondByte = false;
        block16: while (true) {
            if (this.reParse) {
                nRes = 0;
                this.chCurrent = this.chReParseChar;
                this.chReParseChar = '\u0000';
                this.reParse = false;
            } else {
                nRes = this.readChar();
            }
            switch (nRes) {
                case 0: {
                    switch (this.chCurrent) {
                        case '{': {
                            ++this.group;
                            if (this.inFontTable > 0) {
                                ++this.inFontTable;
                            }
                            if (this.noReset > 0) {
                                ++this.noReset;
                            }
                            this.ctxStack.push(new RTFContext(this.ctxStack.peek()));
                            return 1;
                        }
                        case '}': {
                            --this.group;
                            if (this.inFontTable > 0) {
                                --this.inFontTable;
                            }
                            if (this.noReset > 0) {
                                --this.noReset;
                            }
                            if (this.ctxStack.size() > 1) {
                                this.ctxStack.pop();
                                this.loadEncoding(this.ctxStack.peek().encoding);
                            }
                            return 2;
                        }
                        case '\n': 
                        case '\r': {
                            continue block16;
                        }
                        case '\\': {
                            nRes = this.parseAfterBackSlash();
                            if (nRes != -1 && this.skip == 0) {
                                return nRes;
                            }
                            if (nRes != -1) continue block16;
                            if (waitingSecondByte) {
                                waitingSecondByte = false;
                                this.byteBuffer.put(1, this.byteData);
                                try {
                                    charBuf = this.currentCSDec.decode(this.byteBuffer);
                                    this.chCurrent = charBuf.get(0);
                                }
                                catch (CharacterCodingException e) {
                                    this.logger.warning(e.getLocalizedMessage());
                                    this.chCurrent = (char)63;
                                }
                                break;
                            }
                            if (this.skip != 0) break;
                            if (this.isLeadByte(this.byteData)) {
                                waitingSecondByte = true;
                                this.byteBuffer.clear();
                                this.byteBuffer.put(0, this.byteData);
                                continue block16;
                            }
                            this.byteBuffer.clear();
                            this.byteBuffer.put(0, this.byteData);
                            try {
                                charBuf = this.currentCSDec.decode(this.byteBuffer);
                                this.chCurrent = charBuf.get(0);
                                break;
                            }
                            catch (CharacterCodingException e) {
                                this.logger.warning(e.getLocalizedMessage());
                                this.chCurrent = (char)63;
                            }
                        }
                    }
                    if (this.skip > 0) {
                        --this.skip;
                        if (this.skip <= 0) ** break;
                        continue block16;
                        this.chCurrent = this.uChar;
                    }
                    if (waitingSecondByte) {
                        waitingSecondByte = false;
                        this.byteBuffer.put(1, (byte)this.chCurrent);
                        try {
                            charBuf = this.currentCSDec.decode(this.byteBuffer);
                            this.chCurrent = charBuf.get(0);
                        }
                        catch (CharacterCodingException e) {
                            this.logger.warning(e.getLocalizedMessage());
                            this.chCurrent = (char)63;
                        }
                    }
                    this.chPrevTextChar = this.chCurrent;
                    return 0;
                }
                case 3: {
                    if (this.group > 0) {
                        this.logger.warning(String.format("Missing '{' = %d.", new Object[]{this.group}));
                    } else if (this.group < 0) {
                        this.logger.warning(String.format("Extra '}' = %d.", new Object[]{this.group}));
                    }
                    return nRes;
                }
            }
            break;
        }
        return nRes;
    }

    private boolean isLeadByte(byte byteValue) {
        switch (this.currentDBCSCodepage) {
            case 932: {
                if (byteValue >= -127 && byteValue <= -97) {
                    return true;
                }
                if (byteValue >= -32 && byteValue <= -18) {
                    return true;
                }
                if (byteValue < -6 || byteValue > -4) break;
                return true;
            }
            case 936: {
                if (byteValue >= -95 && byteValue <= -87) {
                    return true;
                }
                if (byteValue < -80 || byteValue > -9) break;
                return true;
            }
            case 949: {
                if (byteValue >= -127 && byteValue <= -56) {
                    return true;
                }
                if (byteValue < -54 || byteValue > -3) break;
                return true;
            }
            case 950: {
                if (byteValue >= -95 && byteValue <= -58) {
                    return true;
                }
                if (byteValue < -55 || byteValue > -7) break;
                return true;
            }
        }
        return false;
    }

    private int parseAfterBackSlash() {
        boolean inHexa = false;
        int count = 0;
        String sBuf = "";
        block6: while (this.readChar() == 0) {
            if (inHexa) {
                sBuf = sBuf + this.chCurrent;
                if (++count != 2) continue;
                this.byteData = (byte)Integer.parseInt(sBuf, 16);
                return -1;
            }
            switch (this.chCurrent) {
                case '\'': {
                    inHexa = true;
                    continue block6;
                }
                case '\n': 
                case '\r': {
                    this.code = 20;
                    return 4;
                }
                case '\\': 
                case '{': 
                case '}': {
                    return 0;
                }
                case '-': 
                case ':': 
                case '_': 
                case '|': 
                case '~': {
                    return this.parseControlSymbol();
                }
            }
            return this.parseControlWord();
        }
        throw new OkapiIllegalFilterOperationException("Unexcpected end of input.");
    }

    private int parseControlWord() {
        int nRes;
        int nState = 0;
        String sBuf = "";
        this.word.setLength(0);
        this.word.append(this.chCurrent);
        this.value = 1;
        while ((nRes = this.readChar()) == 0) {
            switch (nState) {
                case 0: {
                    switch (this.chCurrent) {
                        case ' ': {
                            return this.getControlWord();
                        }
                        case '\n': 
                        case '\r': {
                            return this.getControlWord();
                        }
                    }
                    if (Character.isLetter(this.chCurrent)) {
                        this.word.append(this.chCurrent);
                        break;
                    }
                    if (Character.isDigit(this.chCurrent) || this.chCurrent == '-') {
                        nState = 1;
                        sBuf = String.valueOf(this.chCurrent);
                        break;
                    }
                    this.reParse = true;
                    this.chReParseChar = this.chCurrent;
                    return this.getControlWord();
                }
                case 1: {
                    if (Character.isDigit(this.chCurrent)) {
                        sBuf = sBuf + this.chCurrent;
                        break;
                    }
                    if (this.chCurrent != ' ') {
                        this.reParse = true;
                        this.chReParseChar = this.chCurrent;
                    }
                    this.value = Integer.parseInt(sBuf);
                    return this.getControlWord();
                }
            }
        }
        if (nRes == 3) {
            return this.getControlWord();
        }
        throw new OkapiIllegalFilterOperationException("Unexcpected end of input.");
    }

    private int getControlWord() {
        this.code = this.controlWords.containsKey(this.word.toString()) ? this.controlWords.get(this.word.toString()) : -1;
        return this.processControlWord();
    }

    private int processControlWord() {
        switch (this.code) {
            case 3: {
                this.chCurrent = this.chCurrent < '\u0000' ? (char)(65536 + this.value) : (char)this.value;
                this.skip = this.ctxStack.peek().uniCount;
                this.uChar = this.chCurrent;
                return 0;
            }
            case 16: {
                this.ctxStack.peek().uniCount = this.value;
                break;
            }
            case 18: {
                this.inFontTable = 1;
                this.ctxStack.peek().inText = false;
                break;
            }
            case 19: {
                int nFont;
                if (this.inFontTable <= 0 || !this.fonts.containsKey(nFont = this.ctxStack.peek().font)) break;
                RTFFont tmpFont = this.fonts.get(nFont);
                if (this.setCharset0ToDefault && this.value == 0) {
                    tmpFont.encoding = this.defaultEncoding;
                    break;
                }
                if (this.winCharsets.containsKey(this.value)) {
                    tmpFont.encoding = this.winCharsets.get(this.value);
                    break;
                }
                tmpFont.encoding = this.defaultEncoding;
                break;
            }
            case 41: {
                break;
            }
            case 56: {
                this.rtfDetected = true;
                break;
            }
            case 2: {
                if (this.inFontTable > 0) {
                    this.ctxStack.peek().font = this.value;
                    if (this.fonts.containsKey(this.value)) break;
                    RTFFont tmpFont = new RTFFont();
                    this.fonts.put(this.value, tmpFont);
                    break;
                }
                this.ctxStack.peek().font = this.value;
                if (this.fonts.containsKey(this.value)) {
                    RTFFont tmpFont = this.fonts.get(this.value);
                    if (tmpFont.encoding == null) {
                        tmpFont.encoding = this.defaultEncoding;
                    }
                    this.ctxStack.peek().encoding = tmpFont.encoding;
                    this.loadEncoding(tmpFont.encoding);
                    break;
                }
                this.logger.warning(String.format("The font '%d' is undefined. The encoding '%s' is used by default instead.", this.value, this.defaultEncoding));
                this.loadEncoding(this.defaultEncoding);
                break;
            }
            case 26: {
                this.chCurrent = (char)9;
                return 0;
            }
            case 9: {
                this.chCurrent = (char)8226;
                return 0;
            }
            case 5: {
                this.chCurrent = (char)8216;
                return 0;
            }
            case 6: {
                this.chCurrent = (char)8217;
                return 0;
            }
            case 7: {
                this.chCurrent = (char)8220;
                return 0;
            }
            case 8: {
                this.chCurrent = (char)8221;
                return 0;
            }
            case 10: {
                this.chCurrent = (char)8211;
                return 0;
            }
            case 11: {
                this.chCurrent = (char)8212;
                return 0;
            }
            case 12: {
                this.chCurrent = (char)8205;
                return 0;
            }
            case 13: {
                this.chCurrent = (char)8204;
                return 0;
            }
            case 14: {
                this.chCurrent = (char)8206;
                return 0;
            }
            case 15: {
                this.chCurrent = (char)8207;
                return 0;
            }
            case 29: {
                this.ctxStack.peek().encoding = this.setCharset0ToDefault && this.value == 0 ? this.defaultEncoding : (this.winCharsets.containsKey(this.value) ? this.winCharsets.get(this.value) : this.defaultEncoding);
                this.loadEncoding(this.ctxStack.peek().encoding);
                break;
            }
            case 4: 
            case 17: {
                String name = this.winCodepages.get(this.value);
                if (name == null) {
                    this.logger.warning(String.format("The codepage '%d' is undefined. The encoding '%s' is used by default instead.", this.value, this.defaultEncoding));
                    this.ctxStack.peek().encoding = this.defaultEncoding;
                } else {
                    this.ctxStack.peek().encoding = name;
                }
                this.loadEncoding(this.ctxStack.peek().encoding);
                break;
            }
            case 1: {
                this.ctxStack.peek().encoding = this.setCharset0ToDefault ? this.defaultEncoding : "windows-1252";
                this.loadEncoding(this.ctxStack.peek().encoding);
                break;
            }
            case 49: {
                this.ctxStack.peek().encoding = "MacRoman";
                this.loadEncoding(this.ctxStack.peek().encoding);
                break;
            }
            case 50: {
                this.ctxStack.peek().encoding = "ibm437";
                this.loadEncoding(this.ctxStack.peek().encoding);
                break;
            }
            case 51: {
                this.ctxStack.peek().encoding = "ibm850";
                this.loadEncoding(this.ctxStack.peek().encoding);
                break;
            }
            case 25: {
                if ("#+!>@".indexOf(this.chPrevTextChar) == -1) break;
                this.ctxStack.peek().inText = false;
                break;
            }
            case 27: {
                this.ctxStack.peek().inText = this.value == 0;
                break;
            }
            case 28: 
            case 31: {
                this.ctxStack.peek().inText = true;
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 30: 
            case 43: {
                this.ctxStack.peek().inText = false;
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                this.noReset = 1;
                this.ctxStack.peek().inText = false;
                break;
            }
            case 48: {
                this.noReset = 1;
                this.ctxStack.peek().inText = false;
                break;
            }
            case 45: {
                this.ctxStack.peek().inText = this.value == 0;
                break;
            }
            case 46: {
                if (this.noReset != 0) break;
                this.ctxStack.peek().inText = true;
            }
        }
        return 4;
    }

    private void loadEncoding(String encodingName) {
        if (this.currentCSDec != null && this.currentCSName.compareToIgnoreCase(encodingName) == 0) {
            return;
        }
        if ("symbol".compareTo(encodingName) == 0 || "oem".compareTo(encodingName) == 0 || "arabic-user".compareTo(encodingName) == 0 || "hebrew-user".compareTo(encodingName) == 0) {
            this.logger.warning(String.format("The encoding '%s' is unsupported. The encoding '%s' is used by default instead.", encodingName, this.defaultEncoding));
            encodingName = this.defaultEncoding;
        }
        this.currentCSDec = Charset.forName(encodingName).newDecoder();
        this.currentCSName = encodingName.toLowerCase();
        this.currentDBCSCodepage = this.currentCSName.compareTo("shift_jis") == 0 ? 932 : (this.currentCSName.compareTo("windows949") == 0 ? 949 : (this.currentCSName.compareTo("gbk") == 0 ? 936 : (this.currentCSName.compareTo("windows-936") == 0 ? 936 : (this.currentCSName.compareTo("big5") == 0 ? 950 : 0))));
    }

    private int parseControlSymbol() {
        switch (this.chCurrent) {
            case '~': {
                this.chCurrent = (char)160;
                return 0;
            }
            case '_': {
                this.chCurrent = (char)8209;
                return 0;
            }
            case '-': 
            case ':': 
            case '|': {
                return 4;
            }
        }
        throw new OkapiIllegalFilterOperationException(String.format("Unknown control symbol '%c'", Character.valueOf(this.chCurrent)));
    }
}

