/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.table.fwc;

import java.util.List;
import net.sf.okapi.common.ListUtil;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.resource.TextUnitUtil;
import net.sf.okapi.filters.table.base.BaseTableFilter;
import net.sf.okapi.filters.table.fwc.Parameters;
import net.sf.okapi.lib.extra.filters.TextProcessingResult;

public class FixedWidthColumnsFilter
extends BaseTableFilter {
    public static final String FILTER_NAME = "okf_table_fwc";
    public static final String FILTER_CONFIG = "okf_table_fwc";
    public static String COLUMN_WIDTH = "column_width";
    private Parameters params;
    protected List<Integer> columnStartPositions;
    protected List<Integer> columnEndPositions;

    public FixedWidthColumnsFilter() {
        this.setName("okf_table_fwc");
        this.addConfiguration(true, "okf_table_fwc", "Table (Fixed-Width Columns)", "Fixed-width columns table padded with white-spaces.", "okf_table_fwc.fprm");
        this.setParameters(new Parameters());
    }

    @Override
    protected void component_init() {
        this.params = this.getParameters(Parameters.class);
        super.component_init();
        this.columnStartPositions = ListUtil.stringAsIntList(this.params.columnStartPositions);
        this.columnEndPositions = ListUtil.stringAsIntList(this.params.columnEndPositions);
    }

    @Override
    protected TextProcessingResult extractCells(List<TextUnit> cells, TextContainer lineContainer, long lineNum) {
        if (cells == null) {
            return TextProcessingResult.REJECTED;
        }
        if (lineContainer == null) {
            return TextProcessingResult.REJECTED;
        }
        String line = lineContainer.getCodedText();
        if (Util.isEmpty(line)) {
            return TextProcessingResult.REJECTED;
        }
        int len = Math.min(this.columnStartPositions.size(), this.columnEndPositions.size());
        for (int i = 0; i < len; ++i) {
            int skelEnd;
            int end;
            int start = this.columnStartPositions.get(i) - 1;
            if (start >= (end = this.columnEndPositions.get(i) - 1) || start >= line.length()) continue;
            if (end > line.length()) {
                end = line.length();
            }
            if ((skelEnd = i < len - 1 ? this.columnStartPositions.get(i + 1) - 1 : line.length()) > line.length()) {
                skelEnd = line.length();
            }
            String srcPart = line.substring(start, end);
            String skelPart = line.substring(end, skelEnd);
            TextUnit cell = TextUnitUtil.buildTU(srcPart, skelPart);
            cell.setSourceProperty(new Property(COLUMN_WIDTH, String.valueOf(end - start), true));
            cells.add(cell);
        }
        return TextProcessingResult.ACCEPTED;
    }
}

