/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.versifiedtxt;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.common.BOMNewlineEncodingDetector;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filters.AbstractFilter;
import net.sf.okapi.common.filters.EventBuilder;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;

public class VersifiedTextFilter
extends AbstractFilter {
    private static final Logger LOGGER = Logger.getLogger(VersifiedTextFilter.class.getName());
    private static final int BUFFER_SIZE = 128000;
    public static final String VERSIFIED_TXT_MIME_TYPE = "text/x-versified-txt";
    private static final String VERSE = "^\\|v.+$";
    private static final String CHAPTER = "^\\|c.+$";
    private static final String BOOK = "^\\|b.+$";
    private static final String PLACEHOLDER = "\\{[0-9]+\\}";
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("\\{[0-9]+\\}");
    private String newline = "\n";
    private String currentChapter = "";
    private String currentBook = "";
    private EventBuilder eventBuilder;
    private EncoderManager encoderManager;
    private boolean hasUtf8Bom;
    private boolean hasUtf8Encoding;
    private BufferedReader versifiedFileReader;
    private RawDocument currentRawDocument;
    BOMNewlineEncodingDetector detector;

    public VersifiedTextFilter() {
        this.setMimeType(VERSIFIED_TXT_MIME_TYPE);
        this.setFilterWriter(this.createFilterWriter());
        this.setName("okf_versifiedtxt");
        this.setDisplayName("Versified Text Filter");
        this.addConfiguration(new FilterConfiguration(this.getName(), VERSIFIED_TXT_MIME_TYPE, this.getClass().getName(), "Versified Text", "Versified Text Documents"));
    }

    @Override
    public void open(RawDocument input) {
        this.open(input, true);
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        this.close();
        this.currentRawDocument = input;
        this.currentChapter = "";
        this.currentBook = "";
        if (input.getInputURI() != null) {
            this.setDocumentName(input.getInputURI().getPath());
        }
        this.detector = new BOMNewlineEncodingDetector(input.getStream(), input.getEncoding());
        this.detector.detectAndRemoveBom();
        this.setEncoding(input.getEncoding());
        this.hasUtf8Bom = this.detector.hasUtf8Bom();
        this.hasUtf8Encoding = this.detector.hasUtf8Encoding();
        this.newline = this.detector.getNewlineType().toString();
        this.setNewlineType(this.newline);
        String detectedEncoding = this.getEncoding();
        if (this.detector.isDefinitive()) {
            detectedEncoding = this.detector.getEncoding();
            LOGGER.log(Level.FINE, String.format("Overridding user set encoding (if any). Setting auto-detected encoding (%s).", detectedEncoding));
        } else if (!this.detector.isDefinitive() && this.getEncoding().equals("null")) {
            detectedEncoding = this.detector.getEncoding();
            LOGGER.log(Level.FINE, String.format("Default encoding and detected encoding not found. Using best guess encoding (%s)", detectedEncoding));
        }
        input.setEncoding(detectedEncoding);
        this.setEncoding(detectedEncoding);
        this.setOptions(input.getSourceLocale(), input.getTargetLocale(), detectedEncoding, generateSkeleton);
        this.versifiedFileReader = new BufferedReader(input.getReader());
        if (this.eventBuilder == null) {
            this.eventBuilder = new EventBuilder();
        } else {
            this.eventBuilder.reset(null, this.isSubFilter());
        }
        this.eventBuilder.addFilterEvent(this.createStartFilterEvent());
    }

    @Override
    public void close() {
        if (this.currentRawDocument != null) {
            this.currentRawDocument.close();
        }
        if (this.versifiedFileReader != null) {
            try {
                this.versifiedFileReader.close();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Error closing the versified text buffered reader.", e);
            }
        }
    }

    @Override
    public EncoderManager getEncoderManager() {
        if (this.encoderManager == null) {
            this.encoderManager = new EncoderManager();
            this.encoderManager.setMapping(VERSIFIED_TXT_MIME_TYPE, "net.sf.okapi.common.encoder.DefaultEncoder");
        }
        return this.encoderManager;
    }

    @Override
    public IParameters getParameters() {
        return null;
    }

    @Override
    public void setParameters(IParameters params) {
    }

    @Override
    public boolean hasNext() {
        return this.eventBuilder.hasNext();
    }

    @Override
    public Event next() {
        String currentLine = null;
        if (this.eventBuilder.hasQueuedEvents()) {
            return this.eventBuilder.next();
        }
        try {
            while ((currentLine = this.versifiedFileReader.readLine()) != null && !this.isCanceled()) {
                if (currentLine.matches(VERSE)) {
                    this.handleDocumentPart(currentLine + this.newline);
                    this.handleVerse(this.versifiedFileReader, currentLine, currentLine.substring(2));
                } else if (currentLine.matches(BOOK)) {
                    this.currentBook = currentLine.substring(2);
                    this.handleDocumentPart(currentLine + this.newline);
                } else if (currentLine.matches(CHAPTER)) {
                    this.currentChapter = currentLine.substring(2);
                    this.handleDocumentPart(currentLine + this.newline);
                } else {
                    this.handleDocumentPart(currentLine + this.newline);
                }
                if (!this.eventBuilder.hasQueuedEvents()) continue;
                break;
            }
        }
        catch (IOException e) {
            throw new OkapiIOException("IO error reading versified file at: " + (currentLine == null ? "unkown line" : currentLine), e);
        }
        if (currentLine == null) {
            this.eventBuilder.flushRemainingTempEvents();
            this.eventBuilder.addFilterEvent(this.createEndFilterEvent());
        }
        return this.eventBuilder.next();
    }

    @Override
    protected boolean isUtf8Bom() {
        return this.hasUtf8Bom;
    }

    @Override
    protected boolean isUtf8Encoding() {
        return this.hasUtf8Encoding;
    }

    private void handleVerse(BufferedReader verse, String currentVerse, String verseNumber) throws IOException {
        String line = null;
        StringBuilder source = new StringBuilder(128000);
        verse.mark(128000);
        while ((line = verse.readLine()) != null) {
            if (line.matches(VERSE) || line.matches(BOOK) || line.matches(CHAPTER)) {
                verse.reset();
                break;
            }
            source.append(line + "\n");
            verse.mark(128000);
        }
        String v = source.toString();
        this.eventBuilder.startTextUnit();
        Matcher m = PLACEHOLDER_PATTERN.matcher(v);
        if (m.find()) {
            m.reset();
            String[] chunks = PLACEHOLDER_PATTERN.split(v);
            for (int i = 0; i < chunks.length; ++i) {
                this.eventBuilder.addToTextUnit(chunks[i]);
                if (!m.find()) continue;
                String ph = v.substring(m.start(), m.end());
                this.eventBuilder.addToTextUnit(new Code(TextFragment.TagType.PLACEHOLDER, ph, ph));
            }
        } else {
            this.eventBuilder.addToTextUnit(v);
        }
        TextUnit tu = this.eventBuilder.peekMostRecentTextUnit();
        tu.setName(this.currentBook + ":" + this.currentChapter + ":" + verseNumber);
        this.eventBuilder.endTextUnit();
    }

    private void handleDocumentPart(String part) {
        this.eventBuilder.addDocumentPart(part);
    }
}

