/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.beans.v0;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.okapi.common.ISkeleton;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.annotation.IAnnotation;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.resource.TextUnitUtil;
import net.sf.okapi.lib.beans.v0.FactoryBean;
import net.sf.okapi.lib.beans.v0.IPersistenceBean;
import net.sf.okapi.lib.beans.v0.IPersistenceSession;
import net.sf.okapi.lib.beans.v0.PropertyBean;
import net.sf.okapi.lib.beans.v0.TextContainerBean;

public class TextUnitBean
implements IPersistenceBean {
    private String id;
    private String name;
    private String type;
    private boolean isTranslatable;
    private boolean preserveWS;
    private String mimeType;
    private TextContainerBean source = new TextContainerBean();
    private Map<String, TextContainerBean> targets = new ConcurrentHashMap<String, TextContainerBean>();
    private FactoryBean skeleton = new FactoryBean();
    private List<PropertyBean> properties = new ArrayList<PropertyBean>();
    private List<FactoryBean> annotations = new ArrayList<FactoryBean>();

    @Override
    public <T> T get(Class<T> classRef) {
        TextUnit tu = TextUnitUtil.buildTU(this.source.get(TextContainer.class));
        tu.setId(this.id);
        tu.setName(this.name);
        tu.setType(this.type);
        tu.setIsTranslatable(this.isTranslatable);
        tu.setPreserveWhitespaces(this.preserveWS);
        tu.setMimeType(this.mimeType);
        tu.setSource(this.source.get(TextContainer.class));
        for (String locTag : this.targets.keySet()) {
            tu.setTarget(new LocaleId(locTag), this.targets.get(locTag).get(TextContainer.class));
        }
        tu.setSkeleton(this.skeleton.get(ISkeleton.class));
        for (PropertyBean prop : this.properties) {
            tu.setProperty(prop.get(Property.class));
        }
        for (FactoryBean annotationBean : this.annotations) {
            tu.setAnnotation(annotationBean.get(IAnnotation.class));
        }
        return classRef.cast(tu);
    }

    @Override
    public IPersistenceBean set(Object obj) {
        if (obj instanceof TextUnit) {
            TextUnit tu = (TextUnit)obj;
            this.id = tu.getId();
            this.name = tu.getName();
            this.type = tu.getType();
            this.isTranslatable = tu.isTranslatable();
            this.preserveWS = tu.preserveWhitespaces();
            this.mimeType = tu.getMimeType();
            this.source.set(tu.getSource());
            for (LocaleId locId : tu.getTargetLocales()) {
                TextContainerBean targetBean = new TextContainerBean();
                this.targets.put(locId.toString(), targetBean);
                targetBean.set(tu.getTarget(locId));
            }
            this.skeleton.set(tu.getSkeleton());
            for (String propName : tu.getPropertyNames()) {
                PropertyBean propBean = new PropertyBean();
                propBean.set(tu.getProperty(propName));
                this.properties.add(propBean);
            }
        }
        return this;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isTranslatable() {
        return this.isTranslatable;
    }

    public void setTranslatable(boolean isTranslatable) {
        this.isTranslatable = isTranslatable;
    }

    public boolean isPreserveWS() {
        return this.preserveWS;
    }

    public void setPreserveWS(boolean preserveWS) {
        this.preserveWS = preserveWS;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public TextContainerBean getSource() {
        return this.source;
    }

    public void setSource(TextContainerBean source) {
        this.source = source;
    }

    public void setSkeleton(FactoryBean skeleton) {
        this.skeleton = skeleton;
    }

    public FactoryBean getSkeleton() {
        return this.skeleton;
    }

    public Map<String, TextContainerBean> getTargets() {
        return this.targets;
    }

    public void setTargets(Map<String, TextContainerBean> targets) {
        this.targets = targets;
    }

    @Override
    public void init(IPersistenceSession session) {
    }

    public List<FactoryBean> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(List<FactoryBean> annotations) {
        this.annotations = annotations;
    }

    public List<PropertyBean> getProperties() {
        return this.properties;
    }

    public void setProperties(List<PropertyBean> properties) {
        this.properties = properties;
    }
}

