/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.extra.pipelinebuilder;

import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.filters.DefaultFilters;
import net.sf.okapi.common.filters.FilterConfigurationMapper;
import net.sf.okapi.common.pipeline.IPipeline;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.pipeline.Pipeline;
import net.sf.okapi.common.pipeline.PipelineReturnValue;
import net.sf.okapi.common.pipelinedriver.IBatchItemContext;
import net.sf.okapi.common.pipelinedriver.PipelineDriver;
import net.sf.okapi.lib.extra.pipelinebuilder.XBatch;
import net.sf.okapi.lib.extra.pipelinebuilder.XPipelineAsStepImpl;
import net.sf.okapi.lib.extra.pipelinebuilder.XPipelineStep;
import net.sf.okapi.lib.extra.pipelinebuilder.XPipelineType;

public class XPipeline
extends Pipeline
implements IPipelineStep {
    private XPipelineAsStepImpl stepImpl = new XPipelineAsStepImpl();
    private XPipelineType type;
    private XBatch batch;
    private PipelineDriver pd;
    private FilterConfigurationMapper fcMapper = new FilterConfigurationMapper();

    public XPipeline(String description, IPipeline pipeline) {
        this(description, pipeline.getSteps().toArray(new IPipelineStep[0]));
        this.setId(pipeline.getId());
    }

    public XPipeline(String description, IPipelineStep ... steps) {
        this(description, XPipelineType.SEQUENTIAL, steps);
    }

    public XPipeline(String description, XPipelineType type, IPipelineStep ... steps) {
        this(description, type, true, steps);
    }

    private XPipeline(String description, XPipelineType type, boolean buildPipeline, IPipelineStep ... steps) {
        DefaultFilters.setMappings(this.fcMapper, true, true);
        this.stepImpl.setDescription(description);
        this.type = type;
        for (IPipelineStep step : steps) {
            if (step instanceof XPipelineStep && ((XPipelineStep)step).getStep() == null) continue;
            this.addStep(step);
        }
        if (buildPipeline) {
            this.recreatePipeline();
        }
    }

    public XPipeline(String description, XBatch batch, IPipelineStep ... steps) {
        this(description, batch, XPipelineType.SEQUENTIAL, steps);
    }

    public XPipeline(String description, XBatch batch, XPipelineType type, IPipelineStep ... steps) {
        this(description, type, false, steps);
        this.setBatch(batch);
    }

    private void recreatePipeline() {
        this.pd = new PipelineDriver();
        for (IPipelineStep step : this.getSteps()) {
            if (step instanceof XPipelineStep) {
                this.pd.addStep(((XPipelineStep)step).getStep());
                continue;
            }
            this.pd.addStep(step);
        }
        this.pd.setFilterConfigurationMapper(this.fcMapper);
        if (this.batch == null) {
            return;
        }
        for (IBatchItemContext item : this.batch.getItems()) {
            this.pd.addBatchItem(item);
        }
    }

    public PipelineReturnValue execute() {
        if (this.batch == null) {
            return this.getState();
        }
        if (this.pd == null) {
            return this.getState();
        }
        this.pd.processBatch();
        return this.getState();
    }

    @Override
    public String getHelpLocation() {
        return this.stepImpl.getHelpLocation();
    }

    @Override
    public String getName() {
        return this.stepImpl.getName();
    }

    @Override
    public IParameters getParameters() {
        return this.stepImpl.getParameters();
    }

    @Override
    public Event handleEvent(Event event) {
        if (this.type == XPipelineType.SEQUENTIAL) {
            // empty if block
        }
        return this.stepImpl.handleEvent(event);
    }

    @Override
    public boolean isDone() {
        return this.stepImpl.isDone();
    }

    @Override
    public boolean isLastOutputStep() {
        return this.stepImpl.isLastOutputStep();
    }

    @Override
    public void setLastOutputStep(boolean isLastStep) {
        this.stepImpl.setLastOutputStep(isLastStep);
    }

    @Override
    public void setParameters(IParameters params) {
        this.stepImpl.setParameters(params);
    }

    public XBatch getBatch() {
        return this.batch;
    }

    public void setBatch(XBatch batch) {
        this.batch = batch;
        this.recreatePipeline();
    }

    @Override
    public String getDescription() {
        return this.stepImpl.getDescription();
    }
}

