/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.search.lucene.analysis;

import com.ibm.icu.lang.UCharacter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.sf.okapi.common.exceptions.OkapiIOException;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;

public class AlphabeticNgramTokenizer
extends Tokenizer {
    private static final int NO_CHAR = -1;
    private int ngramLength;
    private String ngramType;
    private int offset;
    private TermAttribute termAttribute;
    private OffsetAttribute offsetAttribute;
    private TypeAttribute typeAttribute;
    private List<Character> ngramCache;
    private Locale locale;

    public AlphabeticNgramTokenizer(Reader reader, int ngramLength, Locale locale) {
        super(reader);
        if (ngramLength <= 0) {
            throw new IllegalArgumentException("'ngramLength' must be greater than 0");
        }
        if (reader == null) {
            throw new IllegalArgumentException("'reader' cannot be null");
        }
        this.ngramLength = ngramLength;
        this.termAttribute = this.addAttribute(TermAttribute.class);
        this.offsetAttribute = this.addAttribute(OffsetAttribute.class);
        this.typeAttribute = this.addAttribute(TypeAttribute.class);
        this.locale = locale;
        this.ngramCache = new ArrayList<Character>(ngramLength);
        this.initializeCache();
        this.ngramType = "ngram(" + this.getNgramLength() + ")";
        this.offset = 0;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public int getNgramLength() {
        return this.ngramLength;
    }

    public TermAttribute getTermAttribute() {
        return this.termAttribute;
    }

    private Reader getReader() {
        return this.input;
    }

    private void initializeCache() {
        this.ngramCache.clear();
        this.ngramCache.add(Character.valueOf('\u0000'));
        for (int i = 1; i < this.ngramLength; ++i) {
            int c;
            try {
                c = this.getReader().read();
            }
            catch (IOException ioe) {
                throw new OkapiIOException(ioe.getMessage(), ioe);
            }
            if (c == -1) break;
            this.offset = 0;
            this.ngramCache.add(Character.valueOf((char)c));
        }
    }

    private void createToken() {
        this.termAttribute.setTermBuffer(this.toLowerCase(this.ngramCache));
        this.offsetAttribute.setOffset(this.offset, this.offset + this.ngramCache.size());
        this.typeAttribute.setType(this.ngramType);
    }

    @Override
    public boolean incrementToken() throws IOException {
        this.clearAttributes();
        int c = this.getReader().read();
        if (this.ngramCache.size() > 0) {
            this.ngramCache.remove(0);
        }
        if (c == -1) {
            if (this.ngramCache.size() > 0) {
                this.createToken();
                this.ngramCache.clear();
                return true;
            }
            this.offset = 0;
            return false;
        }
        this.ngramCache.add(Character.valueOf((char)c));
        this.createToken();
        ++this.offset;
        return true;
    }

    @Override
    public void reset(Reader input) throws IOException {
        super.reset(input);
        this.initializeCache();
        this.offset = 0;
    }

    private String toLowerCase(List<Character> ngram) {
        StringBuilder sb = new StringBuilder();
        for (Character cha : ngram) {
            sb.append(cha);
        }
        String termValue = sb.toString();
        if (this.locale != null) {
            termValue = UCharacter.foldCase(termValue, true);
        }
        return termValue;
    }
}

