/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.translation;

import java.util.List;
import java.util.logging.Logger;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.annotation.AltTranslationsAnnotation;
import net.sf.okapi.common.exceptions.OkapiNotImplementedException;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.resource.TextUnitUtil;
import net.sf.okapi.lib.translation.IQuery;
import net.sf.okapi.lib.translation.QueryResult;

public abstract class BaseConnector
implements IQuery {
    private static final Logger LOGGER = Logger.getLogger(BaseConnector.class.getName());
    protected LocaleId srcLoc;
    protected String srcCode;
    protected LocaleId trgLoc;
    protected String trgCode;
    protected QueryResult result;
    protected int current = -1;
    private int weight;

    @Override
    public LocaleId getSourceLanguage() {
        return this.srcLoc;
    }

    @Override
    public LocaleId getTargetLanguage() {
        return this.trgLoc;
    }

    @Override
    public void setLanguages(LocaleId sourceLocale, LocaleId targetLocale) {
        this.srcLoc = sourceLocale;
        this.trgLoc = targetLocale;
        this.srcCode = this.toInternalCode(this.srcLoc);
        this.trgCode = this.toInternalCode(this.trgLoc);
    }

    @Override
    public boolean hasNext() {
        return this.current > -1;
    }

    @Override
    public QueryResult next() {
        if (this.current > -1) {
            this.current = -1;
            return this.result;
        }
        return null;
    }

    @Override
    public void clearAttributes() {
    }

    @Override
    public void removeAttribute(String name) {
    }

    @Override
    public void setAttribute(String name, String value) {
    }

    @Override
    public void setRootDirectory(String rootDir) {
    }

    @Override
    public IParameters getParameters() {
        return null;
    }

    @Override
    public void setParameters(IParameters params) {
    }

    @Override
    public int getWeight() {
        return this.weight;
    }

    @Override
    public void setWeight(int weight) {
        this.weight = weight;
    }

    @Override
    public List<List<QueryResult>> batchQuery(List<TextFragment> fragments) {
        throw new OkapiNotImplementedException();
    }

    @Override
    public void leverage(TextUnit tu) {
        if (tu == null || !tu.isTranslatable()) {
            return;
        }
        AltTranslationsAnnotation at = null;
        boolean hadTarget = tu.hasTarget(this.getTargetLanguage());
        TextContainer trgCont = tu.createTarget(this.getTargetLanguage(), false, 1);
        ISegments trgSegs = trgCont.getSegments();
        if (!hadTarget) {
            for (Segment seg : trgSegs) {
                seg.text.clear();
            }
        }
        for (Segment srcSeg : tu.getSource().getSegments()) {
            if (!srcSeg.text.hasText(false)) continue;
            this.query(srcSeg.text);
            while (this.hasNext()) {
                QueryResult qr = this.next();
                qr.weight = this.getWeight();
                TextUnitUtil.adjustTargetCodes(srcSeg.text, qr.target, true, false, null, tu);
                if (trgCont.hasBeenSegmented()) {
                    Segment ts = trgSegs.get(srcSeg.getId());
                    if (ts == null) {
                        ts = new Segment(srcSeg.id, new TextFragment(""));
                        trgSegs.append(ts);
                        LOGGER.warning(String.format("Cannot find matching target segment for source id: %s.Creating a new target segment at the end of the target.", srcSeg.getId()));
                    }
                    at = TextUnitUtil.addAltTranslation(ts, qr.toAltTranslation(srcSeg.text, this.getSourceLanguage(), this.getTargetLanguage()));
                    continue;
                }
                at = TextUnitUtil.addAltTranslation(trgCont, qr.toAltTranslation(srcSeg.text, this.getSourceLanguage(), this.getTargetLanguage()));
            }
            if (at == null) continue;
            at.sort();
        }
    }

    protected String toInternalCode(LocaleId locId) {
        return locId.toString();
    }
}

