/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.translation;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.annotation.AltTranslation;
import net.sf.okapi.common.annotation.AltTranslationsAnnotation;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.lib.translation.IQuery;
import net.sf.okapi.lib.translation.ITMQuery;
import net.sf.okapi.lib.translation.QueryResult;
import net.sf.okapi.lib.translation.QueryUtil;
import net.sf.okapi.lib.translation.ResourceItem;

public class QueryManager {
    private LinkedHashMap<Integer, ResourceItem> resList = new LinkedHashMap();
    private ArrayList<QueryResult> results = new ArrayList();
    private int current = -1;
    private int lastId = 0;
    private LocaleId srcLoc;
    private LocaleId trgLoc;
    private LinkedHashMap<String, String> attributes = new LinkedHashMap();
    private int threshold = 75;
    private int maxHits = 5;
    private int totalSegments;
    private int exactBestMatches;
    private int fuzzyBestMatches;
    private String rootDir;

    public int addResource(IQuery connector, String name) {
        assert (connector != null);
        ResourceItem ri = new ResourceItem();
        ri.query = connector;
        ri.enabled = true;
        ri.name = name;
        this.resList.put(++this.lastId, ri);
        return this.lastId;
    }

    public int addAndInitializeResource(IQuery connector, String resourceName, IParameters params) {
        int id = this.addResource(connector, resourceName);
        connector.setRootDirectory(this.rootDir);
        connector.setParameters(params);
        connector.open();
        if (this.srcLoc != null && this.trgLoc != null) {
            connector.setLanguages(this.srcLoc, this.trgLoc);
        }
        for (String name : this.attributes.keySet()) {
            connector.setAttribute(name, this.attributes.get(name));
        }
        if (connector instanceof ITMQuery) {
            ((ITMQuery)connector).setThreshold(this.threshold);
            ((ITMQuery)connector).setMaximumHits(this.maxHits);
        }
        return id;
    }

    public int addAndInitializeResource(String connectorClass, String resourceName, String connectorParams) {
        IQuery conn;
        try {
            conn = (IQuery)Class.forName(connectorClass).newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Error creating connector.", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error creating connector.", e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Error creating connector.", e);
        }
        IParameters tmParams = conn.getParameters();
        if (tmParams != null) {
            tmParams.fromString(connectorParams);
        }
        return this.addAndInitializeResource(conn, resourceName == null ? conn.getName() : resourceName, tmParams);
    }

    public void setEnabled(int resourceId, boolean enabled) {
        this.resList.get((Object)Integer.valueOf((int)resourceId)).enabled = enabled;
    }

    public void remove(int resourceId) {
        this.resList.remove(resourceId);
    }

    public IQuery getInterface(int resourceId) {
        return this.resList.get((Object)Integer.valueOf((int)resourceId)).query;
    }

    public ResourceItem getResource(int resourceId) {
        return this.resList.get(resourceId);
    }

    public String getName(int resourceId) {
        return this.resList.get((Object)Integer.valueOf((int)resourceId)).name;
    }

    public Map<Integer, ResourceItem> getResources() {
        return this.resList;
    }

    public void close() {
        for (ResourceItem ri : this.resList.values()) {
            ri.query.close();
        }
    }

    public List<QueryResult> getResults() {
        return this.results;
    }

    public void rewind() {
        this.current = this.results.size() > 0 ? 0 : -1;
    }

    public boolean hasNext() {
        if (this.current >= this.results.size()) {
            this.current = -1;
        }
        return this.current > -1;
    }

    public QueryResult next() {
        if (this.current > -1 && this.current < this.results.size()) {
            ++this.current;
            return this.results.get(this.current - 1);
        }
        this.current = -1;
        return null;
    }

    public int query(String plainText) {
        this.results.clear();
        int resources = 0;
        for (int id : this.resList.keySet()) {
            ResourceItem ri = this.resList.get(id);
            if (!ri.enabled || ri.query.query(plainText) <= 0) continue;
            QueryResult res = null;
            while (ri.query.hasNext()) {
                res = ri.query.next();
                res.connectorId = id;
                if (res.score < this.threshold) break;
                this.results.add(res);
            }
            if (res == null) continue;
            ++resources;
        }
        this.results = QueryUtil.removeDuplicates(this.results);
        if (this.results.size() > 0) {
            this.current = 0;
        }
        return this.results.size();
    }

    public int query(TextFragment text) {
        this.results.clear();
        int resources = 0;
        for (int id : this.resList.keySet()) {
            ResourceItem ri = this.resList.get(id);
            if (!ri.enabled || ri.query.query(text) <= 0) continue;
            QueryResult res = null;
            while (ri.query.hasNext()) {
                res = ri.query.next();
                if (res.score < this.threshold) break;
                res.connectorId = id;
                this.results.add(res);
            }
            if (res == null) continue;
            ++resources;
        }
        this.results = QueryUtil.removeDuplicates(this.results);
        if (this.results.size() > 0) {
            this.current = 0;
        }
        return this.results.size();
    }

    public void setAttribute(String name, String value) {
        this.attributes.put(name, value);
        for (ResourceItem ri : this.resList.values()) {
            ri.query.setAttribute(name, value);
        }
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
        for (ResourceItem ri : this.resList.values()) {
            ri.query.removeAttribute(name);
        }
    }

    public void clearAttributes() {
        this.attributes.clear();
        for (ResourceItem ri : this.resList.values()) {
            ri.query.clearAttributes();
        }
    }

    public void setLanguages(LocaleId sourceLocale, LocaleId targetLocale) {
        this.srcLoc = sourceLocale;
        this.trgLoc = targetLocale;
        for (ResourceItem ri : this.resList.values()) {
            ri.query.setLanguages(this.srcLoc, this.trgLoc);
        }
    }

    public LocaleId getSourceLanguage() {
        return this.srcLoc;
    }

    public LocaleId getTargetLanguage() {
        return this.trgLoc;
    }

    public void setThreshold(int value) {
        this.threshold = value;
        for (ResourceItem ri : this.resList.values()) {
            if (!(ri.query instanceof ITMQuery)) continue;
            ((ITMQuery)ri.query).setThreshold(this.threshold);
        }
    }

    public void setMaximumHits(int max) {
        this.maxHits = max;
        for (ResourceItem ri : this.resList.values()) {
            if (!(ri.query instanceof ITMQuery)) continue;
            ((ITMQuery)ri.query).setMaximumHits(this.maxHits);
        }
    }

    public void setRootDirectory(String rootDir) {
        this.rootDir = rootDir;
        for (ResourceItem ri : this.resList.values()) {
            ri.query.setRootDirectory(this.rootDir);
        }
    }

    public void leverage(TextUnit tu, int thresholdToFill, boolean downgradeIdenticalBestMatches) {
        if (!tu.isTranslatable()) {
            return;
        }
        this.totalSegments += tu.getSource().getSegments().count();
        for (int id : this.resList.keySet()) {
            ResourceItem ri = this.resList.get(id);
            if (!ri.enabled) continue;
            ri.query.leverage(tu);
        }
        AltTranslationsAnnotation altTrans = null;
        AltTranslation bestMatch = null;
        for (LocaleId loc : tu.getTargetLocales()) {
            TextContainer tc = tu.getTarget(loc);
            if (tc == null) continue;
            altTrans = tc.getAnnotation(AltTranslationsAnnotation.class);
            if (altTrans != null) {
                altTrans.sort();
                bestMatch = altTrans.getFirst();
                if (bestMatch != null) {
                    if (bestMatch.getScore() >= 100) {
                        ++this.exactBestMatches;
                    } else if (bestMatch.getScore() > 0) {
                        ++this.fuzzyBestMatches;
                    }
                    if (bestMatch.getScore() >= thresholdToFill) {
                        tu.setTargetContent(this.getTargetLanguage(), bestMatch.getTarget().getFirstContent());
                    }
                    if (downgradeIdenticalBestMatches) {
                        altTrans.downgradeIdenticalBestMatches(false, this.threshold);
                    }
                }
            }
            for (Segment ts : tc.getSegments()) {
                altTrans = ts.getAnnotation(AltTranslationsAnnotation.class);
                if (altTrans == null) continue;
                altTrans.sort();
                bestMatch = altTrans.getFirst();
                if (bestMatch == null) continue;
                if (bestMatch.getScore() >= 100) {
                    ++this.exactBestMatches;
                } else if (bestMatch.getScore() > 0) {
                    ++this.fuzzyBestMatches;
                }
                if (bestMatch.getScore() >= thresholdToFill) {
                    ts.text = bestMatch.getTarget().getFirstContent();
                }
                if (!downgradeIdenticalBestMatches) continue;
                altTrans.downgradeIdenticalBestMatches(false, this.threshold);
            }
        }
    }

    public void resetCounters() {
        this.totalSegments = 0;
        this.exactBestMatches = 0;
        this.fuzzyBestMatches = 0;
    }

    public int getTotalSegments() {
        return this.totalSegments;
    }

    public int getExactBestMatches() {
        return this.exactBestMatches;
    }

    public int getFuzzyBestMatches() {
        return this.fuzzyBestMatches;
    }
}

