/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.translation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.common.HTMLCharacterEntities;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.filterwriter.XLIFFContent;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.lib.translation.QueryResult;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class QueryUtil {
    private static final Pattern HTML_OPENCLOSE = Pattern.compile("(\\<s(\\s+)id=['\"](.*?)['\"]>)|(\\</s\\>)", 2);
    private static final Pattern HTML_ISOLATED = Pattern.compile("\\<br(\\s+)id=['\"](.*?)['\"](\\s*?)/>", 2);
    private static final Pattern HTML_SPAN = Pattern.compile("\\<span\\s(.*?)>|\\</span>", 2);
    private static final Pattern NCR = Pattern.compile("&#(\\S+?);");
    private static final Pattern CER = Pattern.compile("(&\\w*?;)");
    private StringBuilder codesMarkers = new StringBuilder();
    private List<Code> codes;
    private XLIFFContent fmt = new XLIFFContent();
    private HTMLCharacterEntities entities;

    public boolean hasCode() {
        if (this.codes == null) {
            return false;
        }
        return this.codes.size() > 0;
    }

    public String separateCodesFromText(TextFragment frag) {
        this.codesMarkers.setLength(0);
        this.codes = frag.getCodes();
        String text = frag.getCodedText();
        if (!frag.hasCode()) {
            return text;
        }
        StringBuilder tmp = new StringBuilder();
        block3: for (int i = 0; i < text.length(); ++i) {
            switch (text.charAt(i)) {
                case '\ue101': 
                case '\ue102': 
                case '\ue103': {
                    this.codesMarkers.append(text.charAt(i));
                    this.codesMarkers.append(text.charAt(++i));
                    continue block3;
                }
                default: {
                    tmp.append(text.charAt(i));
                }
            }
        }
        return tmp.toString();
    }

    public TextFragment createNewFragmentWithCodes(String plainText) {
        return new TextFragment(plainText + this.codesMarkers, this.codes);
    }

    public String toCodedHTML(TextFragment fragment) {
        if (fragment == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        String text = fragment.getCodedText();
        block7: for (int i = 0; i < text.length(); ++i) {
            switch (text.charAt(i)) {
                case '\ue101': {
                    Code code = fragment.getCode(text.charAt(++i));
                    sb.append(String.format("<s id='%d'>", code.getId()));
                    continue block7;
                }
                case '\ue102': {
                    ++i;
                    sb.append("</s>");
                    continue block7;
                }
                case '\ue103': {
                    Code code = fragment.getCode(text.charAt(++i));
                    sb.append(String.format("<br id='%d'/>", code.getId()));
                    continue block7;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                default: {
                    sb.append(text.charAt(i));
                }
            }
        }
        return sb.toString();
    }

    public String fromCodedHTML(String text, TextFragment fragment) {
        int val;
        Matcher m;
        if (Util.isEmpty(text)) {
            return "";
        }
        text = text.toString().replace("&apos;", "'");
        text = text.replace("&lt;", "<");
        text = text.replace("&gt;", ">");
        text = text.replace("&quot;", "\"");
        StringBuilder sb = new StringBuilder();
        sb.append(text.replace("&amp;", "&"));
        if (this.entities == null) {
            this.entities = new HTMLCharacterEntities();
            this.entities.ensureInitialization(false);
        }
        ArrayList<String> newCodes = new ArrayList<String>();
        ArrayList<String> oriCodes = new ArrayList<String>();
        for (Code code : fragment.getCodes()) {
            switch (code.getTagType()) {
                case OPENING: {
                    oriCodes.add(String.format("o%d", code.getId()));
                    break;
                }
                case CLOSING: {
                    oriCodes.add(String.format("c%d", code.getId()));
                    break;
                }
                case PLACEHOLDER: {
                    oriCodes.add(String.format("i%d", code.getId()));
                }
            }
        }
        while ((m = CER.matcher(sb.toString())).find() && (val = this.entities.lookupReference(m.group(0))) != -1) {
            sb.replace(m.start(0), m.end(0), String.valueOf((char)val));
        }
        m = NCR.matcher(sb.toString());
        while (m.find()) {
            String val2 = m.group(1);
            int n = 63;
            try {
                n = val2.charAt(0) == 'x' ? Integer.valueOf(m.group(1).substring(1), 16).intValue() : Integer.valueOf(m.group(1)).intValue();
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            sb.replace(m.start(0), m.end(0), String.valueOf((char)n));
            m = NCR.matcher(sb.toString());
        }
        m = HTML_OPENCLOSE.matcher(sb.toString());
        Stack<Integer> stack = new Stack<Integer>();
        while (m.find()) {
            String markers;
            if (m.group(1) != null) {
                int id = Util.strToInt(m.group(3), -1);
                markers = String.format("%c%c", 57601, Character.valueOf(TextFragment.toChar(fragment.getIndex(id))));
                sb.replace(m.start(), m.end(), markers);
                stack.push(id);
                newCodes.add(String.format("o%d", id));
            } else {
                if (stack.isEmpty()) {
                    markers = "";
                } else {
                    newCodes.add(String.format("c%d", stack.peek()));
                    markers = String.format("%c%c", 57602, Character.valueOf(TextFragment.toChar(fragment.getIndexForClosing((Integer)stack.pop()))));
                }
                sb.replace(m.start(), m.end(), markers);
            }
            m = HTML_OPENCLOSE.matcher(sb.toString());
        }
        m = HTML_ISOLATED.matcher(sb.toString());
        while (m.find()) {
            int id = Util.strToInt(m.group(2), -1);
            String markers = String.format("%c%c", 57603, Character.valueOf(TextFragment.toChar(fragment.getIndex(id))));
            sb.replace(m.start(), m.end(), markers);
            m = HTML_ISOLATED.matcher(sb.toString());
            newCodes.add(String.format("i%d", id));
        }
        m = HTML_SPAN.matcher(sb.toString());
        while (m.find()) {
            sb.replace(m.start(), m.end(), "");
            m = HTML_SPAN.matcher(sb.toString());
        }
        if (newCodes.size() < oriCodes.size()) {
            for (String tmp : oriCodes) {
                if (newCodes.contains(tmp)) continue;
                switch (tmp.charAt(0)) {
                    case 'o': {
                        sb.append(String.format("%c%c", 57601, Character.valueOf(TextFragment.toChar(fragment.getIndex(Integer.parseInt(tmp.substring(1)))))));
                        break;
                    }
                    case 'c': {
                        sb.append(String.format("%c%c", 57602, Character.valueOf(TextFragment.toChar(fragment.getIndexForClosing(Integer.parseInt(tmp.substring(1)))))));
                        break;
                    }
                    case 'i': {
                        sb.append(String.format("%c%c", 57603, Character.valueOf(TextFragment.toChar(fragment.getIndex(Integer.parseInt(tmp.substring(1)))))));
                    }
                }
            }
        }
        return sb.toString();
    }

    public String fromPlainTextHTML(String text) {
        int val;
        Matcher m;
        if (Util.isEmpty(text)) {
            return "";
        }
        text = text.toString().replace("&apos;", "'");
        text = text.replace("&lt;", "<");
        text = text.replace("&gt;", ">");
        text = text.replace("&quot;", "\"");
        StringBuilder sb = new StringBuilder();
        sb.append(text.replace("&amp;", "&"));
        if (this.entities == null) {
            this.entities = new HTMLCharacterEntities();
            this.entities.ensureInitialization(false);
        }
        while ((m = CER.matcher(sb.toString())).find() && (val = this.entities.lookupReference(m.group(0))) != -1) {
            sb.replace(m.start(0), m.end(0), String.valueOf((char)val));
        }
        m = NCR.matcher(sb.toString());
        while (m.find()) {
            String val2 = m.group(1);
            int n = 63;
            try {
                n = val2.charAt(0) == 'x' ? Integer.valueOf(m.group(1).substring(1), 16).intValue() : Integer.valueOf(m.group(1)).intValue();
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            sb.replace(m.start(0), m.end(0), String.valueOf((char)n));
            m = NCR.matcher(sb.toString());
        }
        return sb.toString();
    }

    public String toXLIFF(TextFragment fragment) {
        if (fragment == null) {
            return "";
        }
        this.fmt.setContent(fragment);
        return this.fmt.toString();
    }

    public TextFragment fromXLIFF(Element elem, TextFragment original) {
        NodeList list = elem.getChildNodes();
        int lastId = -1;
        int id = -1;
        Stack<Integer> stack = new Stack<Integer>();
        StringBuilder buffer = new StringBuilder();
        block4: for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            switch (node.getNodeType()) {
                case 3: {
                    buffer.append(node.getNodeValue());
                    continue block4;
                }
                case 1: {
                    NamedNodeMap map = node.getAttributes();
                    if (node.getNodeName().equals("bpt")) {
                        id = this.getRawIndex(lastId, map.getNamedItem("id"));
                        stack.push(id);
                        buffer.append(String.format("%c%c", 57601, Character.valueOf(TextFragment.toChar(original.getIndex(id)))));
                        continue block4;
                    }
                    if (node.getNodeName().equals("ept")) {
                        buffer.append(String.format("%c%c", 57602, Character.valueOf(TextFragment.toChar(original.getIndexForClosing((Integer)stack.pop())))));
                        continue block4;
                    }
                    if (node.getNodeName().equals("ph")) {
                        id = this.getRawIndex(lastId, map.getNamedItem("id"));
                        buffer.append(String.format("%c%c", 57603, Character.valueOf(TextFragment.toChar(original.getIndex(id)))));
                        continue block4;
                    }
                    if (!node.getNodeName().equals("it")) continue block4;
                    Node pos = map.getNamedItem("pos");
                    if (pos == null) {
                        id = this.getRawIndex(lastId, map.getNamedItem("id"));
                        buffer.append(String.format("%c%c", 57603, Character.valueOf(TextFragment.toChar(original.getIndex(id)))));
                        continue block4;
                    }
                    if (pos.getNodeValue().equals("begin")) {
                        id = this.getRawIndex(lastId, map.getNamedItem("id"));
                        buffer.append(String.format("%c%c", 57601, Character.valueOf(TextFragment.toChar(original.getIndex(id)))));
                        continue block4;
                    }
                    id = this.getRawIndex(lastId, map.getNamedItem("id"));
                    buffer.append(String.format("%c%c", 57602, Character.valueOf(TextFragment.toChar(original.getIndexForClosing(id)))));
                }
            }
        }
        return new TextFragment(buffer.toString(), original.getCodes());
    }

    public static ArrayList<QueryResult> removeDuplicates(List<QueryResult> queryResults) {
        LinkedHashSet<QueryResult> dupRemove = new LinkedHashSet<QueryResult>(queryResults.size());
        Collections.sort(queryResults);
        for (QueryResult qr : queryResults) {
            dupRemove.add(qr);
        }
        return new ArrayList<QueryResult>(dupRemove);
    }

    private int getRawIndex(int lastIndex, Node attr) {
        if (attr == null) {
            return ++lastIndex;
        }
        return Integer.valueOf(attr.getNodeValue());
    }
}

