/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.batchtranslation;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.Source;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.ISegmenter;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.XMLWriter;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filterwriter.TMXWriter;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.lib.segmentation.SRXDocument;
import net.sf.okapi.lib.translation.QueryUtil;
import net.sf.okapi.steps.batchtranslation.Parameters;
import net.sf.okapi.steps.batchtranslation.SimpleStore;
import net.sf.okapi.steps.batchtranslation.StreamGobbler;
import net.sf.okapi.tm.pensieve.common.TranslationUnit;
import net.sf.okapi.tm.pensieve.common.TranslationUnitVariant;
import net.sf.okapi.tm.pensieve.seeker.ITmSeeker;
import net.sf.okapi.tm.pensieve.seeker.TmSeekerFactory;
import net.sf.okapi.tm.pensieve.writer.ITmWriter;
import net.sf.okapi.tm.pensieve.writer.TmWriterFactory;

public class BatchTranslator {
    private static final Logger LOGGER = Logger.getLogger(BatchTranslator.class.getName());
    private IFilterConfigurationMapper fcMapper;
    private IFilter filter;
    private RawDocument rawDoc;
    private QueryUtil qutil;
    private File htmlSourceFile;
    private File htmlTargetFile;
    private File originalStoreFile;
    private Parameters params;
    private ITmWriter tmWriter;
    private TMXWriter tmxWriter;
    private LocaleId srcLoc;
    private LocaleId trgLoc;
    private int subDocId;
    private int currentSubDocId;
    private boolean initDone;
    private Map<String, String> attributes;
    private SimpleStore store;
    private ITmSeeker existingTm;
    private ITmSeeker currentTm;
    private int docInternalMatches;
    private int totalInternalMatches;
    private int docExternalMatches;
    private int totalExternalMatches;
    private int docEntries;
    private int totalEntries;
    private ISegmenter segmenter;
    private String rootDir;

    public BatchTranslator(IFilterConfigurationMapper fcMapper, Parameters params, String rootDir) {
        this.fcMapper = fcMapper;
        this.params = params;
        this.rootDir = rootDir;
        if (this.params == null) {
            this.params = new Parameters();
        }
        this.qutil = new QueryUtil();
        this.initDone = false;
    }

    protected void finalize() {
        this.closeAll();
    }

    private void closeAll() {
        if (this.tmxWriter != null) {
            this.tmxWriter.writeEndDocument();
            this.tmxWriter.close();
            this.tmxWriter = null;
        }
        if (this.existingTm != null) {
            this.existingTm.close();
            this.existingTm = null;
        }
        if (this.currentTm != null) {
            this.currentTm.close();
            this.currentTm = null;
        }
        this.initDone = false;
    }

    public void endBatch() {
        LOGGER.info("");
        if (this.currentTm != null) {
            LOGGER.info(String.format("Total matches from TM being built = %d", this.totalInternalMatches));
            LOGGER.info(String.format("Total matches from existing TM = %d", this.totalExternalMatches));
        }
        LOGGER.info(String.format("Total entries sent to translation = %d", this.totalEntries));
        this.closeAll();
    }

    private void initialize() {
        if (this.params.getMakeTMX()) {
            String tmxOutputPath = Util.fillRootDirectoryVariable(this.params.getTmxPath(), this.rootDir);
            tmxOutputPath = LocaleId.replaceVariables(tmxOutputPath, this.srcLoc, this.trgLoc);
            this.tmxWriter = new TMXWriter(tmxOutputPath);
            this.tmxWriter.writeStartDocument(this.srcLoc, this.trgLoc, this.getClass().getCanonicalName(), "1", "sentence", this.params.getMarkAsMT() ? "MT-based" : null, "unknown");
        }
        this.attributes = new Hashtable<String, String>();
        if (this.params.getMarkAsMT()) {
            this.attributes.put("creationid", "MT!");
        }
        if (!Util.isEmpty(this.params.getOrigin())) {
            this.attributes.put("Txt::Origin", this.params.getOrigin());
        }
        this.initDone = true;
        this.store = new SimpleStore();
        this.totalInternalMatches = 0;
        this.totalExternalMatches = 0;
        this.totalEntries = 0;
        if (this.params.getCheckExistingTm()) {
            String existingTMPath = Util.fillRootDirectoryVariable(this.params.getExistingTm(), this.rootDir);
            existingTMPath = LocaleId.replaceVariables(existingTMPath, this.srcLoc, this.trgLoc);
            this.existingTm = TmSeekerFactory.createFileBasedTmSeeker(existingTMPath);
        }
        this.segmenter = null;
        if (this.params.getSegment()) {
            SRXDocument srxDoc = new SRXDocument();
            String srxPath = Util.fillRootDirectoryVariable(this.params.getSrxPath(), this.rootDir);
            srxPath = LocaleId.replaceVariables(srxPath, this.srcLoc, this.trgLoc);
            srxDoc.loadRules(srxPath);
            this.segmenter = srxDoc.compileLanguageRules(this.srcLoc, null);
        }
    }

    public void processDocument(RawDocument rd) {
        this.rawDoc = rd;
        this.srcLoc = this.rawDoc.getSourceLocale();
        this.trgLoc = this.rawDoc.getTargetLocale();
        if (!this.initDone) {
            this.initialize();
        }
        this.filter = this.fcMapper.createFilter(rd.getFilterConfigId(), this.filter);
        if (this.filter == null) {
            throw new RuntimeException(String.format("No filter available for the configuration '%s'.", rd.getFilterConfigId()));
        }
        this.processInput();
    }

    private void processInput() {
        block28: {
            XMLWriter htmlWriter = null;
            try {
                this.filter.open(this.rawDoc);
                this.htmlSourceFile = File.createTempFile("hft_", ".html");
                if (this.htmlSourceFile != null) {
                    this.htmlSourceFile.deleteOnExit();
                }
                if (this.tmWriter != null) {
                    this.tmWriter.close();
                    this.tmWriter = null;
                }
                if (this.params.getMakeTM()) {
                    String tmDir = Util.fillRootDirectoryVariable(this.params.getTmDirectory(), this.rootDir);
                    tmDir = LocaleId.replaceVariables(tmDir, this.srcLoc, this.trgLoc);
                    Util.createDirectories(tmDir + File.separator);
                    File file = new File(tmDir + File.separator + "segments.gen");
                    this.tmWriter = TmWriterFactory.createFileBasedTmWriter(tmDir, !file.exists());
                    if (this.currentTm != null) {
                        this.currentTm.close();
                    }
                    this.currentTm = TmSeekerFactory.createFileBasedTmSeeker(tmDir);
                }
                this.docInternalMatches = 0;
                this.docExternalMatches = 0;
                this.docEntries = 0;
                int count = 0;
                int maxCount = this.params.getBlockSize();
                this.subDocId = 0;
                this.currentSubDocId = 0;
                block9: while (this.filter.hasNext()) {
                    Event event = this.filter.next();
                    switch (event.getEventType()) {
                        case START_SUBDOCUMENT: {
                            this.currentSubDocId = ++this.subDocId;
                            break;
                        }
                        case END_SUBDOCUMENT: {
                            this.currentSubDocId = 0;
                            break;
                        }
                        case TEXT_UNIT: {
                            TextUnit tu = (TextUnit)event.getResource();
                            if (!tu.isTranslatable()) continue block9;
                            TextContainer tc = tu.getSource();
                            if (this.segmenter != null && this.segmenter.computeSegments(tc) > 1) {
                                tc.getSegments().create(this.segmenter.getRanges());
                            }
                            if (htmlWriter == null) {
                                htmlWriter = this.startTemporaryFiles();
                            }
                            boolean atLeastOne = false;
                            for (Segment seg : tc.getSegments()) {
                                if (this.currentTm != null && this.currentTm.searchFuzzy(seg.text, 95, 1, null).size() > 0) {
                                    ++this.docInternalMatches;
                                    continue;
                                }
                                if (this.existingTm != null && this.existingTm.searchFuzzy(seg.text, 95, 1, null).size() > 0) {
                                    ++this.docExternalMatches;
                                    continue;
                                }
                                this.store.write(seg.text);
                                htmlWriter.writeStartElement("p");
                                htmlWriter.writeAttributeString("id", String.format("%d:%s:%s", this.currentSubDocId, tu.getId(), seg.id));
                                htmlWriter.writeRawXML(this.qutil.toCodedHTML(seg.text));
                                htmlWriter.writeEndElementLineBreak();
                                atLeastOne = true;
                                ++this.docEntries;
                            }
                            if (!atLeastOne) break;
                            ++count;
                        }
                    }
                    if (count < maxCount) continue;
                    this.finishTemporaryFiles(htmlWriter);
                    this.runBatchTranslation();
                    this.retrieveTranslation();
                    count = 0;
                    htmlWriter = null;
                }
                if (count > 0) {
                    this.finishTemporaryFiles(htmlWriter);
                    htmlWriter = null;
                    this.runBatchTranslation();
                    this.retrieveTranslation();
                } else {
                    this.finishTemporaryFiles(htmlWriter);
                    htmlWriter = null;
                }
                if (htmlWriter != null) {
                    this.finishTemporaryFiles(htmlWriter);
                }
                if (this.filter != null) {
                    this.filter.close();
                }
                if (this.tmWriter != null) {
                    this.tmWriter.close();
                }
                if (this.currentTm == null) break block28;
            }
            catch (Throwable e) {
                try {
                    throw new RuntimeException(String.format("Error when processing a file.\nSource='%s'\nTarget='%s'", this.htmlSourceFile.toURI(), this.htmlTargetFile.toURI()), e);
                }
                catch (Throwable throwable) {
                    if (htmlWriter != null) {
                        this.finishTemporaryFiles(htmlWriter);
                    }
                    if (this.filter != null) {
                        this.filter.close();
                    }
                    if (this.tmWriter != null) {
                        this.tmWriter.close();
                    }
                    if (this.currentTm != null) {
                        LOGGER.info(String.format("Existing matches from TM being built = %d", this.docInternalMatches));
                        LOGGER.info(String.format("Existing matches from existing TM = %d", this.docExternalMatches));
                    }
                    LOGGER.info(String.format("Entries sent to translation = %d", this.docEntries));
                    this.totalInternalMatches += this.docInternalMatches;
                    this.totalExternalMatches += this.docExternalMatches;
                    this.totalEntries += this.docEntries;
                    throw throwable;
                }
            }
            LOGGER.info(String.format("Existing matches from TM being built = %d", this.docInternalMatches));
            LOGGER.info(String.format("Existing matches from existing TM = %d", this.docExternalMatches));
        }
        LOGGER.info(String.format("Entries sent to translation = %d", this.docEntries));
        this.totalInternalMatches += this.docInternalMatches;
        this.totalExternalMatches += this.docExternalMatches;
        this.totalEntries += this.docEntries;
    }

    private XMLWriter startTemporaryFiles() {
        XMLWriter htmlWriter = new XMLWriter(this.htmlSourceFile.getPath());
        htmlWriter.writeStartElement("html");
        htmlWriter.writeStartElement("meta");
        htmlWriter.writeAttributeString("http-equiv", "Content-Type");
        htmlWriter.writeAttributeString("content", "text/html; charset=UTF-8");
        htmlWriter.writeEndElementLineBreak();
        String path = this.htmlSourceFile.getAbsolutePath();
        path = Util.getDirectoryName(path) + File.separator + Util.getFilename(path, false) + ".trg.html";
        this.htmlTargetFile = new File(path);
        if (this.htmlTargetFile.exists()) {
            this.htmlTargetFile.delete();
        }
        path = this.htmlSourceFile.getAbsolutePath();
        path = Util.getDirectoryName(path) + File.separator + Util.getFilename(path, false) + ".ori.bin";
        this.originalStoreFile = new File(path);
        this.store.create(this.originalStoreFile);
        return htmlWriter;
    }

    private void finishTemporaryFiles(XMLWriter htmlWriter) {
        if (htmlWriter != null) {
            htmlWriter.writeEndElement();
            htmlWriter.writeEndDocument();
            htmlWriter.close();
        }
        if (this.store != null) {
            this.store.close();
        }
    }

    private void runBatchTranslation() {
        String cmd = this.params.getCommand();
        try {
            cmd = cmd.replace("${inputURI}", this.htmlSourceFile.toString());
            cmd = cmd.replace("${inputPath}", this.htmlSourceFile.getPath());
            cmd = cmd.replace("${outputPath}", this.htmlTargetFile.getPath());
            cmd = cmd.replace("${rootDir}", this.rootDir);
            Locale loc = this.rawDoc.getSourceLocale().toJavaLocale();
            cmd = cmd.replace("${srcLangName}", loc.getDisplayLanguage(Locale.ENGLISH));
            loc = this.rawDoc.getTargetLocale().toJavaLocale();
            cmd = cmd.replace("${trgLangName}", loc.getDisplayLanguage(Locale.ENGLISH));
            cmd = LocaleId.replaceVariables(cmd, this.srcLoc, this.trgLoc);
            LOGGER.info("Command line: " + cmd);
            Process p = Runtime.getRuntime().exec(cmd);
            StreamGobbler errGobbler = new StreamGobbler(p.getErrorStream(), "err");
            StreamGobbler outGobbler = new StreamGobbler(p.getInputStream(), "out");
            errGobbler.start();
            outGobbler.start();
            p.waitFor();
        }
        catch (IOException e) {
            throw new RuntimeException("Error during the batch translation.\nCommand line was:\n" + cmd, e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Program interrupted.", e);
        }
    }

    private void retrieveTranslation() {
        Source html = null;
        try {
            this.store.openForRead(this.originalStoreFile);
            html = new Source(this.htmlTargetFile.toURI().toURL());
            html.fullSequentialParse();
            List<Element> paragraphs = html.getAllElements("p");
            for (Element elem : paragraphs) {
                TextFragment trgFrag;
                String id = elem.getAttributeValue("id");
                if (id == null) continue;
                String[] parts = id.split(":", -1);
                int htmlSubDocId = Integer.valueOf(parts[0]);
                String htmlTuId = parts[1];
                String htmlSegId = parts[2];
                TextFragment srcFrag = this.store.readNext();
                if (srcFrag == null) {
                    break;
                }
                try {
                    String ctext = this.qutil.fromCodedHTML(elem.getContent().toString(), srcFrag);
                    trgFrag = new TextFragment(ctext, srcFrag.getCodes());
                }
                catch (Throwable e) {
                    LOGGER.warning(String.format("Skipping entry '%d:%s:%s'.\n", htmlSubDocId, htmlTuId, htmlSegId) + e.getMessage());
                    continue;
                }
                if (this.tmWriter != null) {
                    TranslationUnit unit = new TranslationUnit(new TranslationUnitVariant(this.srcLoc, srcFrag), new TranslationUnitVariant(this.trgLoc, trgFrag));
                    this.tmWriter.indexTranslationUnit(unit);
                }
                if (this.tmxWriter == null) continue;
                this.tmxWriter.writeTU(srcFrag, trgFrag, null, this.attributes);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Error reading the translations.\nSource='%s'\nTarget='%s'", this.htmlSourceFile.toURI(), this.htmlTargetFile.toURI()), e);
        }
        finally {
            if (html != null) {
                html.clearCache();
            }
            this.htmlTargetFile.deleteOnExit();
            this.store.close();
        }
    }
}

