/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.common;

import java.io.File;
import java.util.ArrayList;
import java.util.logging.Logger;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.steps.common.ExtractionVerificationStepParameters;
import net.sf.okapi.steps.common.ExtractionVerificationUtil;

@UsingParameters(value=ExtractionVerificationStepParameters.class)
public class ExtractionVerificationStep
extends BasePipelineStep {
    private static final Logger LOGGER = Logger.getLogger(ExtractionVerificationStep.class.getName());
    private IFilter filter;
    private IFilterWriter writer;
    private IFilterConfigurationMapper fcMapper;
    private String filterConfigId;
    private ExtractionVerificationStepParameters params = new ExtractionVerificationStepParameters();

    @Override
    public void setParameters(IParameters params) {
        this.params = (ExtractionVerificationStepParameters)params;
    }

    @Override
    public ExtractionVerificationStepParameters getParameters() {
        return this.params;
    }

    @StepParameterMapping(parameterType=StepParameterType.FILTER_CONFIGURATION_MAPPER)
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
        this.fcMapper = fcMapper;
    }

    @StepParameterMapping(parameterType=StepParameterType.FILTER_CONFIGURATION_ID)
    public void setFilterConfigurationId(String filterConfigId) {
        this.filterConfigId = filterConfigId;
    }

    @Override
    public String getName() {
        return "Extraction Verification";
    }

    @Override
    public String getDescription() {
        return "Verifies a raw document can be extracted, merged, then extracted again and produces the same set of events during both extractions. Expects: raw document. Sends back: unmodified raw document.";
    }

    @Override
    protected Event handleRawDocument(Event event) {
        try {
            Event event1;
            if (Util.isEmpty(this.filterConfigId)) {
                Event event2 = event;
                return event2;
            }
            this.filter = this.fcMapper.createFilter(this.filterConfigId, this.filter);
            if (this.filter == null) {
                throw new RuntimeException("Unsupported filter type.");
            }
            RawDocument initialDoc = event.getRawDocument();
            this.filter.open(initialDoc);
            this.writer = this.filter.createFilterWriter();
            File outFile = File.createTempFile("okp-vx_", ".tmp");
            outFile.deleteOnExit();
            this.writer.setOutput(outFile.getAbsolutePath());
            this.writer.setOptions(initialDoc.getSourceLocale(), initialDoc.getEncoding());
            ArrayList<Event> firstEvents = new ArrayList<Event>();
            while (this.filter.hasNext()) {
                event1 = this.filter.next();
                firstEvents.add(event1);
                this.writer.handleEvent(event1);
            }
            this.writer.close();
            this.filter.close();
            RawDocument tmpDoc = new RawDocument(outFile.toURI(), initialDoc.getEncoding(), initialDoc.getSourceLocale());
            this.filter.open(tmpDoc);
            int i = 0;
            while (this.filter.hasNext()) {
                Event event2 = this.filter.next();
                if (i >= firstEvents.size()) {
                    ++i;
                    break;
                }
                if (this.identicalEvent(event1 = (Event)firstEvents.get(i++), event2)) continue;
                LOGGER.info("different events");
                break;
            }
            if (firstEvents.size() > i) {
                LOGGER.warning("Additional events found in the first run");
            } else if (i > firstEvents.size()) {
                LOGGER.warning("Additional events found in the second run");
            }
        }
        catch (Throwable e) {
            throw new RuntimeException("Error during extraction verification.\n" + e.getMessage(), e);
        }
        finally {
            this.closeFilterAndWriter();
        }
        return event;
    }

    private void closeFilterAndWriter() {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
        if (this.filter != null) {
            this.filter.close();
            this.filter = null;
        }
    }

    @Override
    public void destroy() {
        this.closeFilterAndWriter();
    }

    @Override
    public void cancel() {
        if (this.filter != null) {
            this.filter.cancel();
        }
    }

    private boolean identicalEvent(Event event1, Event event2) {
        if (event1 == null && event2 != null) {
            LOGGER.warning("Event from first run is null");
            return false;
        }
        if (event1 != null && event2 == null) {
            LOGGER.warning("Event from second run is null");
            return false;
        }
        if (event1 == null && event2 == null) {
            return true;
        }
        if (event1.getEventType() != event2.getEventType()) {
            LOGGER.warning("Event Types are different");
            return false;
        }
        switch (event1.getEventType()) {
            case START_DOCUMENT: {
                break;
            }
            case START_SUBDOCUMENT: {
                break;
            }
            case START_GROUP: {
                break;
            }
            case END_DOCUMENT: {
                break;
            }
            case END_SUBDOCUMENT: {
                break;
            }
            case END_GROUP: {
                break;
            }
            case DOCUMENT_PART: {
                break;
            }
            case TEXT_UNIT: {
                return ExtractionVerificationUtil.compareTextUnit(event1.getTextUnit(), event2.getTextUnit(), this.params.isCompareSkeleton());
            }
        }
        return true;
    }
}

