/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.common.createtarget;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;

@EditorFor(value=Parameters.class)
public class Parameters
extends BaseParameters
implements IEditorDescriptionProvider {
    private static final String COPYCONTENT = "copyContent";
    private static final String COPYPROPERTIES = "copyProperties";
    private static final String OVERWRITEEXISTING = "overwriteExisting";
    private static final String CREATEONNONTRANSLATABLE = "createOnNonTranslatable";
    private boolean copyProperties;
    private boolean copyContent;
    private boolean overwriteExisting;
    private boolean createOnNonTranslatable;

    public Parameters() {
        this.reset();
    }

    @Override
    public void reset() {
        this.copyProperties = true;
        this.copyContent = true;
        this.overwriteExisting = false;
        this.createOnNonTranslatable = true;
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.copyProperties = this.buffer.getBoolean(COPYPROPERTIES, this.copyProperties);
        this.copyContent = this.buffer.getBoolean(COPYCONTENT, this.copyContent);
        this.overwriteExisting = this.buffer.getBoolean(OVERWRITEEXISTING, this.overwriteExisting);
        this.createOnNonTranslatable = this.buffer.getBoolean(CREATEONNONTRANSLATABLE, this.createOnNonTranslatable);
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setBoolean(COPYPROPERTIES, this.copyProperties);
        this.buffer.setBoolean(COPYCONTENT, this.copyContent);
        this.buffer.setBoolean(OVERWRITEEXISTING, this.overwriteExisting);
        this.buffer.setBoolean(CREATEONNONTRANSLATABLE, this.createOnNonTranslatable);
        return this.buffer.toString();
    }

    public boolean isCopyProperties() {
        return this.copyProperties;
    }

    public void setCopyProperties(boolean copyProperties) {
        this.copyProperties = copyProperties;
    }

    public boolean isCopyContent() {
        return this.copyContent;
    }

    public void setCopyContent(boolean copyContent) {
        this.copyContent = copyContent;
    }

    public boolean isOverwriteExisting() {
        return this.overwriteExisting;
    }

    public void setOverwriteExisting(boolean overwriteExisting) {
        this.overwriteExisting = overwriteExisting;
    }

    public boolean isCreateOnNonTranslatable() {
        return this.createOnNonTranslatable;
    }

    public void setCreateOnNonTranslatable(boolean createOnNonTranslatable) {
        this.createOnNonTranslatable = createOnNonTranslatable;
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(COPYCONTENT, "Copy the source content to the target", null);
        desc.add(COPYPROPERTIES, "Copy the source properties to the target", null);
        desc.add(OVERWRITEEXISTING, "Overwrite the current target content", null);
        desc.add(CREATEONNONTRANSLATABLE, "Creates target for non-translatable text units", null);
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("Create Target", true, false);
        desc.addCheckboxPart(paramsDesc.get(COPYCONTENT));
        desc.addCheckboxPart(paramsDesc.get(COPYPROPERTIES));
        desc.addSeparatorPart();
        desc.addCheckboxPart(paramsDesc.get(OVERWRITEEXISTING));
        desc.addSeparatorPart();
        desc.addCheckboxPart(paramsDesc.get(CREATEONNONTRANSLATABLE));
        return desc;
    }
}

