/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.desegmentation;

import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;

@EditorFor(value=Parameters.class)
public class Parameters
extends BaseParameters
implements IEditorDescriptionProvider {
    private static final String DESEGMENTSOURCE = "desegmentSource";
    private static final String DESEGMENTTARGET = "desegmentTarget";
    private boolean desegmentSource;
    private boolean desegmentTarget;

    public Parameters() {
        this.reset();
    }

    public boolean getDesegmentSource() {
        return this.desegmentSource;
    }

    public void setDesegmentSource(boolean desegmentSource) {
        this.desegmentSource = desegmentSource;
    }

    public boolean getDesegmentTarget() {
        return this.desegmentTarget;
    }

    public void setDesegmentTarget(boolean desegmentTarget) {
        this.desegmentTarget = desegmentTarget;
    }

    @Override
    public void reset() {
        this.desegmentSource = true;
        this.desegmentTarget = true;
    }

    @Override
    public void fromString(String data) {
        this.reset();
        this.buffer.fromString(data);
        this.desegmentSource = this.buffer.getBoolean(DESEGMENTSOURCE, this.desegmentSource);
        this.desegmentTarget = this.buffer.getBoolean(DESEGMENTTARGET, this.desegmentTarget);
    }

    @Override
    public String toString() {
        this.buffer.reset();
        this.buffer.setBoolean(DESEGMENTSOURCE, this.desegmentSource);
        this.buffer.setBoolean(DESEGMENTTARGET, this.desegmentTarget);
        return this.buffer.toString();
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(DESEGMENTSOURCE, "Join all segments of the source text", null);
        desc.add(DESEGMENTTARGET, "Join all segments of the target text", null);
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramDesc) {
        EditorDescription desc = new EditorDescription("Desegmentation");
        desc.addCheckboxPart(paramDesc.get(DESEGMENTSOURCE));
        desc.addCheckboxPart(paramDesc.get(DESEGMENTTARGET));
        return desc;
    }
}

