/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.diffleverage;

import java.util.Comparator;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.lib.search.lucene.analysis.AlphabeticNgramTokenizer;
import net.sf.okapi.lib.search.lucene.scorer.Util;

public class FuzzyTextUnitComparator
implements Comparator<TextUnit> {
    private static final int NGRAM_SIZE = 3;
    private boolean codeSensitive;
    private int threshold;
    private final AlphabeticNgramTokenizer tokenizer;

    public FuzzyTextUnitComparator(boolean codeSensitive, int threshold, LocaleId localeId) {
        this.codeSensitive = codeSensitive;
        this.setThreshold(threshold);
        this.tokenizer = Util.createNgramTokenizer(3, localeId);
    }

    public void setCodeSensitive(boolean codeSensitive) {
        this.codeSensitive = codeSensitive;
    }

    public boolean isCodeSensitive() {
        return this.codeSensitive;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public float getThreshold() {
        return this.threshold;
    }

    @Override
    public int compare(TextUnit oldTextUnit, TextUnit newTextUnit) {
        if (oldTextUnit.isReferent() && !newTextUnit.isReferent()) {
            return -1;
        }
        if (!oldTextUnit.isReferent() && newTextUnit.isReferent()) {
            return 1;
        }
        int result = oldTextUnit.getSource().compareTo(newTextUnit.getSource(), this.codeSensitive);
        if (result == 0) {
            return result;
        }
        return this.fuzzyCompare(oldTextUnit, newTextUnit, result);
    }

    private int fuzzyCompare(TextUnit oldSource, TextUnit newSource, int exactCompareResult) {
        float score = Util.calculateNgramDiceCoefficient(oldSource.getSource().getUnSegmentedContentCopy().getText(), newSource.getSource().getUnSegmentedContentCopy().getText(), this.tokenizer);
        if (score >= (float)this.threshold) {
            return 0;
        }
        return exactCompareResult;
    }
}

