/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.fullwidthconversion;

import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.steps.fullwidthconversion.Parameters;

@UsingParameters(value=Parameters.class)
public class FullWidthConversionStep
extends BasePipelineStep {
    private Parameters params = new Parameters();
    private LocaleId targetLocale;

    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALE)
    public void setTargetLocale(LocaleId targetLocale) {
        this.targetLocale = targetLocale;
    }

    @Override
    public String getName() {
        return "Full-Width Conversion";
    }

    @Override
    public String getDescription() {
        return "Convert the text units content of a document to or from full-width characters (zenkaku). Expects: filter events. Sends back: filter events.";
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    protected Event handleTextUnit(Event event) {
        TextUnit tu = (TextUnit)event.getResource();
        if (!tu.isTranslatable()) {
            return event;
        }
        TextContainer tc = tu.createTarget(this.targetLocale, false, 7);
        for (TextPart part : tc) {
            this.processFragment(part.getContent());
        }
        return event;
    }

    private void processFragment(TextFragment frag) {
        String text = frag.getCodedText();
        StringBuilder sb = new StringBuilder(text);
        if (this.params.toHalfWidth) {
            block271: for (int i = 0; i < sb.length(); ++i) {
                char ch = sb.charAt(i);
                if (TextFragment.isMarker(ch)) {
                    ++i;
                    continue;
                }
                if (ch >= '\uff01' && ch <= '\uff5e') {
                    sb.setCharAt(i, (char)(ch - 65248));
                    continue;
                }
                if (ch > '\u3131' && ch <= '\u314e') {
                    sb.setCharAt(i, (char)(ch + 52848));
                    continue;
                }
                switch (ch) {
                    case '\u3002': {
                        sb.setCharAt(i, '\uff61');
                        break;
                    }
                    case '\u300c': {
                        sb.setCharAt(i, '\uff62');
                        break;
                    }
                    case '\u300d': {
                        sb.setCharAt(i, '\uff63');
                        break;
                    }
                    case '\u3001': {
                        sb.setCharAt(i, '\uff64');
                        break;
                    }
                    case '\u30fb': {
                        sb.setCharAt(i, '\uff65');
                        break;
                    }
                    case '\u30f2': {
                        sb.setCharAt(i, '\uff66');
                        break;
                    }
                    case '\u30a1': {
                        sb.setCharAt(i, '\uff67');
                        break;
                    }
                    case '\u30a3': {
                        sb.setCharAt(i, '\uff68');
                        break;
                    }
                    case '\u30a5': {
                        sb.setCharAt(i, '\uff69');
                        break;
                    }
                    case '\u30a7': {
                        sb.setCharAt(i, '\uff6a');
                        break;
                    }
                    case '\u30a9': {
                        sb.setCharAt(i, '\uff6b');
                        break;
                    }
                    case '\u30e3': {
                        sb.setCharAt(i, '\uff6c');
                        break;
                    }
                    case '\u30e5': {
                        sb.setCharAt(i, '\uff6d');
                        break;
                    }
                    case '\u30e7': {
                        sb.setCharAt(i, '\uff6e');
                        break;
                    }
                    case '\u30c3': {
                        sb.setCharAt(i, '\uff6f');
                        break;
                    }
                    case '\u30fc': {
                        sb.setCharAt(i, '\uff70');
                        break;
                    }
                    case '\u30a2': {
                        sb.setCharAt(i, '\uff71');
                        break;
                    }
                    case '\u30a4': {
                        sb.setCharAt(i, '\uff72');
                        break;
                    }
                    case '\u30a6': {
                        sb.setCharAt(i, '\uff73');
                        break;
                    }
                    case '\u30a8': {
                        sb.setCharAt(i, '\uff74');
                        break;
                    }
                    case '\u30aa': {
                        sb.setCharAt(i, '\uff75');
                        break;
                    }
                    case '\u30ab': {
                        sb.setCharAt(i, '\uff76');
                        break;
                    }
                    case '\u30ad': {
                        sb.setCharAt(i, '\uff77');
                        break;
                    }
                    case '\u30af': {
                        sb.setCharAt(i, '\uff78');
                        break;
                    }
                    case '\u30b1': {
                        sb.setCharAt(i, '\uff79');
                        break;
                    }
                    case '\u30b3': {
                        sb.setCharAt(i, '\uff7a');
                        break;
                    }
                    case '\u30b5': {
                        sb.setCharAt(i, '\uff7b');
                        break;
                    }
                    case '\u30b7': {
                        sb.setCharAt(i, '\uff7c');
                        break;
                    }
                    case '\u30b9': {
                        sb.setCharAt(i, '\uff7d');
                        break;
                    }
                    case '\u30bb': {
                        sb.setCharAt(i, '\uff7e');
                        break;
                    }
                    case '\u30bd': {
                        sb.setCharAt(i, '\uff7f');
                        break;
                    }
                    case '\u30bf': {
                        sb.setCharAt(i, '\uff80');
                        break;
                    }
                    case '\u30c1': {
                        sb.setCharAt(i, '\uff81');
                        break;
                    }
                    case '\u30c4': {
                        sb.setCharAt(i, '\uff82');
                        break;
                    }
                    case '\u30c6': {
                        sb.setCharAt(i, '\uff83');
                        break;
                    }
                    case '\u30c8': {
                        sb.setCharAt(i, '\uff84');
                        break;
                    }
                    case '\u30ca': {
                        sb.setCharAt(i, '\uff85');
                        break;
                    }
                    case '\u30cb': {
                        sb.setCharAt(i, '\uff86');
                        break;
                    }
                    case '\u30cc': {
                        sb.setCharAt(i, '\uff87');
                        break;
                    }
                    case '\u30cd': {
                        sb.setCharAt(i, '\uff88');
                        break;
                    }
                    case '\u30ce': {
                        sb.setCharAt(i, '\uff89');
                        break;
                    }
                    case '\u30cf': {
                        sb.setCharAt(i, '\uff8a');
                        break;
                    }
                    case '\u30d2': {
                        sb.setCharAt(i, '\uff8b');
                        break;
                    }
                    case '\u30d5': {
                        sb.setCharAt(i, '\uff8c');
                        break;
                    }
                    case '\u30d8': {
                        sb.setCharAt(i, '\uff8d');
                        break;
                    }
                    case '\u30db': {
                        sb.setCharAt(i, '\uff8e');
                        break;
                    }
                    case '\u30de': {
                        sb.setCharAt(i, '\uff8f');
                        break;
                    }
                    case '\u30df': {
                        sb.setCharAt(i, '\uff90');
                        break;
                    }
                    case '\u30e0': {
                        sb.setCharAt(i, '\uff91');
                        break;
                    }
                    case '\u30e1': {
                        sb.setCharAt(i, '\uff92');
                        break;
                    }
                    case '\u30e2': {
                        sb.setCharAt(i, '\uff93');
                        break;
                    }
                    case '\u30e4': {
                        sb.setCharAt(i, '\uff94');
                        break;
                    }
                    case '\u30e6': {
                        sb.setCharAt(i, '\uff95');
                        break;
                    }
                    case '\u30e8': {
                        sb.setCharAt(i, '\uff96');
                        break;
                    }
                    case '\u30e9': {
                        sb.setCharAt(i, '\uff97');
                        break;
                    }
                    case '\u30ea': {
                        sb.setCharAt(i, '\uff98');
                        break;
                    }
                    case '\u30eb': {
                        sb.setCharAt(i, '\uff99');
                        break;
                    }
                    case '\u30ec': {
                        sb.setCharAt(i, '\uff9a');
                        break;
                    }
                    case '\u30ed': {
                        sb.setCharAt(i, '\uff9b');
                        break;
                    }
                    case '\u30ef': {
                        sb.setCharAt(i, '\uff9c');
                        break;
                    }
                    case '\u30f3': {
                        sb.setCharAt(i, '\uff9d');
                        break;
                    }
                    case '\u3099': {
                        sb.setCharAt(i, '\uff9e');
                        break;
                    }
                    case '\u309a': {
                        sb.setCharAt(i, '\uff9f');
                        break;
                    }
                    case '\u3164': {
                        sb.setCharAt(i, '\uffa0');
                        break;
                    }
                    case '\u3161': {
                        sb.setCharAt(i, '\uffda');
                        break;
                    }
                    case '\u3162': {
                        sb.setCharAt(i, '\uffdb');
                        break;
                    }
                    case '\u3163': {
                        sb.setCharAt(i, '\uffdc');
                        break;
                    }
                    case '\u2502': {
                        sb.setCharAt(i, '\uffe8');
                        break;
                    }
                    case '\u2190': {
                        sb.setCharAt(i, '\uffe9');
                        break;
                    }
                    case '\u2191': {
                        sb.setCharAt(i, '\uffea');
                        break;
                    }
                    case '\u2192': {
                        sb.setCharAt(i, '\uffeb');
                        break;
                    }
                    case '\u2193': {
                        sb.setCharAt(i, '\uffec');
                        break;
                    }
                    case '\u25a0': {
                        sb.setCharAt(i, '\uffed');
                        break;
                    }
                    case '\u25cb': {
                        sb.setCharAt(i, '\uffee');
                    }
                }
                if (this.params.includeLLS) {
                    switch (ch) {
                        case '\u2100': {
                            sb.setCharAt(i, 'a');
                            sb.insert(i + 1, "/c");
                            i += 2;
                            break;
                        }
                        case '\u2101': {
                            sb.setCharAt(i, 'a');
                            sb.insert(i + 1, "/s");
                            i += 2;
                            break;
                        }
                        case '\u2105': {
                            sb.setCharAt(i, 'c');
                            sb.insert(i + 1, "/o");
                            i += 2;
                            break;
                        }
                        case '\u2103': {
                            sb.setCharAt(i, '\u00b0');
                            sb.insert(i + 1, "C");
                            ++i;
                            break;
                        }
                        case '\u2109': {
                            sb.setCharAt(i, '\u00b0');
                            sb.insert(i + 1, "F");
                            ++i;
                            break;
                        }
                        case '\u2116': {
                            sb.setCharAt(i, 'N');
                            sb.insert(i + 1, "o");
                            ++i;
                            break;
                        }
                        case '\u212a': {
                            sb.setCharAt(i, 'K');
                            break;
                        }
                        case '\u212b': {
                            sb.setCharAt(i, '\u00c5');
                        }
                    }
                }
                if (!this.params.includeSLA) continue;
                switch (ch) {
                    case '\u3371': {
                        sb.setCharAt(i, 'h');
                        sb.insert(i + 1, "Pa");
                        i += 2;
                        continue block271;
                    }
                    case '\u3372': {
                        sb.setCharAt(i, 'd');
                        sb.insert(i + 1, "a");
                        ++i;
                        continue block271;
                    }
                    case '\u3373': {
                        sb.setCharAt(i, 'A');
                        sb.insert(i + 1, "U");
                        ++i;
                        continue block271;
                    }
                    case '\u3374': {
                        sb.setCharAt(i, 'b');
                        sb.insert(i + 1, "ar");
                        i += 2;
                        continue block271;
                    }
                    case '\u3375': {
                        sb.setCharAt(i, 'o');
                        sb.insert(i + 1, "V");
                        ++i;
                        continue block271;
                    }
                    case '\u3376': {
                        sb.setCharAt(i, 'p');
                        sb.insert(i + 1, "c");
                        ++i;
                        continue block271;
                    }
                    case '\u3377': {
                        sb.setCharAt(i, 'd');
                        sb.insert(i + 1, "m");
                        ++i;
                        continue block271;
                    }
                    case '\u3378': {
                        sb.setCharAt(i, 'd');
                        sb.insert(i + 1, "m\u00b2");
                        i += 2;
                        continue block271;
                    }
                    case '\u3379': {
                        sb.setCharAt(i, 'd');
                        sb.insert(i + 1, "m\u00b3");
                        i += 2;
                        continue block271;
                    }
                    case '\u337a': {
                        sb.setCharAt(i, 'I');
                        sb.insert(i + 1, "U");
                        ++i;
                        continue block271;
                    }
                    case '\u3380': {
                        sb.setCharAt(i, 'p');
                        sb.insert(i + 1, "A");
                        ++i;
                        continue block271;
                    }
                    case '\u3381': {
                        sb.setCharAt(i, 'n');
                        sb.insert(i + 1, "A");
                        ++i;
                        continue block271;
                    }
                    case '\u3382': {
                        sb.setCharAt(i, '\u03bc');
                        sb.insert(i + 1, "A");
                        ++i;
                        continue block271;
                    }
                    case '\u3383': {
                        sb.setCharAt(i, 'm');
                        sb.insert(i + 1, "A");
                        ++i;
                        continue block271;
                    }
                    case '\u3384': {
                        sb.setCharAt(i, 'k');
                        sb.insert(i + 1, "A");
                        ++i;
                        continue block271;
                    }
                    case '\u3385': {
                        sb.setCharAt(i, 'K');
                        sb.insert(i + 1, "B");
                        ++i;
                        continue block271;
                    }
                    case '\u3386': {
                        sb.setCharAt(i, 'M');
                        sb.insert(i + 1, "B");
                        ++i;
                        continue block271;
                    }
                    case '\u3387': {
                        sb.setCharAt(i, 'G');
                        sb.insert(i + 1, "B");
                        ++i;
                        continue block271;
                    }
                    case '\u3388': {
                        sb.setCharAt(i, 'c');
                        sb.insert(i + 1, "al");
                        i += 2;
                        continue block271;
                    }
                    case '\u3389': {
                        sb.setCharAt(i, 'k');
                        sb.insert(i + 1, "cal");
                        i += 3;
                        continue block271;
                    }
                    case '\u338a': {
                        sb.setCharAt(i, 'p');
                        sb.insert(i + 1, "F");
                        ++i;
                        continue block271;
                    }
                    case '\u338b': {
                        sb.setCharAt(i, 'n');
                        sb.insert(i + 1, "F");
                        ++i;
                        continue block271;
                    }
                    case '\u338c': {
                        sb.setCharAt(i, '\u03bc');
                        sb.insert(i + 1, "F");
                        ++i;
                        continue block271;
                    }
                    case '\u338d': {
                        sb.setCharAt(i, '\u03bc');
                        sb.insert(i + 1, "g");
                        ++i;
                        continue block271;
                    }
                    case '\u338e': {
                        sb.setCharAt(i, 'm');
                        sb.insert(i + 1, "g");
                        ++i;
                        continue block271;
                    }
                    case '\u338f': {
                        sb.setCharAt(i, 'k');
                        sb.insert(i + 1, "g");
                        ++i;
                        continue block271;
                    }
                    case '\u3390': {
                        sb.setCharAt(i, 'H');
                        sb.insert(i + 1, "z");
                        ++i;
                        continue block271;
                    }
                    case '\u3391': {
                        sb.setCharAt(i, 'k');
                        sb.insert(i + 1, "Hz");
                        i += 2;
                        continue block271;
                    }
                    case '\u3392': {
                        sb.setCharAt(i, 'M');
                        sb.insert(i + 1, "Hz");
                        i += 2;
                        continue block271;
                    }
                    case '\u3393': {
                        sb.setCharAt(i, 'G');
                        sb.insert(i + 1, "Hz");
                        i += 2;
                        continue block271;
                    }
                    case '\u3394': {
                        sb.setCharAt(i, 'T');
                        sb.insert(i + 1, "Hz");
                        i += 2;
                        continue block271;
                    }
                    case '\u3395': {
                        sb.setCharAt(i, '\u03bc');
                        sb.insert(i + 1, "\u2113");
                        ++i;
                        continue block271;
                    }
                    case '\u3396': {
                        sb.setCharAt(i, 'm');
                        sb.insert(i + 1, "\u2113");
                        ++i;
                        continue block271;
                    }
                    case '\u3397': {
                        sb.setCharAt(i, 'd');
                        sb.insert(i + 1, "\u2113");
                        ++i;
                        continue block271;
                    }
                    case '\u3398': {
                        sb.setCharAt(i, 'k');
                        sb.insert(i + 1, "\u2113");
                        ++i;
                        continue block271;
                    }
                    case '\u3399': {
                        sb.setCharAt(i, 'f');
                        sb.insert(i + 1, "m");
                        ++i;
                        continue block271;
                    }
                    case '\u339a': {
                        sb.setCharAt(i, 'n');
                        sb.insert(i + 1, "m");
                        ++i;
                        continue block271;
                    }
                    case '\u339b': {
                        sb.setCharAt(i, '\u03bc');
                        sb.insert(i + 1, "m");
                        ++i;
                        continue block271;
                    }
                    case '\u339c': {
                        sb.setCharAt(i, 'm');
                        sb.insert(i + 1, "m");
                        ++i;
                        continue block271;
                    }
                    case '\u339d': {
                        sb.setCharAt(i, 'c');
                        sb.insert(i + 1, "m");
                        ++i;
                        continue block271;
                    }
                    case '\u339e': {
                        sb.setCharAt(i, 'k');
                        sb.insert(i + 1, "m");
                        ++i;
                        continue block271;
                    }
                    case '\u339f': {
                        sb.setCharAt(i, 'm');
                        sb.insert(i + 1, "m\u00b2");
                        i += 2;
                        continue block271;
                    }
                    case '\u33a0': {
                        sb.setCharAt(i, 'c');
                        sb.insert(i + 1, "m\u00b2");
                        i += 2;
                        continue block271;
                    }
                    case '\u33a1': {
                        sb.setCharAt(i, 'm');
                        sb.insert(i + 1, "\u00b2");
                        ++i;
                        continue block271;
                    }
                    case '\u33a2': {
                        sb.setCharAt(i, 'k');
                        sb.insert(i + 1, "m\u00b2");
                        i += 2;
                        continue block271;
                    }
                    case '\u33a3': {
                        sb.setCharAt(i, 'm');
                        sb.insert(i + 1, "m\u00b3");
                        i += 2;
                        continue block271;
                    }
                    case '\u33a4': {
                        sb.setCharAt(i, 'c');
                        sb.insert(i + 1, "m\u00b3");
                        i += 2;
                        continue block271;
                    }
                    case '\u33a5': {
                        sb.setCharAt(i, 'm');
                        sb.insert(i + 1, "\u00b3");
                        ++i;
                        continue block271;
                    }
                    case '\u33a6': {
                        sb.setCharAt(i, 'k');
                        sb.insert(i + 1, "m\u00b3");
                        i += 2;
                        continue block271;
                    }
                    case '\u33a7': {
                        sb.setCharAt(i, 'm');
                        sb.insert(i + 1, "/s");
                        i += 2;
                        continue block271;
                    }
                    case '\u33a8': {
                        sb.setCharAt(i, 'm');
                        sb.insert(i + 1, "/s\u00b2");
                        i += 3;
                        continue block271;
                    }
                    case '\u33a9': {
                        sb.setCharAt(i, 'P');
                        sb.insert(i + 1, "a");
                        ++i;
                        continue block271;
                    }
                    case '\u33aa': {
                        sb.setCharAt(i, 'k');
                        sb.insert(i + 1, "Pa");
                        i += 2;
                        continue block271;
                    }
                    case '\u33ab': {
                        sb.setCharAt(i, 'M');
                        sb.insert(i + 1, "Pa");
                        i += 2;
                        continue block271;
                    }
                    case '\u33ac': {
                        sb.setCharAt(i, 'G');
                        sb.insert(i + 1, "Pa");
                        i += 2;
                        continue block271;
                    }
                    case '\u33ad': {
                        sb.setCharAt(i, 'r');
                        sb.insert(i + 1, "ad");
                        i += 2;
                        continue block271;
                    }
                    case '\u33ae': {
                        sb.setCharAt(i, 'r');
                        sb.insert(i + 1, "ad/s");
                        i += 4;
                        continue block271;
                    }
                    case '\u33af': {
                        sb.setCharAt(i, 'r');
                        sb.insert(i + 1, "ad/s\u00b2");
                        i += 5;
                        continue block271;
                    }
                    case '\u33b0': {
                        sb.setCharAt(i, 'p');
                        sb.insert(i + 1, "s");
                        ++i;
                        continue block271;
                    }
                    case '\u33b1': {
                        sb.setCharAt(i, 'n');
                        sb.insert(i + 1, "s");
                        ++i;
                        continue block271;
                    }
                    case '\u33b2': {
                        sb.setCharAt(i, '\u03bc');
                        sb.insert(i + 1, "s");
                        ++i;
                        continue block271;
                    }
                    case '\u33b3': {
                        sb.setCharAt(i, 'm');
                        sb.insert(i + 1, "s");
                        ++i;
                        continue block271;
                    }
                    case '\u33b4': {
                        sb.setCharAt(i, 'p');
                        sb.insert(i + 1, "V");
                        ++i;
                        continue block271;
                    }
                    case '\u33b5': {
                        sb.setCharAt(i, 'n');
                        sb.insert(i + 1, "V");
                        ++i;
                        continue block271;
                    }
                    case '\u33b6': {
                        sb.setCharAt(i, '\u03bc');
                        sb.insert(i + 1, "V");
                        ++i;
                        continue block271;
                    }
                    case '\u33b7': {
                        sb.setCharAt(i, 'm');
                        sb.insert(i + 1, "V");
                        ++i;
                        continue block271;
                    }
                    case '\u33b8': {
                        sb.setCharAt(i, 'k');
                        sb.insert(i + 1, "V");
                        ++i;
                        continue block271;
                    }
                    case '\u33b9': {
                        sb.setCharAt(i, 'M');
                        sb.insert(i + 1, "V");
                        ++i;
                        continue block271;
                    }
                    case '\u33ba': {
                        sb.setCharAt(i, 'p');
                        sb.insert(i + 1, "W");
                        ++i;
                        continue block271;
                    }
                    case '\u33bb': {
                        sb.setCharAt(i, 'n');
                        sb.insert(i + 1, "W");
                        ++i;
                        continue block271;
                    }
                    case '\u33bc': {
                        sb.setCharAt(i, '\u03bc');
                        sb.insert(i + 1, "W");
                        ++i;
                        continue block271;
                    }
                    case '\u33bd': {
                        sb.setCharAt(i, 'm');
                        sb.insert(i + 1, "W");
                        ++i;
                        continue block271;
                    }
                    case '\u33be': {
                        sb.setCharAt(i, 'k');
                        sb.insert(i + 1, "W");
                        ++i;
                        continue block271;
                    }
                    case '\u33bf': {
                        sb.setCharAt(i, 'M');
                        sb.insert(i + 1, "W");
                        ++i;
                        continue block271;
                    }
                    case '\u33c0': {
                        sb.setCharAt(i, 'k');
                        sb.insert(i + 1, "\u03a9");
                        ++i;
                        continue block271;
                    }
                    case '\u33c1': {
                        sb.setCharAt(i, 'M');
                        sb.insert(i + 1, "\u03a9");
                        ++i;
                        continue block271;
                    }
                    case '\u33c2': {
                        sb.setCharAt(i, 'a');
                        sb.insert(i + 1, ".m.");
                        i += 3;
                        continue block271;
                    }
                    case '\u33c3': {
                        sb.setCharAt(i, 'B');
                        sb.insert(i + 1, "q");
                        ++i;
                        continue block271;
                    }
                    case '\u33c4': {
                        sb.setCharAt(i, 'c');
                        sb.insert(i + 1, "c");
                        ++i;
                        continue block271;
                    }
                    case '\u33c5': {
                        sb.setCharAt(i, 'c');
                        sb.insert(i + 1, "d");
                        ++i;
                        continue block271;
                    }
                    case '\u33c6': {
                        sb.setCharAt(i, 'C');
                        sb.insert(i + 1, "/kg");
                        i += 3;
                        continue block271;
                    }
                    case '\u33c7': {
                        sb.setCharAt(i, 'C');
                        sb.insert(i + 1, "o.");
                        i += 2;
                        continue block271;
                    }
                    case '\u33c8': {
                        sb.setCharAt(i, 'd');
                        sb.insert(i + 1, "B");
                        ++i;
                        continue block271;
                    }
                    case '\u33c9': {
                        sb.setCharAt(i, 'G');
                        sb.insert(i + 1, "y");
                        ++i;
                        continue block271;
                    }
                    case '\u33ca': {
                        sb.setCharAt(i, 'h');
                        sb.insert(i + 1, "a");
                        ++i;
                        continue block271;
                    }
                    case '\u33cb': {
                        sb.setCharAt(i, 'H');
                        sb.insert(i + 1, "P");
                        ++i;
                        continue block271;
                    }
                    case '\u33cc': {
                        sb.setCharAt(i, 'i');
                        sb.insert(i + 1, "n");
                        ++i;
                        continue block271;
                    }
                    case '\u33cd': {
                        sb.setCharAt(i, 'K');
                        sb.insert(i + 1, "K");
                        ++i;
                        continue block271;
                    }
                    case '\u33ce': {
                        sb.setCharAt(i, 'K');
                        sb.insert(i + 1, "M");
                        ++i;
                        continue block271;
                    }
                    case '\u33cf': {
                        sb.setCharAt(i, 'K');
                        sb.insert(i + 1, "t");
                        ++i;
                        continue block271;
                    }
                    case '\u33d0': {
                        sb.setCharAt(i, 'l');
                        sb.insert(i + 1, "m");
                        ++i;
                        continue block271;
                    }
                    case '\u33d1': {
                        sb.setCharAt(i, 'l');
                        sb.insert(i + 1, "n");
                        ++i;
                        continue block271;
                    }
                    case '\u33d2': {
                        sb.setCharAt(i, 'l');
                        sb.insert(i + 1, "og");
                        i += 2;
                        continue block271;
                    }
                    case '\u33d3': {
                        sb.setCharAt(i, 'l');
                        sb.insert(i + 1, "x");
                        ++i;
                        continue block271;
                    }
                    case '\u33d4': {
                        sb.setCharAt(i, 'm');
                        sb.insert(i + 1, "b");
                        ++i;
                        continue block271;
                    }
                    case '\u33d5': {
                        sb.setCharAt(i, 'm');
                        sb.insert(i + 1, "il");
                        i += 2;
                        continue block271;
                    }
                    case '\u33d6': {
                        sb.setCharAt(i, 'm');
                        sb.insert(i + 1, "ol");
                        i += 2;
                        continue block271;
                    }
                    case '\u33d7': {
                        sb.setCharAt(i, 'p');
                        sb.insert(i + 1, "H");
                        ++i;
                        continue block271;
                    }
                    case '\u33d8': {
                        sb.setCharAt(i, 'p');
                        sb.insert(i + 1, ".m.");
                        i += 3;
                        continue block271;
                    }
                    case '\u33d9': {
                        sb.setCharAt(i, 'P');
                        sb.insert(i + 1, "PM");
                        i += 2;
                        continue block271;
                    }
                    case '\u33da': {
                        sb.setCharAt(i, 'P');
                        sb.insert(i + 1, "R");
                        ++i;
                        continue block271;
                    }
                    case '\u33db': {
                        sb.setCharAt(i, 's');
                        sb.insert(i + 1, "r");
                        ++i;
                        continue block271;
                    }
                    case '\u33dc': {
                        sb.setCharAt(i, 'S');
                        sb.insert(i + 1, "v");
                        ++i;
                        continue block271;
                    }
                    case '\u33dd': {
                        sb.setCharAt(i, 'W');
                        sb.insert(i + 1, "b");
                        ++i;
                        continue block271;
                    }
                    case '\u33de': {
                        sb.setCharAt(i, 'v');
                        sb.insert(i + 1, "/m");
                        i += 2;
                        continue block271;
                    }
                    case '\u33df': {
                        sb.setCharAt(i, 'a');
                        sb.insert(i + 1, "/m");
                        i += 2;
                        continue block271;
                    }
                    case '\u33ff': {
                        sb.setCharAt(i, 'g');
                        sb.insert(i + 1, "al");
                        i += 2;
                    }
                }
            }
        } else {
            block272: for (int i = 0; i < text.length(); ++i) {
                char ch = text.charAt(i);
                if (TextFragment.isMarker(ch)) {
                    ++i;
                    continue;
                }
                if (ch >= '!' && ch <= '~') {
                    sb.setCharAt(i, (char)(ch + 65248));
                    continue;
                }
                if (this.params.asciiOnly) continue;
                if (ch > '\uffa1' && ch <= '\uffbe') {
                    sb.setCharAt(i, (char)(ch - 52848));
                    continue;
                }
                switch (ch) {
                    case '\uff61': {
                        sb.setCharAt(i, '\u3002');
                        continue block272;
                    }
                    case '\uff62': {
                        sb.setCharAt(i, '\u300c');
                        continue block272;
                    }
                    case '\uff63': {
                        sb.setCharAt(i, '\u300d');
                        continue block272;
                    }
                    case '\uff64': {
                        sb.setCharAt(i, '\u3001');
                        continue block272;
                    }
                    case '\uff65': {
                        sb.setCharAt(i, '\u30fb');
                        continue block272;
                    }
                    case '\uff66': {
                        sb.setCharAt(i, '\u30f2');
                        continue block272;
                    }
                    case '\uff67': {
                        sb.setCharAt(i, '\u30a1');
                        continue block272;
                    }
                    case '\uff68': {
                        sb.setCharAt(i, '\u30a3');
                        continue block272;
                    }
                    case '\uff69': {
                        sb.setCharAt(i, '\u30a5');
                        continue block272;
                    }
                    case '\uff6a': {
                        sb.setCharAt(i, '\u30a7');
                        continue block272;
                    }
                    case '\uff6b': {
                        sb.setCharAt(i, '\u30a9');
                        continue block272;
                    }
                    case '\uff6c': {
                        sb.setCharAt(i, '\u30e3');
                        continue block272;
                    }
                    case '\uff6d': {
                        sb.setCharAt(i, '\u30e5');
                        continue block272;
                    }
                    case '\uff6e': {
                        sb.setCharAt(i, '\u30e7');
                        continue block272;
                    }
                    case '\uff6f': {
                        sb.setCharAt(i, '\u30c3');
                        continue block272;
                    }
                    case '\uff70': {
                        sb.setCharAt(i, '\u30fc');
                        continue block272;
                    }
                    case '\uff71': {
                        sb.setCharAt(i, '\u30a2');
                        continue block272;
                    }
                    case '\uff72': {
                        sb.setCharAt(i, '\u30a4');
                        continue block272;
                    }
                    case '\uff73': {
                        sb.setCharAt(i, '\u30a6');
                        continue block272;
                    }
                    case '\uff74': {
                        sb.setCharAt(i, '\u30a8');
                        continue block272;
                    }
                    case '\uff75': {
                        sb.setCharAt(i, '\u30aa');
                        continue block272;
                    }
                    case '\uff76': {
                        sb.setCharAt(i, '\u30ab');
                        continue block272;
                    }
                    case '\uff77': {
                        sb.setCharAt(i, '\u30ad');
                        continue block272;
                    }
                    case '\uff78': {
                        sb.setCharAt(i, '\u30af');
                        continue block272;
                    }
                    case '\uff79': {
                        sb.setCharAt(i, '\u30b1');
                        continue block272;
                    }
                    case '\uff7a': {
                        sb.setCharAt(i, '\u30b3');
                        continue block272;
                    }
                    case '\uff7b': {
                        sb.setCharAt(i, '\u30b5');
                        continue block272;
                    }
                    case '\uff7c': {
                        sb.setCharAt(i, '\u30b7');
                        continue block272;
                    }
                    case '\uff7d': {
                        sb.setCharAt(i, '\u30b9');
                        continue block272;
                    }
                    case '\uff7e': {
                        sb.setCharAt(i, '\u30bb');
                        continue block272;
                    }
                    case '\uff7f': {
                        sb.setCharAt(i, '\u30bd');
                        continue block272;
                    }
                    case '\uff80': {
                        sb.setCharAt(i, '\u30bf');
                        continue block272;
                    }
                    case '\uff81': {
                        sb.setCharAt(i, '\u30c1');
                        continue block272;
                    }
                    case '\uff82': {
                        sb.setCharAt(i, '\u30c4');
                        continue block272;
                    }
                    case '\uff83': {
                        sb.setCharAt(i, '\u30c6');
                        continue block272;
                    }
                    case '\uff84': {
                        sb.setCharAt(i, '\u30c8');
                        continue block272;
                    }
                    case '\uff85': {
                        sb.setCharAt(i, '\u30ca');
                        continue block272;
                    }
                    case '\uff86': {
                        sb.setCharAt(i, '\u30cb');
                        continue block272;
                    }
                    case '\uff87': {
                        sb.setCharAt(i, '\u30cc');
                        continue block272;
                    }
                    case '\uff88': {
                        sb.setCharAt(i, '\u30cd');
                        continue block272;
                    }
                    case '\uff89': {
                        sb.setCharAt(i, '\u30ce');
                        continue block272;
                    }
                    case '\uff8a': {
                        sb.setCharAt(i, '\u30cf');
                        continue block272;
                    }
                    case '\uff8b': {
                        sb.setCharAt(i, '\u30d2');
                        continue block272;
                    }
                    case '\uff8c': {
                        sb.setCharAt(i, '\u30d5');
                        continue block272;
                    }
                    case '\uff8d': {
                        sb.setCharAt(i, '\u30d8');
                        continue block272;
                    }
                    case '\uff8e': {
                        sb.setCharAt(i, '\u30db');
                        continue block272;
                    }
                    case '\uff8f': {
                        sb.setCharAt(i, '\u30de');
                        continue block272;
                    }
                    case '\uff90': {
                        sb.setCharAt(i, '\u30df');
                        continue block272;
                    }
                    case '\uff91': {
                        sb.setCharAt(i, '\u30e0');
                        continue block272;
                    }
                    case '\uff92': {
                        sb.setCharAt(i, '\u30e1');
                        continue block272;
                    }
                    case '\uff93': {
                        sb.setCharAt(i, '\u30e2');
                        continue block272;
                    }
                    case '\uff94': {
                        sb.setCharAt(i, '\u30e4');
                        continue block272;
                    }
                    case '\uff95': {
                        sb.setCharAt(i, '\u30e6');
                        continue block272;
                    }
                    case '\uff96': {
                        sb.setCharAt(i, '\u30e8');
                        continue block272;
                    }
                    case '\uff97': {
                        sb.setCharAt(i, '\u30e9');
                        continue block272;
                    }
                    case '\uff98': {
                        sb.setCharAt(i, '\u30ea');
                        continue block272;
                    }
                    case '\uff99': {
                        sb.setCharAt(i, '\u30eb');
                        continue block272;
                    }
                    case '\uff9a': {
                        sb.setCharAt(i, '\u30ec');
                        continue block272;
                    }
                    case '\uff9b': {
                        sb.setCharAt(i, '\u30ed');
                        continue block272;
                    }
                    case '\uff9c': {
                        sb.setCharAt(i, '\u30ef');
                        continue block272;
                    }
                    case '\uff9d': {
                        sb.setCharAt(i, '\u30f3');
                        continue block272;
                    }
                    case '\uff9e': {
                        sb.setCharAt(i, '\u3099');
                        continue block272;
                    }
                    case '\uff9f': {
                        sb.setCharAt(i, '\u309a');
                        continue block272;
                    }
                    case '\uffa0': {
                        sb.setCharAt(i, '\u3164');
                        continue block272;
                    }
                    case '\uffda': {
                        sb.setCharAt(i, '\u3161');
                        continue block272;
                    }
                    case '\uffdb': {
                        sb.setCharAt(i, '\u3162');
                        continue block272;
                    }
                    case '\uffdc': {
                        sb.setCharAt(i, '\u3163');
                        continue block272;
                    }
                    case '\uffe8': {
                        sb.setCharAt(i, '\u2502');
                        continue block272;
                    }
                    case '\uffe9': {
                        sb.setCharAt(i, '\u2190');
                        continue block272;
                    }
                    case '\uffea': {
                        sb.setCharAt(i, '\u2191');
                        continue block272;
                    }
                    case '\uffeb': {
                        sb.setCharAt(i, '\u2192');
                        continue block272;
                    }
                    case '\uffec': {
                        sb.setCharAt(i, '\u2193');
                        continue block272;
                    }
                    case '\uffed': {
                        sb.setCharAt(i, '\u25a0');
                        continue block272;
                    }
                    case '\uffee': {
                        sb.setCharAt(i, '\u25cb');
                    }
                }
            }
        }
        frag.setCodedText(sb.toString());
    }
}

