/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.rainbowkit.creation;

import java.io.File;
import java.net.URI;
import java.util.UUID;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.steps.rainbowkit.common.IPackageWriter;
import net.sf.okapi.steps.rainbowkit.creation.Parameters;

@UsingParameters(value=Parameters.class)
public class ExtractionStep
extends BasePipelineStep {
    private IPackageWriter writer;
    private Parameters params = new Parameters();
    private LocaleId srcLoc;
    private LocaleId trgLoc;
    private URI inputURI;
    private URI outputURI;
    private String outputEncoding;
    private String filterConfigId;
    private String rootDir;
    private String inputRootDir;
    private String outputRootDir;

    @Override
    public String getDescription() {
        return "BETA --- Generates a Rainbow translation kit for a batch of input documents. Expects: filter events. Sends back: filter events.";
    }

    @Override
    public String getName() {
        return "Rainbow Translation Kit Creation";
    }

    @StepParameterMapping(parameterType=StepParameterType.SOURCE_LOCALE)
    public void setSourceLocale(LocaleId sourceLocale) {
        this.srcLoc = sourceLocale;
    }

    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALE)
    public void setTargetLocale(LocaleId targetLocale) {
        this.trgLoc = targetLocale;
    }

    @StepParameterMapping(parameterType=StepParameterType.INPUT_URI)
    public void setInputURI(URI inputURI) {
        this.inputURI = inputURI;
    }

    @StepParameterMapping(parameterType=StepParameterType.OUTPUT_URI)
    public void setOutputURI(URI outputURI) {
        this.outputURI = outputURI;
    }

    @StepParameterMapping(parameterType=StepParameterType.OUTPUT_ENCODING)
    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    @StepParameterMapping(parameterType=StepParameterType.FILTER_CONFIGURATION_ID)
    public void setFilterConfigurationId(String filterConfigId) {
        this.filterConfigId = filterConfigId;
    }

    @StepParameterMapping(parameterType=StepParameterType.ROOT_DIRECTORY)
    public void setRootDirectory(String rootDir) {
        this.rootDir = rootDir;
    }

    @StepParameterMapping(parameterType=StepParameterType.INPUT_ROOT_DIRECTORY)
    public void setInputRootDirectory(String inputRootDir) {
        this.inputRootDir = inputRootDir;
        this.outputRootDir = inputRootDir;
    }

    @Override
    public Event handleEvent(Event event) {
        switch (event.getEventType()) {
            case START_BATCH: {
                return this.handleStartBatch(event);
            }
            case END_BATCH: {
                return this.handleEndBatch(event);
            }
            case START_DOCUMENT: {
                return this.handleStartDocument(event);
            }
        }
        return this.writer.handleEvent(event);
    }

    @Override
    protected Event handleStartBatch(Event event) {
        try {
            String writerClass = this.params.getWriterClass();
            this.writer = (IPackageWriter)Class.forName(writerClass).newInstance();
            this.writer.setParameters(this.params);
            String resolvedOutputDir = this.params.getPackageDirectory() + File.separator + this.params.getPackageName();
            resolvedOutputDir = Util.fillRootDirectoryVariable(resolvedOutputDir, this.rootDir);
            resolvedOutputDir = Util.fillInputRootDirectoryVariable(resolvedOutputDir, this.inputRootDir);
            resolvedOutputDir = LocaleId.replaceVariables(resolvedOutputDir, this.srcLoc, this.trgLoc);
            Util.deleteDirectory(resolvedOutputDir, false);
            String packageId = UUID.randomUUID().toString();
            String projectId = Util.makeId(this.params.getPackageName() + this.srcLoc.toString() + this.trgLoc.toString());
            this.writer.setBatchInformation(resolvedOutputDir, this.srcLoc, this.trgLoc, this.inputRootDir, packageId, projectId, this.params.getWriterOptions());
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Error creating writer class.", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error creating writer class.", e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Error creating writer class.", e);
        }
        return this.writer.handleEvent(event);
    }

    @Override
    protected Event handleEndBatch(Event event) {
        event = this.writer.handleEvent(event);
        this.writer.close();
        this.writer = null;
        return event;
    }

    @Override
    protected Event handleStartDocument(Event event) {
        StartDocument sd = event.getStartDocument();
        String tmpIn = this.inputURI.getPath();
        String relativeInput = tmpIn.substring(this.inputRootDir.length() + 1);
        String tmpOut = this.outputURI.getPath();
        String relativeOutput = tmpOut.substring(this.outputRootDir.length() + 1);
        IParameters prm = sd.getFilterParameters();
        String paramsData = null;
        if (prm != null) {
            paramsData = ((Object)prm).toString();
        }
        this.writer.setDocumentInformation(relativeInput, this.filterConfigId, paramsData, sd.getEncoding(), relativeOutput, this.outputEncoding, sd.getFilterWriter().getSkeletonWriter());
        return this.writer.handleEvent(event);
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }
}

