/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.rainbowkit.omegat;

import java.io.File;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.XMLWriter;
import net.sf.okapi.steps.rainbowkit.xliff.XLIFFPackageWriter;

public class OmegaTPackageWriter
extends XLIFFPackageWriter {
    public OmegaTPackageWriter() {
        this.extractionType = "omegat";
    }

    @Override
    protected void processStartBatch() {
        this.manifest.setSubDirectories("original", "source", "target", "done", "tm", true);
        this.setTMXInfo(true, this.manifest.getPackageRoot() + "omegat" + File.separator + "project_save.tmx", null, null, null);
        super.processStartBatch();
    }

    @Override
    protected void processEndBatch() {
        Util.createDirectories(this.manifest.getPackageRoot() + "omegat/");
        Util.createDirectories(this.manifest.getPackageRoot() + "glossary/");
        Util.createDirectories(this.manifest.getTargetDirectory());
        Util.createDirectories(this.manifest.getTmDirectory());
        this.createOmegaTProject();
        super.processEndBatch();
    }

    @Override
    protected void processStartDocument(Event event) {
        super.processStartDocument(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createOmegaTProject() {
        XMLWriter XR = null;
        try {
            XR = new XMLWriter(this.manifest.getPackageRoot() + "omegat.project");
            XR.writeStartDocument();
            XR.writeStartElement("omegat");
            XR.writeStartElement("project");
            XR.writeAttributeString("version", "1.0");
            XR.writeStartElement("source_dir");
            XR.writeRawXML("__DEFAULT__");
            XR.writeEndElementLineBreak();
            XR.writeStartElement("target_dir");
            XR.writeRawXML("__DEFAULT__");
            XR.writeEndElementLineBreak();
            XR.writeStartElement("tm_dir");
            XR.writeRawXML("__DEFAULT__");
            XR.writeEndElementLineBreak();
            XR.writeStartElement("glossary_dir");
            XR.writeRawXML("__DEFAULT__");
            XR.writeEndElementLineBreak();
            XR.writeStartElement("source_lang");
            XR.writeRawXML(this.manifest.getSourceLocale().toString());
            XR.writeEndElementLineBreak();
            XR.writeStartElement("target_lang");
            XR.writeRawXML(this.manifest.getTargetLocale().toString());
            XR.writeEndElementLineBreak();
            XR.writeStartElement("sentence_seg");
            XR.writeRawXML(this.getPreSegmented() ? "false" : "true");
            XR.writeEndElementLineBreak();
            XR.writeEndElementLineBreak();
            XR.writeEndElement();
        }
        finally {
            if (XR != null) {
                XR.writeEndDocument();
                XR.close();
            }
        }
    }
}

