/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.rainbowkit.ontram;

import net.sf.okapi.common.Event;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.filters.rainbowkit.MergingInfo;
import net.sf.okapi.filters.xini.XINIWriter;
import net.sf.okapi.steps.rainbowkit.common.BasePackageWriter;

public class OntramPackageWriter
extends BasePackageWriter {
    private XINIWriter writer = new XINIWriter();

    public OntramPackageWriter() {
        super("ontram");
    }

    @Override
    protected void processStartBatch() {
        this.manifest.setSubDirectories("original", "xini", "xini", "translated", null, false);
        this.setTMXInfo(false, null, null, null, null);
        this.writer = new XINIWriter();
        this.writer.setOutputPath(this.manifest.getSourceDirectory() + "contents.xini");
        this.writer.init();
        super.processStartBatch();
    }

    @Override
    protected void processStartDocument(Event event) {
        super.processStartDocument(event);
        MergingInfo info = this.manifest.getItem(this.docId);
        String inputPath = info.getRelativeInputPath();
        this.writer.setNextPageName(inputPath);
        this.writer.handleEvent(event);
    }

    @Override
    protected void processEndBatch() {
        super.processEndBatch();
        this.writer.writeXINI();
        this.close();
    }

    @Override
    protected void processTextUnit(Event event) {
        TextUnit tu = event.getTextUnit();
        if (!tu.isTranslatable()) {
            return;
        }
        this.writer.handleEvent(event);
    }

    @Override
    public void close() {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }
}

