/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.rainbowkit.postprocess;

import java.io.File;
import java.util.logging.Logger;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.resource.TextUnitUtil;
import net.sf.okapi.filters.rainbowkit.Manifest;
import net.sf.okapi.filters.rainbowkit.MergingInfo;

public class Merger {
    private static final Logger LOGGER = Logger.getLogger(Merger.class.getName());
    private IFilter filter;
    private IFilterWriter writer;
    private Manifest manifest;
    private LocaleId trgLoc;
    private IFilterConfigurationMapper fcMapper;

    public Merger(Manifest manifest, IFilterConfigurationMapper fcMapper) {
        this.fcMapper = fcMapper;
        this.manifest = manifest;
        this.trgLoc = manifest.getTargetLocale();
    }

    public void close() {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
        if (this.filter != null) {
            this.filter.close();
            this.filter = null;
        }
    }

    public Event handleEvent(Event event) {
        switch (event.getEventType()) {
            case TEXT_UNIT: {
                this.processTextUnit(event);
                break;
            }
            case END_DOCUMENT: {
                this.processEndDocument();
            }
        }
        return event;
    }

    public void startMerging(MergingInfo info) {
        this.filter = this.fcMapper.createFilter(info.getFilterId(), this.filter);
        if (this.filter == null) {
            throw new OkapiBadFilterInputException(String.format("Filter cannot be created (%s).", info.getFilterId()));
        }
        IParameters fprm = this.filter.getParameters();
        if (fprm != null) {
            fprm.fromString(info.getFilterParameters());
        }
        File file = new File(this.manifest.getOriginalDirectory() + info.getRelativeInputPath());
        RawDocument rd = new RawDocument(file.toURI(), info.getInputEncoding(), this.manifest.getSourceLocale(), this.trgLoc);
        this.filter.open(rd);
        this.writer = this.filter.createFilterWriter();
        this.writer.setOptions(this.trgLoc, info.getTargetEncoding());
        this.writer.setOutput(this.manifest.getMergeDirectory() + info.getRelativeTargetPath());
        Event event = null;
        if (this.filter.hasNext()) {
            event = this.filter.next();
        }
        if (event == null || event.getEventType() != EventType.START_DOCUMENT) {
            LOGGER.severe("The start document event is missing when parsing the original file.");
            return;
        }
        this.writer.handleEvent(event);
    }

    private void processEndDocument() {
        while (this.filter.hasNext()) {
            this.writer.handleEvent(this.filter.next());
        }
    }

    private void processTextUnit(Event event) {
        TextUnit traTu = event.getTextUnit();
        if (!traTu.isTranslatable()) {
            return;
        }
        Event oriEvent = this.processUntilTextUnit();
        if (oriEvent == null) {
            LOGGER.severe(String.format("No corresponding text unit for id='%s' in the original file.", traTu.getId()));
            return;
        }
        TextUnit oriTu = oriEvent.getTextUnit();
        if (!traTu.getId().equals(oriTu.getId())) {
            LOGGER.severe(String.format("De-synchronized files: translated TU id='%s', Original TU id='%s'.", traTu.getId(), oriTu.getId()));
            return;
        }
        TextContainer trgTraCont = traTu.getTarget(this.trgLoc);
        if (trgTraCont == null) {
            LOGGER.warning(String.format("No translation found for TU id='%s'. Using source.", traTu.getId()));
            this.writer.handleEvent(oriEvent);
            return;
        }
        boolean isTransApproved = false;
        Property traProp = traTu.getTargetProperty(this.trgLoc, "approved");
        if (traProp != null) {
            isTransApproved = traProp.getValue().equals("yes");
        }
        if (!isTransApproved && this.manifest.getUseApprovedOnly()) {
            LOGGER.warning(String.format("Item id='%s': Target is not approved. Using source.", traTu.getId()));
            this.writer.handleEvent(oriEvent);
            return;
        }
        TextContainer srcOriCont = oriTu.getSource();
        ISegments trgTraSegs = trgTraCont.getSegments();
        for (Segment srcOriSeg : srcOriCont.getSegments()) {
            Segment trgTraSeg = trgTraSegs.get(srcOriSeg.id);
            if (trgTraSeg == null) {
                LOGGER.warning(String.format("Item id='%s': No translation found for the segment '%s'. Using source.", traTu.getId(), srcOriSeg.id));
                continue;
            }
            TextUnitUtil.adjustTargetCodes(srcOriSeg.text, trgTraSeg.text, true, true, null, oriTu);
        }
        if (srcOriCont.getSegments().count() < trgTraCont.getSegments().count()) {
            LOGGER.warning(String.format("Item id='%s': There is at least one extra segment in the translation file.\nExtra segments are not merged into the translated output.", traTu.getId()));
        }
        oriTu.setTarget(this.trgLoc, trgTraCont);
        if (this.manifest.getUpdateApprovedFlag()) {
            Property oriProp = oriTu.createTargetProperty(this.trgLoc, "approved", false, 0);
            if (traProp != null) {
                oriProp.setValue(traProp.getValue());
            } else {
                oriProp.setValue("yes");
            }
        }
        this.writer.handleEvent(oriEvent);
    }

    private Event processUntilTextUnit() {
        while (this.filter.hasNext()) {
            Event event = this.filter.next();
            if (event.getEventType() == EventType.TEXT_UNIT) {
                TextUnit tu = event.getTextUnit();
                if (!tu.isTranslatable()) {
                    this.writer.handleEvent(event);
                    continue;
                }
                return event;
            }
            this.writer.handleEvent(event);
        }
        return null;
    }
}

