/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.rainbowkit.postprocess;

import net.sf.okapi.common.Event;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.filters.rainbowkit.Manifest;
import net.sf.okapi.filters.rainbowkit.MergingInfo;
import net.sf.okapi.steps.rainbowkit.postprocess.Merger;

public class MergingStep
extends BasePipelineStep {
    private MergingInfo info;
    private Merger merger;
    IFilterConfigurationMapper fcMapper;

    @Override
    public String getDescription() {
        return "BETA --- Post-process a Rainbow translation kit. Expects: filter events. Sends back: filter events.";
    }

    @Override
    public String getName() {
        return "Rainbow Translation Kit Merging";
    }

    @StepParameterMapping(parameterType=StepParameterType.FILTER_CONFIGURATION_MAPPER)
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
        this.fcMapper = fcMapper;
    }

    @Override
    public Event handleEvent(Event event) {
        switch (event.getEventType()) {
            case START_DOCUMENT: {
                return this.handleStartDocument(event);
            }
        }
        if (this.merger != null) {
            this.merger.handleEvent(event);
        }
        return event;
    }

    @Override
    protected Event handleStartBatch(Event event) {
        return event;
    }

    @Override
    protected Event handleEndBatch(Event event) {
        return event;
    }

    @Override
    protected Event handleStartDocument(Event event) {
        StartDocument sd = event.getStartDocument();
        this.info = sd.getAnnotation(MergingInfo.class);
        if (this.info == null) {
            throw new OkapiBadFilterInputException("Start document is missing the merging info annotation.");
        }
        Manifest manifest = sd.getAnnotation(Manifest.class);
        if (manifest == null) {
            throw new OkapiBadFilterInputException("Start document is missing the manifest annotation.");
        }
        if (this.merger == null) {
            this.merger = new Merger(manifest, this.fcMapper);
        }
        this.merger.startMerging(this.info);
        return event;
    }
}

