/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.rainbowkit.xliffrtf;

import java.io.File;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.filters.rainbowkit.MergingInfo;
import net.sf.okapi.filters.xliff.XLIFFFilter;
import net.sf.okapi.steps.rainbowkit.rtf.RTFLayerWriter;
import net.sf.okapi.steps.rainbowkit.xliff.XLIFFPackageWriter;

public class XLIFFRTFPackageWriter
extends XLIFFPackageWriter {
    public XLIFFRTFPackageWriter() {
        this.extractionType = "xliff+rtf";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processEndBatchItem() {
        super.processEndBatchItem();
        RTFLayerWriter layerWriter = null;
        IFilter filter = null;
        File inpFile = null;
        try {
            MergingInfo info = this.manifest.getItem(this.docId);
            inpFile = new File(this.manifest.getSourceDirectory() + info.getRelativeInputPath() + ".xlf");
            String outPath = inpFile.getAbsolutePath() + ".rtf";
            RawDocument rd = new RawDocument(inpFile.toURI(), "UTF-8", this.manifest.getSourceLocale());
            rd.setTargetLocale(this.manifest.getTargetLocale());
            filter = new XLIFFFilter();
            filter.open(rd);
            layerWriter = new RTFLayerWriter(filter.createSkeletonWriter(), outPath, this.manifest.getTargetLocale(), info.getTargetEncoding());
            while (filter.hasNext()) {
                layerWriter.writeEvent(filter.next());
            }
        }
        finally {
            if (filter != null) {
                filter.close();
            }
            if (layerWriter != null) {
                layerWriter.close();
            }
            if (inpFile != null) {
                inpFile.delete();
            }
        }
    }
}

