/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.scopingreport;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.query.MatchType;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.lib.extra.steps.CompoundStep;
import net.sf.okapi.lib.reporting.ReportGenerator;
import net.sf.okapi.steps.scopingreport.Parameters;
import net.sf.okapi.steps.wordcount.categorized.CategoryGroup;
import net.sf.okapi.steps.wordcount.categorized.CategoryResolver;
import net.sf.okapi.steps.wordcount.categorized.gmx.GMXAlphanumericOnlyTextUnitWordCountStep;
import net.sf.okapi.steps.wordcount.categorized.gmx.GMXExactMatchedWordCountStep;
import net.sf.okapi.steps.wordcount.categorized.gmx.GMXFuzzyMatchWordCountStep;
import net.sf.okapi.steps.wordcount.categorized.gmx.GMXLeveragedMatchedWordCountStep;
import net.sf.okapi.steps.wordcount.categorized.gmx.GMXMeasurementOnlyTextUnitWordCountStep;
import net.sf.okapi.steps.wordcount.categorized.gmx.GMXNumericOnlyTextUnitWordCountStep;
import net.sf.okapi.steps.wordcount.categorized.gmx.GMXProtectedWordCountStep;
import net.sf.okapi.steps.wordcount.categorized.gmx.GMXRepetitionMatchedWordCountStep;
import net.sf.okapi.steps.wordcount.categorized.okapi.ConcordanceWordCountStep;
import net.sf.okapi.steps.wordcount.categorized.okapi.ExactDocumentContextMatchWordCountStep;
import net.sf.okapi.steps.wordcount.categorized.okapi.ExactLocalContextMatchWordCountStep;
import net.sf.okapi.steps.wordcount.categorized.okapi.ExactMatchWordCountStep;
import net.sf.okapi.steps.wordcount.categorized.okapi.ExactPreviousVersionMatchWordCountStep;
import net.sf.okapi.steps.wordcount.categorized.okapi.ExactRepairedWordCountStep;
import net.sf.okapi.steps.wordcount.categorized.okapi.ExactStructuralMatchWordCountStep;
import net.sf.okapi.steps.wordcount.categorized.okapi.ExactTextOnlyPreviousVersionMatchWordCountStep;
import net.sf.okapi.steps.wordcount.categorized.okapi.ExactTextOnlyUniqueIdMatchWordCountStep;
import net.sf.okapi.steps.wordcount.categorized.okapi.ExactTextOnlyWordCountStep;
import net.sf.okapi.steps.wordcount.categorized.okapi.ExactUniqueIdMatchWordCountStep;
import net.sf.okapi.steps.wordcount.categorized.okapi.FuzzyMatchWordCountStep;
import net.sf.okapi.steps.wordcount.categorized.okapi.FuzzyPreviousVersionMatchWordCountStep;
import net.sf.okapi.steps.wordcount.categorized.okapi.FuzzyRepairedWordCountStep;
import net.sf.okapi.steps.wordcount.categorized.okapi.FuzzyUniqueIdMatchWordCountStep;
import net.sf.okapi.steps.wordcount.categorized.okapi.MTWordCountStep;
import net.sf.okapi.steps.wordcount.categorized.okapi.PhraseAssembledWordCountStep;
import net.sf.okapi.steps.wordcount.common.BaseCounter;

@UsingParameters(value=Parameters.class)
public class ScopingReportStep
extends CompoundStep {
    public static final String PROJECT_NAME = "PROJECT_NAME";
    public static final String PROJECT_DATE = "PROJECT_DATE";
    public static final String PROJECT_SOURCE_LOCALE = "PROJECT_SOURCE_LOCALE";
    public static final String PROJECT_TARGET_LOCALE = "PROJECT_TARGET_LOCALE";
    public static final String PROJECT_TOTAL_WORD_COUNT = "PROJECT_TOTAL_WORD_COUNT";
    public static final String ITEM_NAME = "ITEM_NAME";
    public static final String ITEM_SOURCE_LOCALE = "ITEM_SOURCE_LOCALE";
    public static final String ITEM_TARGET_LOCALE = "ITEM_TARGET_LOCALE";
    public static final String ITEM_TOTAL_WORD_COUNT = "ITEM_TOTAL_WORD_COUNT";
    public static final String PROJECT_GMX_PROTECTED_WORD_COUNT = "PROJECT_GMX_PROTECTED_WORD_COUNT";
    public static final String PROJECT_GMX_EXACT_MATCHED_WORD_COUNT = "PROJECT_GMX_EXACT_MATCHED_WORD_COUNT";
    public static final String PROJECT_GMX_LEVERAGED_MATCHED_WORD_COUNT = "PROJECT_GMX_LEVERAGED_MATCHED_WORD_COUNT";
    public static final String PROJECT_GMX_REPETITION_MATCHED_WORD_COUNT = "PROJECT_GMX_REPETITION_MATCHED_WORD_COUNT";
    public static final String PROJECT_GMX_FUZZY_MATCHED_WORD_COUNT = "PROJECT_GMX_FUZZY_MATCHED_WORD_COUNT";
    public static final String PROJECT_GMX_ALPHANUMERIC_ONLY_TEXT_UNIT_WORD_COUNT = "PROJECT_GMX_ALPHANUMERIC_ONLY_TEXT_UNIT_WORD_COUNT";
    public static final String PROJECT_GMX_NUMERIC_ONLY_TEXT_UNIT_WORD_COUNT = "PROJECT_GMX_NUMERIC_ONLY_TEXT_UNIT_WORD_COUNT";
    public static final String PROJECT_GMX_MEASUREMENT_ONLY_TEXT_UNIT_WORD_COUNT = "PROJECT_GMX_MEASUREMENT_ONLY_TEXT_UNIT_WORD_COUNT";
    public static final String PROJECT_GMX_NONTRANSLATABLE_WORD_COUNT = "PROJECT_GMX_NONTRANSLATABLE_WORD_COUNT";
    public static final String PROJECT_GMX_TRANSLATABLE_WORD_COUNT = "PROJECT_GMX_TRANSLATABLE_WORD_COUNT";
    public static final String PROJECT_GMX_NOCATEGORY = "PROJECT_GMX_NOCATEGORY";
    public static final String ITEM_GMX_PROTECTED_WORD_COUNT = "ITEM_GMX_PROTECTED_WORD_COUNT";
    public static final String ITEM_GMX_EXACT_MATCHED_WORD_COUNT = "ITEM_GMX_EXACT_MATCHED_WORD_COUNT";
    public static final String ITEM_GMX_LEVERAGED_MATCHED_WORD_COUNT = "ITEM_GMX_LEVERAGED_MATCHED_WORD_COUNT";
    public static final String ITEM_GMX_REPETITION_MATCHED_WORD_COUNT = "ITEM_GMX_REPETITION_MATCHED_WORD_COUNT";
    public static final String ITEM_GMX_FUZZY_MATCHED_WORD_COUNT = "ITEM_GMX_FUZZY_MATCHED_WORD_COUNT";
    public static final String ITEM_GMX_ALPHANUMERIC_ONLY_TEXT_UNIT_WORD_COUNT = "ITEM_GMX_ALPHANUMERIC_ONLY_TEXT_UNIT_WORD_COUNT";
    public static final String ITEM_GMX_NUMERIC_ONLY_TEXT_UNIT_WORD_COUNT = "ITEM_GMX_NUMERIC_ONLY_TEXT_UNIT_WORD_COUNT";
    public static final String ITEM_GMX_MEASUREMENT_ONLY_TEXT_UNIT_WORD_COUNT = "ITEM_GMX_MEASUREMENT_ONLY_TEXT_UNIT_WORD_COUNT";
    public static final String ITEM_GMX_NONTRANSLATABLE_WORD_COUNT = "ITEM_GMX_NONTRANSLATABLE_WORD_COUNT";
    public static final String ITEM_GMX_TRANSLATABLE_WORD_COUNT = "ITEM_GMX_TRANSLATABLE_WORD_COUNT";
    public static final String ITEM_GMX_NOCATEGORY = "ITEM_GMX_NOCATEGORY";
    public static final String PROJECT_EXACT_UNIQUE_ID = "PROJECT_EXACT_UNIQUE_ID";
    public static final String PROJECT_EXACT_PREVIOUS_VERSION = "PROJECT_EXACT_PREVIOUS_VERSION";
    public static final String PROJECT_EXACT_LOCAL_CONTEXT = "PROJECT_EXACT_LOCAL_CONTEXT";
    public static final String PROJECT_EXACT_DOCUMENT_CONTEXT = "PROJECT_EXACT_DOCUMENT_CONTEXT";
    public static final String PROJECT_EXACT_STRUCTURAL = "PROJECT_EXACT_STRUCTURAL";
    public static final String PROJECT_EXACT = "PROJECT_EXACT";
    public static final String PROJECT_EXACT_TEXT_ONLY_PREVIOUS_VERSION = "PROJECT_EXACT_TEXT_ONLY_PREVIOUS_VERSION";
    public static final String PROJECT_EXACT_TEXT_ONLY_UNIQUE_ID = "PROJECT_EXACT_TEXT_ONLY_UNIQUE_ID";
    public static final String PROJECT_EXACT_TEXT_ONLY = "PROJECT_EXACT_TEXT_ONLY";
    public static final String PROJECT_EXACT_REPAIRED = "PROJECT_EXACT_REPAIRED";
    public static final String PROJECT_FUZZY_PREVIOUS_VERSION = "PROJECT_FUZZY_PREVIOUS_VERSION";
    public static final String PROJECT_FUZZY_UNIQUE_ID = "PROJECT_FUZZY_UNIQUE_ID";
    public static final String PROJECT_FUZZY = "PROJECT_FUZZY";
    public static final String PROJECT_FUZZY_REPAIRED = "PROJECT_FUZZY_REPAIRED";
    public static final String PROJECT_PHRASE_ASSEMBLED = "PROJECT_PHRASE_ASSEMBLED";
    public static final String PROJECT_MT = "PROJECT_MT";
    public static final String PROJECT_CONCORDANCE = "PROJECT_CONCORDANCE";
    public static final String PROJECT_NONTRANSLATABLE_WORD_COUNT = "PROJECT_NONTRANSLATABLE_WORD_COUNT";
    public static final String PROJECT_TRANSLATABLE_WORD_COUNT = "PROJECT_TRANSLATABLE_WORD_COUNT";
    public static final String PROJECT_NOCATEGORY = "PROJECT_NOCATEGORY";
    public static final String ITEM_EXACT_UNIQUE_ID = "ITEM_EXACT_UNIQUE_ID";
    public static final String ITEM_EXACT_PREVIOUS_VERSION = "ITEM_EXACT_PREVIOUS_VERSION";
    public static final String ITEM_EXACT_LOCAL_CONTEXT = "ITEM_EXACT_LOCAL_CONTEXT";
    public static final String ITEM_EXACT_DOCUMENT_CONTEXT = "ITEM_EXACT_DOCUMENT_CONTEXT";
    public static final String ITEM_EXACT_STRUCTURAL = "ITEM_EXACT_STRUCTURAL";
    public static final String ITEM_EXACT = "ITEM_EXACT";
    public static final String ITEM_EXACT_TEXT_ONLY_PREVIOUS_VERSION = "ITEM_EXACT_TEXT_ONLY_PREVIOUS_VERSION";
    public static final String ITEM_EXACT_TEXT_ONLY_UNIQUE_ID = "ITEM_EXACT_TEXT_ONLY_UNIQUE_ID";
    public static final String ITEM_EXACT_TEXT_ONLY = "ITEM_EXACT_TEXT_ONLY";
    public static final String ITEM_EXACT_REPAIRED = "ITEM_EXACT_REPAIRED";
    public static final String ITEM_FUZZY_PREVIOUS_VERSION = "ITEM_FUZZY_PREVIOUS_VERSION";
    public static final String ITEM_FUZZY_UNIQUE_ID = "ITEM_FUZZY_UNIQUE_ID";
    public static final String ITEM_FUZZY = "ITEM_FUZZY";
    public static final String ITEM_FUZZY_REPAIRED = "ITEM_FUZZY_REPAIRED";
    public static final String ITEM_PHRASE_ASSEMBLED = "ITEM_PHRASE_ASSEMBLED";
    public static final String ITEM_MT = "ITEM_MT";
    public static final String ITEM_CONCORDANCE = "ITEM_CONCORDANCE";
    public static final String ITEM_NONTRANSLATABLE_WORD_COUNT = "ITEM_NONTRANSLATABLE_WORD_COUNT";
    public static final String ITEM_TRANSLATABLE_WORD_COUNT = "ITEM_TRANSLATABLE_WORD_COUNT";
    public static final String ITEM_NOCATEGORY = "ITEM_NOCATEGORY";
    private static final String DEFAULT_TEMPLATE = "scoping_report.html";
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private Parameters params = new Parameters();
    private ReportGenerator gen;
    private String rootDir;
    private CategoryResolver resolver;

    public ScopingReportStep() {
        this.setParameters(this.params);
        this.setName("Scoping Report");
        this.setDescription("Create a template-based scoping report based on word count and leverage annotations. Expects: filter events. Sends back: filter events.");
    }

    @StepParameterMapping(parameterType=StepParameterType.ROOT_DIRECTORY)
    public void setRootDirectory(String rootDir) {
        this.rootDir = rootDir;
    }

    protected InputStream getTemplateStream() {
        if (this.params.useDefaultTemplate()) {
            return this.getClass().getResourceAsStream(DEFAULT_TEMPLATE);
        }
        try {
            return new BufferedInputStream(new FileInputStream(new File(this.params.getCustomTemplateURI())));
        }
        catch (IOException e) {
            this.logger.warning("Error opening the custom template, default one is used");
            return this.getClass().getResourceAsStream(DEFAULT_TEMPLATE);
        }
    }

    @Override
    protected void addSteps(List<IPipelineStep> list) {
        list.add(new GMXProtectedWordCountStep());
        list.add(new GMXExactMatchedWordCountStep());
        list.add(new GMXLeveragedMatchedWordCountStep());
        list.add(new GMXRepetitionMatchedWordCountStep());
        list.add(new GMXFuzzyMatchWordCountStep());
        list.add(new GMXAlphanumericOnlyTextUnitWordCountStep());
        list.add(new GMXNumericOnlyTextUnitWordCountStep());
        list.add(new GMXMeasurementOnlyTextUnitWordCountStep());
        list.add(new ExactUniqueIdMatchWordCountStep());
        list.add(new ExactPreviousVersionMatchWordCountStep());
        list.add(new ExactLocalContextMatchWordCountStep());
        list.add(new ExactDocumentContextMatchWordCountStep());
        list.add(new ExactStructuralMatchWordCountStep());
        list.add(new ExactMatchWordCountStep());
        list.add(new ExactTextOnlyUniqueIdMatchWordCountStep());
        list.add(new ExactTextOnlyPreviousVersionMatchWordCountStep());
        list.add(new ExactTextOnlyWordCountStep());
        list.add(new ExactRepairedWordCountStep());
        list.add(new FuzzyUniqueIdMatchWordCountStep());
        list.add(new FuzzyPreviousVersionMatchWordCountStep());
        list.add(new FuzzyMatchWordCountStep());
        list.add(new FuzzyRepairedWordCountStep());
        list.add(new PhraseAssembledWordCountStep());
        list.add(new MTWordCountStep());
        list.add(new ConcordanceWordCountStep());
        this.resolver = new CategoryResolver(list);
    }

    @Override
    protected Event handleStartBatch(Event event) {
        this.resolver.reset();
        this.params = this.getParameters(Parameters.class);
        this.gen = new ReportGenerator(this.getTemplateStream());
        DateFormat df = DateFormat.getDateTimeInstance(0, 0);
        this.gen.setField(PROJECT_NAME, this.params.getProjectName());
        this.gen.setField(PROJECT_DATE, df.format(new Date()));
        this.gen.setField(PROJECT_SOURCE_LOCALE, this.getSourceLocale().toString());
        this.gen.setField(PROJECT_TARGET_LOCALE, this.getTargetLocale().toString());
        return super.handleStartBatch(event);
    }

    @Override
    protected Event handleEndBatch(Event event) {
        IResource res = event.getResource();
        if (res != null) {
            this.resolver.resolve(res);
            this.gen.setField(PROJECT_TOTAL_WORD_COUNT, BaseCounter.getCount(res, "TotalWordCount"));
            long ntrCount = this.countNonTranslatable(res, CategoryGroup.OKAPI_WORD_COUNTS);
            this.gen.setField(PROJECT_TRANSLATABLE_WORD_COUNT, Math.max(0L, BaseCounter.getCount(res, "TotalWordCount") - ntrCount));
            this.gen.setField(PROJECT_NONTRANSLATABLE_WORD_COUNT, ntrCount);
            ntrCount = this.countNonTranslatable(res, CategoryGroup.GMX_WORD_COUNTS);
            this.gen.setField(PROJECT_GMX_TRANSLATABLE_WORD_COUNT, Math.max(0L, BaseCounter.getCount(res, "TotalWordCount") - ntrCount));
            this.gen.setField(PROJECT_GMX_NONTRANSLATABLE_WORD_COUNT, ntrCount);
            this.gen.setField(PROJECT_GMX_PROTECTED_WORD_COUNT, BaseCounter.getCount(res, "ProtectedWordCount"));
            this.gen.setField(PROJECT_GMX_EXACT_MATCHED_WORD_COUNT, BaseCounter.getCount(res, "ExactMatchedWordCount"));
            this.gen.setField(PROJECT_GMX_LEVERAGED_MATCHED_WORD_COUNT, BaseCounter.getCount(res, "LeveragedMatchedWordCount"));
            this.gen.setField(PROJECT_GMX_REPETITION_MATCHED_WORD_COUNT, BaseCounter.getCount(res, "RepetitionMatchedWordCount"));
            this.gen.setField(PROJECT_GMX_FUZZY_MATCHED_WORD_COUNT, BaseCounter.getCount(res, "FuzzyMatchedWordCount"));
            this.gen.setField(PROJECT_GMX_ALPHANUMERIC_ONLY_TEXT_UNIT_WORD_COUNT, BaseCounter.getCount(res, "AlphanumericOnlyTextUnitWordCount"));
            this.gen.setField(PROJECT_GMX_NUMERIC_ONLY_TEXT_UNIT_WORD_COUNT, BaseCounter.getCount(res, "NumericOnlyTextUnitWordCount"));
            this.gen.setField(PROJECT_GMX_MEASUREMENT_ONLY_TEXT_UNIT_WORD_COUNT, BaseCounter.getCount(res, "MeasurementOnlyTextUnitWordCount"));
            this.gen.setField(PROJECT_GMX_NOCATEGORY, BaseCounter.getCount(res, "TotalWordCount") - this.countCategories(res, CategoryGroup.GMX_WORD_COUNTS));
            this.gen.setField(PROJECT_EXACT_UNIQUE_ID, BaseCounter.getCount(res, MatchType.EXACT_UNIQUE_ID.name()));
            this.gen.setField(PROJECT_EXACT_PREVIOUS_VERSION, BaseCounter.getCount(res, MatchType.EXACT_PREVIOUS_VERSION.name()));
            this.gen.setField(PROJECT_EXACT_LOCAL_CONTEXT, BaseCounter.getCount(res, MatchType.EXACT_LOCAL_CONTEXT.name()));
            this.gen.setField(PROJECT_EXACT_DOCUMENT_CONTEXT, BaseCounter.getCount(res, MatchType.EXACT_DOCUMENT_CONTEXT.name()));
            this.gen.setField(PROJECT_EXACT_STRUCTURAL, BaseCounter.getCount(res, MatchType.EXACT_STRUCTURAL.name()));
            this.gen.setField(PROJECT_EXACT, BaseCounter.getCount(res, MatchType.EXACT.name()));
            this.gen.setField(PROJECT_EXACT_TEXT_ONLY_PREVIOUS_VERSION, BaseCounter.getCount(res, MatchType.EXACT_TEXT_ONLY_PREVIOUS_VERSION.name()));
            this.gen.setField(PROJECT_EXACT_TEXT_ONLY_UNIQUE_ID, BaseCounter.getCount(res, MatchType.EXACT_TEXT_ONLY_UNIQUE_ID.name()));
            this.gen.setField(PROJECT_EXACT_TEXT_ONLY, BaseCounter.getCount(res, MatchType.EXACT_TEXT_ONLY.name()));
            this.gen.setField(PROJECT_EXACT_REPAIRED, BaseCounter.getCount(res, MatchType.EXACT_REPAIRED.name()));
            this.gen.setField(PROJECT_FUZZY_PREVIOUS_VERSION, BaseCounter.getCount(res, MatchType.FUZZY_PREVIOUS_VERSION.name()));
            this.gen.setField(PROJECT_FUZZY_UNIQUE_ID, BaseCounter.getCount(res, MatchType.FUZZY_UNIQUE_ID.name()));
            this.gen.setField(PROJECT_FUZZY, BaseCounter.getCount(res, MatchType.FUZZY.name()));
            this.gen.setField(PROJECT_FUZZY_REPAIRED, BaseCounter.getCount(res, MatchType.FUZZY_REPAIRED.name()));
            this.gen.setField(PROJECT_PHRASE_ASSEMBLED, BaseCounter.getCount(res, MatchType.PHRASE_ASSEMBLED.name()));
            this.gen.setField(PROJECT_MT, BaseCounter.getCount(res, MatchType.MT.name()));
            this.gen.setField(PROJECT_CONCORDANCE, BaseCounter.getCount(res, MatchType.CONCORDANCE.name()));
            this.gen.setField(PROJECT_NOCATEGORY, BaseCounter.getCount(res, "TotalWordCount") - this.countCategories(res, CategoryGroup.OKAPI_WORD_COUNTS));
            this.setProjectFields(this.gen, res);
        }
        String report = this.gen.generate();
        String outPath = Util.fillRootDirectoryVariable(this.params.getOutputPath(), this.rootDir);
        outPath = LocaleId.replaceVariables(outPath, this.getSourceLocale(), this.getTargetLocale());
        File outFile = new File(outPath);
        Util.createDirectories(outFile.getAbsolutePath());
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), "UTF-8"));
            writer.write(report);
            writer.close();
        }
        catch (UnsupportedEncodingException e) {
            throw new OkapiIOException(e);
        }
        catch (FileNotFoundException e) {
            throw new OkapiIOException(e);
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
        return super.handleEndBatch(event);
    }

    protected long countNonTranslatable(IResource res, CategoryGroup group) {
        long count = 0L;
        switch (group) {
            case GMX_WORD_COUNTS: {
                if (this.params.isCountAsNonTranslatable_GMXProtected()) {
                    count += BaseCounter.getCount(res, "ProtectedWordCount");
                }
                if (this.params.isCountAsNonTranslatable_GMXExactMatched()) {
                    count += BaseCounter.getCount(res, "ExactMatchedWordCount");
                }
                if (this.params.isCountAsNonTranslatable_GMXLeveragedMatched()) {
                    count += BaseCounter.getCount(res, "LeveragedMatchedWordCount");
                }
                if (this.params.isCountAsNonTranslatable_GMXRepetitionMatched()) {
                    count += BaseCounter.getCount(res, "RepetitionMatchedWordCount");
                }
                if (this.params.isCountAsNonTranslatable_GMXFuzzyMatch()) {
                    count += BaseCounter.getCount(res, "FuzzyMatchedWordCount");
                }
                if (this.params.isCountAsNonTranslatable_GMXAlphanumericOnlyTextUnit()) {
                    count += BaseCounter.getCount(res, "AlphanumericOnlyTextUnitWordCount");
                }
                if (this.params.isCountAsNonTranslatable_GMXNumericOnlyTextUnit()) {
                    count += BaseCounter.getCount(res, "NumericOnlyTextUnitWordCount");
                }
                if (!this.params.isCountAsNonTranslatable_GMXMeasurementOnlyTextUnit()) break;
                count += BaseCounter.getCount(res, "MeasurementOnlyTextUnitWordCount");
                break;
            }
            case OKAPI_WORD_COUNTS: {
                if (this.params.isCountAsNonTranslatable_ExactUniqueIdMatch()) {
                    count += BaseCounter.getCount(res, MatchType.EXACT_UNIQUE_ID.name());
                }
                if (this.params.isCountAsNonTranslatable_ExactPreviousVersionMatch()) {
                    count += BaseCounter.getCount(res, MatchType.EXACT_PREVIOUS_VERSION.name());
                }
                if (this.params.isCountAsNonTranslatable_ExactLocalContextMatch()) {
                    count += BaseCounter.getCount(res, MatchType.EXACT_LOCAL_CONTEXT.name());
                }
                if (this.params.isCountAsNonTranslatable_ExactDocumentContextMatch()) {
                    count += BaseCounter.getCount(res, MatchType.EXACT_DOCUMENT_CONTEXT.name());
                }
                if (this.params.isCountAsNonTranslatable_ExactStructuralMatch()) {
                    count += BaseCounter.getCount(res, MatchType.EXACT_STRUCTURAL.name());
                }
                if (this.params.isCountAsNonTranslatable_ExactMatch()) {
                    count += BaseCounter.getCount(res, MatchType.EXACT.name());
                }
                if (this.params.isCountAsNonTranslatable_ExactTextOnlyPreviousVersionMatch()) {
                    count += BaseCounter.getCount(res, MatchType.EXACT_TEXT_ONLY_PREVIOUS_VERSION.name());
                }
                if (this.params.isCountAsNonTranslatable_ExactTextOnlyUniqueIdMatch()) {
                    count += BaseCounter.getCount(res, MatchType.EXACT_TEXT_ONLY_UNIQUE_ID.name());
                }
                if (this.params.isCountAsNonTranslatable_ExactTextOnly()) {
                    count += BaseCounter.getCount(res, MatchType.EXACT_TEXT_ONLY.name());
                }
                if (this.params.isCountAsNonTranslatable_ExactRepaired()) {
                    count += BaseCounter.getCount(res, MatchType.EXACT_REPAIRED.name());
                }
                if (this.params.isCountAsNonTranslatable_FuzzyPreviousVersionMatch()) {
                    count += BaseCounter.getCount(res, MatchType.FUZZY_PREVIOUS_VERSION.name());
                }
                if (this.params.isCountAsNonTranslatable_FuzzyUniqueIdMatch()) {
                    count += BaseCounter.getCount(res, MatchType.FUZZY_UNIQUE_ID.name());
                }
                if (this.params.isCountAsNonTranslatable_FuzzyMatch()) {
                    count += BaseCounter.getCount(res, MatchType.FUZZY.name());
                }
                if (this.params.isCountAsNonTranslatable_FuzzyRepaired()) {
                    count += BaseCounter.getCount(res, MatchType.FUZZY_REPAIRED.name());
                }
                if (this.params.isCountAsNonTranslatable_PhraseAssembled()) {
                    count += BaseCounter.getCount(res, MatchType.PHRASE_ASSEMBLED.name());
                }
                if (this.params.isCountAsNonTranslatable_MT()) {
                    count += BaseCounter.getCount(res, MatchType.MT.name());
                }
                if (!this.params.isCountAsNonTranslatable_Concordance()) break;
                count += BaseCounter.getCount(res, MatchType.CONCORDANCE.name());
            }
        }
        return count > 0L ? count : 0L;
    }

    protected long countCategories(IResource res, CategoryGroup group) {
        long count = 0L;
        switch (group) {
            case GMX_WORD_COUNTS: {
                count += BaseCounter.getCount(res, "ProtectedWordCount");
                count += BaseCounter.getCount(res, "ExactMatchedWordCount");
                count += BaseCounter.getCount(res, "LeveragedMatchedWordCount");
                count += BaseCounter.getCount(res, "RepetitionMatchedWordCount");
                count += BaseCounter.getCount(res, "FuzzyMatchedWordCount");
                count += BaseCounter.getCount(res, "AlphanumericOnlyTextUnitWordCount");
                count += BaseCounter.getCount(res, "NumericOnlyTextUnitWordCount");
                count += BaseCounter.getCount(res, "MeasurementOnlyTextUnitWordCount");
                break;
            }
            case OKAPI_WORD_COUNTS: {
                count += BaseCounter.getCount(res, MatchType.EXACT_UNIQUE_ID.name());
                count += BaseCounter.getCount(res, MatchType.EXACT_PREVIOUS_VERSION.name());
                count += BaseCounter.getCount(res, MatchType.EXACT_LOCAL_CONTEXT.name());
                count += BaseCounter.getCount(res, MatchType.EXACT_DOCUMENT_CONTEXT.name());
                count += BaseCounter.getCount(res, MatchType.EXACT_STRUCTURAL.name());
                count += BaseCounter.getCount(res, MatchType.EXACT.name());
                count += BaseCounter.getCount(res, MatchType.EXACT_TEXT_ONLY_PREVIOUS_VERSION.name());
                count += BaseCounter.getCount(res, MatchType.EXACT_TEXT_ONLY_UNIQUE_ID.name());
                count += BaseCounter.getCount(res, MatchType.EXACT_TEXT_ONLY.name());
                count += BaseCounter.getCount(res, MatchType.EXACT_REPAIRED.name());
                count += BaseCounter.getCount(res, MatchType.FUZZY_PREVIOUS_VERSION.name());
                count += BaseCounter.getCount(res, MatchType.FUZZY_UNIQUE_ID.name());
                count += BaseCounter.getCount(res, MatchType.FUZZY.name());
                count += BaseCounter.getCount(res, MatchType.FUZZY_REPAIRED.name());
                count += BaseCounter.getCount(res, MatchType.PHRASE_ASSEMBLED.name());
                count += BaseCounter.getCount(res, MatchType.MT.name());
                count += BaseCounter.getCount(res, MatchType.CONCORDANCE.name());
            }
        }
        return count > 0L ? count : 0L;
    }

    protected void setProjectFields(ReportGenerator gen, IResource res) {
    }

    protected void setItemFields(ReportGenerator gen, IResource res) {
    }

    @Override
    protected Event handleEndBatchItem(Event event) {
        IResource res = event.getResource();
        if (res != null) {
            this.resolver.resolve(res);
            this.gen.setField(ITEM_TOTAL_WORD_COUNT, BaseCounter.getCount(res, "TotalWordCount"));
            long ntrCount = this.countNonTranslatable(res, CategoryGroup.OKAPI_WORD_COUNTS);
            this.gen.setField(ITEM_TRANSLATABLE_WORD_COUNT, Math.max(0L, BaseCounter.getCount(res, "TotalWordCount") - ntrCount));
            this.gen.setField(ITEM_NONTRANSLATABLE_WORD_COUNT, ntrCount);
            ntrCount = this.countNonTranslatable(res, CategoryGroup.GMX_WORD_COUNTS);
            this.gen.setField(ITEM_GMX_TRANSLATABLE_WORD_COUNT, Math.max(0L, BaseCounter.getCount(res, "TotalWordCount") - ntrCount));
            this.gen.setField(ITEM_GMX_NONTRANSLATABLE_WORD_COUNT, ntrCount);
            this.gen.setField(ITEM_GMX_PROTECTED_WORD_COUNT, BaseCounter.getCount(res, "ProtectedWordCount"));
            this.gen.setField(ITEM_GMX_EXACT_MATCHED_WORD_COUNT, BaseCounter.getCount(res, "ExactMatchedWordCount"));
            this.gen.setField(ITEM_GMX_LEVERAGED_MATCHED_WORD_COUNT, BaseCounter.getCount(res, "LeveragedMatchedWordCount"));
            this.gen.setField(ITEM_GMX_REPETITION_MATCHED_WORD_COUNT, BaseCounter.getCount(res, "RepetitionMatchedWordCount"));
            this.gen.setField(ITEM_GMX_FUZZY_MATCHED_WORD_COUNT, BaseCounter.getCount(res, "FuzzyMatchedWordCount"));
            this.gen.setField(ITEM_GMX_ALPHANUMERIC_ONLY_TEXT_UNIT_WORD_COUNT, BaseCounter.getCount(res, "AlphanumericOnlyTextUnitWordCount"));
            this.gen.setField(ITEM_GMX_NUMERIC_ONLY_TEXT_UNIT_WORD_COUNT, BaseCounter.getCount(res, "NumericOnlyTextUnitWordCount"));
            this.gen.setField(ITEM_GMX_MEASUREMENT_ONLY_TEXT_UNIT_WORD_COUNT, BaseCounter.getCount(res, "MeasurementOnlyTextUnitWordCount"));
            this.gen.setField(ITEM_GMX_NOCATEGORY, BaseCounter.getCount(res, "TotalWordCount") - this.countCategories(res, CategoryGroup.GMX_WORD_COUNTS));
            this.gen.setField(ITEM_EXACT_UNIQUE_ID, BaseCounter.getCount(res, MatchType.EXACT_UNIQUE_ID.name()));
            this.gen.setField(ITEM_EXACT_PREVIOUS_VERSION, BaseCounter.getCount(res, MatchType.EXACT_PREVIOUS_VERSION.name()));
            this.gen.setField(ITEM_EXACT_LOCAL_CONTEXT, BaseCounter.getCount(res, MatchType.EXACT_LOCAL_CONTEXT.name()));
            this.gen.setField(ITEM_EXACT_DOCUMENT_CONTEXT, BaseCounter.getCount(res, MatchType.EXACT_DOCUMENT_CONTEXT.name()));
            this.gen.setField(ITEM_EXACT_STRUCTURAL, BaseCounter.getCount(res, MatchType.EXACT_STRUCTURAL.name()));
            this.gen.setField(ITEM_EXACT, BaseCounter.getCount(res, MatchType.EXACT.name()));
            this.gen.setField(ITEM_EXACT_TEXT_ONLY_PREVIOUS_VERSION, BaseCounter.getCount(res, MatchType.EXACT_TEXT_ONLY_PREVIOUS_VERSION.name()));
            this.gen.setField(ITEM_EXACT_TEXT_ONLY_UNIQUE_ID, BaseCounter.getCount(res, MatchType.EXACT_TEXT_ONLY_UNIQUE_ID.name()));
            this.gen.setField(ITEM_EXACT_TEXT_ONLY, BaseCounter.getCount(res, MatchType.EXACT_TEXT_ONLY.name()));
            this.gen.setField(ITEM_EXACT_REPAIRED, BaseCounter.getCount(res, MatchType.EXACT_REPAIRED.name()));
            this.gen.setField(ITEM_FUZZY_PREVIOUS_VERSION, BaseCounter.getCount(res, MatchType.FUZZY_PREVIOUS_VERSION.name()));
            this.gen.setField(ITEM_FUZZY_UNIQUE_ID, BaseCounter.getCount(res, MatchType.FUZZY_UNIQUE_ID.name()));
            this.gen.setField(ITEM_FUZZY, BaseCounter.getCount(res, MatchType.FUZZY.name()));
            this.gen.setField(ITEM_FUZZY_REPAIRED, BaseCounter.getCount(res, MatchType.FUZZY_REPAIRED.name()));
            this.gen.setField(ITEM_PHRASE_ASSEMBLED, BaseCounter.getCount(res, MatchType.PHRASE_ASSEMBLED.name()));
            this.gen.setField(ITEM_MT, BaseCounter.getCount(res, MatchType.MT.name()));
            this.gen.setField(ITEM_CONCORDANCE, BaseCounter.getCount(res, MatchType.CONCORDANCE.name()));
            this.gen.setField(ITEM_NOCATEGORY, BaseCounter.getCount(res, "TotalWordCount") - this.countCategories(res, CategoryGroup.OKAPI_WORD_COUNTS));
            this.setItemFields(this.gen, res);
        }
        return super.handleEndBatchItem(event);
    }

    @Override
    protected Event handleStartDocument(Event event) {
        Event ev = super.handleStartDocument(event);
        StartDocument sd = (StartDocument)event.getResource();
        if (sd != null) {
            String fname = sd.getName();
            this.gen.setField(ITEM_NAME, new File(fname).getAbsolutePath());
            this.setItemFields(this.gen, sd);
        }
        return ev;
    }

    @Override
    protected Event handleEndDocument(Event event) {
        this.gen.setField(ITEM_SOURCE_LOCALE, this.getSourceLocale().toString());
        this.gen.setField(ITEM_TARGET_LOCALE, this.getTargetLocale().toString());
        this.setItemFields(this.gen, event.getResource());
        return super.handleEndDocument(event);
    }

    @Override
    protected Event handleTextUnit(Event event) {
        TextUnit tu = (TextUnit)event.getResource();
        this.resolver.resolve(tu);
        return super.handleTextUnit(event);
    }

    public ReportGenerator getReportGenerator() {
        return this.gen;
    }
}

